; OpenGL include file for the Netwide Assembler (NASM)
; Copyright 1992-1997 Silicon Graphics, Inc. All Rights Reserved.
; Transformed to this form by Sergey Chaban
; (C) hardCode/<BizarreCreations site> '99
; http://bizarrecreations.webjump.com
; e-mail: soul_cat@mindless.com
;** This file was made to give x86 Assembly coders the ability
;** to write OGL programs, not to get any profit from it.
;** In case there are any objections from SGI, it will be removed
;** from our web-page.

%ifndef _NASM_GL_
%define _NASM_GL_

%ifndef NWIN_EXTRA_MACRO_INCLUDED
 %include "nwinx.inc"
%endif

%define 	GLenum		DWORD
%define		GLboolean	BYTE
%define		GLbitfield	DWORD
%define		GLbyte		SBYTE
%define		GLshort		SWORD
%define		GLint		DWORD
%define		GLsizei		DWORD
%define		GLubyte		BYTE
%define		GLushort	WORD
%define		GLuint		DWORD
%define		GLfloat		DWORD
%define		GLclampf	DWORD  ; float clamped to [0,1]
%define		GLdouble	QWORD
%define		GLclampd	QWORD  ; double clamped to [0,1]

;%define	GLvoid		DWORD

; GL matrices are stored in column-major order.
; Members of this structure are named after D3DMATRIX members,
; what allows easy porting of matrix code from D3D.
STRUC glMATRIX
._11 resd 1
._21 resd 1
._31 resd 1
._41 resd 1
._12 resd 1
._22 resd 1
._32 resd 1
._42 resd 1
._13 resd 1
._23 resd 1
._33 resd 1
._43 resd 1
._14 resd 1
._24 resd 1
._34 resd 1
._44 resd 1
ENDSTRUC


STRUC glVec3f
 .x resd 1
 .y resd 1
 .z resd 1
ENDSCTRUC

;/* Extensions */
GL_VERSION_1_1			EQU	1
GL_EXT_abgr			EQU	1
GL_EXT_bgra			EQU	1
GL_EXT_packed_pixels		EQU	1
GL_EXT_paletted_texture		EQU	1
GL_EXT_vertex_array		EQU	1
GL_SGI_compiled_vertex_array	EQU	1
GL_SGI_cull_vertex		EQU	1
GL_SGI_index_array_formats	EQU	1
GL_SGI_index_func		EQU	1
GL_SGI_index_material		EQU	1
GL_SGI_index_texture		EQU	1
GL_WIN_swap_hint		EQU	1

;/* AttribMask */
GL_CURRENT_BIT			EQU		000000001h
GL_POINT_BIT			EQU		000000002h
GL_LINE_BIT			EQU		000000004h
GL_POLYGON_BIT			EQU		000000008h
GL_POLYGON_STIPPLE_BIT		EQU		000000010h
GL_PIXEL_MODE_BIT		EQU		000000020h
GL_LIGHTING_BIT			EQU		000000040h
GL_FOG_BIT			EQU		000000080h
GL_DEPTH_BUFFER_BIT		EQU		000000100h
GL_ACCUM_BUFFER_BIT		EQU		000000200h
GL_STENCIL_BUFFER_BIT		EQU		000000400h
GL_VIEWPORT_BIT			EQU		000000800h
GL_TRANSFORM_BIT		EQU		000001000h
GL_ENABLE_BIT			EQU		000002000h
GL_COLOR_BUFFER_BIT		EQU		000004000h
GL_HINT_BIT			EQU		000008000h
GL_EVAL_BIT			EQU		000010000h
GL_LIST_BIT			EQU		000020000h
GL_TEXTURE_BIT			EQU		000040000h
GL_SCISSOR_BIT			EQU		000080000h
GL_ALL_ATTRIB_BITS		EQU		0000fffffh

;/* ClientAttribMask */
GL_CLIENT_PIXEL_STORE_BIT	EQU		000000001h
GL_CLIENT_VERTEX_ARRAY_BIT	EQU		000000002h
GL_CLIENT_ALL_ATTRIB_BITS	EQU		0ffffffffh

;/* Boolean */
GL_FALSE		EQU		0
GL_TRUE			EQU		1


;/* BeginMode */
GL_POINTS		EQU		000000000h
GL_LINES		EQU		000000001h
GL_LINE_LOOP		EQU		000000002h
GL_LINE_STRIP		EQU		000000003h
GL_TRIANGLES		EQU		000000004h
GL_TRIANGLE_STRIP	EQU		000000005h
GL_TRIANGLE_FAN		EQU		000000006h
GL_QUADS		EQU		000000007h
GL_QUAD_STRIP		EQU		000000008h
GL_POLYGON		EQU		000000009h

;/* AccumOp */
GL_ACCUM		EQU		000000100h
GL_LOAD			EQU		000000101h
GL_RETURN		EQU		000000102h
GL_MULT			EQU		000000103h
GL_ADD			EQU		000000104h

;/* AlphaFunction */
GL_NEVER		EQU		000000200h
GL_LESS			EQU		000000201h
GL_EQUAL		EQU		000000202h
GL_LEQUAL		EQU		000000203h
GL_GREATER		EQU		000000204h
GL_NOTEQUAL		EQU		000000205h
GL_GEQUAL		EQU		000000206h
GL_ALWAYS		EQU		000000207h

;/* BlendingFactorDest */
GL_ZERO			EQU		0
GL_ONE			EQU		1
GL_SRC_COLOR		EQU		000000300h
GL_ONE_MINUS_SRC_COLOR	EQU		000000301h
GL_SRC_ALPHA		EQU		000000302h
GL_ONE_MINUS_SRC_ALPHA	EQU		000000303h
GL_DST_ALPHA		EQU		000000304h
GL_ONE_MINUS_DST_ALPHA	EQU		000000305h

;/* BlendingFactorSrc */
GL_DST_COLOR		EQU		000000306h
GL_ONE_MINUS_DST_COLOR	EQU		000000307h
GL_SRC_ALPHA_SATURATE		EQU		000000308h


;/* DrawBufferMode */
GL_NONE			EQU		0
GL_FRONT_LEFT		EQU		000000400h
GL_FRONT_RIGHT		EQU		000000401h
GL_BACK_LEFT		EQU		000000402h
GL_BACK_RIGHT		EQU		000000403h
GL_FRONT		EQU		000000404h
GL_BACK			EQU		000000405h
GL_LEFT			EQU		000000406h
GL_RIGHT		EQU		000000407h
GL_FRONT_AND_BACK	EQU		000000408h
GL_AUX0			EQU		000000409h
GL_AUX1			EQU		00000040ah
GL_AUX2			EQU		00000040bh
GL_AUX3			EQU		00000040ch

;/* ErrorCode */
GL_NO_ERROR		EQU		0
GL_INVALID_ENUM		EQU		000000500h
GL_INVALID_VALUE	EQU		000000501h
GL_INVALID_OPERATION	EQU		000000502h
GL_STACK_OVERFLOW	EQU		000000503h
GL_STACK_UNDERFLOW	EQU		000000504h
GL_OUT_OF_MEMORY	EQU		000000505h

;/* FeedbackType */
GL_2D			EQU		000000600h
GL_3D			EQU		000000601h
GL_3D_COLOR		EQU		000000602h
GL_3D_COLOR_TEXTURE	EQU		000000603h
GL_4D_COLOR_TEXTURE	EQU		000000604h

;/* FeedBackToken */
GL_PASS_THROUGH_TOKEN	EQU		000000700h
GL_POINT_TOKEN		EQU		000000701h
GL_LINE_TOKEN		EQU		000000702h
GL_POLYGON_TOKEN	EQU		000000703h
GL_BITMAP_TOKEN		EQU		000000704h
GL_DRAW_PIXEL_TOKEN	EQU		000000705h
GL_COPY_PIXEL_TOKEN	EQU		000000706h
GL_LINE_RESET_TOKEN	EQU		000000707h

;/* FogMode */
;GL_LINEAR
GL_EXP			EQU		000000800h
GL_EXP2			EQU		000000801h
;/* FogParameter */
;      GL_FOG_COLOR
;      GL_FOG_DENSITY
;      GL_FOG_END
;      GL_FOG_INDEX
;      GL_FOG_MODE
;      GL_FOG_START


;/* FrontFaceDirection */
GL_CW			EQU		000000900h
GL_CCW			EQU		000000901h

;/* GetMapQuery */
GL_COEFF		EQU		000000a00h
GL_ORDER		EQU		000000a01h
GL_DOMAIN		EQU		000000a02h

;/* GetPixelMap */
GL_PIXEL_MAP_I_TO_I	EQU		000000c70h
GL_PIXEL_MAP_S_TO_S	EQU		000000c71h
GL_PIXEL_MAP_I_TO_R	EQU		000000c72h
GL_PIXEL_MAP_I_TO_G	EQU		000000c73h
GL_PIXEL_MAP_I_TO_B	EQU		000000c74h
GL_PIXEL_MAP_I_TO_A	EQU		000000c75h
GL_PIXEL_MAP_R_TO_R	EQU		000000c76h
GL_PIXEL_MAP_G_TO_G	EQU		000000c77h
GL_PIXEL_MAP_B_TO_B	EQU		000000c78h
GL_PIXEL_MAP_A_TO_A	EQU		000000c79h


;/* GetPointervPName */
GL_VERTEX_ARRAY_POINTER		EQU	00000808eh
GL_NORMAL_ARRAY_POINTER		EQU	00000808fh
GL_COLOR_ARRAY_POINTER		EQU	000008090h
GL_INDEX_ARRAY_POINTER		EQU	000008091h
GL_TEXTURE_COORD_ARRAY_POINTER	EQU	000008092h
GL_EDGE_FLAG_ARRAY_POINTER	EQU	000008093h


;/* GetPName */
GL_CURRENT_COLOR			EQU		000000b00h
GL_CURRENT_INDEX			EQU		000000b01h
GL_CURRENT_NORMAL			EQU		000000b02h
GL_CURRENT_TEXTURE_COORDS		EQU		000000b03h
GL_CURRENT_RASTER_COLOR			EQU		000000b04h
GL_CURRENT_RASTER_INDEX			EQU		000000b05h
GL_CURRENT_RASTER_TEXTURE_COORDS	EQU		000000b06h
GL_CURRENT_RASTER_POSITION		EQU		000000b07h
GL_CURRENT_RASTER_POSITION_VALID	EQU		000000b08h
GL_CURRENT_RASTER_DISTANCE		EQU		000000b09h
GL_POINT_SMOOTH				EQU		000000b10h
GL_POINT_SIZE				EQU		000000b11h
GL_POINT_SIZE_RANGE			EQU		000000b12h
GL_POINT_SIZE_GRANULARITY		EQU		000000b13h
GL_LINE_SMOOTH				EQU		000000b20h
GL_LINE_WIDTH				EQU		000000b21h
GL_LINE_WIDTH_RANGE			EQU		000000b22h
GL_LINE_WIDTH_GRANULARITY		EQU		000000b23h
GL_LINE_STIPPLE				EQU		000000b24h
GL_LINE_STIPPLE_PATTERN			EQU		000000b25h
GL_LINE_STIPPLE_REPEAT			EQU		000000b26h
GL_LIST_MODE				EQU		000000b30h
GL_MAX_LIST_NESTING			EQU		000000b31h
GL_LIST_BASE				EQU		000000b32h
GL_LIST_INDEX				EQU		000000b33h
GL_POLYGON_MODE				EQU		000000b40h
GL_POLYGON_SMOOTH			EQU		000000b41h
GL_POLYGON_STIPPLE			EQU		000000b42h
GL_EDGE_FLAG				EQU		000000b43h
GL_CULL_FACE				EQU		000000b44h
GL_CULL_FACE_MODE			EQU		000000b45h
GL_FRONT_FACE				EQU		000000b46h
GL_LIGHTING				EQU		000000b50h
GL_LIGHT_MODEL_LOCAL_VIEWER		EQU		000000b51h
GL_LIGHT_MODEL_TWO_SIDE			EQU		000000b52h
GL_LIGHT_MODEL_AMBIENT			EQU		000000b53h
GL_SHADE_MODEL				EQU		000000b54h
GL_COLOR_MATERIAL_FACE			EQU		000000b55h
GL_COLOR_MATERIAL_PARAMETER		EQU		000000b56h
GL_COLOR_MATERIAL			EQU		000000b57h
GL_FOG					EQU		000000b60h
GL_FOG_INDEX				EQU		000000b61h
GL_FOG_DENSITY				EQU		000000b62h
GL_FOG_START				EQU		000000b63h
GL_FOG_END				EQU		000000b64h
GL_FOG_MODE				EQU		000000b65h
GL_FOG_COLOR				EQU		000000b66h
GL_DEPTH_RANGE				EQU		000000b70h
GL_DEPTH_TEST				EQU		000000b71h
GL_DEPTH_WRITEMASK			EQU		000000b72h
GL_DEPTH_CLEAR_VALUE			EQU		000000b73h
GL_DEPTH_FUNC				EQU		000000b74h
GL_ACCUM_CLEAR_VALUE			EQU		000000b80h
GL_STENCIL_TEST				EQU		000000b90h
GL_STENCIL_CLEAR_VALUE			EQU		000000b91h
GL_STENCIL_FUNC				EQU		000000b92h
GL_STENCIL_VALUE_MASK			EQU		000000b93h
GL_STENCIL_FAIL				EQU		000000b94h
GL_STENCIL_PASS_DEPTH_FAIL		EQU		000000b95h
GL_STENCIL_PASS_DEPTH_PASS		EQU		000000b96h
GL_STENCIL_REF				EQU		000000b97h
GL_STENCIL_WRITEMASK			EQU		000000b98h
GL_MATRIX_MODE				EQU		000000ba0h
GL_NORMALIZE				EQU		000000ba1h
GL_VIEWPORT				EQU		000000ba2h
GL_MODELVIEW_STACK_DEPTH		EQU		000000ba3h
GL_PROJECTION_STACK_DEPTH		EQU		000000ba4h
GL_TEXTURE_STACK_DEPTH			EQU		000000ba5h
GL_MODELVIEW_MATRIX			EQU		000000ba6h
GL_PROJECTION_MATRIX			EQU		000000ba7h
GL_TEXTURE_MATRIX			EQU		000000ba8h
GL_ATTRIB_STACK_DEPTH			EQU		000000bb0h
GL_CLIENT_ATTRIB_STACK_DEPTH		EQU		000000bb1h
GL_ALPHA_TEST				EQU		000000bc0h
GL_ALPHA_TEST_FUNC			EQU		000000bc1h
GL_ALPHA_TEST_REF			EQU		000000bc2h
GL_DITHER				EQU		000000bd0h
GL_BLEND_DST				EQU		000000be0h
GL_BLEND_SRC				EQU		000000be1h
GL_BLEND				EQU		000000be2h
GL_LOGIC_OP_MODE			EQU		000000bf0h
GL_INDEX_LOGIC_OP			EQU		000000bf1h
GL_LOGIC_OP				EQU		GL_INDEX_LOGIC_OP
GL_COLOR_LOGIC_OP			EQU		000000bf2h
GL_AUX_BUFFERS				EQU		000000c00h
GL_DRAW_BUFFER				EQU		000000c01h
GL_READ_BUFFER				EQU		000000c02h
GL_SCISSOR_BOX				EQU		000000c10h
GL_SCISSOR_TEST				EQU		000000c11h
GL_INDEX_CLEAR_VALUE			EQU		000000c20h
GL_INDEX_WRITEMASK			EQU		000000c21h
GL_COLOR_CLEAR_VALUE			EQU		000000c22h
GL_COLOR_WRITEMASK			EQU		000000c23h
GL_INDEX_MODE				EQU		000000c30h
GL_RGBA_MODE				EQU		000000c31h
GL_DOUBLEBUFFER				EQU		000000c32h
GL_STEREO				EQU		000000c33h
GL_RENDER_MODE				EQU		000000c40h
GL_PERSPECTIVE_CORRECTION_HINT		EQU		000000c50h
GL_POINT_SMOOTH_HINT			EQU		000000c51h
GL_LINE_SMOOTH_HINT			EQU		000000c52h
GL_POLYGON_SMOOTH_HINT			EQU		000000c53h
GL_FOG_HINT				EQU		000000c54h
GL_TEXTURE_GEN_S			EQU		000000c60h
GL_TEXTURE_GEN_T			EQU		000000c61h
GL_TEXTURE_GEN_R			EQU		000000c62h
GL_TEXTURE_GEN_Q			EQU		000000c63h
GL_PIXEL_MAP_I_TO_I_SIZE		EQU		000000cb0h
GL_PIXEL_MAP_S_TO_S_SIZE		EQU		000000cb1h
GL_PIXEL_MAP_I_TO_R_SIZE		EQU		000000cb2h
GL_PIXEL_MAP_I_TO_G_SIZE		EQU		000000cb3h
GL_PIXEL_MAP_I_TO_B_SIZE		EQU		000000cb4h
GL_PIXEL_MAP_I_TO_A_SIZE		EQU		000000cb5h
GL_PIXEL_MAP_R_TO_R_SIZE		EQU		000000cb6h
GL_PIXEL_MAP_G_TO_G_SIZE		EQU		000000cb7h
GL_PIXEL_MAP_B_TO_B_SIZE		EQU		000000cb8h
GL_PIXEL_MAP_A_TO_A_SIZE		EQU		000000cb9h
GL_UNPACK_SWAP_BYTES			EQU		000000cf0h
GL_UNPACK_LSB_FIRST			EQU		000000cf1h
GL_UNPACK_ROW_LENGTH			EQU		000000cf2h
GL_UNPACK_SKIP_ROWS			EQU		000000cf3h
GL_UNPACK_SKIP_PIXELS			EQU		000000cf4h
GL_UNPACK_ALIGNMENT			EQU		000000cf5h
GL_PACK_SWAP_BYTES			EQU		000000d00h
GL_PACK_LSB_FIRST			EQU		000000d01h
GL_PACK_ROW_LENGTH			EQU		000000d02h
GL_PACK_SKIP_ROWS			EQU		000000d03h
GL_PACK_SKIP_PIXELS			EQU		000000d04h
GL_PACK_ALIGNMENT			EQU		000000d05h
GL_MAP_COLOR				EQU		000000d10h
GL_MAP_STENCIL				EQU		000000d11h
GL_INDEX_SHIFT				EQU		000000d12h
GL_INDEX_OFFSET				EQU		000000d13h
GL_RED_SCALE				EQU		000000d14h
GL_RED_BIAS				EQU		000000d15h
GL_ZOOM_X				EQU		000000d16h
GL_ZOOM_Y				EQU		000000d17h
GL_GREEN_SCALE				EQU		000000d18h
GL_GREEN_BIAS				EQU		000000d19h
GL_BLUE_SCALE				EQU		000000d1ah
GL_BLUE_BIAS				EQU		000000d1bh
GL_ALPHA_SCALE				EQU		000000d1ch
GL_ALPHA_BIAS				EQU		000000d1dh
GL_DEPTH_SCALE				EQU		000000d1eh
GL_DEPTH_BIAS				EQU		000000d1fh
GL_MAX_EVAL_ORDER			EQU		000000d30h
GL_MAX_LIGHTS				EQU		000000d31h
GL_MAX_CLIP_PLANES			EQU		000000d32h
GL_MAX_TEXTURE_SIZE			EQU		000000d33h
GL_MAX_PIXEL_MAP_TABLE			EQU		000000d34h
GL_MAX_ATTRIB_STACK_DEPTH		EQU		000000d35h
GL_MAX_MODELVIEW_STACK_DEPTH		EQU		000000d36h
GL_MAX_NAME_STACK_DEPTH			EQU		000000d37h
GL_MAX_PROJECTION_STACK_DEPTH		EQU		000000d38h
GL_MAX_TEXTURE_STACK_DEPTH		EQU		000000d39h
GL_MAX_VIEWPORT_DIMS			EQU		000000d3ah
GL_MAX_CLIENT_ATTRIB_STACK_DEPTH	EQU		000000d3bh
GL_SUBPIXEL_BITS			EQU		000000d50h
GL_INDEX_BITS				EQU		000000d51h
GL_RED_BITS				EQU		000000d52h
GL_GREEN_BITS				EQU		000000d53h
GL_BLUE_BITS				EQU		000000d54h
GL_ALPHA_BITS				EQU		000000d55h
GL_DEPTH_BITS				EQU		000000d56h
GL_STENCIL_BITS				EQU		000000d57h
GL_ACCUM_RED_BITS			EQU		000000d58h
GL_ACCUM_GREEN_BITS			EQU		000000d59h
GL_ACCUM_BLUE_BITS			EQU		000000d5ah
GL_ACCUM_ALPHA_BITS			EQU		000000d5bh
GL_NAME_STACK_DEPTH			EQU		000000d70h
GL_AUTO_NORMAL				EQU		000000d80h
GL_MAP1_COLOR_4				EQU		000000d90h
GL_MAP1_INDEX				EQU		000000d91h
GL_MAP1_NORMAL				EQU		000000d92h
GL_MAP1_TEXTURE_COORD_1			EQU		000000d93h
GL_MAP1_TEXTURE_COORD_2			EQU		000000d94h
GL_MAP1_TEXTURE_COORD_3			EQU		000000d95h
GL_MAP1_TEXTURE_COORD_4			EQU		000000d96h
GL_MAP1_VERTEX_3			EQU		000000d97h
GL_MAP1_VERTEX_4			EQU		000000d98h
GL_MAP2_COLOR_4				EQU		000000db0h
GL_MAP2_INDEX				EQU		000000db1h
GL_MAP2_NORMAL				EQU		000000db2h
GL_MAP2_TEXTURE_COORD_1			EQU		000000db3h
GL_MAP2_TEXTURE_COORD_2			EQU		000000db4h
GL_MAP2_TEXTURE_COORD_3			EQU		000000db5h
GL_MAP2_TEXTURE_COORD_4			EQU		000000db6h
GL_MAP2_VERTEX_3			EQU		000000db7h
GL_MAP2_VERTEX_4			EQU		000000db8h
GL_MAP1_GRID_DOMAIN			EQU		000000dd0h
GL_MAP1_GRID_SEGMENTS			EQU		000000dd1h
GL_MAP2_GRID_DOMAIN			EQU		000000dd2h
GL_MAP2_GRID_SEGMENTS			EQU		000000dd3h
GL_TEXTURE_1D				EQU		000000de0h
GL_TEXTURE_2D				EQU		000000de1h
GL_FEEDBACK_BUFFER_POINTER		EQU		000000df0h
GL_FEEDBACK_BUFFER_SIZE			EQU		000000df1h
GL_FEEDBACK_BUFFER_TYPE			EQU		000000df2h
GL_SELECTION_BUFFER_POINTER		EQU		000000df3h
GL_SELECTION_BUFFER_SIZE		EQU		000000df4h
GL_POLYGON_OFFSET_UNITS			EQU		000002a00h
GL_POLYGON_OFFSET_POINT			EQU		000002a01h
GL_POLYGON_OFFSET_LINE			EQU		000002a02h
GL_POLYGON_OFFSET_FILL			EQU		000008037h
GL_POLYGON_OFFSET_FACTOR		EQU		000008038h
GL_TEXTURE_BINDING_1D			EQU		000008068h
GL_TEXTURE_BINDING_2D			EQU		000008069h
GL_VERTEX_ARRAY				EQU		000008074h
GL_NORMAL_ARRAY				EQU		000008075h
GL_COLOR_ARRAY				EQU		000008076h
GL_INDEX_ARRAY				EQU		000008077h
GL_TEXTURE_COORD_ARRAY			EQU		000008078h
GL_EDGE_FLAG_ARRAY			EQU		000008079h
GL_VERTEX_ARRAY_SIZE			EQU		00000807ah
GL_VERTEX_ARRAY_TYPE			EQU		00000807bh
GL_VERTEX_ARRAY_STRIDE			EQU		00000807ch
GL_NORMAL_ARRAY_TYPE			EQU		00000807eh
GL_NORMAL_ARRAY_STRIDE			EQU		00000807fh
GL_COLOR_ARRAY_SIZE			EQU		000008081h
GL_COLOR_ARRAY_TYPE			EQU		000008082h
GL_COLOR_ARRAY_STRIDE			EQU		000008083h
GL_INDEX_ARRAY_TYPE			EQU		000008085h
GL_INDEX_ARRAY_STRIDE			EQU		000008086h
GL_TEXTURE_COORD_ARRAY_SIZE		EQU		000008088h
GL_TEXTURE_COORD_ARRAY_TYPE		EQU		000008089h
GL_TEXTURE_COORD_ARRAY_STRIDE		EQU		00000808ah
GL_EDGE_FLAG_ARRAY_STRIDE		EQU		00000808ch



;/* GetTextureParameter */
GL_TEXTURE_WIDTH		EQU		000001000h
GL_TEXTURE_HEIGHT		EQU		000001001h
GL_TEXTURE_INTERNAL_FORMAT	EQU		000001003h
GL_TEXTURE_COMPONENTS		EQU		000001003h
GL_TEXTURE_BORDER_COLOR		EQU		000001004h
GL_TEXTURE_BORDER		EQU		000001005h
GL_TEXTURE_RED_SIZE		EQU		00000805ch
GL_TEXTURE_GREEN_SIZE		EQU		00000805dh
GL_TEXTURE_BLUE_SIZE		EQU		00000805eh
GL_TEXTURE_ALPHA_SIZE		EQU		00000805fh
GL_TEXTURE_LUMINANCE_SIZE	EQU		000008060h
GL_TEXTURE_INTENSITY_SIZE	EQU		000008061h
GL_TEXTURE_PRIORITY		EQU		000008066h
GL_TEXTURE_RESIDENT		EQU		000008067h

;/* HintMode */
GL_DONT_CARE			EQU		000001100h
GL_FASTEST			EQU		000001101h
GL_NICEST			EQU		000001102h

;/* LightParameter */
GL_AMBIENT			EQU		000001200h
GL_DIFFUSE			EQU		000001201h
GL_SPECULAR			EQU		000001202h
GL_POSITION			EQU		000001203h
GL_SPOT_DIRECTION		EQU		000001204h
GL_SPOT_EXPONENT		EQU		000001205h
GL_SPOT_CUTOFF			EQU		000001206h
GL_CONSTANT_ATTENUATION		EQU		000001207h
GL_LINEAR_ATTENUATION		EQU		000001208h
GL_QUADRATIC_ATTENUATION	EQU		000001209h

;/* ListMode */
GL_COMPILE			EQU		000001300h
GL_COMPILE_AND_EXECUTE		EQU		000001301h

;/* DataType */
GL_BYTE				EQU		000001400h
GL_UNSIGNED_BYTE		EQU		000001401h
GL_SHORT			EQU		000001402h
GL_UNSIGNED_SHORT		EQU		000001403h
GL_INT				EQU		000001404h
GL_UNSIGNED_INT			EQU		000001405h
GL_FLOAT			EQU		000001406h
GL_2_BYTES			EQU		000001407h
GL_3_BYTES			EQU		000001408h
GL_4_BYTES			EQU		000001409h
GL_DOUBLE			EQU		00000140ah
GL_DOUBLE_EXT			EQU		00000140ah

;/* ListNameType */
;  GL_BYTE
;  GL_UNSIGNED_BYTE */
;  GL_SHORT */
;  GL_UNSIGNED_SHORT */
;  GL_INT */
;  GL_UNSIGNED_INT */
;  GL_FLOAT */
;  GL_2_BYTES */
;  GL_3_BYTES */
;  GL_4_BYTES */


;/* LogicOp */
GL_CLEAR			EQU		000001500h
GL_AND				EQU		000001501h
GL_AND_REVERSE			EQU		000001502h
GL_COPY				EQU		000001503h
GL_AND_INVERTED			EQU		000001504h
GL_NOOP				EQU		000001505h
GL_XOR				EQU		000001506h
GL_OR				EQU		000001507h
GL_NOR				EQU		000001508h
GL_EQUIV			EQU		000001509h
GL_INVERT			EQU		00000150ah
GL_OR_REVERSE			EQU		00000150bh
GL_COPY_INVERTED		EQU		00000150ch
GL_OR_INVERTED			EQU		00000150dh
GL_NAND				EQU		00000150eh
GL_SET				EQU		00000150fh


;/* MaterialParameter */
GL_EMISSION		EQU		000001600h
GL_SHININESS		EQU		000001601h
GL_AMBIENT_AND_DIFFUSE	EQU		000001602h
GL_COLOR_INDEXES	EQU		000001603h
; GL_AMBIENT
; GL_DIFFUSE
; GL_SPECULAR


;/* MatrixMode */
GL_MODELVIEW		EQU		000001700h
GL_PROJECTION		EQU		000001701h
GL_TEXTURE		EQU		000001702h


;/* PixelCopyType */
GL_COLOR		EQU		000001800h
GL_DEPTH		EQU		000001801h
GL_STENCIL		EQU		000001802h


;/* PixelFormat */
GL_COLOR_INDEX		EQU		000001900h
GL_STENCIL_INDEX	EQU		000001901h
GL_DEPTH_COMPONENT	EQU		000001902h
GL_RED			EQU		000001903h
GL_GREEN		EQU		000001904h
GL_BLUE			EQU		000001905h
GL_ALPHA		EQU		000001906h
GL_RGB			EQU		000001907h
GL_RGBA			EQU		000001908h
GL_LUMINANCE		EQU		000001909h
GL_LUMINANCE_ALPHA	EQU		00000190ah

;/* PixelType */
GL_BITMAP		EQU		000001a00h


;/* PolygonMode */
GL_POINT		EQU		000001b00h
GL_LINE			EQU		000001b01h
GL_FILL			EQU		000001b02h

;/* RenderingMode */
GL_RENDER		EQU		000001c00h
GL_FEEDBACK		EQU		000001c01h
GL_SELECT		EQU		000001c02h

;/* ShadingModel */
GL_FLAT			EQU		000001d00h
GL_SMOOTH		EQU		000001d01h

;/* StencilOp */
; GL_ZERO
GL_KEEP			EQU		000001e00h
GL_REPLACE		EQU		000001e01h
GL_INCR			EQU		000001e02h
GL_DECR			EQU		000001e03h
; GL_INVERT

;/* StringName */
GL_VENDOR		EQU		000001f00h
GL_RENDERER		EQU		000001f01h
GL_VERSION		EQU		000001f02h
GL_EXTENSIONS		EQU		000001f03h


;/* TextureCoordName */
GL_S			EQU		000002000h
GL_T			EQU		000002001h
GL_R			EQU		000002002h
GL_Q			EQU		000002003h

;/* TextureEnvMode */
GL_MODULATE		EQU		000002100h
GL_DECAL		EQU		000002101h
; GL_BLEND
; GL_REPLACE
; GL_ADD

;/* TextureEnvParameter */
GL_TEXTURE_ENV_MODE		EQU		000002200h
GL_TEXTURE_ENV_COLOR		EQU		000002201h

;/* TextureEnvTarget */
GL_TEXTURE_ENV		EQU		000002300h

;/* TextureGenMode */
GL_EYE_LINEAR		EQU		000002400h
GL_OBJECT_LINEAR	EQU		000002401h
GL_SPHERE_MAP		EQU		000002402h


;/* TextureGenParameter */
GL_TEXTURE_GEN_MODE	EQU		000002500h
GL_OBJECT_PLANE		EQU		000002501h
GL_EYE_PLANE		EQU		000002502h

;/* TextureMagFilter */
GL_NEAREST		EQU		000002600h
GL_LINEAR		EQU		000002601h


;/* TextureMinFilter */
; GL_NEAREST
;  GL_LINEAR
GL_NEAREST_MIPMAP_NEAREST	EQU		000002700h
GL_LINEAR_MIPMAP_NEAREST	EQU		000002701h
GL_NEAREST_MIPMAP_LINEAR	EQU		000002702h
GL_LINEAR_MIPMAP_LINEAR		EQU		000002703h


;/* TextureParameterName */
GL_TEXTURE_MAG_FILTER	EQU		000002800h
GL_TEXTURE_MIN_FILTER	EQU		000002801h
GL_TEXTURE_WRAP_S	EQU		000002802h
GL_TEXTURE_WRAP_T	EQU		000002803h

;/* TextureTarget */
GL_PROXY_TEXTURE_1D	EQU		000008063h
GL_PROXY_TEXTURE_2D	EQU		000008064h

;/* TextureWrapMode */
GL_CLAMP		EQU		000002900h
GL_REPEAT		EQU		000002901h

;/* PixelInternalFormat */
GL_R3_G3_B2		EQU		000002a10h
GL_ALPHA4		EQU		00000803bh
GL_ALPHA8		EQU		00000803ch
GL_ALPHA12		EQU		00000803dh
GL_ALPHA16		EQU		00000803eh
GL_LUMINANCE4		EQU		00000803fh
GL_LUMINANCE8		EQU		000008040h
GL_LUMINANCE12		EQU		000008041h
GL_LUMINANCE16		EQU		000008042h
GL_LUMINANCE4_ALPHA4	EQU		000008043h
GL_LUMINANCE6_ALPHA2	EQU		000008044h
GL_LUMINANCE8_ALPHA8	EQU		000008045h
GL_LUMINANCE12_ALPHA4	EQU		000008046h
GL_LUMINANCE12_ALPHA12	EQU		000008047h
GL_LUMINANCE16_ALPHA16	EQU		000008048h
GL_INTENSITY		EQU		000008049h
GL_INTENSITY4		EQU		00000804ah
GL_INTENSITY8		EQU		00000804bh
GL_INTENSITY12		EQU		00000804ch
GL_INTENSITY16		EQU		00000804dh
GL_RGB4			EQU		00000804fh
GL_RGB5			EQU		000008050h
GL_RGB8			EQU		000008051h
GL_RGB10		EQU		000008052h
GL_RGB12		EQU		000008053h
GL_RGB16		EQU		000008054h
GL_RGBA2		EQU		000008055h
GL_RGBA4		EQU		000008056h
GL_RGB5_A1		EQU		000008057h
GL_RGBA8		EQU		000008058h
GL_RGB10_A2		EQU		000008059h
GL_RGBA12		EQU		00000805ah
GL_RGBA16		EQU		00000805bh


;/* InterleavedArrayFormat */
GL_V2F			EQU		000002a20h
GL_V3F			EQU		000002a21h
GL_C4UB_V2F		EQU		000002a22h
GL_C4UB_V3F		EQU		000002a23h
GL_C3F_V3F		EQU		000002a24h
GL_N3F_V3F		EQU		000002a25h
GL_C4F_N3F_V3F		EQU		000002a26h
GL_T2F_V3F		EQU		000002a27h
GL_T4F_V4F		EQU		000002a28h
GL_T2F_C4UB_V3F		EQU		000002a29h
GL_T2F_C3F_V3F		EQU		000002a2ah
GL_T2F_N3F_V3F		EQU		000002a2bh
GL_T2F_C4F_N3F_V3F	EQU		000002a2ch
GL_T4F_C4F_N3F_V4F	EQU		000002a2dh


;/* ClipPlaneName */
GL_CLIP_PLANE0		EQU		000003000h
GL_CLIP_PLANE1		EQU		000003001h
GL_CLIP_PLANE2		EQU		000003002h
GL_CLIP_PLANE3		EQU		000003003h
GL_CLIP_PLANE4		EQU		000003004h
GL_CLIP_PLANE5		EQU		000003005h


;/* LightName */
GL_LIGHT0		EQU		000004000h
GL_LIGHT1		EQU		000004001h
GL_LIGHT2		EQU		000004002h
GL_LIGHT3		EQU		000004003h
GL_LIGHT4		EQU		000004004h
GL_LIGHT5		EQU		000004005h
GL_LIGHT6		EQU		000004006h
GL_LIGHT7		EQU		000004007h

;/* EXT_abgr */
GL_ABGR_EXT		EQU		000008000h

;/* EXT_packed_pixels */
GL_UNSIGNED_BYTE_3_3_2_EXT		EQU		000008032h
GL_UNSIGNED_SHORT_4_4_4_4_EXT		EQU		000008033h
GL_UNSIGNED_SHORT_5_5_5_1_EXT		EQU		000008034h
GL_UNSIGNED_INT_8_8_8_8_EXT		EQU		000008035h
GL_UNSIGNED_INT_10_10_10_2_EXT		EQU		000008036h

;/* EXT_vertex_array */
GL_VERTEX_ARRAY_EXT			EQU		000008074h
GL_NORMAL_ARRAY_EXT			EQU		000008075h
GL_COLOR_ARRAY_EXT			EQU		000008076h
GL_INDEX_ARRAY_EXT			EQU		000008077h
GL_TEXTURE_COORD_ARRAY_EXT		EQU		000008078h
GL_EDGE_FLAG_ARRAY_EXT			EQU		000008079h
GL_VERTEX_ARRAY_SIZE_EXT		EQU		00000807ah
GL_VERTEX_ARRAY_TYPE_EXT		EQU		00000807bh
GL_VERTEX_ARRAY_STRIDE_EXT		EQU		00000807ch
GL_VERTEX_ARRAY_COUNT_EXT		EQU		00000807dh
GL_NORMAL_ARRAY_TYPE_EXT		EQU		00000807eh
GL_NORMAL_ARRAY_STRIDE_EXT		EQU		00000807fh
GL_NORMAL_ARRAY_COUNT_EXT		EQU		000008080h
GL_COLOR_ARRAY_SIZE_EXT			EQU		000008081h
GL_COLOR_ARRAY_TYPE_EXT			EQU		000008082h
GL_COLOR_ARRAY_STRIDE_EXT		EQU		000008083h
GL_COLOR_ARRAY_COUNT_EXT		EQU		000008084h
GL_INDEX_ARRAY_TYPE_EXT			EQU		000008085h
GL_INDEX_ARRAY_STRIDE_EXT		EQU		000008086h
GL_INDEX_ARRAY_COUNT_EXT		EQU		000008087h
GL_TEXTURE_COORD_ARRAY_SIZE_EXT		EQU		000008088h
GL_TEXTURE_COORD_ARRAY_TYPE_EXT		EQU		000008089h
GL_TEXTURE_COORD_ARRAY_STRIDE_EXT	EQU		00000808ah
GL_TEXTURE_COORD_ARRAY_COUNT_EXT	EQU		00000808bh
GL_EDGE_FLAG_ARRAY_STRIDE_EXT		EQU		00000808ch
GL_EDGE_FLAG_ARRAY_COUNT_EXT		EQU		00000808dh
GL_VERTEX_ARRAY_POINTER_EXT		EQU		00000808eh
GL_NORMAL_ARRAY_POINTER_EXT		EQU		00000808fh
GL_COLOR_ARRAY_POINTER_EXT		EQU		000008090h
GL_INDEX_ARRAY_POINTER_EXT		EQU		000008091h
GL_TEXTURE_COORD_ARRAY_POINTER_EXT	EQU		000008092h
GL_EDGE_FLAG_ARRAY_POINTER_EXT		EQU		000008093h

;/* EXT_color_table */
GL_TABLE_TOO_LARGE_EXT			EQU		000008031h
GL_COLOR_TABLE_FORMAT_EXT		EQU		0000080d8h
GL_COLOR_TABLE_WIDTH_EXT		EQU		0000080d9h
GL_COLOR_TABLE_RED_SIZE_EXT		EQU		0000080dah
GL_COLOR_TABLE_GREEN_SIZE_EXT		EQU		0000080dbh
GL_COLOR_TABLE_BLUE_SIZE_EXT		EQU		0000080dch
GL_COLOR_TABLE_ALPHA_SIZE_EXT		EQU		0000080ddh
GL_COLOR_TABLE_LUMINANCE_SIZE_EXT	EQU		0000080deh
GL_COLOR_TABLE_INTENSITY_SIZE_EXT	EQU		0000080dfh


;/* EXT_bgra */
GL_BGR_EXT		EQU		0000080e0h
GL_BGRA_EXT		EQU		0000080e1h

;/* EXT_paletted_texture */
GL_COLOR_INDEX1_EXT		EQU		0000080e2h
GL_COLOR_INDEX2_EXT		EQU		0000080e3h
GL_COLOR_INDEX4_EXT		EQU		0000080e4h
GL_COLOR_INDEX8_EXT		EQU		0000080e5h
GL_COLOR_INDEX12_EXT		EQU		0000080e6h
GL_COLOR_INDEX16_EXT		EQU		0000080e7h

;/* SGI_compiled_vertex_array */
GL_ARRAY_ELEMENT_LOCK_FIRST_SGI		EQU		0000081a8h
GL_ARRAY_ELEMENT_LOCK_COUNT_SGI		EQU		0000081a9h

;/* SGI_index_array_formats */
GL_CULL_VERTEX_SGI			EQU		0000081aah
GL_CULL_VERTEX_EYE_POSITION_SGI		EQU		0000081abh
GL_CULL_VERTEX_OBJECT_POSITION_SGI	EQU		0000081ach
GL_IUI_V2F_SGI				EQU		0000081adh
GL_IUI_V3F_SGI				EQU		0000081aeh
GL_IUI_N3F_V2F_SGI			EQU		0000081afh
GL_IUI_N3F_V3F_SGI			EQU		0000081b0h
GL_T2F_IUI_V2F_SGI			EQU		0000081b1h
GL_T2F_IUI_V3F_SGI			EQU		0000081b2h
GL_T2F_IUI_N3F_V2F_SGI			EQU		0000081b3h
GL_T2F_IUI_N3F_V3F_SGI			EQU		0000081b4h

;/* SGI_index_func */
GL_INDEX_TEST_SGI		EQU		0000081b5h
GL_INDEX_TEST_FUNC_SGI		EQU		0000081b6h
GL_INDEX_TEST_REF_SGI		EQU		0000081b7h

;/* SGI_index_material */
GL_INDEX_MATERIAL_SGI		EQU		0000081b8h
GL_INDEX_MATERIAL_PARAMETER_SGI	EQU		0000081b9h
GL_INDEX_MATERIAL_FACE_SGI	EQU		0000081bah



;**************************************************************************
; functions prototypes for opengl.lib
%ifndef _GDI32_INCLUDED_
 ; overloaded functions in GDI32
 XDEF ChoosePixelFormat,4,4
 XDEF DescribePixelFormat,   4,4,4,4
 XDEF GetPixelFormat,   4
 XDEF SetPixelFormat,   4,4,4
 XDEF SwapBuffers,   4
%endif ;//_GDI32_INCLUDED_
XDEF glAccum,   4,4
XDEF glAlphaFunc,   4,4
XDEF glAreTexturesResident,   4,4,4
XDEF glArrayElement,   4
XDEF glBegin,   4
XDEF glBindTexture,   4,4
XDEF glBitmap,   4,4,4,4,4,4,4
XDEF glBlendFunc,   4,4
XDEF glCallList,   4
XDEF glCallLists,   4,4,4
XDEF glClear,   4
XDEF glClearAccum,   4,4,4,4
XDEF glClearColor,   4,4,4,4
XDEF glClearDepth,   4,4
XDEF glClearIndex,   4
XDEF glClearStencil,   4
XDEF glClipPlane,   4,4
XDEF glColor3b,   4,4,4
XDEF glColor3bv,   4
XDEF glColor3d,   4,4,4,4,4,4
XDEF glColor3dv,   4
XDEF glColor3f,   4,4,4
XDEF glColor3fv,   4
XDEF glColor3i,   4,4,4
XDEF glColor3iv,   4
XDEF glColor3s,   4,4,4
XDEF glColor3sv,   4
XDEF glColor3ub,   4,4,4
XDEF glColor3ubv,   4
XDEF glColor3ui,   4,4,4
XDEF glColor3uiv,   4
XDEF glColor3us,   4,4,4
XDEF glColor3usv,   4
XDEF glColor4b,   4,4,4,4
XDEF glColor4bv,   4
XDEF glColor4d,   4,4,4,4,4,4,4,4
XDEF glColor4dv,   4
XDEF glColor4f,   4,4,4,4
XDEF glColor4fv,   4
XDEF glColor4i,   4,4,4,4
XDEF glColor4iv,   4
XDEF glColor4s,   4,4,4,4
XDEF glColor4sv,   4
XDEF glColor4ub,   4,4,4,4
XDEF glColor4ubv,   4
XDEF glColor4ui,   4,4,4,4
XDEF glColor4uiv,   4
XDEF glColor4us,   4,4,4,4
XDEF glColor4usv,   4
XDEF glColorMask,   4,4,4,4
XDEF glColorMaterial,   4,4
XDEF glColorPointer,   4,4,4,4
XDEF glCopyPixels,   4,4,4,4,4
XDEF glCopyTexImage1D,   4,4,4,4,4,4,4
XDEF glCopyTexImage2D,   4,4,4,4,4,4,4,4
XDEF glCopyTexSubImage1D,   4,4,4,4,4,4
XDEF glCopyTexSubImage2D,   4,4,4,4,4,4,4,4
XDEF glCullFace,   4
XDEF glDeleteLists,   4,4
XDEF glDeleteTextures,   4,4
XDEF glDepthFunc,   4
XDEF glDepthMask,   4
XDEF glDepthRange,   4,4,4,4  ; params are of GLclampd type
XDEF glDisable,   4
XDEF glDisableClientState,   4
XDEF glDrawArrays,   4,4,4
XDEF glDrawBuffer,   4
XDEF glDrawElements,   4,4,4,4
XDEF glDrawPixels,   4,4,4,4,4
XDEF glEdgeFlag,   4
XDEF glEdgeFlagPointer,   4,4
XDEF glEdgeFlagv,   4
XDEF glEnable,   4
XDEF glEnableClientState,   4
XDEF glEnd
XDEF glEndList
XDEF glEvalCoord1d,   4,4
XDEF glEvalCoord1dv,   4
XDEF glEvalCoord1f,   4
XDEF glEvalCoord1fv,   4
XDEF glEvalCoord2d,   4,4,4,4
XDEF glEvalCoord2dv,   4
XDEF glEvalCoord2f,   4,4
XDEF glEvalCoord2fv,   4
XDEF glEvalMesh1,   4,4,4
XDEF glEvalMesh2,   4,4,4,4,4
XDEF glEvalPoint1,   4
XDEF glEvalPoint2,   4,4
XDEF glFeedbackBuffer,   4,4,4
XDEF glFinish
XDEF glFlush
XDEF glFogf,   4,4
XDEF glFogfv,   4,4
XDEF glFogi,   4,4
XDEF glFogiv,   4,4
XDEF glFrontFace,   4
XDEF glFrustum,   4,4,4,4,4,4,4,4,4,4,4,4
XDEF glGenLists,   4
XDEF glGenTextures,   4,4
XDEF glGetBooleanv,   4,4
XDEF glGetClipPlane,   4,4
XDEF glGetDoublev,   4,4
XDEF glGetError
XDEF glGetFloatv,   4,4
XDEF glGetIntegerv,   4,4
XDEF glGetLightfv,   4,4,4
XDEF glGetLightiv,   4,4,4
XDEF glGetMapdv,   4,4,4
XDEF glGetMapfv,   4,4,4
XDEF glGetMapiv,   4,4,4
XDEF glGetMaterialfv,   4,4,4
XDEF glGetMaterialiv,   4,4,4
XDEF glGetPixelMapfv,   4,4
XDEF glGetPixelMapuiv,   4,4
XDEF glGetPixelMapusv,   4,4
XDEF glGetPointerv,   4,4
XDEF glGetPolygonStipple,   4
XDEF glGetString,   4
XDEF glGetTexEnvfv,   4,4,4
XDEF glGetTexEnviv,   4,4,4
XDEF glGetTexGendv,   4,4,4
XDEF glGetTexGenfv,   4,4,4
XDEF glGetTexGeniv,   4,4,4
XDEF glGetTexImage,   4,4,4,4,4
XDEF glGetTexLevelParameterfv,   4,4,4,4
XDEF glGetTexLevelParameteriv,   4,4,4,4
XDEF glGetTexParameterfv,   4,4,4
XDEF glGetTexParameteriv,   4,4,4
XDEF glHint,   4,4
XDEF glIndexMask,   4
XDEF glIndexPointer,   4,4,4
XDEF glIndexd,   4,4
XDEF glIndexdv,   4
XDEF glIndexf,   4
XDEF glIndexfv,   4
XDEF glIndexi,   4
XDEF glIndexiv,   4
XDEF glIndexs,   4
XDEF glIndexsv,   4
XDEF glIndexub,   4
XDEF glIndexubv,   4
XDEF glInitNames
XDEF glInterleavedArrays,   4,4,4
XDEF glIsEnabled,   4
XDEF glIsList,   4
XDEF glIsTexture,   4
XDEF glLightModelf,   4,4
XDEF glLightModelfv,   4,4
XDEF glLightModeli,   4,4
XDEF glLightModeliv,   4,4
XDEF glLightf,   4,4,4
XDEF glLightfv,   4,4,4
XDEF glLighti,   4,4,4
XDEF glLightiv,   4,4,4
XDEF glLineStipple,   4,4
XDEF glLineWidth,   4
XDEF glListBase,   4
XDEF glLoadIdentity
XDEF glLoadMatrixd,   4
XDEF glLoadMatrixf,   4
XDEF glLoadName,   4
XDEF glLogicOp,   4
XDEF glMap1d,   4,4,4,4,4,4,4,4
XDEF glMap1f,   4,4,4,4,4,4
XDEF glMap2d,   4,4,4,4,4,4,4,4,4,4,4,4,4,4
XDEF glMap2f,   4,4,4,4,4,4,4,4,4,4
XDEF glMapGrid1d,   4,4,4,4,4
XDEF glMapGrid1f,   4,4,4
XDEF glMapGrid2d,   4,4,4,4,4,4,4,4,4,4
XDEF glMapGrid2f,   4,4,4,4,4,4
XDEF glMaterialf,   4,4,4
XDEF glMaterialfv,   4,4,4
XDEF glMateriali,   4,4,4
XDEF glMaterialiv,   4,4,4
XDEF glMatrixMode,   4
XDEF glMultMatrixd,   4
XDEF glMultMatrixf,   4
XDEF glNewList,   4,4
XDEF glNormal3b,   4,4,4
XDEF glNormal3bv,   4
XDEF glNormal3d,   4,4,4,4,4,4
XDEF glNormal3dv,   4
XDEF glNormal3f,   4,4,4
XDEF glNormal3fv,   4
XDEF glNormal3i,   4,4,4
XDEF glNormal3iv,   4
XDEF glNormal3s,   4,4,4
XDEF glNormal3sv,   4
XDEF glNormalPointer,   4,4,4
XDEF glOrtho,   4,4,4,4,4,4,4,4,4,4,4,4
XDEF glPassThrough,   4
XDEF glPixelMapfv,   4,4,4
XDEF glPixelMapuiv,   4,4,4
XDEF glPixelMapusv,   4,4,4
XDEF glPixelStoref,   4,4
XDEF glPixelStorei,   4,4
XDEF glPixelTransferf,   4,4
XDEF glPixelTransferi,   4,4
XDEF glPixelZoom,   4,4
XDEF glPointSize,   4
XDEF glPolygonMode,   4,4
XDEF glPolygonOffset,   4,4
XDEF glPolygonStipple,   4
XDEF glPopAttrib
XDEF glPopClientAttrib
XDEF glPopMatrix
XDEF glPopName
XDEF glPrioritizeTextures,   4,4,4
XDEF glPushAttrib,   4
XDEF glPushClientAttrib,   4
XDEF glPushMatrix
XDEF glPushName,   4
XDEF glRasterPos2d,   4,4,4,4
XDEF glRasterPos2dv,   4
XDEF glRasterPos2f,   4,4
XDEF glRasterPos2fv,   4
XDEF glRasterPos2i,   4,4
XDEF glRasterPos2iv,   4
XDEF glRasterPos2s,   4,4
XDEF glRasterPos2sv,   4
XDEF glRasterPos3d,   4,4,4,4,4,4
XDEF glRasterPos3dv,   4
XDEF glRasterPos3f,   4,4,4
XDEF glRasterPos3fv,   4
XDEF glRasterPos3i,   4,4,4
XDEF glRasterPos3iv,   4
XDEF glRasterPos3s,   4,4,4
XDEF glRasterPos3sv,   4
XDEF glRasterPos4d,   4,4,4,4,4,4,4,4
XDEF glRasterPos4dv,   4
XDEF glRasterPos4f,   4,4,4,4
XDEF glRasterPos4fv,   4
XDEF glRasterPos4i,   4,4,4,4
XDEF glRasterPos4iv,   4
XDEF glRasterPos4s,   4,4,4,4
XDEF glRasterPos4sv,   4
XDEF glReadBuffer,   4
XDEF glReadPixels,   4,4,4,4,4,4,4
XDEF glRectd,   4,4,4,4,4,4,4,4
XDEF glRectdv,   4,4
XDEF glRectf,   4,4,4,4
XDEF glRectfv,   4,4
XDEF glRecti,   4,4,4,4
XDEF glRectiv,   4,4
XDEF glRects,   4,4,4,4
XDEF glRectsv,   4,4
XDEF glRenderMode,   4
XDEF glRotated,   4,4,4,4,4,4,4,4
XDEF glRotatef,   4,4,4,4
XDEF glScaled,   4,4,4,4,4,4
XDEF glScalef,   4,4,4
XDEF glScissor,   4,4,4,4
XDEF glSelectBuffer,   4,4
XDEF glShadeModel,   4
XDEF glStencilFunc,   4,4,4
XDEF glStencilMask,   4
XDEF glStencilOp,   4,4,4
XDEF glTexCoord1d,   4,4
XDEF glTexCoord1dv,   4
XDEF glTexCoord1f,   4
XDEF glTexCoord1fv,   4
XDEF glTexCoord1i,   4
XDEF glTexCoord1iv,   4
XDEF glTexCoord1s,   4
XDEF glTexCoord1sv,   4
XDEF glTexCoord2d,   4,4,4,4
XDEF glTexCoord2dv,   4
XDEF glTexCoord2f,   4,4
XDEF glTexCoord2fv,   4
XDEF glTexCoord2i,   4,4
XDEF glTexCoord2iv,   4
XDEF glTexCoord2s,   4,4
XDEF glTexCoord2sv,   4
XDEF glTexCoord3d,   4,4,4,4,4,4
XDEF glTexCoord3dv,   4
XDEF glTexCoord3f,   4,4,4
XDEF glTexCoord3fv,   4
XDEF glTexCoord3i,   4,4,4
XDEF glTexCoord3iv,   4
XDEF glTexCoord3s,   4,4,4
XDEF glTexCoord3sv,   4
XDEF glTexCoord4d,   4,4,4,4,4,4,4,4
XDEF glTexCoord4dv,   4
XDEF glTexCoord4f,   4,4,4,4
XDEF glTexCoord4fv,   4
XDEF glTexCoord4i,   4,4,4,4
XDEF glTexCoord4iv,   4
XDEF glTexCoord4s,   4,4,4,4
XDEF glTexCoord4sv,   4
XDEF glTexCoordPointer,   4,4,4,4
XDEF glTexEnvf,   4,4,4
XDEF glTexEnvfv,   4,4,4
XDEF glTexEnvi,   4,4,4
XDEF glTexEnviv,   4,4,4
XDEF glTexGend,   4,4,4,4
XDEF glTexGendv,   4,4,4
XDEF glTexGenf,   4,4,4
XDEF glTexGenfv,   4,4,4
XDEF glTexGeni,   4,4,4
XDEF glTexGeniv,   4,4,4
XDEF glTexImage1D,   4,4,4,4,4,4,4,4
XDEF glTexImage2D,   4,4,4,4,4,4,4,4,4
XDEF glTexParameterf,   4,4,4
XDEF glTexParameterfv,   4,4,4
XDEF glTexParameteri,   4,4,4
XDEF glTexParameteriv,   4,4,4
XDEF glTexSubImage1D,   4,4,4,4,4,4,4
XDEF glTexSubImage2D,   4,4,4,4,4,4,4,4,4
XDEF glTranslated,   4,4,4,4,4,4
XDEF glTranslatef,   4,4,4
XDEF glVertex2d,   4,4,4,4
XDEF glVertex2dv,   4
XDEF glVertex2f,   4,4
XDEF glVertex2fv,   4
XDEF glVertex2i,   4,4
XDEF glVertex2iv,   4
XDEF glVertex2s,   4,4
XDEF glVertex2sv,   4
XDEF glVertex3d,   4,4,4,4,4,4
XDEF glVertex3dv,   4
XDEF glVertex3f,   4,4,4
XDEF glVertex3fv,   4
XDEF glVertex3i,   4,4,4
XDEF glVertex3iv,   4
XDEF glVertex3s,   4,4,4
XDEF glVertex3sv,   4
XDEF glVertex4d,   4,4,4,4,4,4,4,4
XDEF glVertex4dv,   4
XDEF glVertex4f,   4,4,4,4
XDEF glVertex4fv,   4
XDEF glVertex4i,   4,4,4,4
XDEF glVertex4iv,   4
XDEF glVertex4s,   4,4,4,4
XDEF glVertex4sv,   4
XDEF glVertexPointer,   4,4,4,4
XDEF glViewport,   4,4,4,4
%ifdef __SGIGLCOSMO__
XDEF mglCosmoCheckVisual,   4,4
XDEF mglCosmoChooseVisual,   4,4
XDEF mglCosmoCreateContext,   4,4
XDEF mglCosmoCreateSurface,   4,4
XDEF mglCosmoDeleteContext,   4
XDEF mglCosmoDeleteSurface,   4
XDEF mglCosmoMakeCurrent,   4,4
XDEF mglCosmoSetSurfacePtr,   4,4,4
%endif ;//__SGIGLCOSMO__
XDEF wglChoosePixelFormat,   4,4
XDEF wglCopyContext,   4,4,4
XDEF wglCreateContext,   4
XDEF wglCreateLayerContext,   4,4
XDEF wglDeleteContext,   4
XDEF wglDescribeLayerPlane,   4,4,4,4,4
XDEF wglDescribePixelFormat,   4,4,4,4
XDEF wglGetCurrentContext
XDEF wglGetCurrentDC
XDEF wglGetDefaultProcAddress,   4
XDEF wglGetLayerPaletteEntries,   4,4,4,4,4
XDEF wglGetPixelFormat,   4
XDEF wglGetProcAddress,   4
XDEF wglMakeCurrent,   4,4
XDEF wglRealizeLayerPalette,   4,4,4
XDEF wglSetLayerPaletteEntries,   4,4,4,4,4
XDEF wglSetPixelFormat,   4,4,4
XDEF wglShareLists,   4,4
XDEF wglSwapBuffers,   4
XDEF wglSwapLayerBuffers,   4,4
_XDEF wglUseFontBitmaps,   4,4,4,4

_XDEF wglUseFontOutlines,   4,4,4,4,4,4,4,4


%macro gl_movf 2
 db 0x68
 dd %2
 pop %1
%endmacro


%macro gl_fpush 1
%ifid %1
 push dword [%1]
%else
 db 0x68
 dd %1
%endif
%endmacro


%macro dpush 1
 push dword %1
%endmacro


%macro gl_dpush 1
%ifid %1
 push dword [%1+4]
 push dword [%1]
%else
 jmp %%label
  align 4
%%datum:
 dq %1
%%label:
 push dword [%%datum+4]
 push dword [%%datum]
%endif
%endmacro


%macro _glFrustum 6
 gl_dpush %6
 gl_dpush %5
 gl_dpush %4
 gl_dpush %3
 gl_dpush %2
 gl_dpush %1
 call glFrustum
%endmacro

%macro _glOrtho 6
 gl_dpush %6
 gl_dpush %5
 gl_dpush %4
 gl_dpush %3
 gl_dpush %2
 gl_dpush %1
 call glOrtho
%endmacro

%macro _glDepthRange 2
 gl_dpush %2
 gl_dpush %1
 call glDepthRange
%endmacro


%macro _glTranslatef 3
 gl_fpush %3
 gl_fpush %2
 gl_fpush %1
 call glTranslatef
%endmacro

%macro _glRotatef 4
 gl_fpush %4
 gl_fpush %3
 gl_fpush %2
 gl_fpush %1
 call glRotatef
%endmacro

%macro _glNormal3f 3
 gl_fpush %3
 gl_fpush %2
 gl_fpush %1
 call glNormal3f
%endmacro

%macro _glVertex3f 3
 gl_fpush %3
 gl_fpush %2
 gl_fpush %1
 call glVertex3f
%endmacro

%macro _glVertex2f 2
 gl_fpush %2
 gl_fpush %1
 call glVertex2f
%endmacro

%macro _glColor3f 3
 gl_fpush %3
 gl_fpush %2
 gl_fpush %1
 call glColor3f
%endmacro

%macro _glTexCoord2f 2
 gl_fpush %2
 gl_fpush %1
 call glTexCoord2f
%endmacro

%macro _glTexEnvfv 3
 dpush %3
 dpush %2
 dpush %1
 call glTexEnvfv
%endmacro

%macro _glTexEnvf 3
 gl_fpush %3
 dpush %2
 dpush %1
 call glTexEnvf
%endmacro

%macro _glTexEnvi 3
 dpush %3
 dpush %2
 dpush %1
 call glTexEnvf
%endmacro

%macro _glTexParameterf 3
 gl_fpush %3
 dpush %2
 dpush %1
 call glTexParameterf
%endmacro

%macro _glTexParameteri 3
 dpush %3
 dpush %2
 dpush %1
 call glTexParameteri
%endmacro

%macro _glBegin 1
 dpush %1
 call glBegin
%endmacro

%macro _glEnd 0
 call glEnd
%endmacro

%macro _glEnable 1
 dpush %1
 call glEnable
%endmacro

%macro _glDisable 1
 dpush %1
 call glDisable
%endmacro

%macro _glBindTexture 2
 dpush %2
 dpush %1
 call glBindTexture
%endmacro

%macro _glMatrixMode 1
 dpush %1
 call glMatrixMode
%endmacro

%macro _glShadeModel 1
 dpush %1
 call glShadeModel
%endmacro

%macro _glLoadIdentity 0
 call glLoadIdentity
%endmacro

%macro _glFrontFace 1
 dpush %1
 call glFrontFace
%endmacro

%macro _glViewport 4
 dpush %4
 dpush %3
 dpush %2
 dpush %1
 call glViewport
%endmacro

%macro _glMaterialfv 3
 dpush %3
 dpush %2
 dpush %1
 call glMaterialfv
%endmacro

%macro _glMaterialf 3
 dpush %3
 dpush %2
 dpush %1
 call glMaterialf
%endmacro

;***********These actually should be defined in windows.inc

%macro _safedef 2
 %ifndef %1
   %1 equ %2
 %endif
%endmacro

%ifndef HGLRC
 %define HGLRC DWORD
%endif

;**** These flags may be needed when setting full-screen mode
;**** via ChangeDisplaySettings API. Not a good practice however.
;/* Flags for ChangeDisplaySettings */
_safedef CDS_UPDATEREGISTRY,1
_safedef CDS_TEST,2
_safedef CDS_FULLSCREEN,4
_safedef CDS_GLOBAL,8
_safedef CDS_SET_PRIMARY,10h
_safedef CDS_RESET,40000000h
_safedef CDS_SETRECT,20000000h
_safedef CDS_NORESET,10000000h

;/* Return values for ChangeDisplaySettings */
_safedef DISP_CHANGE_SUCCESSFUL,0
_safedef DISP_CHANGE_RESTART,1
_safedef DISP_CHANGE_FAILED,-1
_safedef DISP_CHANGE_BADMODE,-2
_safedef DISP_CHANGE_NOTUPDATED,-3
_safedef DISP_CHANGE_BADFLAGS,-4
_safedef DISP_CHANGE_BADPARAM,-5


;**** PixelFormat-related constants

;/* pixel types */
_safedef PFD_TYPE_RGBA,0
_safedef PFD_TYPE_COLORINDEX,1

;/* layer types */
_safedef PFD_MAIN_PLANE,0
_safedef PFD_OVERLAY_PLANE,1
_safedef PFD_UNDERLAY_PLANE,-1

;/* PIXELFORMATDESCRIPTOR flags */
_safedef PFD_DOUBLEBUFFER,1
_safedef PFD_STEREO,2
_safedef PFD_DRAW_TO_WINDOW,4
_safedef PFD_DRAW_TO_BITMAP,8
_safedef PFD_SUPPORT_GDI,10h
_safedef PFD_SUPPORT_OPENGL,20h
_safedef PFD_GENERIC_FORMAT,40h
_safedef PFD_NEED_PALETTE,80h
_safedef PFD_NEED_SYSTEM_PALETTE,100h
_safedef PFD_SWAP_EXCHANGE,200h
_safedef PFD_SWAP_COPY,400h
_safedef PFD_SWAP_LAYER_BUFFERS,800h
_safedef PFD_GENERIC_ACCELERATED,1000h

;/* PIXELFORMATDESCRIPTOR flags for use in ChoosePixelFormat only */
_safedef PFD_DEPTH_DONTCARE,20000000h
_safedef PFD_DOUBLEBUFFER_DONTCARE,40000000h
_safedef PFD_STEREO_DONTCARE,80000000h

%endif ;//_NASM_GL_
