;==============================================================================
; BARE BONES
; SKELETON Version 3.0
; Copyright 2000 Wayne J. Radburn
;
; Assembles with Microsoft MASM v6.14.8444 as follows:
;    ML /c /coff Bones.asm
;
; Links with Microsoft LINK v5.12.8181 as follows:
;    LINK /SUBSYSTEM:WINDOWS /ENTRY:Main Bones.obj BonesRC.obj
;
; See Bones.rc for how to create BonesRC.obj
;==============================================================================

	.586			;32-Bit when .586 before .MODEL
	.MODEL	FLAT, STDCALL
	OPTION	CASEMAP:NONE

	INCLUDE Kernel32.inc
	INCLUDE	User32.inc
	INCLUDE	htmlhelp.inc

;;
;;	RESOURCE IDs
;;

IDI_ICON	EQU	01h
IDM_MENU	EQU	01h
IDD_ABOUT	EQU	01h

IDM_FILEMENU	EQU	20h
IDM_HELPMENU	EQU	21h

IDM_EXIT	EQU	22h

IDM_HELPTOPICS	EQU	23h
IDM_ABOUT	EQU	24h

;;
;;	MAIN THREAD, WINDOW, and MESSAGE LOOP
;;

	.CODE
Main	PROC
;Initialize the Main window
	call	MainINIT	;returns exit code in EAX

	test	eax,eax		;Z to continue
	jnz	Exit		;NZ to exit

;Process queued messages until WM_QUIT is received
	call	MsgLOOP		;returns exit code in EAX

;End this process and all its threads
Exit:
	push	eax			;nExitCode
	call	[ExitProcess]		;KERNEL

	ret
Main	ENDP

	ALIGN	4
MsgLOOP	PROC
	push	ebp
	sub	esp,SIZEOF(MSG)	;LOCAL EBP=OFFSET msg
	mov	ebp,esp
	jmp	Retrieve

;Dispatch the message to a window procedure
Dispatch:
	push	ebp			;pMsg
	call	[TranslateMessage]	;USER

	push	ebp			;pMsg
	call	[DispatchMessage]	;USER

;Retrieve a message from the thread message queue
Retrieve:
	push	0			;wMsgFilterMax
	push	0			;wMsgFilterMin
	push	0			;hWnd
	push	ebp			;pMsg
	call	[GetMessage]		;USER

	cmp	eax,-1
	je	Exit		;E if error so exit

	test	eax,eax		;EAX=0 if WM_QUIT
	jnz	Dispatch	;NZ if other message retrieved so process it

	mov	eax,[ebp+MSG.wParam]	;return ExitCode
Exit:
	add	esp,SIZEOF(MSG)	;LOCAL msg removed
	pop	ebp
	ret
MsgLOOP	ENDP

;;
;;	MAIN WINDOW MESSAGES
;;

       	.CONST
MainMsg	DWORD	WM_COMMAND,
		WM_WINDOWPOSCHANGED,
		WM_PAINT,
		WM_CREATE, WM_CLOSE, WM_DESTROY
	DWORD	MainWM_COMMAND,
		MainWM_WINDOWPOSCHANGED,
		MainWM_PAINT,
		MainWM_CREATE, MainWM_CLOSE, MainWM_DESTROY

;Equates used to simplify references to window procedure parameters
lParam 	TEXTEQU	<ebp+14h>
wParam 	TEXTEQU	<ebp+10h>
uMsg   	TEXTEQU	<ebp+0Ch>
hWnd   	TEXTEQU	<ebp+08h>

	.CODE
MainWND	PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	push	ebx
	push	esi
	push	edi

;IF message is not found
	mov	eax,[uMsg]
	mov	edi,OFFSET MainMsg
	mov	ecx,LENGTHOF MainMsg
	repne scasd
	je	Process

;THEN let DefWindowProc handle this message
Default:
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;Msg
	push	[hWnd]			;hWnd
	call	[DefWindowProc]		;USER

	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
	ALIGN 4
Process:
	call	DWORD PTR [edi+(SIZEOF MainMsg-4)]
	jc	Default
Return:
	pop	edi
	pop	esi
	pop	ebx

	mov	esp,ebp
	pop	ebp
	ret	10h
MainWND	ENDP

;;
;;	MAIN WINDOW MENU COMMANDS
;;

	.CONST
MainCmd	DWORD	IDM_EXIT,
		IDM_HELPTOPICS, IDM_ABOUT
	DWORD	MainWM_CLOSE,
		HelpTOPICS, HelpABOUT

	.CODE
MainWM_COMMAND PROC
;IF message is not found
	mov	eax,[wParam]	;LOWORD(wParam)=ID
	mov	edi,OFFSET   MainCmd
	mov	ecx,LENGTHOF MainCmd
	and	eax,0FFFFh
	repne	scasd
	je	Process

;THEN let DefWindowProc handle this message
	stc		;set carry flag for default processing
	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
Process:
	call	DWORD PTR [edi+(SIZEOF MainCmd-4)]
Return:
 	ret
MainWM_COMMAND ENDP

;;
;;	MAIN WINDOW CREATION
;;

	.CONST
szMainClass	BYTE	"Main",0,0,0,0

	.DATA?
hInst		HINSTANCE ?
hwndMain	HWND	?

	.CODE
MainINIT PROC
;Get module handle for this process
	push	0			;pModuleName
	call	[GetModuleHandle]	;KERNEL

	test	eax,eax
	jz	Error

	mov	[hInst],eax
	mov	ebx,eax		;EBX=hInst

;Register the Main window class
	sub	esp,SIZEOF(WNDCLASSEX)	;LOCAL ESP=OFFSET wcex

	xor	eax,eax		;EAX=0
	mov	[esp+WNDCLASSEX.cbSize],SIZEOF(WNDCLASSEX)
	mov	[esp+WNDCLASSEX.style],eax
	mov	[esp+WNDCLASSEX.lpfnWndProc],OFFSET MainWND
	mov	[esp+WNDCLASSEX.cbClsExtra],eax
	mov	[esp+WNDCLASSEX.cbWndExtra],eax
	mov	[esp+WNDCLASSEX.hInstance],ebx

	push	0			;fuLoad
	push	32			;cyDesired
	push	32			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIcon],eax

	push	LR_DEFAULTSIZE OR LR_SHARED	;fuLoad
	push	0			;cyDesired - uses default
	push	0			;cxDesired - uses default
	push	IMAGE_CURSOR		;uType
	push	OCR_NORMAL		;pszName - image identifier
	push	0			;hinst - OEM image
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hCursor],eax
	mov	[esp+WNDCLASSEX.hbrBackground],COLOR_WINDOW + 1
	mov	[esp+WNDCLASSEX.lpszMenuName],IDM_MENU
	mov	[esp+WNDCLASSEX.lpszClassName],OFFSET szMainClass

	push	0			;fuLoad
	push	16			;cyDesired
	push	16			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIconSm],eax

	push	esp			;pwcx
	call	[RegisterClassEx]	;USER

	add	esp,SIZEOF(WNDCLASSEX)	;LOCAL wcex removed

	test	eax,eax
	jz	Error

;Create the Main window
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	eax			;hMenu - NULL, use class menu
	push	eax			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	WS_OVERLAPPEDWINDOW OR WS_VSCROLL OR WS_HSCROLL	;dwStyle
	push	OFFSET szTitle		;pWindowName
	push	OFFSET szMainClass	;pClassName
	push	WS_EX_CLIENTEDGE	;dwExStyle
	call	[CreateWindowEx]	;USER

	test 	eax,eax		;EAX=hwndMain
	jz	Error

;Set the Main window placement
	mov	esi,OFFSET wpMain
	mov	edi,eax		;EDI=hwndMain
	mov	eax,[esi+WINDOWPLACEMENT.showCmd]
	mov	edx,SW_SHOWNORMAL
	cmp	eax,SW_SHOWMINIMIZED	;do not open minimized
	jne	@F

	mov	[esi+WINDOWPLACEMENT.showCmd],edx
@@:
	push	esi			;pWINDOWPLACEMENT
	push	edi			;hWnd
	call	[SetWindowPlacement]	;USER

;Update the Main window
	push	edi			;hWnd
	call	[UpdateWindow]		;USER

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	inc	eax		;return non-zero exit code
	jmp	Return
MainINIT ENDP

	ALIGN 4
MainWM_CREATE PROC
;Get handle to Main window and save it
	mov	esi,[hWnd]	;ESI=hwndMain
	mov	ebx,[hInst]	;EBX=hInst
	mov	[hwndMain],esi

	;;****  OTHER CREATION PROCESSING  ****

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	dec	eax		;return -1 to exit
	jmp	Return
MainWM_CREATE ENDP

;;
;;	MAIN WINDOW TERMINATION
;;

	.CODE
MainWM_CLOSE PROC
;Send WM_DESTROY to destroy the Main window and exit
	push	[hwndMain]		;hWnd
	call	[DestroyWindow]		;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_CLOSE ENDP

	ALIGN	4
MainWM_DESTROY PROC
;Post WM_QUIT to the message queue to exit
	push	0			;nExitCode
	call	[PostQuitMessage]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_DESTROY ENDP

;;
;;	MAIN WINDOW PLACEMENT
;;

	.DATA
wpMain	WINDOWPLACEMENT	<SIZEOF(WINDOWPLACEMENT),0,SW_SHOWDEFAULT,\
		<0,0>, <0,0>, <0, 0, 260h, 1A0h>>

	.DATA?
rcMain	RECT	<>	;Main window client area

	.CODE
MainWM_WINDOWPOSCHANGED PROC
;Get window placement of Main window
	push	OFFSET wpMain		;pWINDOWPLACEMENT
	push	[hwndMain]		;hWnd
	call	[GetWindowPlacement]	;USER

;Get client area of Main window
	mov	edi,OFFSET rcMain

	push	edi			;pRECT
	push	[hwndMain]		;hWnd
	call	[GetClientRect]		;USER

	;;****  OTHER SIZE/POSITION PROCESSING  ****

Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_WINDOWPOSCHANGED ENDP

;;
;;	OTHER MAIN WINDOW MESSAGES
;;

	.CODE
MainWM_PAINT PROC
	sub	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ESP=OFFSET ps

	push	esp			;pPAINTSTRUCT
	push	[hwndMain]		;hWnd
	call	[BeginPaint]		;USER

	;;****  PAINT CLIENT AREA  ****

	push	esp			;pPAINTSTRUCT
	push	[hwndMain]		;hWnd
	call	[EndPaint]		;USER
Return:
	add	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ps removed

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_PAINT ENDP

;;
;;	FILE MENU COMMANDS
;;

	.CONST
szTitle	BYTE	"Bones",0,0,0

;;
;;	HELP MENU COMMANDS
;;

	.CONST
szHelpFile BYTE	"Skeleton.chm",0

	.CODE
HelpTOPICS PROC
	push	0	       		;dwData
	push	HH_DISPLAY_TOPIC	;uCommand
	push	OFFSET szHelpFile	;pszFile
	push	[hWnd]	 		;hwndCaller
	call	[HtmlHelp]		;HTMLHELP

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpTOPICS ENDP

	ALIGN	4
HelpABOUT PROC
	push	0	       		;dwInitParam
	push	OFFSET AboutDLG		;pDialogFunc
	push	[hWnd]	 		;hWndParent
	push	IDD_ABOUT		;pTemplateName - integer resource identifierID
	push	[hInst]	       		;hInstance
	call	[DialogBoxParam]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpABOUT ENDP

	ALIGN	4
AboutDLG PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	mov	eax,[uMsg]

	cmp	eax,WM_INITDIALOG
	je	Processed	;E to process - no initializing required

	cmp	eax,WM_COMMAND
	je	Commands
Default:
	xor	eax,eax		;return FALSE for message not processed
	jmp	Return
Commands:
	mov	eax,[wParam]
	and	eax,0FFFFh
	cmp	eax,IDOK
	je	Done

	cmp	eax,IDCANCEL
	je	Done

	jmp	Default
Done:
	push	TRUE			;nResult
	push	[hWnd]			;hDlg
	call	[EndDialog]		;USER
Processed:
	mov	eax,TRUE	;return TRUE for message processed
Return:
	mov	esp,ebp
	pop	ebp
	ret	10h
AboutDLG ENDP

	END