;;=============================================================================
;;	This file contains a subset of the
;;	Microsoft Win32 API Constants, Structures, and Functions
;;	converted from the Platform SDK Header and Library files for MASM
;;=============================================================================

INCLUDELIB ComCtl32.Lib

;;=============================================================================
;;	Commctrl.h
;;=============================================================================

INITCOMMONCONTROLSEX	STRUCT
 dwSize	DD ?
 dwICC	DD ?
INITCOMMONCONTROLSEX	ENDS

ICC_LISTVIEW_CLASSES	EQU 0001h
ICC_TREEVIEW_CLASSES	EQU 0002h
ICC_BAR_CLASSES		EQU 0004h
ICC_TAB_CLASSES		EQU 0008h
ICC_UPDOWN_CLASS	EQU 0010h
ICC_PROGRESS_CLASS	EQU 0020h
ICC_HOTKEY_CLASS	EQU 0040h
ICC_ANIMATE_CLASS	EQU 0080h
ICC_WIN95_CLASSES	EQU 00FFh
ICC_DATE_CLASSES	EQU 0100h
ICC_USEREX_CLASSES	EQU 0200h
ICC_COOL_CLASSES	EQU 0400h
ICC_INTERNET_CLASSES	EQU 0800h
ICC_PAGESCROLLER_CLASS	EQU 1000h
ICC_NATIVEFNTCTL_CLASS	EQU 2000h

NM_FIRST	EQU 0
NM_SETFOCUS	EQU NM_FIRST-7
NM_KILLFOCUS	EQU NM_FIRST-8

HDM_FIRST	EQU 1200h	; Header messages
HDN_FIRST	EQU -300	; Header notifications

HDS_HORZ	EQU 0000h
HDS_BUTTONS	EQU 0002h
HDS_HOTTRACK	EQU 0004h
HDS_HIDDEN	EQU 0008h
HDS_DRAGDROP	EQU 0040h
HDS_FULLDRAG	EQU 0080h
HDS_FILTERBAR	EQU 0100h

HDITEM		STRUCT
 _mask 		DD ?
 cxy		DD ?
 pszText	DD ?
 hbm		DD ?
 cchTextMax	DD ?
 fmt		DD ?
 lParam		DD ?
HDITEM		ENDS

HDI_WIDTH	EQU 0001h
HDI_HEIGHT	EQU HDI_WIDTH
HDI_TEXT	EQU 0002h
HDI_FORMAT	EQU 0004h
HDI_LPARAM	EQU 0008h
HDI_BITMAP	EQU 0010h

HDF_LEFT	EQU 0
HDF_RIGHT	EQU 1
HDF_CENTER	EQU 2
HDF_JUSTIFYMASK	EQU 3
HDF_RTLREADING	EQU 4

HDF_OWNERDRAW	EQU 8000h
HDF_STRING	EQU 4000h
HDF_BITMAP	EQU 2000h

HDM_GETITEMCOUNT EQU HDM_FIRST + 0
HDM_INSERTITEM	EQU HDM_FIRST + 1
HDM_DELETEITEM	EQU HDM_FIRST + 2
HDM_GETITEM	EQU HDM_FIRST + 3
HDM_SETITEM	EQU HDM_FIRST + 4

HD_LAYOUT	STRUCT
 prc		DD ?
 pwpos		DD ?
HD_LAYOUT	ENDS

HDM_LAYOUT	EQU HDM_FIRST + 5
HHT_NOWHERE	EQU 0001h
HHT_ONHEADER	EQU 0002h
HHT_ONDIVIDER	EQU 0004h
HHT_ONDIVOPEN	EQU 0008h
HHT_ABOVE	EQU 0100h
HHT_BELOW	EQU 0200h
HHT_TORIGHT	EQU 0400h
HHT_TOLEFT	EQU 0800h

HD_HITTESTINFO	STRUCT
  pt		POINT <>
  flags 	DD ?
  iItem 	DD ?
HD_HITTESTINFO	ENDS

HDM_HITTEST	EQU HDM_FIRST + 6

HDN_ITEMCHANGING	EQU HDN_FIRST-0
HDN_ITEMCHANGED		EQU HDN_FIRST-1
HDN_ITEMCLICK		EQU HDN_FIRST-2
HDN_ITEMDBLCLICK	EQU HDN_FIRST-3
HDN_DIVIDERDBLCLICK	EQU HDN_FIRST-5
HDN_BEGINTRACK		EQU HDN_FIRST-6
HDN_ENDTRACK		EQU HDN_FIRST-7
HDN_TRACK		EQU HDN_FIRST-8

HD_NOTIFY	STRUCT
 hdr		NMHDR <>
 iItem 		DD ?
 iButton	DD ?
 pitem 		DD ?
HD_NOTIFY	ENDS

TBBUTTON	STRUCT
 iBitMap	DD ?
 idCommand	DD ?
 fsState	DB ?
 fsStyle	DB ?
		DW ?
 dwData		DD ?
 iString	DD ?
TBBUTTON	ENDS

TBSTATE_CHECKED		EQU 01h
TBSTATE_PRESSED		EQU 02h
TBSTATE_ENABLED		EQU 04h
TBSTATE_HIDDEN		EQU 08h
TBSTATE_INDETERMINATE	EQU 10h
TBSTATE_WRAP		EQU 20h

TBSTYLE_BUTTON		EQU 0h
TBSTYLE_SEP		EQU 1h
TBSTYLE_CHECK		EQU 2h
TBSTYLE_GROUP		EQU 4h
TBSTYLE_CHECKGROUP	EQU TBSTYLE_CHECK + TBSTYLE_GROUP
TBSTYLE_TOOLTIPS	EQU 0100h
TBSTYLE_FLAT		EQU 0800h

TB_ENABLEBUTTON		EQU WM_USER + 1
TB_CHECKBUTTON		EQU WM_USER + 2
TB_PRESSBUTTON		EQU WM_USER + 3
TB_HIDEBUTTON		EQU WM_USER + 4
TB_INDETERMINATE	EQU WM_USER + 5
TB_ISBUTTONENABLED	EQU WM_USER + 9
TB_ISBUTTONCHECKED	EQU WM_USER + 10
TB_ISBUTTONPRESSED	EQU WM_USER + 11
TB_ISBUTTONHIDDEN	EQU WM_USER + 12
TB_ISBUTTONINDETERMINATE EQU WM_USER + 14
TB_SETSTATE		EQU WM_USER + 17
TB_GETSTATE		EQU WM_USER + 18
TB_ADDBITMAP		EQU WM_USER + 19
TB_ADDBUTTONS		EQU WM_USER + 20
TB_ADDSTRING		EQU WM_USER + 28
TB_BUTTONSTRUCTSIZE	EQU WM_USER + 30
TB_SETBUTTONSIZE	EQU WM_USER + 31
TB_SETBITMAPSIZE	EQU WM_USER + 32
TB_AUTOSIZE		EQU WM_USER + 33
TB_SETINDENT		EQU WM_USER + 47

TBADDBITMAP	STRUCT
 hInst		DD ?
 nID		DD ?
TBADDBITMAP	ENDS

HINST_COMMCTRL		EQU -1
IDB_STD_SMALL_COLOR	EQU 0
IDB_STD_LARGE_COLOR	EQU 1
IDB_VIEW_SMALL_COLOR	EQU 4
IDB_VIEW_LARGE_COLOR	EQU 5
IDB_HIST_SMALL_COLOR	EQU 8
IDB_HIST_LARGE_COLOR	EQU 9

STD_CUT		EQU 00h
STD_COPY	EQU 01h
STD_PASTE	EQU 02h
STD_UNDO	EQU 03h
STD_REDOW	EQU 04h
STD_DELETE	EQU 05h
STD_FILENEW	EQU 06h
STD_FILEOPEN	EQU 07h
STD_FILESAVE	EQU 08h
STD_PRINTPRE	EQU 09h
STD_PROPERTIES	EQU 0Ah
STD_HELP	EQU 0Bh
STD_FIND	EQU 0Ch
STD_REPLACE	EQU 0Dh
STD_PRINT	EQU 0Eh

HIST_BACK	EQU 0h
HIST_FORWARD	EQU 1h

TTN_FIRST	EQU -520
TTN_GETDISPINFO	EQU TTN_FIRST - 0

NMTTDISPINFO	STRUCT
 hdr		NMHDR <>
 lpszText	DD ?
 szText		DB 80 DUP (?)
 hinst		DD ?
 uFlags		DD ?
NMTTDISPINFO	ENDS

SBARS_SIZEGRIP	EQU 0100h

SB_SETTEXTA	EQU (WM_USER+1)
SB_SETTEXT	EQU SB_SETTEXTA
SB_SIMPLE	EQU (WM_USER+9)
SBT_NOBORDERS	EQU 0100h
SBT_POPOUT	EQU 0200h

TBM_GETPOS	EQU (WM_USER)
TBM_SETPOS	EQU (WM_USER+5)
TBM_SETRANGE	EQU (WM_USER+6)
TBM_SETTICFREQ	EQU (WM_USER+20)
TBM_SETPAGESIZE	EQU (WM_USER+21)
TB_LINEUP	EQU 00h
TB_LINEDOWN	EQU 01h
TB_PAGEUP	EQU 02h
TB_PAGEDOWN	EQU 03h
TB_THUMBPOSITION EQU 04h
TB_THUMBTRACK	EQU 05h
TB_TOP		EQU 06h
TB_BOTTOM	EQU 07h
TB_ENDTRACK	EQU 08h

UDM_SETRANGE	EQU (WM_USER+101)
UDM_SETPOS	EQU (WM_USER+103)
UDM_GETPOS	EQU (WM_USER+104)

LPSTR_TEXTCALLBACK EQU -1h

TV_FIRST	EQU 1100h

TVN_FIRST	EQU 0-400
TVN_LAST	EQU 0-499

HTREEITEM	TYPEDEF DWORD

TVS_HASBUTTONS		EQU 0001h
TVS_HASLINES		EQU 0002h
TVS_LINESATROOT		EQU 0004h
TVS_EDITLABELS		EQU 0008h
TVS_DISABLEDRAGDROP	EQU 0010h
TVS_SHOWSELALWAYS	EQU 0020h

TVS_RTLREADING		EQU 0040h
TVS_NOTOOLTIPS		EQU 0080h
TVS_CHECKBOXES		EQU 0100h
TVS_TRACKSELECT		EQU 0200h
TVS_SINGLEEXPAND	EQU 0400h
TVS_INFOTIP		EQU 0800h
TVS_FULLROWSELECT	EQU 1000h
TVS_NOSCROLL		EQU 2000h
TVS_NONEVENHEIGHT	EQU 4000h

TVIF_TEXT		EQU 0001h
TVIF_IMAGE		EQU 0002h
TVIF_PARAM		EQU 0004h
TVIF_STATE		EQU 0008h
TVIF_HANDLE		EQU 0010h
TVIF_SELECTEDIMAGE 	EQU 0020h
TVIF_CHILDREN		EQU 0040h

TVIS_FOCUSED		EQU 0001h
TVIS_SELECTED		EQU 0002h
TVIS_CUT		EQU 0004h
TVIS_DROPHILITED	EQU 0008h
TVIS_BOLD		EQU 0010h
TVIS_EXPANDED		EQU 0020h
TVIS_EXPANDEDONCE	EQU 0040h
TVIS_OVERLAYMASK	EQU 0F00h
TVIS_STATEIMAGEMASK 	EQU 0F000h
TVIS_USERMASK		EQU 0F000h

TVITEM		STRUCT
 _mask		DD ?
 hItem		DD ?
 state		DD ?
 stateMask	DD ?
 pszText	DD ?
 cchTextMax	DD ?
 iImage		DD ?
 iSelectedImage	DD ?
 cChildren	DD ?
 dParam		DD ?
TVITEM		ENDS

TVI_ROOT	EQU 0FFFF0000h
TVI_FIRST	EQU 0FFFF0001h
TVI_LAST	EQU 0FFFF0002h
TVI_SORT	EQU 0FFFF0003h

TVINSERTSTRUCT	STRUCT
 hParent	DD ?
 hInsertAfter	DD ?
 item		TVITEM <>
TVINSERTSTRUCT	ENDS

TVM_INSERTITEM	EQU TV_FIRST + 0
TVM_DELETEITEM	EQU TV_FIRST + 1
TVM_EXPAND	EQU TV_FIRST + 2

TVE_COLLAPSE	EQU 0001h
TVE_EXPAND	EQU 0002h
TVE_TOGGLE	EQU 0003h
TVE_COLLAPSERESET EQU 8000h

TVM_GETITEMRECT	EQU TV_FIRST + 4
TVM_GETCOUNT	EQU TV_FIRST + 5
TVM_GETINDENT	EQU TV_FIRST + 6
TVM_SETINDENT	EQU TV_FIRST + 7
TVM_GETIMAGELIST	EQU TV_FIRST + 8
TVM_SETIMAGELIST	EQU TV_FIRST + 9
TVM_GETNEXTITEM		EQU TV_FIRST + 10

TVGN_ROOT		EQU 0000h
TVGN_NEXT		EQU 0001h
TVGN_PREVIOUS		EQU 0002h
TVGN_PARENT		EQU 0003h
TVGN_CHILD		EQU 0004h
TVGN_FIRSTVISIBLE	EQU 0005h
TVGN_NEXTVISIBLE	EQU 0006h
TVGN_PREVIOUSVISIBLE 	EQU 0007h
TVGN_DROPHILITE		EQU 0008h
TVGN_CARET		EQU 0009h

TVM_SELECTITEM		EQU TV_FIRST + 11
TVM_GETITEM		EQU TV_FIRST + 12
TVM_SETITEM		EQU TV_FIRST + 13
TVM_EDITLABEL		EQU TV_FIRST + 14
TVM_GETEDITCONTROL 	EQU TV_FIRST + 15
TVM_GETVISIBLECOUNT 	EQU TV_FIRST + 16
TVM_HITTEST		EQU TV_FIRST + 17

TVHITTESTINFO	STRUCT
 pt		POINT <>
 flags		DD ?
 hItem		DD ?
TVHITTESTINFO	ENDS

TVHT_NOWHERE		EQU 001h
TVHT_ONITEMICON		EQU 002h
TVHT_ONITEMLABEL	EQU 004h
TVHT_ONITEM		EQU TVHT_ONITEMICON + TVHT_ONITEMLABEL + TVHT_ONITEMSTATEICON
TVHT_ONITEMINDENT	EQU 008h
TVHT_ONITEMBUTTON	EQU 010h
TVHT_ONITEMRIGHT	EQU 020h
TVHT_ONITEMSTATEICON 	EQU 040h
TVHT_ABOVE		EQU 100h
TVHT_BELOW		EQU 200h
TVHT_TORIGHT		EQU 400h
TVHT_TOLEFT		EQU 800h

TVM_CREATEDRAGIMAGE 	EQU TV_FIRST + 18
TVM_SORTCHILDREN	EQU TV_FIRST + 19
TVM_ENSUREVISIBLE	EQU TV_FIRST + 20
TVM_SORTCHILDRENCB 	EQU TV_FIRST + 21
TVM_ENDEDITLABELNOW 	EQU TV_FIRST + 22
TVM_GETISEARCHSTRING 	EQU TV_FIRST + 23

TVM_SETTOOLTIPS		EQU TV_FIRST + 24
TVM_GETTOOLTIPS		EQU TV_FIRST + 25
TVM_SETINSERTMARK	EQU TV_FIRST + 26
TVM_SETITEMHEIGHT	EQU TV_FIRST + 27
TVM_GETITEMHEIGHT	EQU TV_FIRST + 28
TVM_SETBKCOLOR		EQU TV_FIRST + 29
TVM_SETTEXTCOLOR	EQU TV_FIRST + 30
TVM_GETBKCOLOR		EQU TV_FIRST + 31
TVM_GETTEXTCOLOR	EQU TV_FIRST + 32
TVM_SETSCROLLTIME	EQU TV_FIRST + 33
TVM_GETSCROLLTIME	EQU TV_FIRST + 34
TVM_SETINSERTMARKCOLOR	EQU TV_FIRST + 37
TVM_GETINSERTMARKCOLOR	EQU TV_FIRST + 38
TVM_GETITEMSTATE	EQU TV_FIRST + 39

TVSORTCB	STRUCT
 hParent	DD ?
 lpfnCompare	DD ?
 lParam		DD ?
TVSORTCB	ENDS

NMTREEVIEW	STRUCT
 hdr		NMHDR <>
 action		DD ?
 itemOld	TVITEM <>
 itemNew	TVITEM <>
 ptDrag		POINT <>
NMTREEVIEW	ENDS

TVN_SELCHANGING	EQU TVN_FIRST-1
TVN_SELCHANGED	EQU TVN_FIRST-2

TVC_UNKNOWN	EQU 0000h
TVC_BYMOUSE	EQU 0001h
TVC_BYKEYBOARD	EQU 0002h

TVN_GETDISPINFO	EQU TVN_FIRST-3
TVN_SETDISPINFO	EQU TVN_FIRST-4

TVIF_DI_SETITEM	EQU 1000h

NMTVDISPINFO	STRUCT
 hdr		NMHDR <>
 item		TVITEM <>
NMTVDISPINFO	ENDS

TVN_ITEMEXPANDING	EQU TVN_FIRST-5
TVN_ITEMEXPANDED	EQU TVN_FIRST-6
TVN_BEGINDRAG		EQU TVN_FIRST-7
TVN_BEGINRDRAG		EQU TVN_FIRST-8
TVN_DELETEITEM		EQU TVN_FIRST-9
TVN_BEGINLABELEDIT	EQU TVN_FIRST-10
TVN_ENDLABELEDIT	EQU TVN_FIRST-11
TVN_KEYDOWN		EQU TVN_FIRST-12
TVN_GETINFOTIP		EQU TVN_FIRST-13

NMTVKEYDOWN	STRUCT
 hdr		NMHDR <>
 wVKey		DW ?
 flags		DD ?
NMTVKEYDOWN	ENDS

NMTVGETINFOTIP	STRUCT
 hdr		NMHDR <>
 pszText	DD ?
 cchTextMax	DD ?
 hItem		DD ?
 dParam		DD ?
NMTVGETINFOTIP	ENDS

;;=============================================================================
;;	ComCtl32.Lib Functions
;;=============================================================================

API CreateMappedBitmap, 20
API CreatePropertySheetPage, 4, %AW
API CreateStatusWindow, 16, %AW
API CreateToolbar, 32
API CreateToolbarEx, 52
API CreateUpDownControl, 48
API DestroyPropertySheetPage, 4
API DrawInsert, 12
API DrawStatusText, 16, %AW
API FlatSB_EnableScrollBar, 12
API FlatSB_GetScrollInfo, 12
API FlatSB_GetScrollPos, 8
API FlatSB_GetScrollProp, 12
API FlatSB_GetScrollRange, 16
API FlatSB_SetScrollInfo, 16
API FlatSB_SetScrollPos, 16
API FlatSB_SetScrollProp, 16
API FlatSB_SetScrollRange, 20
API FlatSB_ShowScrollBar, 12
API GetEffectiveClientRect, 12
API GetMUILanguage, 0
API ImageList_Add, 12
API ImageList_AddIcon, 8
API ImageList_AddMasked, 12
API ImageList_BeginDrag, 16
API ImageList_Copy, 20
API ImageList_Create, 20
API ImageList_Destroy, 4
API ImageList_DragEnter, 12
API ImageList_DragLeave, 4
API ImageList_DragMove, 8
API ImageList_DragShowNolock, 4
API ImageList_Draw, 24
API ImageList_DrawEx, 40
API ImageList_DrawIndirect, 4
API ImageList_Duplicate, 4
API ImageList_EndDrag, 0
API ImageList_GetBkColor, 4
API ImageList_GetDragImage, 8
API ImageList_GetIcon, 12
API ImageList_GetIconSize, 12
API ImageList_GetImageCount, 4
API ImageList_GetImageInfo, 12
API ImageList_GetImageRect, 12
API ImageList_LoadImage, 28, %AW
API ImageList_Merge, 24
API ImageList_Read, 4
API ImageList_Remove, 8
API ImageList_Replace, 16
API ImageList_ReplaceIcon, 12
API ImageList_SetBkColor, 8
API ImageList_SetDragCursorImage, 16
API ImageList_SetFilter, 12
API ImageList_SetFlags, 8
API ImageList_SetIconSize, 12
API ImageList_SetImageCount, 8
API ImageList_SetOverlayImage, 12
API ImageList_Write, 8
API InitCommonControls, 0
API InitCommonControlsEx, 4
API InitMUILanguage, 4
API InitializeFlatSB, 4
API LBItemFromPt, 16
API MakeDragList, 4
API MenuHelp, 28
API PropertySheet, 4, %AW
API ShowHideMenuCtl, 12
API UninitializeFlatSB, 4
API _TrackMouseEvent, 4