;==============================================================================
; IN THE FLESH
; SKELETON Version 3.0
; Copyright 2000 Wayne J. Radburn
;
; Assembles with Microsoft MASM v6.14.8444 as follows:
;    ML /c /coff Flesh.asm
;
; Links with Microsoft LINK v5.12.8181 as follows:
;    LINK /SUBSYSTEM:WINDOWS /ENTRY:Main Flesh.obj FleshRC.obj
;
; See Flesh.rc for how to create FleshRC.obj
;==============================================================================

	.586			;32-Bit when .586 before .MODEL
	.MODEL	FLAT, STDCALL
	OPTION	CASEMAP:NONE

	INCLUDE Kernel32.inc
	INCLUDE	User32.inc
	INCLUDE	ComDlg32.inc
	INCLUDE	ComCtl32.inc
	INCLUDE	htmlhelp.inc

;;
;;	RESOURCE IDs
;;

IDI_ICON	EQU	01h
IDB_TOOLBAR	EQU	01h
IDM_MENU	EQU	01h
IDA_ACCEL	EQU	01h
IDD_ABOUT	EQU	01h

IDM_FILEMENU	EQU	20h
IDM_VIEWMENU	EQU	21h
IDM_HELPMENU	EQU	22h

IDM_OPEN	EQU	23h
IDM_CLOSE	EQU	24h
IDM_EXIT	EQU	25h

IDM_TOOLBAR	EQU	26h
IDM_STATUSBAR	EQU	27h

IDM_HELPTOPICS	EQU	28h
IDM_ABOUT	EQU	29h

;;
;;	WINDOW IDs
;;

ID_TOOLBAR	EQU	0F0h
ID_STATUSBAR	EQU	0F1h
ID_VIEW		EQU	0F2h

;;
;;	MAIN THREAD, WINDOW, and MESSAGE LOOP
;;

	.CODE
Main	PROC
;Initialize the Main window
	call	MainINIT	;returns exit code in EAX

	test	eax,eax		;Z to continue
	jnz	Exit		;NZ to exit

;Process queued messages until WM_QUIT is received
	call	MsgLOOP		;returns exit code in EAX

;End this process and all its threads
Exit:
	push	eax			;nExitCode
	call	[ExitProcess]		;KERNEL

	ret
Main	ENDP

	ALIGN	4
MsgLOOP	PROC
	push	ebp
	sub	esp,SIZEOF(MSG)	;LOCAL EBP=OFFSET msg
	mov	ebp,esp
	jmp	Retrieve

;Dispatch the message to a window procedure
Dispatch:
	push	ebp			;pMsg
	push	[hAccel]		;hAccTable
	push	[hwndMain]		;hWnd
	call	[TranslateAccelerator]	;USER

	test	eax,eax
	jnz	Retrieve	;NZ if already translated and processed

	push	ebp			;pMsg
	call	[TranslateMessage]	;USER

	push	ebp			;pMsg
	call	[DispatchMessage]	;USER

;Retrieve a message from the thread message queue
Retrieve:
	push	0			;wMsgFilterMax
	push	0			;wMsgFilterMin
	push	0			;hWnd
	push	ebp			;pMsg
	call	[GetMessage]		;USER

	cmp	eax,-1
	je	Exit		;E if error so exit

	test	eax,eax		;EAX=0 if WM_QUIT
	jnz	Dispatch	;NZ if other message retrieved so process it

	mov	eax,[ebp+MSG.wParam]	;return ExitCode
Exit:
	add	esp,SIZEOF(MSG)	;LOCAL msg removed
	pop	ebp
	ret
MsgLOOP	ENDP

;;
;;	MAIN WINDOW MESSAGES
;;

       	.CONST
MainMsg	DWORD	WM_NOTIFY, WM_COMMAND, WM_MENUSELECT,
		WM_WINDOWPOSCHANGED,
		WM_ERASEBKGND,
		WM_CREATE, WM_CLOSE, WM_DESTROY
	DWORD	MainWM_NOTIFY, MainWM_COMMAND, MainWM_MENUSELECT,
		MainWM_WINDOWPOSCHANGED,
		MainWM_ERASEBKGND,
		MainWM_CREATE, MainWM_CLOSE, MainWM_DESTROY

;Equates used to simplify references to window procedure parameters
lParam 	TEXTEQU	<ebp+14h>
wParam 	TEXTEQU	<ebp+10h>
uMsg   	TEXTEQU	<ebp+0Ch>
hWnd   	TEXTEQU	<ebp+08h>

	.CODE
MainWND	PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	push	ebx
	push	esi
	push	edi

;IF message is not found
	mov	eax,[uMsg]
	mov	edi,OFFSET MainMsg
	mov	ecx,LENGTHOF MainMsg
	repne scasd
	je	Process

;THEN let DefWindowProc handle this message
Default:
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;Msg
	push	[hWnd]			;hWnd
	call	[DefWindowProc]		;USER

	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
	ALIGN 4
Process:
	call	DWORD PTR [edi+(SIZEOF MainMsg-4)]
	jc	Default
Return:
	pop	edi
	pop	esi
	pop	ebx

	mov	esp,ebp
	pop	ebp
	ret	10h
MainWND	ENDP

;;
;;	MAIN WINDOW NOTIFICATION MESSAGES
;;

	.CONST
MainNtf	DWORD	TTN_GETDISPINFO
	DWORD	TTNGetDispInfo

	.CODE
MainWM_NOTIFY PROC
;IF message is not found
	mov	ebx,[lParam]	;lParam=pNMHDR
	mov	edi,OFFSET   MainNtf
	mov	ecx,LENGTHOF MainNtf
	mov	eax,[ebx+NMHDR.code]
	repne	scasd
	je	Process

;THEN let DefWindowProc handle this message
	stc		;set carry flag for default processing
	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
Process:
	call	DWORD PTR [edi+(SIZEOF MainNtf-4)]
Return:
 	ret
MainWM_NOTIFY ENDP

;;
;;	MAIN WINDOW MENU COMMANDS
;;

	.CONST
MainCmd	DWORD	IDM_OPEN, IDM_CLOSE, IDM_EXIT,
		IDM_TOOLBAR, IDM_STATUSBAR,
		IDM_HELPTOPICS, IDM_ABOUT
	DWORD	FileOPEN, FileCLOSE, MainWM_CLOSE,
		ViewTB, ViewSB,
		HelpTOPICS, HelpABOUT

	.CODE
MainWM_COMMAND PROC
;IF message is not found
	mov	eax,[wParam]	;LOWORD(wParam)=ID
	mov	edi,OFFSET   MainCmd
	mov	ecx,LENGTHOF MainCmd
	and	eax,0FFFFh
	repne	scasd
	je	Process

;THEN let DefWindowProc handle this message
	stc		;set carry flag for default processing
	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
Process:
	call	DWORD PTR [edi+(SIZEOF MainCmd-4)]
Return:
 	ret
MainWM_COMMAND ENDP

;;
;;	MAIN WINDOW CREATION
;;

	.CONST
szMainClass	BYTE	"Main",0,0,0,0
szToolBar	BYTE	"ToolBarWindow32",0
szTreeView	BYTE	"SysTreeView32",0,0,0

	.DATA
;Bits for view options SB TB
fOptions	DWORD	0011b

miiTB	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_CHECKED,IDM_TOOLBAR,>
miiSB	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_CHECKED,IDM_STATUSBAR,>

tbButtons	TBBUTTON <0, IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0>

	.DATA?
hInst		HINSTANCE ?
hwndMain	HWND	?
hMenu		HMENU	?
hAccel		HACCEL	?

hToolBar	HWND	?
hStatusBar	HWND	?

	.CODE
MainINIT PROC
;Get module handle for this process
	push	0			;pModuleName
	call	[GetModuleHandle]	;KERNEL

	test	eax,eax
	jz	Error

	mov	[hInst],eax
	mov	ebx,eax		;EBX=hInst

;Initialize Common Controls
	sub	esp,SIZEOF(INITCOMMONCONTROLSEX)	;LOCAL ESP=OFFSET iccex

	mov	[esp+INITCOMMONCONTROLSEX.dwSize],SIZEOF(INITCOMMONCONTROLSEX)
	mov	[esp+INITCOMMONCONTROLSEX.dwICC],ICC_TREEVIEW_CLASSES OR ICC_BAR_CLASSES

	push	esp			;pInitCtrls
	call	[InitCommonControlsEx]	;COMCTL

	add	esp,SIZEOF(INITCOMMONCONTROLSEX)	;LOCAL iccex removed

;Register the Main window class
	sub	esp,SIZEOF(WNDCLASSEX)	;LOCAL ESP=OFFSET wcex

	xor	eax,eax		;EAX=0
	mov	[esp+WNDCLASSEX.cbSize],SIZEOF(WNDCLASSEX)
	mov	[esp+WNDCLASSEX.style],eax
	mov	[esp+WNDCLASSEX.lpfnWndProc],OFFSET MainWND
	mov	[esp+WNDCLASSEX.cbClsExtra],eax
	mov	[esp+WNDCLASSEX.cbWndExtra],eax
	mov	[esp+WNDCLASSEX.hInstance],ebx

	push	0			;fuLoad
	push	32			;cyDesired
	push	32			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIcon],eax

	push	LR_DEFAULTSIZE OR LR_SHARED	;fuLoad
	push	0			;cyDesired - uses default
	push	0			;cxDesired - uses default
	push	IMAGE_CURSOR		;uType
	push	OCR_NORMAL		;pszName - image identifier
	push	0			;hinst - OEM image
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hCursor],eax
	mov	[esp+WNDCLASSEX.hbrBackground],0	;paint own background
	mov	[esp+WNDCLASSEX.lpszMenuName],IDM_MENU
	mov	[esp+WNDCLASSEX.lpszClassName],OFFSET szMainClass

	push	0			;fuLoad
	push	16			;cyDesired
	push	16			;cxDesired
	push	IMAGE_ICON		;uType
	push	IDI_ICON		;pszName - image identifier
	push	ebx			;hinst
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hIconSm],eax

	push	esp			;pwcx
	call	[RegisterClassEx]	;USER

	add	esp,SIZEOF(WNDCLASSEX)	;LOCAL wcex removed

	test	eax,eax
	jz	Error

;Create the Main window
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	eax			;hMenu - NULL, use class menu
	push	eax			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	WS_OVERLAPPEDWINDOW	;dwStyle
	push	eax			;pWindowName
	push	OFFSET szMainClass	;pClassName
	push	eax			;dwExStyle
	call	[CreateWindowEx]	;USER

	test 	eax,eax		;EAX=hwndMain
	jz	Error

;Set the Main window placement
	mov	esi,OFFSET wpMain
	mov	edi,eax		;EDI=hwndMain
	mov	eax,[esi+WINDOWPLACEMENT.showCmd]
	mov	edx,SW_SHOWNORMAL
	cmp	eax,SW_SHOWMINIMIZED	;do not open minimized
	jne	@F

	mov	[esi+WINDOWPLACEMENT.showCmd],edx
@@:
	push	esi			;pWINDOWPLACEMENT
	push	edi			;hWnd
	call	[SetWindowPlacement]	;USER

;Update the Main window
	push	edi			;hWnd
	call	[UpdateWindow]		;USER

;Set the text for the Main window title bar
	call	FileINIT

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	inc	eax		;return non-zero exit code
	jmp	Return
MainINIT ENDP

	ALIGN 4
MainWM_CREATE PROC
;Get handle to Main window and save it
	mov	esi,[hWnd]	;ESI=hwndMain
	mov	ebx,[hInst]	;EBX=hInst
	mov	[hwndMain],esi

;Load Accelerators
	push	IDA_ACCEL		;pTableName - resource identifier
	push	ebx			;hInstance
	call	[LoadAccelerators]	;USER

	test	eax,eax
	jz	Error

	mov	[hAccel],eax

;Get handle to Main menu and save it
	push	esi			;hWnd
	call	[GetMenu]		;USER

	test	eax,eax
	jz	Error

	mov	[hMenu],eax
	mov	edi,eax		;EDI=hMenu

;Create the ToolBar window and update its menu item info
	mov	eax,MFS_UNCHECKED	;hidden state
	mov	ecx,WS_CHILD OR TBSTYLE_TOOLTIPS OR TBSTYLE_FLAT
	test	[fOptions],1		;ToolBar bit
	jz	@F

	mov	eax,MFS_CHECKED		;visible state
	or	ecx,WS_VISIBLE		;visible style adjustment
@@:
	mov	[miiTB.fState],eax
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	ID_TOOLBAR		;hMenu - window identifier
	push	esi			;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	ecx			;dwStyle
	push	eax			;pWindowName
	push	OFFSET szToolBar	;pClassName
	push	eax			;dwExStyle
	call	[CreateWindowEx]	;USER

	test	eax,eax
	jz	Error

	mov	[hToolBar],eax

	push	OFFSET miiTB		;pmii
	push	FALSE			;fByPosition
	push	IDM_TOOLBAR		;uItem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

;Initialize the ToolBar window
	push	edi			;save hMenu
	sub	esp,SIZEOF(TBADDBITMAP)	;LOCAL ESP=OFFSET tbab

	mov	edi,[hToolBar]		;EDI=hToolBar
	mov	[esp+TBADDBITMAP.hInst],ebx
	mov	[esp+TBADDBITMAP.nID],IDB_TOOLBAR

	push	0			;lParam
	push	SIZEOF(TBBUTTON)	;wParam - cbSize
	push	TB_BUTTONSTRUCTSIZE	;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	0			;lParam
	push	8			;wParam - indentation in pixels
	push	TB_SETINDENT		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	esp			;lParam	- ptbab
	push	1			;wParam - nButtons
	push	TB_ADDBITMAP		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	OFFSET tbButtons	;lParam	- pButtons
	push	1			;wParam - uNumButtons
	push	TB_ADDBUTTONS		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	push	0			;lParam
	push	0			;wParam
	push	TB_AUTOSIZE		;Msg
	push	edi			;hWnd
	call	[SendMessage]		;USER

	add	esp,SIZEOF(TBADDBITMAP)	;LOCAL tbab removed
	pop	edi			;restore hMenu

;Create the StatusBar window and update its menu item info
	mov	eax,MFS_UNCHECKED	;hidden state
	mov	ecx,WS_CHILD OR WS_CLIPSIBLINGS	;hidden style
	test	[fOptions],2		;StatusBar bit
	jz	@F

	mov	eax,MFS_CHECKED		;visible state
	or	ecx,WS_VISIBLE		;visible style adjustment
@@:
	mov	[miiSB.fState],eax

	push	ID_STATUSBAR		;wID
	push	esi			;hwndParent
	push	OFFSET szReady		;pszText
	push	ecx			;style
	call	[CreateStatusWindow]	;COMCTL

	test	eax,eax
	jz	Error

	mov	[hStatusBar],eax

	push	OFFSET miiSB		;pmii
	push	FALSE			;fByPosition
	push	IDM_STATUSBAR		;uItem
	push	edi			;hMenu
	call	[SetMenuItemInfo]	;USER

;Initialize the View window
	call	ViewINIT
	jz	Error

	xor	eax,eax		;return 0 to continue
Return:
	ret
Error:
	dec	eax		;return -1 to exit
	jmp	Return
MainWM_CREATE ENDP

;;
;;	MAIN WINDOW TERMINATION
;;

	.CODE
MainWM_CLOSE PROC
;Close the file
	call	FileUNMAP

;Send WM_DESTROY to destroy the Main window and exit
	push	[hwndMain]		;hWnd
	call	[DestroyWindow]		;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_CLOSE ENDP

	ALIGN	4
MainWM_DESTROY PROC
;Post WM_QUIT to the message queue to exit
	push	0			;nExitCode
	call	[PostQuitMessage]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_DESTROY ENDP

;;
;;	MAIN WINDOW PLACEMENT
;;

	.DATA
wpMain	WINDOWPLACEMENT	<SIZEOF(WINDOWPLACEMENT),0,SW_SHOWDEFAULT,\
		<0,0>, <0,0>, <0, 0, 260h, 1A0h>>

	.DATA?
rcMain		RECT	<>	;Main window client area
rcToolBar	RECT	<>	;ToolBar screen coordinates
rcStatusBar	RECT	<>	;StatusBar screen coordinates

	.CODE
MainWM_WINDOWPOSCHANGED PROC
;Get window placement of Main window
	push	OFFSET wpMain		;pWINDOWPLACEMENT
	push	[hwndMain]		;hWnd
	call	[GetWindowPlacement]	;USER

;Get client area of Main window
	mov	edi,OFFSET rcMain

	push	edi			;pRECT
	push	[hwndMain]		;hWnd
	call	[GetClientRect]		;USER

;Set HIWORD(EBX)=nHeight and LOWORD(EBX)=nWidth for ToolBar and StatusBar
	mov	eax,[edi+RECT.bottom]
	mov	ebx,[edi+RECT.right]
	shl	eax,16
	add	ebx,eax		;EBX=client area

;Notify ToolBar of size change and get new dimensions in screen coordinates
	push	ebx			;lParam	- client area
	push	SIZE_RESTORED		;wParam - resizing flag
	push	WM_SIZE			;Msg
	push	[hToolBar]		;hWnd
	call	[SendMessage]		;USER

	push	OFFSET rcToolBar	;pRECT
	push	[hToolBar]		;hWnd
	call	[GetWindowRect]		;USER

;Notify StatusBar of size change and get new dimensions in screen coordinates
	push	ebx			;lParam - client area
	push	SIZE_RESTORED		;wParam - resizing flag
	push	WM_SIZE			;Msg
	push	[hStatusBar]		;hWnd
	call	[SendMessage]		;USER

	push	OFFSET rcStatusBar	;pRECT
	push	[hStatusBar]		;hWnd
	call	[GetWindowRect]		;USER

;Update display
	call	MainCHANGED
Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_WINDOWPOSCHANGED ENDP

	ALIGN	4
MainCHANGED PROC
;Set vertical position and size of View window
	mov	eax,[fOptions]
	mov	esi,[rcMain.top]	;ESI=yView
	mov	edi,[rcMain.bottom]	;EDI=cyView
	test	eax,1		;ToolBar bit
	jz	NoTB		;Z if not visible

	mov	ecx,[rcToolBar.bottom]
	mov	edx,[rcToolBar.top]
	sub	ecx,edx
	add	esi,ecx		;adjusted by cyToolBar
NoTB:
	test	eax,2		;StatusBar bit
	jz	NoSB		;Z if not visible

	mov	ecx,[rcStatusBar.bottom]
	mov	edx,[rcStatusBar.top]
	sub	ecx,edx
	sub	edi,ecx		;adjusted by cyStatusBar
NoSB:
	sub	edi,esi		;adjusted by cyToolBar and cyStatusBar

;Update dimensions of the View window
	push	SWP_NOZORDER OR SWP_NOACTIVATE OR SWP_NOSENDCHANGING	;uFlags
	push	edi			;cy
	push	[rcMain.right]		;cx
	push	esi			;Y
	push	0			;X
	push	0			;hWndInsertAfter
	push	[hwndView]		;hWnd
	call	[SetWindowPos]		;USER
Return:
	ret
MainCHANGED ENDP

;;
;;	OTHER MAIN WINDOW MESSAGES
;;

	.CODE
MainWM_ERASEBKGND PROC
;IF the ToolBar is visible
	mov	eax,[fOptions]
	xor	ecx,ecx		;ECX=0 for left and top
	test	eax,1		;ToolBar bit
	jz	NoTB		;Z if ToolBar not visible

;THEN erase background for transparent ToolBar
	sub	esp,SIZEOF(RECT)	;LOCAL ESP=OFFSET rcTB

	mov	eax,[rcToolBar.right]
	mov	edx,[rcToolBar.left]
	sub	eax,edx			;width
	mov	[esp+RECT.left],ecx
	mov	[esp+RECT.right],eax
	mov	eax,[rcToolBar.bottom]
	mov	edx,[rcToolBar.top]
	sub	eax,edx			;height
	mov	[esp+RECT.top],ecx
	mov	[esp+RECT.bottom],eax
	mov	eax,esp			;EAX=prcTB

	push	COLOR_3DFACE + 1	;hBrush
	push	eax	      		;pRECT
	push	[wParam]      		;hDC
	call	[FillRect]    		;USER

	add	esp,SIZEOF(RECT)	;LOCAL rcTB removed
NoTB:
	xor	eax,eax		;message processed, clear carry flag
	inc	eax		;return nonzero - background erased
	ret
MainWM_ERASEBKGND ENDP

;;
;;	STATUS BAR MANAGEMENT
;;

	.CONST
MenuHelpIDs	DWORD	0, IDM_FILEMENU	;for StatusBar help text
		DWORD	0, 0

szReady	DB	"Ready",0,0,0
szOpening DB	"Opening...",0,0
szClosing DB	"Closing...",0,0

	.CODE
MainWM_MENUSELECT PROC
	push	OFFSET MenuHelpIDs	;pwIDs
	push	[hStatusBar]		;hwndStatus
	push	[hInst]			;hInst
	push	[hMenu]			;hMainMenu
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;uMsg
	call	[MenuHelp]		;COMCTL

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
MainWM_MENUSELECT ENDP

	ALIGN 4
StatusUPDATE PROC		;ESI=pszStatusText
;Update StatusBar text with given string
	push	esi			;lParam - pszText
	push	0			;wParam - iPart | uType
	push	SB_SETTEXT		;Msg
	push	[hStatusBar]		;hWnd
	call	[SendMessage]		;USER
Return:
	ret
StatusUPDATE ENDP

;;
;;	TOOLTIP NOTIFICATION MESSAGES
;;

	.CODE
TTNGetDispInfo PROC		;EBX=lParam
	mov	eax,[ebx+NMTTDISPINFO.hdr.idFrom]
	mov	edx,[hInst]
	add	eax,80h		;EAX=Tooltip StringID
	mov	[ebx+NMTTDISPINFO.lpszText],eax
	mov	[ebx+NMTTDISPINFO.hinst],edx
	ret
TTNGetDispInfo ENDP

;;
;;	FILE MENU COMMANDS
;;

	.CONST
szTitle		BYTE	"Flesh - "
szUntitled	BYTE	"Untitled",0,0,0,0
szFilter	BYTE	"All Files (*.*)",0,"*.*",0,0

	.DATA
miiFC	MENUITEMINFO <SIZEOF(MENUITEMINFO),MIIM_STATE,,MFS_DISABLED,IDM_CLOSE,>
ofn	OPENFILENAME <SIZEOF(OPENFILENAME), 0, 0,\
			OFFSET szFilter, 0, 0, 1,\
			OFFSET szFileTemp, MAX_PATH,\
			0, 0,\
			0, 0, 0, 0, 0,\
			0, 0, 0, 0>

	.DATA?
pCmdLine	DWORD	?
szWindowName	BYTE	LENGTHOF szTitle DUP (?)
szFile		BYTE	MAX_PATH DUP (?)
szFileTemp	BYTE	MAX_PATH DUP (?)

	.CODE
FileINIT PROC
;Set the text for the Main window title bar to the default
	mov	esi,OFFSET szTitle
	call	FileNAME

;Process command line arguments
	call	[GetCommandLine]	;KERNEL

	mov	[pCmdLine],eax

	;;**** COMMAND LINE PROCESSING ****
	;;* possibly calling FileOPENING  *

	ret
FileINIT ENDP

	ALIGN	4
FileNAME PROC		;ESI=pszTitle or NULL for already initialized
;IF ESI points to text
	mov	edi,OFFSET szWindowName
	test	esi,esi
	jz	Update

;THEN set szWindowName to this text for the title bar
	mov	ecx,LENGTHOF szTitle + LENGTHOF szUntitled
	push	edi
	rep movsb
	pop	edi

;Update the text for the Main window title bar
Update:
	push	edi			;pString
	push	[hwndMain]		;hWnd
	call	[SetWindowText]		;USER

	ret
FileNAME ENDP

	ALIGN	4
FileOPEN PROC
;Select a new file to open
	mov	esi,OFFSET ofn
	mov	eax,[hwndMain]
	mov	ecx,OFN_PATHMUSTEXIST OR OFN_FILEMUSTEXIST OR OFN_HIDEREADONLY OR OFN_EXPLORER
	mov	[esi+OPENFILENAME.hwndOwner],eax
	mov	[esi+OPENFILENAME.Flags],ecx

	push	esi			;pOPENFILENAME
	call	[GetOpenFileName]	;COMDLG

	test	eax,eax
	jz	Return

;Close the current file
	call	FileCLOSE

;Open the new file
	call	FileOPENING

Return:
	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
FileOPEN ENDP

	ALIGN	4
FileOPENING PROC
;Display "Opening..." on the status bar
	mov	esi,OFFSET szOpening
	call	StatusUPDATE

;Open the file
	call	FileMAP		;returns EAX=cbFile or 0

	test	eax,eax
	jz	Error		;Z if error opening file

;Update the name of the currently opened file
	mov	ecx,MAX_PATH
	mov	esi,OFFSET szFileTemp
	mov	edi,OFFSET szFile
	rep movsb

;Set the text for the Main window title bar
	xor	esi,esi
	mov	DWORD PTR [szFileTemp],esi	;clear for next OPENFILENAME
	call	FileNAME

;Set the state for the File Close menu item
	mov	[miiFC.fState],MFS_ENABLED

	push	OFFSET miiFC		;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_CLOSE		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;View the file
	call	ViewFILE
Return:
	ret
Error:
;Close the file
	call	FileUNMAP

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	jmp	Return
FileOPENING ENDP

	ALIGN	4
FileCLOSE PROC
;Display "Closing..." on the status bar
	mov	esi,OFFSET szClosing
	call	StatusUPDATE

;Close the file
	call	FileUNMAP

;Set the text for the Main window title bar to the default
	mov	esi,OFFSET szTitle
	call	FileNAME

;Disable the File Close menu item
	mov	[miiFC.fState],MFS_DISABLED

	push	OFFSET miiFC		;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_CLOSE		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
FileCLOSE ENDP

;;
;;	MEMORY MAPPED FILE MANAGEMENT
;;

	.DATA?
hFile		HANDLE	?
hMapFile	HANDLE	?
pMapFile	DWORD	?
cbFile		DWORD	?

	.CODE
FileMAP	PROC
;Open the file
	push	0			;hTemplateFile
	push	FILE_ATTRIBUTE_NORMAL	;dwFlagsAndAttributes
	push	OPEN_EXISTING		;dwCreationDisposition
	push	0			;pSecurityAttributes
	push	FILE_SHARE_READ		;dwShareMode
	push	GENERIC_READ		;dwDesiredAccess
	push	OFFSET szFileTemp	;pFileName
	call	[CreateFile]		;KERNEL

	cmp	eax,INVALID_HANDLE_VALUE
	je	Error

	mov	[hFile],eax

;Create file mapping
	push	0			;pName
	push	0			;dwMaximumSizeLow
	push	0			;dwMaximumSizeHigh
	push	PAGE_READONLY		;fProtect
	push	0			;pAttributes
	push	eax			;hFile
	call	[CreateFileMapping]	;KERNEL

	test	eax,eax
	jz	Error

	mov	[hMapFile],eax

;Map view of file
	push	0			;dwNumberOfBytesToMap
	push	0			;dwFileOffsetLow
	push	0			;dwFileOffsetHigh
	push	FILE_MAP_READ		;dwDesiredAccess
	push	eax			;hFileMappingObject
	call	[MapViewOfFile]		;KERNEL

	test	eax,eax
	jz	Error

	mov	[pMapFile],eax

;Get the file size
	xor	eax,eax
	mov	[cbFile],eax

	push	0			;pFileSizeHigh
	push	[hFile]			;hFile
	call	[GetFileSize]		;KERNEL

	cmp	eax,0FFFFFFFFh
	je	Error

	mov	[cbFile],eax	;return EAX=cbFile
Return:
	ret
Error:
;Close the file
	call	FileUNMAP	;returns EAX=0
	jmp	Return
FileMAP	ENDP

	ALIGN	4
FileUNMAP PROC
;Unmap view of file
	mov	eax,[pMapFile]
	test	eax,eax
	jz	@F

	push	eax			;pBaseAddress
	call	[UnmapViewOfFile]	;KERNEL

	xor	eax,eax
	mov	[pMapFile],eax
@@:
;Close file mapping
	mov	eax,[hMapFile]
	test	eax,eax
	jz	@F

	push	eax			;hObject
	call	[CloseHandle]		;KERNEL

	xor	eax,eax
	mov	[hMapFile],eax
@@:
;Close the file
	mov	eax,[hFile]
	test	eax,eax
	jz	@F

	push	eax			;hObject
	call	[CloseHandle]		;KERNEL

	xor	eax,eax
	mov	[hFile],eax
@@:
	ret			;return 0
FileUNMAP ENDP

;;
;;	VIEW MENU COMMANDS
;;

	.CODE
ViewTB	PROC
;Switch state of ToolBar
	xor	[fOptions],1	;ToolBar bit
	mov	esi,OFFSET miiTB
	mov	eax,SW_HIDE
	xor	[esi+MENUITEMINFO.fState],MFS_CHECKED
	jz	@F

	mov	eax,SW_SHOW
@@:
;Set new show state and menu item info
	push	eax			;nCmdShow
	push	[hToolBar]		;hWnd
	call	[ShowWindow]		;USER

	push	esi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_TOOLBAR		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Update display
	call	MainCHANGED

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewTB	ENDP

	ALIGN	4
ViewSB	PROC
;Switch state of StatusBar
	xor	[fOptions],2	;StatusBar bit
	mov	esi,OFFSET miiSB
	mov	eax,SW_HIDE
	xor	[esi+MENUITEMINFO.fState],MFS_CHECKED
	jz	@F

	mov	eax,SW_SHOW
@@:
;Set new show state and menu item info
	push	eax			;nCmdShow
	push	[hStatusBar]		;hWnd
	call	[ShowWindow]		;USER

	push	esi			;pMENUITEMINFO
	push	FALSE			;fByPosition
	push	IDM_STATUSBAR		;uItem
	push	[hMenu]			;hMenu
	call	[SetMenuItemInfo]	;USER

;Update display
	call	MainCHANGED

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewSB	ENDP

;;
;;	HELP MENU COMMANDS
;;

	.CONST
szHelpFile BYTE	"Skeleton.chm",0

	.CODE
HelpTOPICS PROC
	push	0	       		;dwData
	push	HH_DISPLAY_TOPIC	;uCommand
	push	OFFSET szHelpFile	;pszFile
	push	[hWnd]	 		;hwndCaller
	call	[HtmlHelp]		;HTMLHELP

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpTOPICS ENDP

	ALIGN	4
HelpABOUT PROC
	push	0	       		;dwInitParam
	push	OFFSET AboutDLG		;pDialogFunc
	push	[hWnd]	 		;hWndParent
	push	IDD_ABOUT		;pTemplateName - integer resource identifierID
	push	[hInst]	       		;hInstance
	call	[DialogBoxParam]	;USER

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
HelpABOUT ENDP

	ALIGN	4
AboutDLG PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	mov	eax,[uMsg]

	cmp	eax,WM_INITDIALOG
	je	Processed	;E to process - no initializing required

	cmp	eax,WM_COMMAND
	je	Commands
Default:
	xor	eax,eax		;return FALSE for message not processed
	jmp	Return
Commands:
	mov	eax,[wParam]
	and	eax,0FFFFh
	cmp	eax,IDOK
	je	Done

	cmp	eax,IDCANCEL
	je	Done

	jmp	Default
Done:
	push	TRUE			;nResult
	push	[hWnd]			;hDlg
	call	[EndDialog]		;USER
Processed:
	mov	eax,TRUE	;return TRUE for message processed
Return:
	mov	esp,ebp
	pop	ebp
	ret	10h
AboutDLG ENDP

;;
;;	VIEW WINDOW CREATION
;;

	.CONST
szViewClass	BYTE	"View",0,0,0,0

	.DATA?
hwndView HANDLE	?
hdcView	HDC	?

	.CODE
ViewINIT PROC
;Register View window class
	sub	esp,SIZEOF(WNDCLASSEX)	;LOCAL ESP=OFFSET wcex

	xor	eax,eax		;EAX=0
	mov	ebx,[hInst]	;EBX=hInst

	mov	[esp+WNDCLASSEX.cbSize],SIZEOF(WNDCLASSEX)
	mov	[esp+WNDCLASSEX.style],CS_OWNDC
	mov	[esp+WNDCLASSEX.lpfnWndProc],OFFSET ViewWND
	mov	[esp+WNDCLASSEX.cbClsExtra],eax
	mov	[esp+WNDCLASSEX.cbWndExtra],eax
	mov	[esp+WNDCLASSEX.hInstance],ebx
	mov	[esp+WNDCLASSEX.hIcon],eax
	mov	[esp+WNDCLASSEX.hIconSm],eax

	push	LR_DEFAULTSIZE OR LR_SHARED	;fuLoad
	push	0			;cyDesired - uses default
	push	0			;cxDesired - uses default
	push	IMAGE_CURSOR		;uType
	push	OCR_NORMAL		;pszName - image identifier
	push	0			;hinst - OEM image
	call	[LoadImage]		;USER

	mov	[esp+WNDCLASSEX.hCursor],eax
	mov	[esp+WNDCLASSEX.hbrBackground],COLOR_WINDOW + 1
	mov	[esp+WNDCLASSEX.lpszMenuName],IDM_MENU
	mov	[esp+WNDCLASSEX.lpszClassName],OFFSET szViewClass

	push	esp			;pWNDCLASSEX
	call	[RegisterClassEx]	;USER

	add	esp,SIZEOF(WNDCLASSEX)	;LOCAL wcex removed

	test	eax,eax
	jz	Return

;Create the View window
	xor	eax,eax		;EAX=0

	push	eax			;pParam
	push	ebx			;hInstance
	push	ID_VIEW			;hMenu - window identifier
	push	[hwndMain]		;hWndParent
	push	eax			;nHeight
	push	eax			;nWidth
	push	eax			;y
	push	eax			;x
	push	WS_CHILD OR WS_CLIPSIBLINGS OR WS_VISIBLE OR WS_VSCROLL OR WS_HSCROLL ;dwStyle
	push	eax			;pWindowName
	push	OFFSET szViewClass	;pClassName
	push	WS_EX_CLIENTEDGE OR WS_EX_NOPARENTNOTIFY	;dwExStyle
	call	[CreateWindowEx]	;USER

	test 	eax,eax		;EAX=hwndView
	jz	Return

	mov	[hwndView],eax

;Get CS_OWNDC for the View window
	push	eax			;hWnd
	call	[GetDC]			;USER

	mov	[hdcView],eax

	xor	eax,eax
	inc	eax		;return non-zero to continue
Return:
	ret
ViewINIT ENDP

;;
;;	VIEW WINDOW MESSAGES
;;

       	.CONST
ViewMsg	DWORD	WM_PAINT, WM_WINDOWPOSCHANGED
	DWORD	ViewWM_PAINT, ViewWM_WINDOWPOSCHANGED

	.CODE
ViewWND	PROC
	push	ebp
	mov	ebp,esp	;hWnd=EBP+08h, uMsg=EBP+0Ch, wParam=EBP+10h, lParam=EBP+14h

	push	ebx
	push	esi
	push	edi

;IF message is not found
	mov	eax,[uMsg]
	mov	edi,OFFSET   ViewMsg
	mov	ecx,LENGTHOF ViewMsg
	repne scasd
	je	Process

;THEN let DefWindowProc handle this message
Default:
	push	[lParam]		;lParam
	push	[wParam]		;wParam
	push	[uMsg]			;uMsg
	push	[hWnd]			;hWnd
	call	[DefWindowProc]		;USER

	jmp	Return

;ELSE process this message possibly setting carry flag for default processing
	ALIGN 4
Process:
	call	DWORD PTR [edi+(SIZEOF ViewMsg-4)]
	jc	Default
Return:
	pop	edi
	pop	esi
	pop	ebx

	mov	esp,ebp
	pop	ebp
	ret	10h
ViewWND	ENDP

;;
;;	VIEW WINDOW PLACEMENT
;;

	.DATA?
rcView	RECT	<>		;View window client area

	.CODE
ViewWM_WINDOWPOSCHANGED PROC
;Get client area of View window
	push	OFFSET rcView		;pRECT
	push	[hwndView]		;hWnd
	call	[GetClientRect]		;USER

	;;****  OTHER SIZE/POSITION PROCESSING  ****

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewWM_WINDOWPOSCHANGED ENDP

;;
;;	OTHER VIEW WINDOW MESSAGES
;;

	.CODE
ViewWM_PAINT PROC
	sub	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ESP=OFFSET ps

	push	esp			;pPAINTSTRUCT
	push	[hwndView]		;hWnd
	call	[BeginPaint]		;USER

	;;****  PAINT CLIENT AREA  ****

	push	esp			;pPAINTSTRUCT
	push	[hwndView]		;hWnd
	call	[EndPaint]		;USER
Return:
	add	esp,SIZEOF(PAINTSTRUCT)	;LOCAL ps removed

	xor	eax,eax		;return 0 - message processed, clear carry flag
	ret
ViewWM_PAINT ENDP

	ALIGN 4
ViewFILE PROC

	;;**** OTHER FILE PROCESSING ****

;Update the client area of the View window
	push	TRUE			;bErase
	push	OFFSET rcView		;pRect
	push	[hwndView]		;hWnd
	call	[InvalidateRect]	;USER

;Display "Ready" on the status bar
	mov	esi,OFFSET szReady
	call	StatusUPDATE

	ret
ViewFILE ENDP

	END