;;=============================================================================
;;	This file contains a subset of the
;;	Microsoft Win32 API Constants, Structures, and Functions
;;	converted from the Platform SDK Header and Library files for MASM
;;=============================================================================

INCLUDELIB Gdi32.Lib

;;=============================================================================
;;	Wingdi.h
;;=============================================================================

SRCCOPY		EQU 00CC0020h	;dest = source
SRCPAINT	EQU 00EE0086h	;dest = source OR dest
SRCAND		EQU 008800C6h	;dest = source AND dest
SRCINVERT	EQU 00660046h	;dest = source XOR dest
SRCERASE	EQU 00440328h	;dest = source AND (NOT dest)
PATINVERT	EQU 005A0049h	;dest = pattern XOR dest
DSTINVERT	EQU 00550009h	;dest = (NOT dest)

TA_LEFT		EQU 000h
TA_RIGHT	EQU 002h
TA_CENTER	EQU 006h
TA_TOP		EQU 000h
TA_BOTTOM	EQU 008h
TA_BASELINE	EQU 018h

ETO_OPAQUE	EQU 02h
ETO_CLIPPED	EQU 04h
ETO_GLYPH_INDEX	EQU 10h

SP_ERROR	EQU -1

BITMAP		STRUCT
 bmType		DD ?
 bmWidth	DD ?
 bmHeight	DD ?
 bmWidthBytes	DD ?
 bmPlanes	DW ?
 bmBitsPixel	DW ?
 bmBits		DD ?
BITMAP		ENDS

TEXTMETRIC		STRUCT
 tmHeight		DD ?
 tmAscent		DD ?
 tmDescent		DD ?
 tmInternalLeading 	DD ?
 tmExternalLeading 	DD ?
 tmAveCharWidth		DD ?
 tmMaxCharWidth		DD ?
 tmWeight		DD ?
 tmOverhang		DD ?
 tmDigitizedAspectX 	DD ?
 tmDigitizedAspectY 	DD ?
 tmFirstChar		S ?
 tmLastChar		S ?
 tmDefaultChar		S ?
 tmBreakChar		S ?
 tmItalic		DB ?
 tmUnderlined		DB ?
 tmStruckOut		DB ?
 tmPitchAndFamily	DB ?
 tmCharSet		DB ?
TEXTMETRIC		ENDS

LF_FACESIZE	EQU 32
LF_FULLFACESIZE EQU 64

LOGFONT		STRUCT
 lfHeight	DD ?
 lfWidth	DD ?
 lfEscapement	DD ?
 lfOrientation	DD ?
 lfWeight	DD ?
 lfItalic	DB ?
 lfUnderline	DB ?
 lfStrikeOut	DB ?
 lfCharSet 	DB ?
 lfOutPrecision	DB ?
 lfClipPrecision DB ?
 lfQuality	DB ?
 lfPitchAndFamily DB ?
 lfFaceName	S LF_FACESIZE DUP (?)
LOGFONT		ENDS

DRAFT_QUALITY	EQU 002h
PROOF_QUALITY	EQU 003h
FIXED_PITCH	EQU 001h
VARIABLE_PITCH	EQU 002h
FW_NORMAL	EQU 400
FW_BOLD		EQU 700
FF_ROMAN	EQU 010h
FF_MODERN	EQU 030h

TRANSPARENT	EQU 01h
OPAQUE		EQU 02h

WHITE_BRUSH	EQU 00h
LTGRAY_BRUSH	EQU 01h
GRAY_BRUSH	EQU 02h
DKGRAY_BRUSH	EQU 03h
BLACK_BRUSH	EQU 04h
ANSI_FIXED_FONT	EQU 0Bh
ANSI_VAR_FONT	EQU 0Ch

PS_SOLID	EQU 00h
PS_DASH		EQU 01h
PS_DOT		EQU 02h
PS_NULL		EQU 05h

GCP_ERROR	EQU 8000h
FLI_MASK	EQU 103Bh
GCP_JUSTIFY	EQU 00010000h

GCP_RESULTS	STRUCT
 lStructSize	DD ?
 lpOutString	DD ?
 lpOrder	DD ?
 lpDx		DD ?
 lpCaretPos	DD ?
 lpClass	DD ?
 lpGlyphs	DD ?
 nGlyphs	DD ?
 nMaxFit	DD ?
GCP_RESULTS	ENDS

DIB_RGB_COLORS	EQU 0
DIB_PAL_COLORS	EQU 1
BI_RGB		EQU 0
BI_RLE8		EQU 1
BI_RLE4		EQU 2
BI_BITFIELDS	EQU 3

DOCINFO		STRUCT
 cbSize		DD ?
 lpszDocName	DD ?
 lpszOutput	DD ?
 lpszDataType	DD ?
 fwType		DD ?
DOCINFO		ENDS

;;=============================================================================
;;	Gdi32.Lib Functions
;;=============================================================================

API AbortDoc, 4
API AbortPath, 4
API AddFontMemResourceEx, 16
API AddFontResource, 4, %AW
API AddFontResourceEx, 12, %AW
API AngleArc, 24
API AnimatePalette, 16
API Arc, 36
API ArcTo, 36
API BeginPath, 4
API BitBlt, 36
API CancelDC, 4
API CheckColorsInGamut, 16
API ChoosePixelFormat, 8
API Chord, 36
API CloseEnhMetaFile, 4
API CloseFigure, 4
API CloseMetaFile, 4
API ColorCorrectPalette, 16
API ColorMatchToTarget, 12
API CombineRgn, 16
API CombineTransform, 12
API CopyEnhMetaFile, 8, %AW
API CopyMetaFile, 8, %AW
API CreateBitmap, 20
API CreateBitmapIndirect, 4
API CreateBrushIndirect, 4
API CreateColorSpace, 4, %AW
API CreateCompatibleBitmap, 12
API CreateCompatibleDC, 4
API CreateDC, 16, %AW
API CreateDIBPatternBrush, 8
API CreateDIBPatternBrushPt, 8
API CreateDIBSection, 24
API CreateDIBitmap, 24
API CreateDiscardableBitmap, 12
API CreateEllipticRgn, 16
API CreateEllipticRgnIndirect, 4
API CreateEnhMetaFile, 16, %AW
API CreateFont, 56, %AW
API CreateFontIndirect, 4, %AW
API CreateFontIndirectEx, 4, %AW
API CreateHalftonePalette, 4
API CreateHatchBrush, 8
API CreateIC, 16, %AW
API CreateMetaFile, 4, %AW
API CreatePalette, 4
API CreatePatternBrush, 4
API CreatePen, 12
API CreatePenIndirect, 4
API CreatePolyPolygonRgn, 16
API CreatePolygonRgn, 12
API CreateRectRgn, 16
API CreateRectRgnIndirect, 4
API CreateRoundRectRgn, 24
API CreateScalableFontResource, 16, %AW
API CreateSolidBrush, 4
API DPtoLP, 12
API DeleteColorSpace, 4
API DeleteDC, 4
API DeleteEnhMetaFile, 4
API DeleteMetaFile, 4
API DeleteObject, 4
API DescribePixelFormat, 16
API DeviceCapabilitiesEx, 24, %AW
API DrawEscape, 16
API Ellipse, 20
API EnableEUDC, 4
API EndDoc, 4
API EndFormPage, 4
API EndPage, 4
API EndPath, 4
API EnumEnhMetaFile, 20
API EnumFontFamilies, 16, %AW
API EnumFontFamiliesEx, 20, %AW
API EnumFonts, 16, %AW
API EnumICMProfiles, 12, %AW
API EnumMetaFile, 16
API EnumObjects, 16
API EqualRgn, 8
API Escape, 20
API EudcLoadLinkW, 16
API EudcUnloadLinkW, 8
API ExcludeClipRect, 20
API ExtCreatePen, 20
API ExtCreateRegion, 12
API ExtEscape, 24
API ExtFloodFill, 20
API ExtSelectClipRgn, 12
API ExtTextOut, 32, %AW
API FillPath, 4
API FillRgn, 12
API FixBrushOrgEx, 16
API FlattenPath, 4
API FloodFill, 16
API FrameRgn, 20
API GdiArtificialDecrementDriver, 8
API GdiComment, 12
API GdiDeleteSpoolFileHandle, 4
API GdiEndDocEMF, 4
API GdiEndPageEMF, 8
API GdiFlush, 0
API GdiGetBatchLimit, 0
API GdiGetDC, 4
API GdiGetDevmodeForPage, 16
API GdiGetPageCount, 4
API GdiGetPageHandle, 12
API GdiGetSpoolFileHandle, 12
API GdiPlayDCScript, 24
API GdiPlayEMF, 20
API GdiPlayJournal, 20
API GdiPlayPageEMF, 20
API GdiPlayPrivatePageEMF, 12
API GdiPlayScript, 28
API GdiResetDCEMF, 8
API GdiSetBatchLimit, 4
API GdiStartDocEMF, 8
API GdiStartPageEMF, 4
API GetArcDirection, 4
API GetAspectRatioFilterEx, 8
API GetBitmapBits, 12
API GetBitmapDimensionEx, 8
API GetBkColor, 4
API GetBkMode, 4
API GetBoundsRect, 12
API GetBrushOrgEx, 8
API GetCharABCWidths, 16, %AW
API GetCharABCWidthsFloat, 16, %AW
API GetCharABCWidthsI, 20
API GetCharWidth32, 16, %AW
API GetCharWidth, 16, %AW
API GetCharWidthFloat, 16, %AW
API GetCharWidthI, 20
API GetCharacterPlacement, 24, %AW
API GetClipBox, 8
API GetClipRgn, 8
API GetColorAdjustment, 8
API GetColorSpace, 4
API GetCurrentObject, 8
API GetCurrentPositionEx, 8
API GetDCBrushColor, 4
API GetDCOrgEx, 8
API GetDCPenColor, 4
API GetDIBColorTable, 16
API GetDIBits, 28
API GetDeviceCaps, 8
API GetDeviceGammaRamp, 8
API GetEnhMetaFile, 4, %AW
API GetEnhMetaFileBits, 12
API GetEnhMetaFileDescription, 12, %AW
API GetEnhMetaFileHeader, 12
API GetEnhMetaFilePaletteEntries, 12
API GetEnhMetaFilePixelFormat, 12
API GetFontAssocStatus, 4
API GetFontData, 20
API GetFontLanguageInfo, 4
API GetFontResourceInfoW, 16
API GetFontUnicodeRanges, 8
API GetGlyphIndices, 20, %AW
API GetGlyphOutline, 28, %AW
API GetGraphicsMode, 4
API GetICMProfile, 12, %AW
API GetKerningPairs, 12, %AW
API GetLayout, 4
API GetLogColorSpace, 12, %AW
API GetMapMode, 4
API GetMetaFile, 4, %AW
API GetMetaFileBitsEx, 12
API GetMetaRgn, 8
API GetMiterLimit, 8
API GetNearestColor, 8
API GetNearestPaletteIndex, 8
API GetObject, 12, %AW
API GetObjectType, 4
API GetOutlineTextMetrics, 12, %AW
API GetPaletteEntries, 16
API GetPath, 16
API GetPixel, 12
API GetPixelFormat, 4
API GetPolyFillMode, 4
API GetROP2, 4
API GetRandomRgn, 12
API GetRasterizerCaps, 8
API GetRegionData, 12
API GetRelAbs, 8
API GetRgnBox, 8
API GetStockObject, 4
API GetStretchBltMode, 4
API GetSystemPaletteEntries, 16
API GetSystemPaletteUse, 4
API GetTextAlign, 4
API GetTextCharacterExtra, 4
API GetTextCharset, 4
API GetTextCharsetInfo, 12
API GetTextColor, 4
API GetTextExtentExPoint, 28, %AW
API GetTextExtentExPointI, 28
API GetTextExtentPoint32, 16, %AW
API GetTextExtentPoint, 16, %AW
API GetTextExtentPointI, 16
API GetTextFace, 12, %AW
API GetTextMetrics, 8, %AW
API GetViewportExtEx, 8
API GetViewportOrgEx, 8
API GetWinMetaFileBits, 20
API GetWindowExtEx, 8
API GetWindowOrgEx, 8
API GetWorldTransform, 8
API IntersectClipRect, 20
API InvertRgn, 8
API LPtoDP, 12
API LineDDA, 24
API LineTo, 12
API MaskBlt, 48
API ModifyWorldTransform, 12
API MoveToEx, 16
API OffsetClipRgn, 12
API OffsetRgn, 12
API OffsetViewportOrgEx, 16
API OffsetWindowOrgEx, 16
API PaintRgn, 8
API PatBlt, 24
API PathToRegion, 4
API Pie, 36
API PlayEnhMetaFile, 12
API PlayEnhMetaFileRecord, 16
API PlayMetaFile, 8
API PlayMetaFileRecord, 16
API PlgBlt, 40
API PolyBezier, 12
API PolyBezierTo, 12
API PolyDraw, 16
API PolyPolygon, 16
API PolyPolyline, 16
API PolyTextOut, 12, %AW
API Polygon, 12
API Polyline, 12
API PolylineTo, 12
API PtInRegion, 12
API PtVisible, 12
API RealizePalette, 4
API RectInRegion, 8
API RectVisible, 8
API Rectangle, 20
API RemoveFontMemResourceEx, 4
API RemoveFontResource, 4, %AW
API RemoveFontResourceEx, 12, %AW
API ResetDC, 8, %AW
API ResizePalette, 8
API RestoreDC, 8
API RoundRect, 28
API SaveDC, 4
API ScaleViewportExtEx, 24
API ScaleWindowExtEx, 24
API SelectBrushLocal, 8
API SelectClipPath, 8
API SelectClipRgn, 8
API SelectFontLocal, 8
API SelectObject, 8
API SelectPalette, 12
API SetAbortProc, 8
API SetArcDirection, 8
API SetBitmapBits, 12
API SetBitmapDimensionEx, 16
API SetBkColor, 8
API SetBkMode, 8
API SetBoundsRect, 12
API SetBrushOrgEx, 16
API SetColorAdjustment, 8
API SetColorSpace, 8
API SetDCBrushColor, 8
API SetDCPenColor, 8
API SetDIBColorTable, 16
API SetDIBits, 28
API SetDIBitsToDevice, 48
API SetDeviceGammaRamp, 8
API SetEnhMetaFileBits, 8
API SetFontEnumeration, 4
API SetGraphicsMode, 8
API SetICMMode, 8
API SetICMProfile, 8, %AW
API SetLayout, 8
API SetMagicColors, 12
API SetMapMode, 8
API SetMapperFlags, 8
API SetMetaFileBitsEx, 8
API SetMetaRgn, 4
API SetMiterLimit, 12
API SetPaletteEntries, 16
API SetPixel, 16
API SetPixelFormat, 12
API SetPixelV, 16
API SetPolyFillMode, 8
API SetROP2, 8
API SetRectRgn, 20
API SetRelAbs, 8
API SetStretchBltMode, 8
API SetSystemPaletteUse, 8
API SetTextAlign, 8
API SetTextCharacterExtra, 8
API SetTextColor, 8
API SetTextJustification, 12
API SetViewportExtEx, 16
API SetViewportOrgEx, 16
API SetWinMetaFileBits, 16
API SetWindowExtEx, 16
API SetWindowOrgEx, 16
API SetWorldTransform, 8
API StartDoc, 8, %AW
API StartFormPage, 4
API StartPage, 4
API StretchBlt, 44
API StretchDIBits, 52
API StrokeAndFillPath, 4
API StrokePath, 4
API SwapBuffers, 4
API TextOut, 20, %AW
API TranslateCharsetInfo, 12
API UnrealizeObject, 4
API UpdateColors, 4
API UpdateICMRegKey, 16, %AW
API WidenPath, 4
API gdiPlaySpoolStream, 24