;;=============================================================================
;;	This file contains a subset of the
;;	Microsoft Win32 API Constants, Structures, and Functions
;;	converted from the Platform SDK Header and Library files for MASM
;;=============================================================================

INCLUDELIB Kernel32.Lib

IFDEF	UNICODE
S	TYPEDEF	WORD
AW	TEXTEQU	<W>
xW	TEXTEQU	<W>
ELSE
S	TYPEDEF	BYTE
AW	TEXTEQU	<A>
xW	TEXTEQU	<>
ENDIF

;;****USE THIS API MACRO IF USING INVOKE TO DEFINE FUNCTION PROTOTYPES****
;D	TYPEDEF	DWORD
;Param	TEXTEQU < :D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D ,:D >
;Params	TEXTEQU <>
;
;API	MACRO	sName:REQ, cbParam:REQ, sAW
;Params	SUBSTR	Param,1,cbParam
;&sName&&sAW&	PROTO Params
;IF @SizeStr(sAW)
;sName	TEXTEQU <&sName&&sAW&>
;ENDIF
;ENDM

;;****USE THIS API MACRO IF NOT USING INVOKE TO DEFINE FUNCTIONS****
API	MACRO	sName:REQ, cbParam:REQ, sAW
EXTERNDEF _imp__&sName&&sAW&@&cbParam:DWORD
sName	TEXTEQU <_imp__&sName&&sAW&@&cbParam>
ENDM

;;=============================================================================
;;	WinDef.H
;;=============================================================================

MAX_PATH	EQU 260
NULL	EQU 0
FALSE	EQU 0
TRUE	EQU 1

BOOL	TYPEDEF	DWORD
LPBYTE	TYPEDEF	PTR BYTE
LPWORD	TYPEDEF	PTR WORD
LPDWORD	TYPEDEF	PTR DWORD
LPVOID	TYPEDEF	PTR
LPCVOID	TYPEDEF	PTR

UINT	TYPEDEF	DWORD
SINT	TYPEDEF	DWORD
LONG	TYPEDEF	DWORD

WPARAM	TYPEDEF	UINT
LPARAM	TYPEDEF	DWORD

HANDLE	TYPEDEF	DWORD
HWND 	TYPEDEF	DWORD
HGLOBAL	TYPEDEF	DWORD
HGDIOBJ	TYPEDEF	DWORD
HACCEL	TYPEDEF	DWORD
HBITMAP	TYPEDEF	DWORD
HBRUSH	TYPEDEF	DWORD
HDC  	TYPEDEF	DWORD
HFONT	TYPEDEF	DWORD
HICON	TYPEDEF	DWORD
HMENU	TYPEDEF	DWORD
HINSTANCE	TYPEDEF	DWORD
HMODULE		TYPEDEF	DWORD
HPEN	TYPEDEF	DWORD
HRGN	TYPEDEF	DWORD
HRSRC	TYPEDEF	DWORD
HCURSOR	TYPEDEF	DWORD
COLORREF	TYPEDEF	DWORD

DC_FIELDS	EQU 1
DC_PAPERS	EQU 2
DC_PAPERSIZE	EQU 3
DC_MINEXTENT	EQU 4
DC_MAXEXTENT	EQU 5
DC_BINS		EQU 6
DC_DUPLEX	EQU 7
DC_SIZE		EQU 8
DC_EXTRA	EQU 9
DC_VERSION	EQU 10
DC_DRIVER	EQU 11
DC_BINNAMES	EQU 12
DC_ENUMRESOLUTIONS	EQU 13
DC_FILEDEPENDENCIES	EQU 14
DC_TRUETYPE	EQU 15
DC_PAPERNAMES	EQU 16
DC_ORIENTATION	EQU 17
DC_COPIES	EQU 18

RECT 	STRUCT
 left	DD ?
 top 	DD ?
 right	DD ?
 bottom	DD ?
RECT 	ENDS

POINT	STRUCT
 x   	DD ?
 y   	DD ?
POINT	ENDS

;;=============================================================================
;;	WinNT.h
;;=============================================================================

LPSTR	TYPEDEF	DWORD
LPCSTR	TYPEDEF	DWORD
ACCESS_MASK	TYPEDEF	DWORD

FILE_ATTRIBUTE_READONLY		EQU 0001h
FILE_ATTRIBUTE_HIDDEN		EQU 0002h
FILE_ATTRIBUTE_SYSTEM		EQU 0004h
FILE_ATTRIBUTE_DIRECTORY	EQU 0010h
FILE_ATTRIBUTE_ARCHIVE		EQU 0020h
FILE_ATTRIBUTE_NORMAL		EQU 0080h
FILE_ATTRIBUTE_TEMPORARY	EQU 0100h
FILE_ATTRIBUTE_COMPRESSED	EQU 0800h

PAGE_NOACCESS	EQU 01h
PAGE_READONLY	EQU 02h
PAGE_READWRITE	EQU 04h
PAGE_WRITECOPY	EQU 08h
MEM_COMMIT	EQU 1000h
MEM_RESERVE	EQU 2000h
MEM_DECOMMIT	EQU 4000h
MEM_RELEASE	EQU 8000h
MEM_FREE	EQU 10000h

FILE_SHARE_READ		EQU 1h
FILE_SHARE_WRITE	EQU 2h

READ_CONTROL	EQU 00020000h
SYNCHRONIZE	EQU 00100000h
STANDARD_RIGHTS_REQUIRED	EQU 000F0000h
STANDARD_RIGHTS_READ		EQU READ_CONTROL
STANDARD_RIGHTS_WRITE		EQU READ_CONTROL
STANDARD_RIGHTS_EXECUTE		EQU READ_CONTROL
STANDARD_RIGHTS_ALL		EQU 001F0000h
SPECIFIC_RIGHTS_ALL		EQU 0000FFFFh

GENERIC_READ	EQU 080000000h
GENERIC_WRITE	EQU 040000000h
GENERIC_EXECUTE	EQU 020000000h
GENERIC_ALL	EQU 010000000h

IMAGE_FILE_HEADER	STRUCT
 Machine		DW ?
 NumberOfSections	DW ?
 TimeDateStamp		DD ?
 PointerToSymbolTable	DD ?
 NumberOfSymbols	DD ?
 SizeOfOptionalHeader	DW ?
 Characteristics	DW ?
IMAGE_FILE_HEADER	ENDS

HEAP_ZERO_MEMORY	EQU 000000008h

DLL_PROCESS_ATTACH	EQU 01h
DLL_THREAD_ATTACH	EQU 02h
DLL_THREAD_DETACH	EQU 03h
DLL_PROCESS_DETACH	EQU 00h

KEY_QUERY_VALUE		EQU 0001h
KEY_SET_VALUE		EQU 0002h
KEY_CREATE_SUB_KEY	EQU 0004h
KEY_ENUMERATE_SUB_KEYS	EQU 0008h
KEY_NOTIFY		EQU 0010h
KEY_CREATE_LINK		EQU 0020h
KEY_READ		EQU STANDARD_RIGHTS_READ OR KEY_QUERY_VALUE OR KEY_ENUMERATE_SUB_KEYS OR KEY_NOTIFY AND NOT(SYNCHRONIZE)
KEY_WRITE		EQU STANDARD_RIGHTS_WRITE OR KEY_SET_VALUE OR KEY_CREATE_SUB_KEY AND NOT(SYNCHRONIZE)
KEY_EXECUTE		EQU KEY_READ AND NOT(SYNCHRONIZE)
KEY_ALL_ACCESS		EQU STANDARD_RIGHTS_ALL OR KEY_QUERY_VALUE OR KEY_SET_VALUE OR KEY_CREATE_SUB_KEY OR KEY_ENUMERATE_SUB_KEYS OR KEY_NOTIFY OR KEY_CREATE_LINK AND NOT(SYNCHRONIZE)

REG_OPTION_NON_VOLATILE	EQU 00000000h
REG_OPTION_VOLATILE	EQU 00000001h
REG_OPTION_CREATE_LINK	EQU 00000002h
REG_OPTION_BACKUP_RESTORE EQU 00000004h
REG_OPTION_OPEN_LINK	EQU 00000008h
REG_LEGAL_OPTION	EQU 0000000Fh
REG_CREATED_NEW_KEY	EQU 00000001h
REG_OPENED_EXISTING_KEY	EQU 00000002h

REG_NONE		EQU 0
REG_SZ			EQU 1
REG_EXPAND_SZ		EQU 2
REG_BINARY		EQU 3
REG_DWORD		EQU 4
REG_DWORD_LITTLE_ENDIAN	EQU 4
REG_DWORD_BIG_ENDIAN	EQU 5
REG_LINK		EQU 6
REG_MULTI_SZ		EQU 7
REG_RESOURCE_LIST	EQU 8
REG_FULL_RESOURCE_DESCRIPTOR EQU 9
REG_RESOURCE_REQUIREMENTS_LIST EQU 10

EXCEPTION_NONCONTINUABLE	EQU 1

;;=============================================================================
;;	WinBase.h
;;=============================================================================

INVALID_HANDLE_VALUE	EQU -1
FILE_FLAG_DELETE_ON_CLOSE EQU 04000000h

CREATE_NEW		EQU 01h
CREATE_ALWAYS		EQU 02h
OPEN_EXISTING		EQU 03h
OPEN_ALWAYS		EQU 04h
TRUNCATE_EXISTING	EQU 05h

OVERLAPPED	STRUCT
 Internal	DD ?
 InternalHigh	DD ?
 _Offset	DD ?
 OffsetHigh	DD ?
 hEvent		DD ?
OVERLAPPED	ENDS

SECURITY_ATTRIBUTES	STRUCT
 nLength		DD ?
 lpSecurityDescriptor	DD ?
 bInheritHandle		DD ?
SECURITY_ATTRIBUTES	ENDS

PROCESS_INFORMATION	STRUCT
 hProcess		DD ?
 hThread		DD ?
 dwProcessID		DD ?
 dwThreadID		DD ?
PROCESS_INFORMATION	ENDS

FILETIME	STRUCT
 dwLowDateTime	DD ?
 dwHighDateTime	DD ?
FILETIME	ENDS

SYSTEMTIME	STRUCT
 wYear		DW ?
 wMonth		DW ?
 wDayOfWeek	DW ?
 wDay		DW ?
 wHour		DW ?
 wMinute	DW ?
 wSecond	DW ?
 wMilliseconds 	DW ?
SYSTEMTIME	ENDS

GMEM_FIXED	EQU 00000h
GMEM_MOVEABLE	EQU 00002h
GMEM_ZEROINIT	EQU 00040h
GMEM_SHARE	EQU 02000h

DEBUG_PROCESS		EQU 001h
DEBUG_ONLY_THIS_PROCESS	EQU 002h
CREATE_SUSPENDED	EQU 004h
DETACHED_PROCESS	EQU 008h
CREATE_NEWE_CONSOLE	EQU 010h
NORMAL_PRIORITY_CLASS	EQU 020h

INFINITE		EQU 0FFFFFFFFh

FILE_MAP_COPY		EQU 01h
FILE_MAP_WRITE		EQU 02h
FILE_MAP_READ		EQU 04h
FILE_MAP_ALL_ACCESS	EQU 0F0017h

LOCALE_SYSTEM_DEFAULT	EQU 00000800h

CP_ACP	EQU 0h

STARTF_USESHOWWINDOW	EQU 0001h
STARTF_USESIZE		EQU 0002h
STARTF_USEPOSITION	EQU 0004h
STARTF_USECOUNTCHARS	EQU 0008h
STARTF_USEFILLATTRIBUTE	EQU 0010h
STARTF_RUNFULLSCREEN	EQU 0020h
STARTF_FORCEONFEEDBACK	EQU 0040h
STARTF_FORCEOFFFEEDBACK	EQU 0080h
STARTF_USESTDHANDLES	EQU 0100h
STARTF_USEHOTKEY	EQU 0200h

STARTUPINFO	STRUCT
 cb		DD ?
 lpReserved	DD ?
 lpDesktop	DD ?
 lpTitle	DD ?
 dwX		DD ?
 dwY		DD ?
 dwXSize	DD ?
 dwYSize	DD ?
 dwXCountChars	DD ?
 dwYCountChars	DD ?
 dwFillAttribute DD ?
 dwFlags	DD ?
 wShowWindow	DW ?
 cbReserved2	DW ?
 lpReserved2	DD ?
 hStdInput	DD ?
 hStdOutput	DD ?
 hStdError	DD ?
STARTUPINFO	ENDS

OSVERSIONINFO STRUCT
 dwOSVersionInfoSize	DD ?
 dwMajorVersion		DD ?
 dwMinorVersion		DD ?
 dwBuildNumber		DD ?
 dwPlatformId		DD ?
 szCSDVersion		S 128 DUP (?)
OSVERSIONINFO ENDS

VER_PLATFORM_WIN32_WINDOWS	EQU	1
VER_PLATFORM_WIN32_NT		EQU	2

;;=============================================================================
;;	WinError.h
;;=============================================================================

ERROR_SUCCESS		EQU 0
ERROR_INVALID_FUNCTION	EQU 1
ERROR_FILE_NOT_FOUND	EQU 2
ERROR_PATH_NOT_FOUND	EQU 3
ERROR_TOO_MANY_OPEN_FILES EQU 4
ERROR_ACCESS_DENIED	EQU 5
ERROR_INVALID_HANDLE	EQU 6
ERROR_ALREADY_EXISTS	EQU 183

;;=============================================================================
;;	Kernel32.Lib Functions
;;=============================================================================

API AddAtom, 4, %AW
API AllocConsole, 0
API AllocateUserPhysicalPages, 12
API AreFileApisANSI, 0
API AssignProcessToJobObject, 8
API BackupRead, 28
API BackupSeek, 24
API BackupWrite, 28
API Beep, 8
API BeginUpdateResource, 8, %AW
API BindIoCompletionCallback, 12
API BuildCommDCB, 8, %AW
API BuildCommDCBAndTimeouts, 12, %AW
API CallNamedPipe, 28, %AW
API CancelDeviceWakeupRequest, 4
API CancelIo, 4
API CancelTimerQueueTimer, 8
API CancelWaitableTimer, 4
API ChangeTimerQueueTimer, 16
API ClearCommBreak, 4
API ClearCommError, 12
API CloseHandle, 4
API CommConfigDialog, 12, %AW
API CompareFileTime, 8
API CompareString, 24, %AW
API ConnectNamedPipe, 8
API ContinueDebugEvent, 12
API ConvertDefaultLocale, 4
API ConvertThreadToFiber, 4
API CopyFile, 12, %AW
API CopyFileEx, 24, %AW
API CreateConsoleScreenBuffer, 20
API CreateDirectory, 8, %AW
API CreateDirectoryEx, 12, %AW
API CreateEvent, 16, %AW
API CreateFiber, 12
API CreateFile, 28, %AW
API CreateFileMapping, 24, %AW
API CreateHardLink, 12, %AW
API CreateIoCompletionPort, 16
API CreateJobObject, 8, %AW
API CreateMailslot, 16, %AW
API CreateMutex, 12, %AW
API CreateNamedPipe, 32, %AW
API CreatePipe, 16
API CreateProcess, 40, %AW
API CreateRemoteThread, 28
API CreateSemaphore, 16, %AW
API CreateTapePartition, 16
API CreateThread, 24
API CreateTimerQueue, 0
API CreateTimerQueueTimer, 28
API CreateToolhelp32Snapshot, 8
API CreateWaitableTimer, 12, %AW
API DebugActiveProcess, 4
API DebugBreak, 0
API DefineDosDevice, 12, %AW
API DeleteAtom, 4
API DeleteCriticalSection, 4
API DeleteFiber, 4
API DeleteFile, 4, %AW
API DeleteTimerQueue, 4
API DeleteTimerQueueEx, 8
API DeleteTimerQueueTimer, 12
API DeleteVolumeMountPoint, 4, %AW
API DeviceIoControl, 32
API DisableThreadLibraryCalls, 4
API DisconnectNamedPipe, 4
API DnsHostnameToComputerName, 12, %AW
API DosDateTimeToFileTime, 12
API DuplicateHandle, 28
API EndUpdateResource, 8, %AW
API EnterCriticalSection, 4
API EnumCalendarInfo, 16, %AW
API EnumCalendarInfoEx, 16, %AW
API EnumDateFormats, 12, %AW
API EnumDateFormatsEx, 12, %AW
API EnumLanguageGroupLocales, 16, %AW
API EnumResourceLanguages, 20, %AW
API EnumResourceNames, 16, %AW
API EnumResourceTypes, 12, %AW
API EnumSystemCodePages, 8, %AW
API EnumSystemLanguageGroups, 12, %AW
API EnumSystemLocales, 8, %AW
API EnumTimeFormats, 12, %AW
API EnumUILanguages, 12, %AW
API EraseTape, 12
API EscapeCommFunction, 8
API ExitProcess, 4
API ExitThread, 4
API ExpandEnvironmentStrings, 12, %AW
API FatalAppExit, 8, %AW
API FatalExit, 4
API FileTimeToDosDateTime, 12
API FileTimeToLocalFileTime, 8
API FileTimeToSystemTime, 8
API FillConsoleOutputAttribute, 20
API FillConsoleOutputCharacter, 20, %AW
API FindAtom, 4, %AW
API FindClose, 4
API FindCloseChangeNotification, 4
API FindFirstChangeNotification, 12, %AW
API FindFirstFile, 8, %AW
API FindFirstFileEx, 24, %AW
API FindFirstVolume, 8, %AW
API FindFirstVolumeMountPoint, 12, %AW
API FindNextChangeNotification, 4
API FindNextFile, 8, %AW
API FindNextVolume, 12, %AW
API FindNextVolumeMountPoint, 12, %AW
API FindResource, 12, %AW
API FindResourceEx, 16, %AW
API FindVolumeClose, 4
API FindVolumeMountPointClose, 4
API FlushConsoleInputBuffer, 4
API FlushFileBuffers, 4
API FlushInstructionCache, 12
API FlushViewOfFile, 8
API FoldString, 20, %AW
API FormatMessage, 28, %AW
API FreeConsole, 0
API FreeEnvironmentStrings, 4, %AW
API FreeLibrary, 4
API FreeLibraryAndExitThread, 8
API FreeResource, 4
API FreeUserPhysicalPages, 12
API GenerateConsoleCtrlEvent, 8
API GetACP, 0
API GetAtomName, 12, %AW
API GetBinaryType, 8, %AW
API GetCPInfo, 8
API GetCPInfoEx, 12, %AW
API GetCalendarInfo, 24, %AW
API GetCommConfig, 12
API GetCommMask, 8
API GetCommModemStatus, 8
API GetCommProperties, 8
API GetCommState, 8
API GetCommTimeouts, 8
API GetCommandLine, 0, %AW
API GetCompressedFileSize, 8, %AW
API GetComputerName, 8, %AW
API GetComputerNameEx, 12, %AW
API GetConsoleCP, 0
API GetConsoleCursorInfo, 8
API GetConsoleMode, 8
API GetConsoleOutputCP, 0
API GetConsoleScreenBufferInfo, 8
API GetConsoleTitle, 8, %AW
API GetCurrencyFormat, 24, %AW
API GetCurrentDirectory, 8, %AW
API GetCurrentProcess, 0
API GetCurrentProcessId, 0
API GetCurrentThread, 0
API GetCurrentThreadId, 0
API GetDateFormat, 24, %AW
API GetDefaultCommConfig, 12, %AW
API GetDevicePowerState, 8
API GetDiskFreeSpace, 20, %AW
API GetDiskFreeSpaceEx, 16, %AW
API GetDriveType, 4, %AW
API GetEnvironmentStrings, 0, %AW
API GetEnvironmentVariable, 12, %AW
API GetExitCodeProcess, 8
API GetExitCodeThread, 8
API GetFileAttributes, 4, %AW
API GetFileAttributesEx, 12, %AW
API GetFileInformationByHandle, 8
API GetFileSize, 8
API GetFileSizeEx, 8
API GetFileTime, 16
API GetFileType, 4
API GetFullPathName, 16, %AW
API GetHandleInformation, 8
API GetLargestConsoleWindowSize, 4
API GetLastError, 0
API GetLocalTime, 4
API GetLocaleInfo, 16, %AW
API GetLogicalDriveStrings, 8, %AW
API GetLogicalDrives, 0
API GetLongPathName, 12, %AW
API GetMailslotInfo, 20
API GetModuleFileName, 12, %AW
API GetModuleHandle, 4, %AW
API GetNamedPipeHandleState, 28, %AW
API GetNamedPipeInfo, 20
API GetNumberFormat, 24, %AW
API GetNumberOfConsoleInputEvents, 8
API GetNumberOfConsoleMouseButtons, 4
API GetOEMCP, 0
API GetOverlappedResult, 16
API GetPriorityClass, 4
API GetPrivateProfileInt, 16, %AW
API GetPrivateProfileSection, 16, %AW
API GetPrivateProfileSectionNames, 12, %AW
API GetPrivateProfileString, 24, %AW
API GetPrivateProfileStruct, 20, %AW
API GetProcAddress, 8
API GetProcessAffinityMask, 12
API GetProcessHeap, 0
API GetProcessHeaps, 8
API GetProcessIoCounters, 8
API GetProcessPriorityBoost, 8
API GetProcessShutdownParameters, 8
API GetProcessTimes, 20
API GetProcessVersion, 4
API GetProcessWorkingSetSize, 12
API GetProfileInt, 12, %AW
API GetProfileSection, 12, %AW
API GetProfileString, 20, %AW
API GetQueuedCompletionStatus, 20
API GetShortPathName, 12, %AW
API GetStartupInfo, 4, %AW
API GetStdHandle, 4
API GetStringType, 20, %AW
API GetStringTypeEx, 20, %AW
API GetSystemDefaultLCID, 0
API GetSystemDefaultLangID, 0
API GetSystemDefaultUILanguage, 0
API GetSystemDirectory, 8, %AW
API GetSystemInfo, 4
API GetSystemPowerStatus, 4
API GetSystemTime, 4
API GetSystemTimeAdjustment, 12
API GetSystemTimeAsFileTime, 4
API GetSystemWindowsDirectory, 8, %AW
API GetTapeParameters, 16
API GetTapePosition, 20
API GetTapeStatus, 4
API GetTempFileName, 16, %AW
API GetTempPath, 8, %AW
API GetThreadContext, 8
API GetThreadLocale, 0
API GetThreadPriority, 4
API GetThreadPriorityBoost, 8
API GetThreadSelectorEntry, 12
API GetThreadTimes, 20
API GetTickCount, 0
API GetTimeFormat, 24, %AW
API GetTimeZoneInformation, 4
API GetUserDefaultLCID, 0
API GetUserDefaultLangID, 0
API GetUserDefaultUILanguage, 0
API GetVersion, 0
API GetVersionEx, 4, %AW
API GetVolumeInformation, 32, %AW
API GetVolumeNameForVolumeMountPoint, 12, %AW
API GetVolumePathName, 12, %AW
API GetWindowsDirectory, 8, %AW
API GetWriteWatch, 24
API GlobalAddAtom, 4, %AW
API GlobalAlloc, 8
API GlobalCompact, 4
API GlobalDeleteAtom, 4
API GlobalFindAtom, 4, %AW
API GlobalFix, 4
API GlobalFlags, 4
API GlobalFree, 4
API GlobalGetAtomName, 12, %AW
API GlobalHandle, 4
API GlobalLock, 4
API GlobalMemoryStatus, 4
API GlobalMemoryStatusEx, 4
API GlobalReAlloc, 12
API GlobalSize, 4
API GlobalUnWire, 4
API GlobalUnfix, 4
API GlobalUnlock, 4
API GlobalWire, 4
API Heap32First, 12
API Heap32ListFirst, 8
API Heap32ListNext, 8
API Heap32Next, 4
API HeapAlloc, 12
API HeapCompact, 8
API HeapCreate, 12
API HeapDestroy, 4
API HeapFree, 12
API HeapLock, 4
API HeapReAlloc, 16
API HeapSize, 12
API HeapUnlock, 4
API HeapValidate, 12
API HeapWalk, 8
API InitAtomTable, 4
API InitializeCriticalSection, 4
API InitializeCriticalSectionAndSpinCount, 8
API InterlockedCompareExchange, 12
API InterlockedDecrement, 4
API InterlockedExchange, 8
API InterlockedExchangeAdd, 8
API InterlockedIncrement, 4
API IsBadCodePtr, 4
API IsBadHugeReadPtr, 8
API IsBadHugeWritePtr, 8
API IsBadReadPtr, 8
API IsBadStringPtr, 8, %AW
API IsBadWritePtr, 8
API IsDBCSLeadByte, 4
API IsDBCSLeadByteEx, 8
API IsDebuggerPresent, 0
API IsProcessorFeaturePresent, 4
API IsSystemResumeAutomatic, 0
API IsValidCodePage, 4
API IsValidLanguageGroup, 8
API IsValidLocale, 8
API LCMapString, 24, %AW
API LeaveCriticalSection, 4
API LoadLibrary, 4, %AW
API LoadLibraryEx, 12, %AW
API LoadModule, 8
API LoadResource, 8
API LocalAlloc, 8
API LocalCompact, 4
API LocalFileTimeToFileTime, 8
API LocalFlags, 4
API LocalFree, 4
API LocalHandle, 4
API LocalLock, 4
API LocalReAlloc, 12
API LocalShrink, 8
API LocalSize, 4
API LocalUnlock, 4
API LockFile, 20
API LockFileEx, 24
API LockResource, 4
API MapUserPhysicalPages, 12
API MapUserPhysicalPagesScatter, 12
API MapViewOfFile, 20
API MapViewOfFileEx, 24
API MapViewOfFileVlm, 28

API Module32First, 8, %xW
API Module32Next, 8, %xW

API MoveFile, 8, %AW
API MoveFileEx, 12, %AW
API MoveFileWithProgress, 20, %AW
API MulDiv, 12
API MultiByteToWideChar, 24
API OpenEvent, 12, %AW
API OpenFile, 12
API OpenFileMapping, 12, %AW
API OpenJobObject, 12, %AW
API OpenMutex, 12, %AW
API OpenProcess, 12
API OpenSemaphore, 12, %AW
API OpenThread, 12
API OpenWaitableTimer, 12, %AW
API OutputDebugString, 4, %AW
API PeekConsoleInput, 16, %AW
API PeekNamedPipe, 24
API PostQueuedCompletionStatus, 16
API PrepareTape, 12

API Process32First, 8, %xW
API Process32Next, 8, %xW

API ProcessIdToSessionId, 8
API PulseEvent, 4
API PurgeComm, 8
API QueryDosDevice, 12, %AW
API QueryInformationJobObject, 20
API QueryPerformanceCounter, 4
API QueryPerformanceFrequency, 4
API QueueUserAPC, 12
API QueueUserWorkItem, 12
API RaiseException, 16
API ReadConsole, 20, %AW
API ReadConsoleInput, 16, %AW
API ReadConsoleOutput, 20, %AW
API ReadConsoleOutputAttribute, 20
API ReadConsoleOutputCharacter, 20, %AW
API ReadDirectoryChangesW, 32
API ReadFile, 20
API ReadFileEx, 20
API ReadFileScatter, 20
API ReadFileVlm, 20
API ReadProcessMemory, 20
API ReadProcessMemoryVlm, 20
API RegisterWaitForSingleObject, 24
API RegisterWaitForSingleObjectEx, 20
API ReleaseMutex, 4
API ReleaseSemaphore, 12
API RemoveDirectory, 4, %AW
API ReplaceFile, 24, %AW
API RequestDeviceWakeup, 4
API RequestWakeupLatency, 4
API ResetEvent, 4
API ResetWriteWatch, 8
API ResumeThread, 4

API RtlFillMemory, 12
FillMemory	TEXTEQU	<RtlFillMemory>
API RtlMoveMemory, 12
MoveMemory	TEXTEQU	<RtlMoveMemory>

API RtlUnwind, 16
API RtlZeroMemory, 8
API ScrollConsoleScreenBuffer, 20, %AW
API SearchPath, 24, %AW
API SetCalendarInfo, 16, %AW
API SetCommBreak, 4
API SetCommConfig, 12
API SetCommMask, 8
API SetCommState, 8
API SetCommTimeouts, 8
API SetComputerName, 4, %AW
API SetComputerNameEx, 8, %AW
API SetConsoleActiveScreenBuffer, 4
API SetConsoleCP, 4
API SetConsoleCtrlHandler, 8
API SetConsoleCursor, 8
API SetConsoleCursorInfo, 8
API SetConsoleCursorPosition, 8
API SetConsoleMode, 8
API SetConsoleOutputCP, 4
API SetConsoleScreenBufferSize, 8
API SetConsoleTextAttribute, 8
API SetConsoleTitle, 4, %AW
API SetConsoleWindowInfo, 12
API SetCriticalSectionSpinCount, 8
API SetCurrentDirectory, 4, %AW
API SetDefaultCommConfig, 12, %AW
API SetEndOfFile, 4
API SetEnvironmentVariable, 8, %AW
API SetErrorMode, 4
API SetEvent, 4
API SetFileApisToANSI, 0
API SetFileApisToOEM, 0
API SetFileAttributes, 8, %AW
API SetFilePointer, 16
API SetFilePointerEx, 20
API SetFileTime, 16
API SetHandleCount, 4
API SetHandleInformation, 12
API SetInformationJobObject, 16
API SetLastError, 4
API SetLocalTime, 4
API SetLocaleInfo, 12, %AW
API SetMailslotInfo, 8
API SetMessageWaitingIndicator, 8
API SetNamedPipeHandleState, 16
API SetPriorityClass, 8
API SetProcessAffinityMask, 8
API SetProcessPriorityBoost, 8
API SetProcessShutdownParameters, 8
API SetProcessWorkingSetSize, 12
API SetStdHandle, 8
API SetSystemPowerState, 8
API SetSystemTime, 4
API SetSystemTimeAdjustment, 8
API SetTapeParameters, 12
API SetTapePosition, 24
API SetThreadAffinityMask, 8
API SetThreadContext, 8
API SetThreadExecutionState, 4
API SetThreadIdealProcessor, 8
API SetThreadLocale, 4
API SetThreadPriority, 8
API SetThreadPriorityBoost, 8
API SetTimeZoneInformation, 4
API SetTimerQueueTimer, 24
API SetUnhandledExceptionFilter, 4
API SetVolumeLabel, 8, %AW
API SetVolumeMountPoint, 8, %AW
API SetWaitableTimer, 24
API SetupComm, 12
API SignalObjectAndWait, 16
API SizeofResource, 8
API Sleep, 4
API SleepEx, 8
API SuspendThread, 4
API SwitchToFiber, 4
API SwitchToThread, 0
API SystemTimeToFileTime, 8
API SystemTimeToTzSpecificLocalTime, 12
API TerminateJobObject, 8
API TerminateProcess, 8
API TerminateThread, 8
API Thread32First, 8
API Thread32Next, 8
API TlsAlloc, 0
API TlsFree, 4
API TlsGetValue, 4
API TlsSetValue, 8
API Toolhelp32ReadProcessMemory, 20
API TransactNamedPipe, 28
API TransmitCommChar, 8
API TryEnterCriticalSection, 4
API UnhandledExceptionFilter, 4
API UnlockFile, 20
API UnlockFileEx, 20
API UnmapViewOfFile, 4
API UnmapViewOfFileVlm, 4
API UnregisterWait, 4
API UnregisterWaitEx, 8
API UpdateResource, 24, %AW
API VerLanguageName, 12, %AW
API VerSetConditionMask, 16
API VerifyVersionInfo, 16, %AW
API VirtualAlloc, 16
API VirtualAllocEx, 20
API VirtualAllocVlm, 24
API VirtualFree, 12
API VirtualFreeEx, 16
API VirtualFreeVlm, 20
API VirtualLock, 8
API VirtualProtect, 16
API VirtualProtectEx, 20
API VirtualProtectVlm, 24
API VirtualQuery, 12
API VirtualQueryEx, 16
API VirtualQueryVlm, 16
API VirtualUnlock, 8
API WaitCommEvent, 12
API WaitForDebugEvent, 8
API WaitForMultipleObjects, 16
API WaitForMultipleObjectsEx, 20
API WaitForSingleObject, 8
API WaitForSingleObjectEx, 12
API WaitNamedPipe, 8, %AW
API WideCharToMultiByte, 32
API WinExec, 8
API WriteConsole, 20, %AW
API WriteConsoleInput, 16, %AW
API WriteConsoleOutput, 20, %AW
API WriteConsoleOutputAttribute, 20
API WriteConsoleOutputCharacter, 20, %AW
API WriteFile, 20
API WriteFileEx, 20
API WriteFileGather, 20
API WriteFileVlm, 20
API WritePrivateProfileSection, 12, %AW
API WritePrivateProfileString, 16, %AW
API WritePrivateProfileStruct, 20, %AW
API WriteProcessMemory, 20
API WriteProcessMemoryVlm, 20
API WriteProfileSection, 8, %AW
API WriteProfileString, 12, %AW
API WriteTapemark, 16
API _hread, 12
API _hwrite, 12
API _lclose, 4
API _lcreat, 8
API _llseek, 12
API _lopen, 8
API _lread, 12
API _lwrite, 12
API lstrcat, 8, %AW
API lstrcmp, 8, %AW
API lstrcmpi, 8, %AW
API lstrcpy, 8, %AW
API lstrcpyn, 12, %AW
API lstrlen, 4, %AW