 ;-------------------------------------------------------------------------------------------  
 ; ASM code by +PedroGranjaCarvalho  steps are:  FOR NASM
 ; -------------------------------------------------------------------------------- 17-12-1999   
 ;   1.Get the instance handle of your program (required)   
 ;   2.Register window class (required ,unless you use predefined window types, eg. MessageBox
 ;     or a dialog box)   
 ;   3.Create the window (required)   
 ;   4.Message Pump or Message Loop (messages are preprocessed to be sent to correspondent
 ;     window procedure)   
 ;   5.window procedure is called by DispatchMessage with the Constants that descrive the
 ;       content of message structure   
 ;      residing on the stack   
 ;   6.Quit program if the user closes the window   
 ;------------------------------------------------------------------------------------------  
 ;=====================================================
 ;FILES NEEDED:
 ;=============
 ; NASM v0.98: http://www.web-sites.co.uk/nasm (official)
 ;           http://ourworld.compuserve.com/homepages/jorgon/NASMjorg.zip
 ;
 ;GoRC v0.53: http://ourworld.compuserve.com/homepages/jorgon/GoRCjorg.zip
 ;        
 ;ALINK v1.6: http://www.geocities.com/SiliconValley/Network/4311/   
 ;WIN32N.INC: http://rs1.szif.hu/~tomcat/win32/win32n.zip
 ;        
 ;WIN32.LIB:  http://www.geocities.com/SiliconValley/Network/4311/win32lib.zip
 ;           http://rs1.szif.hu/~tomcat/win32/
 ;====================================================
;===========================
;CONTACT: assembler@clix.pt  
;=========================== 

 ; -------------------------------------- Import Functions   

%include 'win32n.inc'   

import GetOpenFileNameA comdlg32.dll
extern GetOpenFileNameA
EXTERN LoadCursorA
IMPORT LoadCursorA user32.dll
EXTERN LoadIconA
IMPORT LoadIconA user32.dll
EXTERN GetModuleHandleA   
import GetModuleHandleA kernel32.dll   
EXTERN RegisterClassA   
IMPORT RegisterClassA user32.dll   
EXTERN CreateWindowExA   
IMPORT CreateWindowExA user32.dll   
EXTERN GetMessageA   
IMPORT GetMessageA user32.dll   
EXTERN DispatchMessageA   
IMPORT DispatchMessageA user32.dll   
EXTERN ExitProcess   
IMPORT ExitProcess kernel32.dll   
EXTERN DefWindowProcA   
IMPORT DefWindowProcA user32.dll   
EXTERN PostQuitMessage   
IMPORT PostQuitMessage user32.dll   

EXTERN MessageBoxA
 
EXTERN mciSendStringA

EXTERN ExitProcess

extern sndPlaySoundA


 ; ================================== Code Section   
    

 SECTION CODE USE32 CLASS=CODE   
 
    

 ..start:   
    
    
   
    

; ----------------------- 1 Get the instance handle of your program (required)   
    
    

PUSH DWORD 0 ;PUSH LPCTSTR NULL  ;could be like this too ... (  it's on  ;win32n.inc))   
CALL [GetModuleHandleA]   
MOV [wc+WNDCLASS.hInstance],EAX ;window class wc defenida em baixo   
push dword [wc+WNDCLASS.hInstance] 
pop dword [opfhistance]   
    
    
  

push dword namepicture   
push dword [wc+WNDCLASS.hInstance]   
call [LoadIconA]   
mov [wc+WNDCLASS.hIcon],eax 
push dword cursorepicture
push dword [wc+WNDCLASS.hInstance] 
call [LoadCursorA]
mov [wc+WNDCLASS.hCursor],eax 



;-------------------------------------------------------------------------------------   
    
    
    
    

 ; ----------------------- 2 Register Window Class   
    

 PUSH DWORD wc ; manda para a stack a estrutura de wc a nossa window class   
 CALL [RegisterClassA] ;  obrigatorio a nossa nova class registala.. a call saca da stack a class...   
    
    

 ;-------------------------------- 3 CreateWindowEx   
    
    

 PUSH LPVOID NULL   ;NULL esta no (win32n.inc...)   
 PUSH HINSTANCE [wc+WNDCLASS.hInstance]   
 PUSH HMENU NULL   
 PUSH HWND NULL   
 PUSH INTEGER 65   
 PUSH INTEGER 400   
 PUSH INTEGER 300   
 PUSH INTEGER 320   
 PUSH DWORD WS_CAPTION + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_SIZEBOX + WS_SYSMENU +WS_VISIBLE  ;WS_POPUP | WS_VISIBLE ; ver win32api.hlp esta la os tipos de DWORD  dwStyle   
 PUSH LPCTSTR windowname   
 PUSH LPCTSTR szAppName ;If lpClassName is a string neste caso  szAppName , it specifies thewindow class name ver.. que AT WNDCLASS.lpszClassName, DD szAppName   
 PUSH DWORD WS_EX_CLIENTEDGE + WS_EX_WINDOWEDGE ;0 ;dwExStyle podia ser por exemplo WS_EX_APPWINDOW ver win32api.hlp   
 CALL [CreateWindowExA]   
 mov [windowhandle],eax ; para por caso chamemos dialog boxes etc..   
    

 ;-------------------------------from win32api.hlp ----------------------------------------  
 ;The CreateWindowEx function creates an overlapped, pop-up, or child window with an extended
 ;style; otherwise, this function is identical to the CreateWindow function. For more
 ;information about creating a window and for full descriptions of the other parameters of
 ;CreateWindowEx, see CreateWindow.   
 ;os parametros sao mandados PUSH para stack de ordem inverssa (logicamente claro ;-)  )   
 ;HWND CreateWindowEx(   
 ;   
 ;    DWORD  dwExStyle, // extended window style   
 ;    LPCTSTR  lpClassName, // address of registered class name   
 ;    LPCTSTR  lpWindowName, // address of window name   
 ;    DWORD  dwStyle, // window style   
 ;    int  x, // horizontal position of window   
 ;    int  y, // vertical position of window   
 ;    int  nWidth, // window width   
 ;    int  nHeight, // window height   
 ;    HWND  hWndParent, // handle of parent or owner window   
 ;    HMENU  hMenu, // handle of menu, or child-window identifier   
 ;    HINSTANCE  hInstance, // handle of application instance   
 ;    LPVOID  lpParam  // address of window-creation data   
 ;   );   
 ;------------------------------------------------------------------------------------------   
    
    
    
    
    
    
    

 ; ------------------------ 4  Message Pump or Message Loop   

 msgloop:   

 PUSH UINT NULL   
 PUSH UINT NULL   
 PUSH HWND NULL   
 PUSH DWORD msg   
 CALL [GetMessageA]   
 TEST EAX,EAX   
 JZ quit_received   
 PUSH DWORD msg   
 CALL [DispatchMessageA]   
 JMP msgloop   
    
    
 ;-------------------------- 6 quit program if user close window   

 quit_received:   
 PUSH INTEGER 0   
 CALL [ExitProcess]      
    
    
    
    

 ;---5.window procedure is called by DispatchMessage with the Constants that descrive the
 ;content of message structure residing on the stack   
 ;only two messages are checked the WM_COMMAND for menus and WM_DESTROY that indicates that
 ;window is under destruction   
    
    
    

 windowprocedure:   

 cmp dword [esp+4+msgmsg],WM_COMMAND 
 jne near nothing   

 cmp dword [esp+4+msgwparam],103h   
 je about   

 cmp dword [esp+4+msgwparam],101h
 je procedure1   
    
 cmp dword [esp+4+msgwparam],102h
 je quit_received    

procedure1:

mov  eax,[opf+OPENFILENAME.lpstrFile];---here we make the path that is in the buffer going to variavel 'ficheiro' using EAX
mov  dword [ficheiro],eax     

;-- here opf here is activated with the parameters we made above

PUSH DWORD opf
CALL [GetOpenFileNameA] 


PUSH byte 1
PUSH dword TITULO
PUSH dword Tocar
PUSH byte 0
CALL MessageBoxA







PUSH dword SND_NOSTOP
PUSH DWORD [ficheiro]
call sndPlaySoundA
jmp msgloop

about:

PUSH DWORD 40
PUSH DWORD aboutthis1
PUSH DWORD aboutthis2
PUSH DWORD 0
CALL MessageBoxA

jmp msgloop
 


 nothing:   

 cmp dword [esp+4+msgmsg],WM_DESTROY   
 je endprogram   
 jmp [DefWindowProcA]   
    
    
    

 endprogram:   
 push dword 0   
 call [PostQuitMessage]   
 xor eax,eax   
 ret 16   
    
    

  
    

   
    
    
    
    
    
    
    
    
    

    
    
    
    
    


;================================== Initialised Data Section   
    

 




[SECTION DATA USE32 CLASS=DATA]   

 szAppName DB "win32pgc1999 ",0   
 windowname DB 'W a v e P l a y e r  made in assembler ',0   
 windowhandle DD 0   


;if we use resources  like rs files 
namepicture dd 'picaa',0 
cursorepicture dd 'picab',0 
Menuname dd 'Waveplayer',0   


;---open file

BufferForOurFile times 260 DB (0)   
filtrofile DB ' (*.xm, *.mod , *.*)',0,'*.xm;*.mod;*.*',0,0,0   

nmaxfile EQU 256
ficheiro DD 0
opfhistance dd 0



Tocar DB "Tocar Wave ?",0
TITULO DB "By +Pedro G.C. 1999",0 
aboutthis1 DB '  W A V E   P l A Y E R ',0
aboutthis2 db 'b y  P e d r o G C  1 9 9 9 ',0


;-------our window strutcure ,we call it wc ,if you want you can call it what ever you want  
 
wc:
ISTRUC WNDCLASS
AT WNDCLASS.style,         DD 0
AT WNDCLASS.lpfnWndProc,   DD windowprocedure
AT WNDCLASS.cbClsExtra,    DD 0
AT WNDCLASS.cbWndExtra,    DD 0
AT WNDCLASS.hInstance,     DD NULL
AT WNDCLASS.hIcon,         DD NULL  ; podia ser nomedoicon
AT WNDCLASS.hCursor,       DD NULL
AT WNDCLASS.hbrBackground, DD COLOR_INACTIVECAPTION + 1
AT WNDCLASS.lpszMenuName,  DD Menuname; or NULL if no menu
AT WNDCLASS.lpszClassName, DD szAppName
IEND

;OUR OPENFILE CLASS WE CALL IT opf

opf:
ISTRUC OPENFILENAME
AT OPENFILENAME.lStructSize, DD OPENFILENAME_size
AT OPENFILENAME.hWndOwner,   DD 0
AT OPENFILENAME.hInstance,   DD 0
AT OPENFILENAME.lpstrFilter, DD filtrofile
AT OPENFILENAME.lpstrCustomFilter, DD 0
AT OPENFILENAME.nMaxCustFilter, DD 0
AT OPENFILENAME.nFilterIndex, DD 0
AT OPENFILENAME.lpstrFile, DD BufferForOurFile
AT OPENFILENAME.nMaxFile, DD nmaxfile
AT OPENFILENAME.lpstrFileTitle, DD 0
AT OPENFILENAME.nMaxFileTitle, DD 0
AT OPENFILENAME.lpstrInitialDir, DD 0
AT OPENFILENAME.lpstrTitle, DD 0
AT OPENFILENAME.Flags, DD OFN_LONGNAMES | OFN_EXPLORER
AT OPENFILENAME.nFileOffset, DW 0
AT OPENFILENAME.nFileExtension, DW 0
AT OPENFILENAME.lpstrDefExt, DD 0
AT OPENFILENAME.lCustData, DD 0
AT OPENFILENAME.lpfnHook, DD 0
AT OPENFILENAME.lpTemplateName, DD 0
IEND
 






;---- 5. Contants that descrives the message structure on the stack have to be 0 4 8 12 16
  

 msghwnd equ 0   
 msgmsg  equ 4   
 msgwparam equ 8   
 msglparam equ 12 
    
 



;------------------------------------- Uninitialised Data   
[SECTION DATA? USE32 CLASS=BSS]   
msg RESB MSG_size ;this is the messagebuffer   
    