; Simple demo of the miscellaneous routines
; by Gaz
;
%include "Gaz\Dos\Macros\Misc.mac"
%include "Gaz\Dos\Macros\String.mac"
%include "Gaz\Dos\Macros\System.mac"
;
[BITS 32]
[section .text]
GLOBAL _WDOSXStart
_WDOSXStart:
	push	ds
	pop	es
	DetectOS
	DetectCPU
	Print	_messos				; display intro text
	mov	esi,_osstrtable			; esi->table of addresses of OS strings
	mov	eax,[_os_type]			; eax holds OS type
	shl	eax,2				; *2 because it's 4 bytes/address
	add	esi,eax				; get to right position in table
	PrintLine [esi]				; display OS string
	cmp	[_os_version],dword 0		; does it have a version number?
	je	_nover				; no
	Print	_messver			; yes, display version number
	xor	eax,eax
	mov	ax,[_os_version]		; get version number
	IntToStrU eax,_messver3			; convert to string
	Print _messver3				; and display it
	Print _messver2				; display '.'
	mov	ax,[_os_subversion]		; and display the subversion number
	IntToStrU eax,_messver3
	PrintLine _messver3
_nover:
	Print	_messcpu			; display the CPU type
	mov	esi,_cpu386			; assume 386
	mov	eax,[_cpu_type]
	cmp	eax,_CPU_TYPE_386		; is it a 386?
	je	_displaycpu			; yes, display string
	mov	esi,_cpu486			; no, assume 486
	cmp	eax,_CPU_TYPE_486		; is it a 486?
	je	_displaycpu			; yes, display string
	mov	esi,_cpu586			; no, assume 586
	cmp	eax,_CPU_TYPE_586		; is it a 586?
	je	_displaycpu			; yes, display string
	mov	esi,_cpu686			; no, must be 686
_displaycpu:
	PrintLine esi				; display string
	Print	_messfpu			; display FPU status
	mov	esi,_messyes			; assume there's an FPU
	cmp	[_cpu_fpu],dword _CPU_FPU_SUPPORTED	; is there an FPU?
	je	_displayfpu			; yes, display string
	mov	esi,_messno			; no
_displayfpu:
	PrintLine esi				; display string
	Print	_messmmx			; and finally do the MMX
	mov	esi,_messyes			; assume it's supported
	cmp	[_cpu_mmx],dword _CPU_MMX_SUPPORTED	; is it supported?
	je	_displaymmx			; yes, display string
	mov	esi,_messno			; no
_displaymmx:
	PrintLine esi				; display string
	Exit
;
[section .data]
_osstrtable	dd _osdos
		dd _oswin3
		dd _oswin95
		dd _oswinnt
		dd _osos2
		dd _osos2warp
		dd _osdosemu
		dd _osopendos
;
_osdos		db "MS-DOS",0
_oswin3		db 'Windows 3.x',0
_oswin95	db 'Windows 95',0
_oswinnt	db 'Windows NT',0
_osos2		db 'OS2',0
_osos2warp	db 'OS2/Warp',0
_osdosemu	db 'DOSEmu',0
_osopendos	db 'OpenDOS',0
;
_cpu386		db '80386',0
_cpu486		db '80486',0
_cpu586		db 'Pentium',0
_cpu686		db 'Pentium Pro',0
;
_messos		db 'OS information:',13,10
		db 'OS: ',0
_messver	db 'Version: ',0
_messver2	db '.',0
_messver3	dd 0,0,0,0
_messcpu	db 13,10,'CPU information:',13,10
		db 'CPU: ',0
_messfpu	db 'FPU installed: ',0
_messmmx	db 'MMX capable: ',0
_messyes	db 'Yes',0
_messno		db 'No',0
;
%include "Gaz\Dos\Includes\Routs.inc"
