; Code speed tester, as given in Agner Fog's Pentium Optimisation Manual
; Displays the number of cycles the instructions took
; Pentium+ only!
;
%include "gaz\string.mac"
%include "gaz\system.mac"

ITERATIONS	equ	10			; number of times to test the code

[BITS 32]
[section .text]
GLOBAL _WDOSXStart
_WDOSXStart:
	push	ds
	pop	es
	mov	[_counter],dword 0
_testloop:
;
; Do any initialisations here
;

;
; End of initialisations
;
	rdtsc					; read Pentium's internal clock
	mov	[_tics],eax			; save clock count
	cld					; non-pairable filler
	nop					; eight NOPs to avoid shadowing effect
	nop
	nop
	nop
	nop
	nop
	nop
	nop
;
; Put instructions to test here
;

;
; End of instructions to test
;
	clc					; non-pairable filler with shadow
	rdtsc					; read the new clock count
	sub	eax,[_tics]			; compute difference
	sub	eax,15				; subtract cycles used by fillers, etc.
	mov	edx,[_counter]
	mov	[_results + edx*4],eax		; save result
	inc	dword [_counter]		; another test done
	cmp	[_counter],dword ITERATIONS
	jb	near _testloop
	mov	ecx,[_counter]			; display results
	mov	esi,_results
_printloop:
	IntToStrU [esi],_string
	PrintLine _string
	add	esi,4
	dec	ecx
	jnz	_printloop
	Exit
[section .data]
_counter	dd 0
_tics		dd 0
_string		dd 0,0,0,0

[section .bss]
_results	resd ITERATIONS

%include "gaz\routs.inc"