; Simple demo showing how to use the string routines
; by Gaz
;
; All this does is display all the arguments passed to the program and
; also displays the TMP, NASM and BLASTER environment variables (if
; they exist). Painfully trivial, but the string routines should have
; all the routines you need for manipulation of the arguments.
;
%include "Gaz\Dos\Macros\System.mac"
%include "Gaz\Dos\Macros\String.mac"
;
[BITS 32]
[section .text]
GLOBAL _WdosxStart
_WdosxStart:
	push	ds
	pop	es
	ArgsInit				; initialise argument routines
	Argc	ecx				; get number of parameters
	mov	eax,1
_loop:
	Argv	eax,esi				; get the parameter
	PrintLine esi				; and display it
	inc	eax				; display all parameters
	cmp	eax,ecx
	jbe	_loop
	GetEnv	_tmpstr,esi			; display TMP environment variable
	jc	_notmp
	PrintLine esi
_notmp:
	GetEnv	_blasterstr,esi			; display BLASTER environment variable
	jc	_noblaster
	PrintLine esi
_noblaster:
	GetEnv	_nasmstr,esi			; display NASM environment variable
	jc	_exit
	PrintLine esi
_exit:
	Exit
;
[section .data]
_tmpstr		db 'tmp',0
_blasterstr	db 'blaster',0
_nasmstr	db 'nasm',0
;
%include "Gaz\Dos\Includes\Routs.inc"
