; VESA VBE example program - switches to 640x480x256 mode, draws
; scanlines until line 480 then waits for a keypress. Last scanline
; is drawn differently so you know when it's done.
; Reports type of bank switching used on return
;
%include "Gaz\Dos\Macros\System.mac"
%include "Gaz\Dos\Macros\Video.mac"
[BITS 32]
[section .text]
GLOBAL  _WdosxStart
_WdosxStart:
	push	ds
	pop	es
	VBEInit	1			; initialise video subsystem, reporting information
	jc	near _end6		; no VBE!
	mov	edx,_Choices		; display choices on screen
	mov	ah,9
	int	$21
	xor	eax,eax			; wait for a keypress
	int	$16
	mov	edx,640			; edx holds x resolution to set
	cmp	al,'1'			; use real-mode bank switching?
	jne	_no1			; no
	or	edx,$080010000		; yes, force it
_no1:
	cmp	al,'2'			; use pmode bank switching?
	jne	_no2			; no
	or	edx,$080020000		; yes, force it
_no2:
	cmp	al,'3'			; use LFB?
	jne	_no3			; no
	or	edx,$080040000		; yes, force it
_no3:
	cmp	al,'4'			; use card's best type?
	je	_go			; yes
	cmp	edx,640			; another key pressed?
	je	near _end6		; yes, exit
_go:
	cmp	al,'4'			; are we after the card's best type?
	jne	_go2			; no
	mov	edx,640			; yes, just go for the best the card can do
_go2:
	VBESetMode	edx,480,8,1	; try and set 640x480x256 and report information
	jnc	_init_vbe_mode_ok	; everything's ok
	mov	edx,VESAErrorStr	; can't set mode!
	mov	ah,9			; report error
	int	$21
	Exit				; exit
_init_vbe_mode_ok:
	mov	eax,[_VESABankFlag]	; have we got an LFB?
	cmp	eax,1
	jne	_init_vbe_nolfbdouble	; no
	mov	eax,[_VESADoubleFlag]	; have we got a double-buffer?
	or	eax,eax
	jz	_init_vbe_nolfbdouble	; no
	mov	[_lfbdouble],dword 1
_init_vbe_nolfbdouble:
	mov	edi,[_VESAScreen]	; clear the screen
	mov	ecx,160*480		; (640/4)*480 dwords to do
_clear_loop:
	mov	[edi],dword 0		; clear dword
	add	edi,4			; next dword on
	dec	ecx			; one dword done
	jnz	_clear_loop		; loop to do all dwords
_main_loop:
	VBEDoScreen			; display screen
	mov	edi,[_VESAScreen]	; the screen
	add	edi,[_offset]		; offset into the screen
	mov	ecx,160			; draw one scanline
	cmp	[_lfbdouble],dword 0
	jz	_myloop
	mov	ecx,320
_myloop:
	mov	[edi],dword $0aabbccdd	; draw the scanline
	add	edi,4
	dec	ecx
	jnz	_myloop
	add	[_offset],dword 640	; onto next scanline
	cmp	[_offset],dword 640*479	; 479 scanlines done?
	jl	_main_loop		; no, keep drawing each scanline
_end:
	mov	edi,[_VESAScreen]	; the screen
	add	edi,[_offset]		; offset into the screen
	mov	ecx,160			; draw one scanline
_myloop2:
	mov	[edi],dword $0dddddddd	; draw the final scanline
	add	edi,4
	dec	ecx
	jnz	_myloop2
	VBEDoScreen			; display screen
	xor	eax,eax			; wait for a keypress
	int	$16
	VBEExit				; back to text mode
	mov	eax,[_VESABankFlag]	; type of bank switching used
	cmp	eax,1			; LFB?
	jne	_end2
	mov	edx,_Str1
	mov	ah,9
	int	$21
_end2:
	cmp	eax,2			; pmode bank switching
	jne	_end3
	mov	edx,_Str2
	mov	ah,9
	int	$21
_end3:
	cmp	eax,4			; real-mode bank switching :(
	jne	_end4
	mov	edx,_Str3
	mov	ah,9
	int	$21
_end4:
	cmp	[_VESADoubleFlag],dword 0
	je	_end5
	mov	edx,_Str4
	mov	ah,9
	int	$21
_end5:
	cmp	[_VESAOptimisedFlag],dword 0
	je	_end6
	mov	edx,_Str5
	mov	ah,9
	int	$21
_end6:
	Exit
;
;-------------------------------------------------------------------------
;
[section .data]
VESAErrorStr	db 10,13,"Madness! Your graphics card doesn't support 640x480x256 mode!$"
_offset		dd 0
_lfbdouble	dd 0
_Choices	db 10,13,10,13,"Press (or any other key to exit):",10,13,"1 for linear framebuffer"
		db 10,13,"2 for protected mode bank switching"
		db 10,13,"3 for real mode bank switching"
		db 10,13,"4 to detect and use card's best type"
		db 10,13,10,13,"Note that 1 and 2 may not always be available."
		db 10,13,"The actual type used is displayed on exit.$"
_Str1		db "Linear frame buffer used.",10,13,"$"
_Str2		db "Protected mode bank switching used.",10,13,"$"
_Str3		db "Real-mode bank switching used.",10,13,"$"
_Str4		db "Hardware double-buffer used.",10,13,"$"
_Str5		db "Pentium-optimised screen copying routines used.",10,13,"$"
_BankMode	dd 0
;
;-------------------------------------------------------------------------
;
%include "Gaz\Dos\Includes\Routs.inc"
