; File subsystem
; by Gaz
;
%ifndef _MYFILE
%define _MYFILE

_myfile_open_readonly		equ 0
_myfile_open_writeonly		equ 1
_myfile_open_readandwrite	equ 2

[BITS 32]
[section .bss]
_myfile_spare		resd 1

[section .text]
;
;--------------------------------------------------------------------
;
; Loads a file
;
%ifdef _MYFILE_LOAD_MACRO
_myfile_load_2:
	push	eax
	push	ebx
	mov	eax,[esp + 16]
	mov	ebx,[esp + 12]
	FileOpen eax,ax
	jc	_myfile_load_error
	FileRead ax,ebx,$0ffffffff
	jc	_myfile_load_error
	FileClose ax
	jc	_myfile_load_error
	pop	ebx
	pop	eax
	clc
	ret
_myfile_load_error:
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Saves a file
;
%ifdef _MYFILE_SAVE_MACRO
_myfile_save_2:
	push	eax
	push	ebx
	push	ecx
	mov	eax,[esp + 24]
	mov	ebx,[esp + 20]
	mov	ecx,[esp + 16]
	FileCreate eax,ax
	jc	_myfile_save_error
	FileWrite ax,ebx,ecx
	jc	_myfile_save_error
	FileWrite ax,ebx,0
	jc	_myfile_save_error
	FileClose ax
	jc	_myfile_save_error
	pop	ecx
	pop	ebx
	pop	eax
	clc
	ret
_myfile_save_error:
	pop	ecx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Creates a file
;
%ifdef _MYFILE_CREATE_MACRO
_myfile_create_2:
	push	eax
	push	ecx
	push	edx
	mov	ah,$03c
	xor	ecx,ecx
	mov	edx,[esp + 16]
	int	$21
	jc	_myfile_create_error
	mov	[_myfile_spare],ax
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_create_error:
	mov	[_myfile_spare],dword 0
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Opens a file
;
%ifdef _MYFILE_OPEN_MACRO
_myfile_open_2:
	push	eax				; save registers
	push	ebx
	push	edx
	mov	edx,[esp + 16]			; edx -> filename
	mov	ah,$03d				; open file function
	mov	al,_myfile_open_readandwrite	; open for reading + writing
	int	$21				; open file
	jc	_myfile_open_trywfse
	mov	[_myfile_spare],ax		; save file handle
	pop	edx
	pop	ebx
	pop	eax
	clc
	ret
_myfile_open_trywfse:
	mov	eax,$0fffd			; WFSE installed?
	int	$21
	jc	_myfile_open_error
	mov	eax,$03d00fffd			; WFSE open file
	int	$21
	jc	_myfile_open_error
	mov	[_myfile_spare],ax
	pop	edx
	pop	ebx
	pop	eax
	clc
	ret
_myfile_open_error:
	pop	edx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Checks whether a file exists by trying to open it (read-only)
;
%ifdef _MYFILE_EXISTS_MACRO
_myfile_exists_2:
	push	eax				; save registers
	push	ebx
	push	edx
	mov	edx,[esp + 16]			; edx -> filename
	mov	ah,$03d				; open file function
	mov	al,_myfile_open_readonly	; open as read only
	int	$21				; open file
	jc	_myfile_exists_trywfse
	FileClose ax				; close file
	pop	edx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_myfile_exists_trywfse:
	mov	eax,$0fffd			; WFSE installed?
	int	$21
	jc	_myfile_exists_error
	mov	eax,$03d00fffd			; WFSE open file
	int	$21
	jc	_myfile_exists_error
	FileClose ax
	pop	edx
	pop	ebx
	pop	eax
	clc
	ret
_myfile_exists_error:
	pop	edx
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Closes a file
;
%ifdef _MYFILE_CLOSE_MACRO
_myfile_close_2:
	push	eax
	mov	eax,ebx
	and	eax,$08000			; mask off top bit
	jnz	_myfile_close_wfse		; WFSE file
	mov	ah,$03e
	int	$21
	jc	_myfile_close_error
	pop	eax
	clc
	ret
_myfile_close_wfse:
	mov	eax,$03e00fffd			; WFSE close file
	int	$21
	jc	_myfile_close_error
	pop	eax
	clc
	ret
_myfile_close_error:
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Checks whether the end of the file has been reached
;
%ifdef _MYFILE_EOF_MACRO
_myfile_eof_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_eof_wfse
	mov	ah,$03f
	mov	ecx,1
	mov	edx,_myfile_spare
	int	$21
	jc	_myfile_eof_error
	cmp	eax,0
	je	_myfile_eof_error
	FileSeek bx,-1
	jc	_myfile_eof_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_eof_wfse:
	mov	eax,$03f00fffd
	mov	ecx,1
	mov	edx,_myfile_spare
	int	$21
	jc	_myfile_eof_error
	cmp	eax,0
	je	_myfile_eof_error
	FileSeek bx,-1
	jc	_myfile_eof_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_eof_error:
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Returns a file's size
;
%ifdef _MYFILE_SIZE_MACRO
_myfile_size_2:
	push	ecx
	push	edx
	FilePosition bx,ecx
	jc	_myfile_size_error
	FileSeekAbsolute bx,0
	jc	_myfile_size_error2
	xor	edx,edx
_myfile_size_loop:
	FileRead bx,_myfile_spare,1
	jc	_myfile_size_loop_end
	inc	edx
	jmp	_myfile_size_loop
_myfile_size_loop_end:
	mov	[_myfile_spare],edx
	FileSeekAbsolute bx,ecx
	jc	_myfile_size_error
	pop	edx
	pop	ecx
	clc
	ret
_myfile_size_error2:
	FileSeekAbsolute bx,ecx
_myfile_size_error:
	mov	[_myfile_spare],dword 0
	pop	edx
	pop	ecx
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Seeks within a file
;
%ifdef _MYFILE_SEEK_MACRO
_myfile_seek_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_seek_wfse
	mov	eax,$04201			; relative seek
	mov	edx,[esp + 20]			; cx:dx = seek count
	mov	ecx,edx
	shr	ecx,16
	int	$21
	jc	_myfile_seek_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_seek_wfse:
	mov	eax,$04201FFFD			; relative seek
	mov	edx,[esp + 20]			; cx:dx = seek count
	mov	ecx,edx
	shr	ecx,16
	int	$21
	jc	_myfile_seek_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_seek_error:
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Seeks from the start of a file
;
%ifdef _MYFILE_SEEKABSOLUTE_MACRO
_myfile_seekabsolute_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_seekabsolute_wfse
	mov	eax,$04200			; seek from file start
	mov	edx,[esp + 20]			; cx:dx = seek count
	mov	ecx,edx
	shr	ecx,16
	int	$21
	jc	_myfile_seekabsolute_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_seekabsolute_wfse:
	mov	eax,$04201FFFD			; relative seek
	mov	edx,[esp + 20]			; cx:dx = seek count
	mov	ecx,edx
	shr	ecx,16
	int	$21
	jc	_myfile_seekabsolute_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_seekabsolute_error:
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Returns the current file pointer position
;
%ifdef _MYFILE_POSITION_MACRO
_myfile_position_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_position_wfse
	mov	eax,$04201			; relative seek
	xor	ecx,ecx
	xor	edx,edx
	int	$21
	jc	_myfile_position_error
	shl	edx,16
	mov	dx,ax
	mov	[_myfile_spare],edx
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_position_wfse:
	mov	eax,$04201FFFD			; relative seek
	xor	ecx,ecx
	xor	edx,edx
	int	$21
	jc	_myfile_position_error
	shl	edx,16
	mov	dx,ax
	mov	[_myfile_spare],edx
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_position_error:
	mov	[_myfile_spare],dword 0
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Reads from a file
;
%ifdef _MYFILE_READ_MACRO
_myfile_read_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_read_wfse		; WFSE file?
	mov	ah,$03f				; no, read file function
	mov	ecx,[esp + 20]			; number of bytes to read
	mov	edx,[esp + 24]			; address to read it to
	int	$21
	jc	_myfile_read_error
	or	eax,eax
	jz	_myfile_read_error
;	cmp	eax,[esp + 20]			; read number of bytes requested?
;	jne	_myfile_read_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_read_wfse:
	mov	eax,$03f00fffd
	mov	ecx,[esp + 20]
	mov	edx,[esp + 24]
	int	$21
	jc	_myfile_read_error
	cmp	eax,[esp + 20]
	jne	_myfile_read_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_read_error:
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif
;
;--------------------------------------------------------------------
;
; Writes to a file
;
%ifdef _MYFILE_WRITE_MACRO
_myfile_write_2:
	push	eax
	push	ecx
	push	edx
	mov	eax,ebx
	and	eax,$08000
	jnz	_myfile_write_error		; WFSE file?
	mov	ah,$040				; no, write file function
	mov	ecx,[esp + 20]			; number of bytes to read
	mov	edx,[esp + 24]			; address to read it to
	int	$21
	jc	_myfile_write_error
	pop	edx
	pop	ecx
	pop	eax
	clc
	ret
_myfile_write_error:
	pop	edx
	pop	ecx
	pop	eax
	stc
	ret
%endif

%endif