; Mouse subsystem
; by Gaz
;
%ifndef _MYMOUSE
%define _MYMOUSE
[BITS 32]
;
;-------------------------------------------------------------------------
;
[segment .bss]
%ifdef _MYMOUSE_INIT_MACRO
	times ($$-$) & 31 resb 1		; alignment
_mymouse_cursor_foreground	resb (72*32)	; space for the four
_mymouse_cursor_foreground1	resb (72*32)	; shifted versions of
_mymouse_cursor_foreground2	resb (72*32)	; the mouse cursor
_mymouse_cursor_foreground3	resb (72*32)
	times ($$-$) & 31 resb 1		; alignment
_mymouse_cursor_background	resw 4608	; space to save the background (for later restoration)
_mymouse_dseg	resd 1				; data selector for use in mouse handler
_mymouse_xpos	resw 1				; current x position of mouse
_mymouse_ypos	resw 1				; and the y position
_mymouse_state	resw 1				; and the button state
		resw 1
_mymouse_oldx	resw 1				; the old x and y position
_mymouse_oldy	resw 1
_mymouse_oldx2	resw 1				; the old x and y position (if we're using two screens)
_mymouse_oldy2	resw 1
_mymouse_xres	resd 1				; x and y resolution
_mymouse_yres	resd 1
_mymouse_axres	resd 1				; the actual x and y resolution (varies depending on the bits/pixel)
_mymouse_ayres	resd 1
_mymouse_xres16	resd 1				; and for the 16x16 draw routine
_mymouse_yres16	resd 1
_mymouse_xres32	resd 1				; and for the 32x32 draw routine
_mymouse_yres32	resd 1
%endif
;
;-------------------------------------------------------------------------
;
[segment .data]
%ifdef _MYMOUSE_INIT_MACRO
_mymouse_flag	dw 0		; installed flag
%endif
	times ($$-$) & 31 db 0	; alignment
%ifdef _MYMOUSE_SET_CURSOR16_8_MACRO
_mymouse_cursor_default16_8:
	db	80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	; some (poor!) example cursors
	db	80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,80,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,80,80,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,0,80,80,0,0,0,0,0,0,0,0,0,0,0
	db	80,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,80,80,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,80,80,0,0,0,0,0,0,0,0
%endif
%ifdef _MYMOUSE_SET_CURSOR32_8_MACRO
_mymouse_cursor_default32_8:
	db	80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,80,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,80,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	80,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,80,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
%endif
%ifdef _MYMOUSE_SET_CURSOR16_16_MACRO
_mymouse_cursor_default16_16:
	dw	$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0
%endif
%ifdef _MYMOUSE_SET_CURSOR32_16_MACRO
_mymouse_cursor_default32_16:
	dw	$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,$0ffff,$0ffff,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,$0ffff
	dw	$0ffff,$0ffff,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	$0ffff,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,$0ffff,$0ffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
%endif
%ifdef _MYMOUSE_SET_CURSOR16_32_MACRO
_mymouse_cursor_default16_32:
	dd	$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0
%endif
%ifdef _MYMOUSE_SET_CURSOR32_32_MACRO
_mymouse_cursor_default32_32:
	dd	$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,$0ffffffff,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	$0ffffffff,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,$0ffffffff,$0ffffffff,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
%endif
;
;-------------------------------------------------------------------------
;
[segment .text]
;
;-------------------------------------------------------------------------
;
; Detects existence of mouse driver, centers mouse on screen, sets up
; resolution and installs new mouse handler.
;
%ifdef _MYMOUSE_INIT_MACRO
_mymouse_init_2:
	push	eax			; save registers
	push	ebx
	push	ecx
	push	edx
	mov	eax,[esp + 28]
	mov	ebx,[esp + 24]
	mov	ecx,[esp + 20]
	mov	[_mymouse_state],cx	; save cx for later
	cmp	[_mymouse_flag],word 0
	jne	near _mymouse_init_end
	and	eax,$0ffff
	and	ebx,$0ffff
	mov	[_mymouse_xres],eax	; save resolution
	mov	[_mymouse_yres],ebx
	dec	eax			; x and y resolutions start from 0
	dec	ebx
	mov	[_mymouse_oldx],ax	; save resolution for a bit later
	mov	[_mymouse_oldy],bx
	xor	eax,eax			; reset driver, get status
	int	$33
	cmp	ax,0
	je	near _mymouse_init_end	; no mouse driver
	mov	eax,7			; mouse driver set x resolution
	mov	ecx,0			; minimum x value
	mov	dx,[_mymouse_oldx]	; maximum x value
	int	$33
	mov	eax,8			; mouse driver set y resolution
	mov	ecx,0			; minimum y value
	mov	dx,[_mymouse_oldy]	; maximum y value
	int	$33
	mov	eax,4			; center mouse in new resolution
	mov	cx,[_mymouse_oldx]	; get the x center
	shr	cx,1			; divide by 2
	mov	[_mymouse_xpos],cx
	mov	[_mymouse_oldx],cx
	mov	[_mymouse_oldx2],cx
	mov	dx,[_mymouse_oldy]	; now the y
	shr	dx,1
	mov	[_mymouse_ypos],dx
	mov	[_mymouse_oldy],dx
	mov	[_mymouse_oldy2],dx
	int	$33
	mov	cx,[_mymouse_state]	; install the handler?
	cmp	cx,0
	jne	_mymouse_init_go	; no
	mov	ax,ds
	mov	[_mymouse_dseg],ax	; save selector for handler
	mov	eax,$0c			; mouse driver set new handler
	mov	ecx,$0ffffffff		; call mask (only bits 0-6 used)
	push	es			; save es
	push	cs			; es=cs
	pop	es
	mov	edx,_mymouse_handler	; es:edx->new mouse handler
	int	$33
	pop	es			; restore es
	mov	[_mymouse_flag],word 1	; installed
_mymouse_init_go:
	mov	[_mymouse_state],ax	; set the button state to none pressed
%define _MYMOUSE_EXIT_MACRO
	AtExit	_mymouse_exit_2
	pop	edx			; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc				; flag success
	ret
_mymouse_init_end:
	mov	[_mymouse_flag],word 0	; not installed
	pop	edx			; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc				; flag failure
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Call before program exit.
;
%ifdef _MYMOUSE_EXIT_MACRO
_mymouse_exit_2:
	push	eax			; save registers
	push	ebx
	push	ecx
	push	edx
	cmp	[_mymouse_flag],word 0
	je	_mymouse_exit_end
	mov	eax,$0c			; remove the handler
	mov	ecx,$0ffffffff
	push	es
	mov	bx,0
	mov	es,bx
	mov	edx,0
	int	$33
	pop	es
	jc	_mymouse_exit_end	; help!
	xor	eax,eax
	int	$33			; reset the mouse driver anyway
	xor	eax,eax
	pop	edx			; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc				; flag success
	ret
_mymouse_exit_end:
	int	$33			; reset the mouse driver anyway
	pop	edx			; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc				; flag failure
	ret
%endif
;
;-------------------------------------------------------------------------
;
; The mouse handler
;
%ifdef _MYMOUSE_INIT_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_handler:
	push	ds
	mov	ds,[cs:_mymouse_dseg]	; get to the right segment
	mov	[_mymouse_xpos],cx	; save the current mouse state
	mov	[_mymouse_ypos],dx
	mov	[_mymouse_state],bx
	pop	ds
	retf
%endif
;
;-------------------------------------------------------------------------
;
; Set a new 16x16 or 32x32 mouse cursor - doesn't preserve registers (uses all except ebp)
;
; _mymouse_set_cursor16_8 to set a 16x16 cursor (8 bits/pixel)
; _mymouse_set_cursor16_16 (15/16 bpp)
; _mymouse_set_cursor16_32 (32 bpp)
; _mymouse_set_cursor32_8 to set a 32x32 cursor (8 bits/pixel)
; _mymouse_set_cursor32_16 (15/16 bpp)
; _mymouse_set_cursor32_32 (32 bpp)
;
%ifdef _MYMOUSE_SET_CURSOR16_8_MACRO
%define _MYMOUSE_SET_CURSOR_SHIFT_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor16_8_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,16			; 16 scanlines
_mymouse_set_cursor16_8_loop2:
	mov	ebx,4			; 4 dwords (16 pixels) per scanline
_mymouse_set_cursor16_8_loop:
	mov	eax,[edi]		; get 4 pixels
	mov	[esi],dword 0		; for making the mask
	mov	[esi+4],eax		; the 4 pixels
	mov	edx,eax			; save the 4 pixels
	and	edx,$0ff000000		; first pixel non-zero?
	jnz	_mymouse_set_cursor16_8_1
	or	[esi],dword $0ff000000	; no, so set the mask
_mymouse_set_cursor16_8_1:
	mov	edx,eax			; repeat for the other 3 pixels
	and	edx,$000ff0000
	jnz	_mymouse_set_cursor16_8_2
	or	[esi],dword $000ff0000
_mymouse_set_cursor16_8_2:
	mov	edx,eax
	and	edx,$00000ff00
	jnz	_mymouse_set_cursor16_8_3
	or	[esi],dword $00000ff00
_mymouse_set_cursor16_8_3:
	mov	edx,eax
	and	edx,$0000000ff
	jnz	_mymouse_set_cursor16_8_4
	or	[esi],dword $0000000ff
_mymouse_set_cursor16_8_4:
	add	edi,4			; 4 pixels on
	add	esi,8			; mask + 4 pixels on
	dec	ebx			; do all dwords/scanline
	jnz	_mymouse_set_cursor16_8_loop
	mov	[esi],dword $0ffffffff	; need an extra two dwords for the
	mov	[esi+4],dword 0		; shifted cursors
	add	esi,8
	dec	ecx
	jnz	_mymouse_set_cursor16_8_loop2	; do all scanlines
	mov	esi,_mymouse_cursor_foreground	; make a cursor shifted by 1 pixel
	mov	edi,_mymouse_cursor_foreground1
	mov	ecx,160			; 10 dwords/scanline * 16 scanlines
	call	_mymouse_set_cursor_shift_8
	mov	esi,_mymouse_cursor_foreground1	; use the 1 shifted to make a
	mov	edi,_mymouse_cursor_foreground2	; 2 shifted cursor
	call	_mymouse_set_cursor_shift_8
	mov	esi,_mymouse_cursor_foreground2	; and the 2 to make the 3 shifted
	mov	edi,_mymouse_cursor_foreground3
	call	_mymouse_set_cursor_shift_8
	mov	edi,_mymouse_cursor_foreground1
	or	[edi],dword $0000000ff		; mask out the shifted pixels
	or	[edi+2304],dword $00000ffff
	or	[edi+4608],dword $000ffffff
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax
	mov	[_mymouse_ayres],ebx
	sub	eax,16
	sub	ebx,16
	mov	[_mymouse_xres16],eax
	mov	[_mymouse_yres16],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR16_16_MACRO
%define _MYMOUSE_SET_CURSOR_SHIFT_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor16_16_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,16			; 16 scanlines to do
_mymouse_set_cursor16_16_loop:
	mov	ebx,8			; 8 dwords/scanline
_mymouse_set_cursor16_16_loop_2:
	mov	[esi],dword 0		; zero the mask
	mov	eax,[edi]		; get two pixels
	mov	[esi+4],eax		; save the pixels
	mov	edx,eax
	and	eax,$0ffff
	jnz	_mymouse_set_cursor16_16_1
	or	[esi],dword $0ffff
_mymouse_set_cursor16_16_1:
	and	edx,$0ffff0000
	jnz	_mymouse_set_cursor16_16_2
	or	[esi],dword $0ffff0000
_mymouse_set_cursor16_16_2:
	add	edi,4			; 2 pixels on
	add	esi,8			; 2 pixels on (mask + 2 pixels)
	dec	ebx			; do all dwords on the scanline
	jnz	_mymouse_set_cursor16_16_loop_2
	mov	[esi],dword $0ffffffff	; add in an extra two pixels for the shifted version
	mov	[esi+4],dword 0
	add	esi,8
	dec	ecx			; do all scanlines
	jnz	_mymouse_set_cursor16_16_loop
	mov	esi,_mymouse_cursor_foreground
	mov	edi,_mymouse_cursor_foreground2
	mov	ecx,288			; 9 dwords/scanline, 16 scanlines * 2
	call	_mymouse_set_cursor_shift_16	; make up the shifted version
	mov	edi,_mymouse_cursor_foreground2
	or	[edi],dword $0ffff		; mask out the shifted pixel
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax		; actual resolution = resolution * 2
	add	[_mymouse_axres],eax		; because it's 2 bytes/pixel
	mov	[_mymouse_ayres],ebx
	sub	eax,16
	sub	ebx,16
	mov	[_mymouse_xres16],eax
	mov	[_mymouse_yres16],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR16_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor16_32_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,16			; 16 scanlines to do
_mymouse_set_cursor16_32_loop:
	mov	ebx,16			; 16 dwords/scanline
_mymouse_set_cursor16_32_loop_2:
	mov	eax,[edi]		; get a pixel
	mov	[esi+4],eax		; save it
	mov	[esi],dword 0		; assume a pixel there
	or	eax,eax			; is it a transparent pixel?
	jnz	_mymouse_set_cursor16_32_1	; no
	mov	[esi],dword $0ffffffff	; yes, set the mask
_mymouse_set_cursor16_32_1:
	add	edi,4			; 1 pixel on
	add	esi,8			; 1 pixel on (mask + 1 pixel)
	dec	ebx			; do all dwords on the scanline
	jnz	_mymouse_set_cursor16_32_loop_2
	dec	ecx			; do all scanlines
	jnz	_mymouse_set_cursor16_32_loop
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax		; actual resolution = resolution * 4
	add	[_mymouse_axres],eax		; because it's 4 bytes/pixel
	add	[_mymouse_axres],eax
	add	[_mymouse_axres],eax
	mov	[_mymouse_ayres],ebx
	sub	eax,16
	sub	ebx,16
	mov	[_mymouse_xres16],eax
	mov	[_mymouse_yres16],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR32_8_MACRO
%define _MYMOUSE_SET_CURSOR_SHIFT_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor32_8_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,32			; 32 scanlines
_mymouse_set_cursor32_8_loop2:
	mov	ebx,8			; 8 dwords (32 pixels) per scanline
_mymouse_set_cursor32_8_loop:
	mov	eax,[edi]		; get 4 pixels
	mov	[esi],dword 0		; for making the mask
	mov	[esi+4],eax		; the 4 pixels
	mov	edx,eax			; save the 4 pixels
	and	edx,$0ff000000		; first pixel non-zero?
	jnz	_mymouse_set_cursor32_8_1
	or	[esi],dword $0ff000000	; no, so set the mask
_mymouse_set_cursor32_8_1:
	mov	edx,eax			; repeat for the other 3 pixels
	and	edx,$000ff0000
	jnz	_mymouse_set_cursor32_8_2
	or	[esi],dword $000ff0000
_mymouse_set_cursor32_8_2:
	mov	edx,eax
	and	edx,$00000ff00
	jnz	_mymouse_set_cursor32_8_3
	or	[esi],dword $00000ff00
_mymouse_set_cursor32_8_3:
	mov	edx,eax
	and	edx,$0000000ff
	jnz	_mymouse_set_cursor32_8_4
	or	[esi],dword $0000000ff
_mymouse_set_cursor32_8_4:
	add	edi,4			; 4 pixels on
	add	esi,8			; mask + 4 pixels on
	dec	ebx			; do all dwords/scanline
	jnz	_mymouse_set_cursor32_8_loop
	mov	[esi],dword $0ffffffff	; need an extra two dwords for the
	mov	[esi+4],dword 0		; shifted cursors (mask + 4 pixels)
	add	esi,8
	dec	ecx
	jnz	_mymouse_set_cursor32_8_loop2	; do all scanlines
	mov	esi,_mymouse_cursor_foreground	; make a cursor shifted by 1 pixel
	mov	edi,_mymouse_cursor_foreground1
	mov	ecx,576			; 18 dwords/scanline * 32 scanlines
	call	_mymouse_set_cursor_shift_8
	mov	esi,_mymouse_cursor_foreground1	; use the 1 shifted to make a
	mov	edi,_mymouse_cursor_foreground2	; 2 shifted cursor
	call	_mymouse_set_cursor_shift_8
	mov	esi,_mymouse_cursor_foreground2	; and the 2 to make the 3 shifted
	mov	edi,_mymouse_cursor_foreground3
	call	_mymouse_set_cursor_shift_8
	mov	edi,_mymouse_cursor_foreground1
	or	[edi],dword $0000000ff		; mask out the shifted pixels
	or	[edi+2304],dword $00000ffff
	or	[edi+4608],dword $000ffffff
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax
	mov	[_mymouse_ayres],ebx
	sub	eax,32
	sub	ebx,32
	mov	[_mymouse_xres32],eax
	mov	[_mymouse_yres32],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR32_16_MACRO
%define _MYMOUSE_SET_CURSOR_SHIFT_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor32_16_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,32			; 32 scanlines to do
_mymouse_set_cursor32_16_loop:
	mov	ebx,16			; 16 dwords/scanline
_mymouse_set_cursor32_16_loop_2:
	mov	[esi],dword 0		; zero the mask
	mov	eax,[edi]		; get two pixels
	mov	[esi+4],eax		; save the pixels
	mov	edx,eax
	and	eax,$0ffff
	jnz	_mymouse_set_cursor32_16_1
	or	[esi],dword $0ffff
_mymouse_set_cursor32_16_1:
	and	edx,$0ffff0000
	jnz	_mymouse_set_cursor32_16_2
	or	[esi],dword $0ffff0000
_mymouse_set_cursor32_16_2:
	add	edi,4			; 2 pixels on
	add	esi,8			; 2 pixels on (mask + 2 pixels)
	dec	ebx			; do all dwords on the scanline
	jnz	_mymouse_set_cursor32_16_loop_2
	mov	[esi],dword $0ffffffff	; add in an extra two pixels for the shifted version
	mov	[esi+4],dword 0
	add	esi,8
	dec	ecx			; do all scanlines
	jnz	_mymouse_set_cursor32_16_loop
	mov	esi,_mymouse_cursor_foreground
	mov	edi,_mymouse_cursor_foreground2
	mov	ecx,1088			; 17 dwords/scanline, 32 scanlines * 2
	call	_mymouse_set_cursor_shift_16	; make up the shifted version
	mov	edi,_mymouse_cursor_foreground2
	or	[edi],dword $0ffff		; mask out the shifted pixel
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax		; actual resolution = resolution * 2
	add	[_mymouse_axres],eax		; because it's 2 bytes/pixel
	mov	[_mymouse_ayres],ebx
	sub	eax,32
	sub	ebx,32
	mov	[_mymouse_xres32],eax
	mov	[_mymouse_yres32],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR32_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor32_32_2m:
	mov	esi,_mymouse_cursor_foreground
	mov	ecx,32			; 32 scanlines to do
_mymouse_set_cursor32_32_loop:
	mov	ebx,32			; 32 dwords/scanline
_mymouse_set_cursor32_32_loop_2:
	mov	eax,[edi]		; get a pixel
	mov	[esi+4],eax		; save it
	mov	[esi],dword 0		; assume a pixel there
	or	eax,eax			; is it a transparent pixel?
	jnz	_mymouse_set_cursor32_32_1	; no
	mov	[esi],dword $0ffffffff	; yes, set the mask
_mymouse_set_cursor32_32_1:
	add	edi,4			; 1 pixel on
	add	esi,8			; 1 pixel on (mask + 1 pixel)
	dec	ebx			; do all dwords on the scanline
	jnz	_mymouse_set_cursor32_32_loop_2
	dec	ecx			; do all scanlines
	jnz	_mymouse_set_cursor32_32_loop
	mov	eax,[_mymouse_xres]
	mov	ebx,[_mymouse_yres]
	mov	[_mymouse_axres],eax		; actual resolution = resolution * 4
	add	[_mymouse_axres],eax		; because it's 4 bytes/pixel
	add	[_mymouse_axres],eax
	add	[_mymouse_axres],eax
	mov	[_mymouse_ayres],ebx
	sub	eax,32
	sub	ebx,32
	mov	[_mymouse_xres32],eax
	mov	[_mymouse_yres32],ebx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR_SHIFT_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor_shift_8:		; esi->source cursor, edi->destination
	push	ecx			; ecx=number of dwords in total
	push	ecx			; clear the destination for when we
	push	edi			; OR in the source (shifted right by 1 pixel)
_mymouse_set_cursor_shift_8_loop:
	mov	[edi],dword 0
	add	edi,4
	dec	ecx
	jnz	_mymouse_set_cursor_shift_8_loop
	pop	edi
	pop	ecx
_mymouse_set_cursor_shift_8_loop2:
	mov	eax,[esi]		; get 4 pixels
	mov	ebx,eax
	shl	eax,8			; shift _right_ by 1 pixel (Intel byte ordering...)
	shr	ebx,24			; get the pixel we've just shifted out
	or	[edi],eax		; OR these two shifted dwords into the destination
	or	[edi+8],ebx
	add	esi,4			; 4 pixels on
	add	edi,4
	dec	ecx			; do all dwords
	jnz	_mymouse_set_cursor_shift_8_loop2
	pop	ecx			; restore ecx
	ret
%endif
;
%ifdef _MYMOUSE_SET_CURSOR_SHIFT_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_set_cursor_shift_16:
	push	ecx			; save ecx
	push	ecx
	push	edi
_mymouse_set_cursor_shift_16_loop:
	mov	[edi],dword 0
	add	edi,4
	dec	ecx
	jnz	_mymouse_set_cursor_shift_16_loop
	pop	edi
	pop	ecx
_mymouse_set_cursor_shift_16_loop2:
	mov	eax,[esi]		; get 2 pixels
	rol	eax,16			; swap them
	mov	ebx,eax
	and	eax,$0ffff		; eax holds upper word (_second_ pixel)
	and	ebx,$0ffff0000		; ebx holds lower word (_first_ pixel)
	or	[edi],ebx		; store them in the new positions
	or	[edi+8],eax
	add	esi,4			; 2 pixels on
	add	edi,4
	dec	ecx			; do all dwords
	jnz	_mymouse_set_cursor_shift_16_loop2
	pop	ecx			; restore ecx
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Gets the current mouse state - doesn't preserve registers
;
%ifdef _MYMOUSE_GET_STATE_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_get_state_2:
	mov	eax,3
	int	$33
	mov	[_mymouse_xpos],cx
	mov	[_mymouse_ypos],dx
	mov	[_mymouse_state],bx
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Restores the cursor background - doesn't preserve registers (uses all)
;
; _mymouse_undraw_mouse16_8 for 16x16 cursors (8 bits/pixel)
; _mymouse_undraw_mouse16_16 (15/16 bpp)
; _mymouse_undraw_mouse16_32 (32 bpp)
; _mymouse_undraw_mouse32_8 for 32x32 cursors  (8 bits/pixel)
; _mymouse_undraw_mouse32_16 (15/16 bpp)
; _mymouse_undraw_mouse32_32 (32 bpp)
;
%ifdef _MYMOUSE_UNDRAW_MOUSE16_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse16_8_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ecx,16			; 16 scanlines to do
	mov	bx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	and	ebx,$0fffffffc		; align to every fourth pixel
	cmp	eax,[_mymouse_yres16]	; screen height-16 for clipping check
	jbe	_mymouse_undraw_mouse16_8_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ecx,eax			; number of lines to draw
_mymouse_undraw_mouse16_8_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	add	edi,ebx
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	_mymouse_undraw_mouse16_8_clipped
_mymouse_undraw_mouse16_8_loop:
	mov	eax,[esi]		; get 4 pixels
	mov	ebx,[esi+4]		; the second 4
	mov	edx,[esi+8]		; the third 4
	mov	[edi],eax		; copy first 4
	mov	eax,[esi+12]		; get fourth 4
	mov	[edi+4],ebx		; copy second 4
	mov	ebx,[esi+16]		; get fifth (last) 4
	add	esi,20			; 20 pixels on in source
	mov	[edi+8],edx		; copy remaining pixels
	mov	[edi+12],eax
	mov	[edi+16],ebx
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_8_loop
	ret
_mymouse_undraw_mouse16_8_clipped:
	mov	edx,[_mymouse_axres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,2			; /4 = number of dwords to do
_mymouse_undraw_mouse16_8_loop2b:
	mov	ebx,edx			; ebx holds number of dwords to do
_mymouse_undraw_mouse16_8_loop2a:
	mov	eax,[esi]		; copy dwords
	add	esi,4
	mov	[edi],eax
	add	edi,4
	dec	ebx			; all dowrds done?
	jnz	_mymouse_undraw_mouse16_8_loop2a
	add	edi,[_mymouse_axres]	; next scanline
	mov	ebx,edx
	shl	ebx,2
	sub	edi,ebx
	add	esi,20
	sub	esi,ebx
	dec	ecx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_8_loop2b
	ret
%endif
;
%ifdef _MYMOUSE_UNDRAW_MOUSE16_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse16_16_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ebx,16			; 16 scanlines to do
	mov	cx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	and	ecx,$0fffffffe		; align to every second pixel
	cmp	eax,[_mymouse_yres16]	; screen height-16 for clipping check
	jbe	_mymouse_undraw_mouse16_16_noyclip	; no clipping
	mov	ebx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ebx,eax			; number of lines to draw
_mymouse_undraw_mouse16_16_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ecx*2]	; twice because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ecx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	_mymouse_undraw_mouse16_16_clipped
_mymouse_undraw_mouse16_16_loop:
	push	edi
	mov	ecx,9			; 9 dwords to do
	rep	movsd			; copy dwords
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_16_loop
	ret
_mymouse_undraw_mouse16_16_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ecx
	shr	edx,1			; /2 = number of dwords to do
_mymouse_undraw_mouse16_16_loop2:
	push	edi
	push	esi
	mov	ecx,edx			; get the count
	rep	movsd			; restore background
	pop	esi
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	add	esi,36			; next line in background
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_16_loop2
	ret
%endif
;
%ifdef _MYMOUSE_UNDRAW_MOUSE16_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse16_32_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ebx,16			; 16 scanlines to do
	mov	cx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	cmp	eax,[_mymouse_yres16]	; screen height-16 for clipping check
	jbe	_mymouse_undraw_mouse16_32_noyclip	; no clipping
	mov	ebx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ebx,eax			; number of lines to draw
_mymouse_undraw_mouse16_32_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ecx*4]	; four times because it's 4 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ecx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	_mymouse_undraw_mouse16_32_clipped
_mymouse_undraw_mouse16_32_loop:
	push	edi
	mov	ecx,16			; 16 dwords to do
	rep	movsd			; copy dwords
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_32_loop
	ret
_mymouse_undraw_mouse16_32_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels (=number of dwords) to do
	sub	edx,ecx
_mymouse_undraw_mouse16_32_loop2:
	push	edi
	push	esi
	mov	ecx,edx			; get the count
	rep	movsd			; restore background
	pop	esi
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	add	esi,64			; next line in background
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse16_32_loop2
	ret
%endif
;
%ifdef _MYMOUSE_UNDRAW_MOUSE32_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse32_8_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ecx,32			; 32 scanlines to do
	mov	bx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	cmp	[_VESALFBDoubleFlag],dword 0	; special case of LFB + double-buffer?
	jz	_mymouse_undraw_mouse32_8_nolfbd	; no
	cmp	[_VESAScreenFlag],dword 0	; yes, are we on screen 1?
	jz	_mymouse_undraw_mouse32_8_nolfbd	; yes, go as normal
	mov	bx,[_mymouse_oldx2]	; no, use the other screen's old co-ordinates
	mov	ax,[_mymouse_oldy2]
	lea	esi,[esi + 4608]	; and background
_mymouse_undraw_mouse32_8_nolfbd:
	and	ebx,$0fffffffc		; align to every fourth pixel
	cmp	eax,[_mymouse_yres32]	; screen height-32 for clipping check
	jbe	_mymouse_undraw_mouse32_8_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ecx,eax			; number of lines to draw
_mymouse_undraw_mouse32_8_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	add	edi,ebx
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres32]	; screen width-32 for x clipping check
	jae	_mymouse_undraw_mouse32_8_clipped	; clipped cursor
_mymouse_undraw_mouse32_8_loop:
	mov	eax,[esi]		; get first 4 pixels
	mov	ebx,[esi+4]		; the second 4
	mov	edx,[esi+8]		; the third 4
	mov	[edi],eax		; copy first 4
	mov	eax,[esi+12]		; get fourth 4
	mov	[edi+4],ebx		; copy second 4
	mov	ebx,[esi+16]		; get fifth 4
	mov	[edi+8],edx		; and repeat for the rest
	mov	edx,[esi+20]
	mov	[edi+12],eax
	mov	eax,[esi+24]
	mov	[edi+16],ebx
	mov	ebx,[esi+28]
	mov	[edi+20],edx
	mov	edx,[esi+32]
	add	esi,36			; 36 pixels on in source
	mov	[edi+24],eax
	mov	[edi+28],ebx
	mov	[edi+32],edx
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_8_loop
	ret
_mymouse_undraw_mouse32_8_clipped:
	mov	edx,[_mymouse_axres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,2			; /4 = number of dwords to do
_mymouse_undraw_mouse32_8_loop2b:
	mov	ebx,edx			; number of dwords to do
_mymouse_undraw_mouse32_8_loop2a:
	mov	eax,[esi]		; copy dwords
	add	esi,4
	mov	[edi],eax
	add	edi,4
	dec	ebx			; all done?
	jnz	_mymouse_undraw_mouse32_8_loop2a
	add	edi,[_mymouse_axres]	; next scanline
	mov	ebx,edx			; number of dwords already done
	shl	ebx,2			; *4 for number of pixels
	add	esi,36			; 36 pixels on in source
	sub	edi,ebx			; correct for number of pixels already done
	sub	esi,ebx
	dec	ecx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_8_loop2b
	ret
%endif
;
%ifdef _MYMOUSE_UNDRAW_MOUSE32_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse32_16_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ebx,32			; 32 scanlines to do
	mov	cx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	and	ecx,$0fffffffe		; align to every second pixel
	cmp	eax,[_mymouse_yres32]	; screen height-32 for clipping check
	jbe	_mymouse_undraw_mouse32_16_noyclip	; no clipping
	mov	ebx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ebx,eax			; number of lines to draw
_mymouse_undraw_mouse32_16_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ecx*2]	; twice because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ecx,[_mymouse_xres32]	; screen width-32 for x clipping check
	jae	_mymouse_undraw_mouse32_16_clipped
_mymouse_undraw_mouse32_16_loop:
	push	edi
	mov	ecx,17			; 17 dwords to do
	rep	movsd			; copy dwords
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_16_loop
	ret
_mymouse_undraw_mouse32_16_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ecx
	shr	edx,1			; /2 = number of dwords to do
_mymouse_undraw_mouse32_16_loop2:
	push	edi
	push	esi
	mov	ecx,edx			; get the count
	rep	movsd			; restore background
	pop	esi
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	add	esi,68			; next line in background
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_16_loop2
	ret
%endif
;
%ifdef _MYMOUSE_UNDRAW_MOUSE32_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_undraw_mouse32_32_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_background	; the original background
	mov	ebx,32			; 32 scanlines to do
	mov	cx,[_mymouse_oldx]	; the old cursor's position
	mov	ax,[_mymouse_oldy]
	cmp	eax,[_mymouse_yres32]	; screen height-32 for clipping check
	jbe	_mymouse_undraw_mouse32_32_noyclip	; no clipping
	mov	ebx,[_mymouse_ayres]	; at bottom of screen so clip it
	sub	ebx,eax			; number of lines to draw
_mymouse_undraw_mouse32_32_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ecx*4]	; four times because it's 4 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ecx,[_mymouse_xres32]	; screen width-32 for x clipping check
	jae	_mymouse_undraw_mouse32_32_clipped
_mymouse_undraw_mouse32_32_loop:
	push	edi
	mov	ecx,32			; 32 dwords to do
	rep	movsd			; copy dwords
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_32_loop
	ret
_mymouse_undraw_mouse32_32_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels (=number of dwords) to do
	sub	edx,ecx
_mymouse_undraw_mouse32_32_loop2:
	push	edi
	push	esi
	mov	ecx,edx			; get the count
	rep	movsd			; restore background
	pop	esi
	pop	edi
	add	edi,[_mymouse_axres]	; next scanline
	add	esi,128			; next line in background
	dec	ebx			; do all scanlines
	jnz	_mymouse_undraw_mouse32_32_loop2
	ret
%endif
;
;-------------------------------------------------------------------------
;
; Draws the mouse cursor on screen - doesn't preserve registers (uses all)
;
; _mymouse_draw_mouse16_8 for 16x16 cursors (8 bits/pixel)
; _mymouse_draw_mouse16_16 (15/16 bpp)
; _mymouse_draw_mouse16_32 (32 bpp)
; _mymouse_draw_mouse32_8 for 32x32 cursors (8 bits/pixel)
; _mymouse_draw_mouse32_16 (15/16 bpp)
; _mymouse_draw_mouse32_32 (32 bpp)
;
%ifdef _MYMOUSE_DRAW_MOUSE16_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse16_8_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
	mov	ecx,ebx
	and	ebx,$0fffffffc		; align to every fourth pixel
	and	ecx,3			; find out which shifted cursor to use
	shl	ecx,8			; *256
	add	esi,ecx
	shl	ecx,3			; = shl 11 = *2048
	add	esi,ecx			; ecx=ecx*2304 (cursor size)
	mov	ecx,16			; 16 scanlines to do
	cmp	eax,[_mymouse_yres16]	; screen height-16 for y clipping check
	jbe	_mymouse_draw_mouse16_8_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse16_8_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	add	edi,ebx
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	_mymouse_draw_mouse16_8_clipped
_mymouse_draw_mouse16_8_loop:
	mov	eax,[edi]		; get current dword
	mov	ebx,[esi]		; get the 4-byte mask
	mov	edx,[esi+4]		; get the 4-byte pixels
	mov	[ebp],eax		; save the background for undrawing later
	and	[edi],ebx		; mask out the 4 current pixels
	or	[edi],edx		; set the cursor
	mov	eax,[edi+4]		; repeat for the other 4 dwords
	mov	ebx,[esi+8]
	mov	edx,[esi+12]
	mov	[ebp+4],eax
	and	[edi+4],ebx
	or	[edi+4],edx
	mov	eax,[edi+8]
	mov	ebx,[esi+16]
	mov	edx,[esi+20]
	mov	[ebp+8],eax
	and	[edi+8],ebx
	or	[edi+8],edx
	mov	eax,[edi+12]
	mov	ebx,[esi+24]
	mov	edx,[esi+28]
	mov	[ebp+12],eax
	and	[edi+12],ebx
	or	[edi+12],edx
	mov	eax,[edi+16]
	mov	ebx,[esi+32]
	mov	edx,[esi+36]
	mov	[ebp+16],eax
	and	[edi+16],ebx
	or	[edi+16],edx
	add	esi,40			; 20 pixels/scanline * 2 (pixels+mask)
	add	ebp,20			; 20 pixels/scanline
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse16_8_loop
	ret
_mymouse_draw_mouse16_8_clipped:
	mov	edx,[_mymouse_axres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,2			; /4 = number of dwords to do
	push	edx			; save number of dwords to do
_mymouse_draw_mouse16_8_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse16_8_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the 4 pixels
	or	[edi],ebx
	add	edi,4			; 4 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse16_8_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,40			; 20 pixels/scanline * 2 (pixels+mask)
	add	ebp,20			; 20 pixels/scanline
	shl	eax,2			; *4 for number of pixels
	sub	edi,eax
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse16_8_loop2b
	pop	edx			; restore stack
	ret
%endif
;
%ifdef _MYMOUSE_DRAW_MOUSE16_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse16_16_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
	mov	ecx,ebx
	and	ebx,$0fffffffe		; align to every second pixel
	and	ecx,1			; find out which shifted cursor to use
	jz	_mymouse_draw_mouse16_16_noshift
	mov	esi,_mymouse_cursor_foreground2
_mymouse_draw_mouse16_16_noshift:
	mov	ecx,16			; 16 scanlines to do
	cmp	eax,[_mymouse_yres16]	; screen height-16 for y clipping check
	jbe	_mymouse_draw_mouse16_16_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse16_16_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ebx*2]	; twice because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	near _mymouse_draw_mouse16_16_clipped
_mymouse_draw_mouse16_16_loop:
	push	ecx			; save the scanline count
	mov	ecx,9			; 9 dwords to save (the background)
	push	edi			; save registers
	push	esi
	mov	esi,edi			; esi->screen
	mov	edi,ebp			; edi->background buffer
	rep	movsd			; save the background
	mov	ebp,edi			; keep track of the background pointer
	pop	esi			; restore registers
	pop	edi
	mov	eax,[esi]		; now AND in the cursor mask
	mov	ebx,[esi+4]		; and OR in the cursor itself
	mov	ecx,[esi+8]
	mov	edx,[esi+12]
	and	[edi],eax
	and	[edi+4],ecx
	or	[edi],ebx
	or	[edi+4],edx
	mov	eax,[esi+16]
	mov	ebx,[esi+20]
	mov	ecx,[esi+24]
	mov	edx,[esi+28]
	and	[edi+8],eax
	and	[edi+12],ecx
	or	[edi+8],ebx
	or	[edi+12],edx
	mov	eax,[esi+32]
	mov	ebx,[esi+36]
	mov	ecx,[esi+40]
	mov	edx,[esi+44]
	and	[edi+16],eax
	and	[edi+20],ecx
	or	[edi+16],ebx
	or	[edi+20],edx
	mov	eax,[esi+48]
	mov	ebx,[esi+52]
	mov	ecx,[esi+56]
	mov	edx,[esi+60]
	and	[edi+24],eax
	and	[edi+28],ecx
	or	[edi+24],ebx
	or	[edi+28],edx
	mov	eax,[esi+64]
	mov	ebx,[esi+68]
	and	[edi+32],eax
	or	[edi+32],ebx
	pop	ecx			; restore the scanline count
	add	esi,72			; 18 pixels/scanline * 2 (pixels+mask) * 2 (2 bytes/pixel)
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	near _mymouse_draw_mouse16_16_loop
	ret
_mymouse_draw_mouse16_16_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,1			; /2 = number of dwords to do
	push	edx			; save number of dwords to do
_mymouse_draw_mouse16_16_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse16_16_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the 2 pixels
	or	[edi],ebx
	add	edi,4			; 2 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse16_16_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,72			; 18 pixels/scanline * 2 (pixels+mask) * 2 (2 bytes/pixel)
	add	ebp,36			; 18 pixels/scanline (2 bytes/pixel)
	shl	eax,2			; *4 for number of bytes
	sub	edi,eax
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse16_16_loop2b
	pop	edx			; restore stack
	ret
%endif
;
%ifdef _MYMOUSE_DRAW_MOUSE16_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse16_32_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
	mov	ecx,16			; 16 scanlines to do
	cmp	eax,[_mymouse_yres16]	; screen height-16 for y clipping check
	jbe	_mymouse_draw_mouse16_32_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse16_32_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ebx*4]	; four times because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres16]	; screen width-16 for x clipping check
	jae	near _mymouse_draw_mouse16_32_clipped
_mymouse_draw_mouse16_32_loop:
	push	ecx			; save the scanline count
	mov	ecx,16			; 16 dwords to save (the background)
	push	edi			; save registers
	push	esi
	mov	esi,edi			; esi->screen
	mov	edi,ebp			; edi->background buffer
	rep	movsd			; save the background
	mov	ebp,edi			; keep track of the background pointer
	pop	esi			; restore registers
	pop	edi
	mov	eax,[esi]		; now AND in the cursor mask
	mov	ebx,[esi+4]		; and OR in the cursor itself
	mov	ecx,[esi+8]
	mov	edx,[esi+12]
	and	[edi],eax
	and	[edi+4],ecx
	or	[edi],ebx
	or	[edi+4],edx
	mov	eax,[esi+16]
	mov	ebx,[esi+20]
	mov	ecx,[esi+24]
	mov	edx,[esi+28]
	and	[edi+8],eax
	and	[edi+12],ecx
	or	[edi+8],ebx
	or	[edi+12],edx
	mov	eax,[esi+32]
	mov	ebx,[esi+36]
	mov	ecx,[esi+40]
	mov	edx,[esi+44]
	and	[edi+16],eax
	and	[edi+20],ecx
	or	[edi+16],ebx
	or	[edi+20],edx
	mov	eax,[esi+48]
	mov	ebx,[esi+52]
	mov	ecx,[esi+56]
	mov	edx,[esi+60]
	and	[edi+24],eax
	and	[edi+28],ecx
	or	[edi+24],ebx
	or	[edi+28],edx
	mov	eax,[esi+64]
	mov	ebx,[esi+68]
	mov	ecx,[esi+72]
	mov	edx,[esi+76]
	and	[edi+32],eax
	and	[edi+36],ecx
	or	[edi+32],ebx
	or	[edi+36],edx
	mov	eax,[esi+80]
	mov	ebx,[esi+84]
	mov	ecx,[esi+88]
	mov	edx,[esi+92]
	and	[edi+40],eax
	and	[edi+44],ecx
	or	[edi+40],ebx
	or	[edi+44],edx
	mov	eax,[esi+96]
	mov	ebx,[esi+100]
	mov	ecx,[esi+104]
	mov	edx,[esi+108]
	and	[edi+48],eax
	and	[edi+52],ecx
	or	[edi+48],ebx
	or	[edi+52],edx
	mov	eax,[esi+112]
	mov	ebx,[esi+116]
	mov	ecx,[esi+120]
	mov	edx,[esi+124]
	and	[edi+56],eax
	and	[edi+60],ecx
	or	[edi+56],ebx
	or	[edi+60],edx
	pop	ecx			; restore the scanline count
	add	esi,128			; 16 pixels/scanline * 2 (pixels+mask) * 4 (4 bytes/pixel)
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	near _mymouse_draw_mouse16_32_loop
	ret
_mymouse_draw_mouse16_32_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	push	edx			; save number of dwords to do
_mymouse_draw_mouse16_32_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse16_32_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the pixel
	or	[edi],ebx
	add	edi,4			; 2 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse16_32_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,128			; 16 pixels/scanline * 2 (pixels+mask) * 4 (4 bytes/pixel)
	add	ebp,64			; 16 pixels/scanline (4 bytes/pixel)
	shl	eax,2			; *4 for number of bytes
	sub	edi,eax
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse16_32_loop2b
	pop	edx			; restore stack
	ret
%endif
;
%ifdef _MYMOUSE_DRAW_MOUSE32_8_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse32_8_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	cmp	[_VESAScreenFlag],dword 0	; are we on screen 1?
	jz	_mymouse_draw_mouse32_8_nolfbd	; yes
	lea	ebp,[ebp + 4608]	; no, save to other background part
	mov	[_mymouse_oldx2],bx	; save the current position (for
	mov	[_mymouse_oldy2],ax	; when we undraw it)
	jmp	_mymouse_draw_mouse32_8_nolfbd2
_mymouse_draw_mouse32_8_nolfbd:
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
_mymouse_draw_mouse32_8_nolfbd2:
	mov	ecx,ebx
	and	ebx,$0fffffffc		; align to every fourth pixel
	and	ecx,3			; find out which shifted cursor to use
	shl	ecx,8			; *256
	add	esi,ecx
	shl	ecx,3			; = shl 11 = *2048
	add	esi,ecx			; =*2304 (cursor size)
	mov	ecx,32			; 32 scanlines to do
	cmp	eax,[_mymouse_yres32]	; screen height-32 for y clipping check
	jbe	_mymouse_draw_mouse32_8_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse32_8_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	add	edi,ebx
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres32]	; screen width-32 for clipping check
	jae	near _mymouse_draw_mouse32_8_clipped
_mymouse_draw_mouse32_8_loop:
	mov	eax,[edi]		; get current dword
	mov	ebx,[esi]		; get the 4-byte mask
	mov	edx,[esi+4]		; get the 4-byte pixels
	mov	[ebp],eax		; save the background for undrawing later
	and	[edi],ebx		; mask out the 4 current pixels
	or	[edi],edx		; set the cursor
	mov	eax,[edi+4]		; repeat for the other 8 dwords
	mov	ebx,[esi+8]
	mov	edx,[esi+12]
	mov	[ebp+4],eax
	and	[edi+4],ebx
	or	[edi+4],edx
	mov	eax,[edi+8]
	mov	ebx,[esi+16]
	mov	edx,[esi+20]
	mov	[ebp+8],eax
	and	[edi+8],ebx
	or	[edi+8],edx
	mov	eax,[edi+12]
	mov	ebx,[esi+24]
	mov	edx,[esi+28]
	mov	[ebp+12],eax
	and	[edi+12],ebx
	or	[edi+12],edx
	mov	eax,[edi+16]
	mov	ebx,[esi+32]
	mov	edx,[esi+36]
	mov	[ebp+16],eax
	and	[edi+16],ebx
	or	[edi+16],edx
	mov	eax,[edi+20]
	mov	ebx,[esi+40]
	mov	edx,[esi+44]
	mov	[ebp+20],eax
	and	[edi+20],ebx
	or	[edi+20],edx
	mov	eax,[edi+24]
	mov	ebx,[esi+48]
	mov	edx,[esi+52]
	mov	[ebp+24],eax
	and	[edi+24],ebx
	or	[edi+24],edx
	mov	eax,[edi+28]
	mov	ebx,[esi+56]
	mov	edx,[esi+60]
	mov	[ebp+28],eax
	and	[edi+28],ebx
	or	[edi+28],edx
	mov	eax,[edi+32]
	mov	ebx,[esi+64]
	mov	edx,[esi+68]
	mov	[ebp+32],eax
	and	[edi+32],ebx
	or	[edi+32],edx
	add	esi,72			; 36 pixels/scanline * 2 (pixels+mask)
	add	ebp,36			; 36 pixels/scanline
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	near _mymouse_draw_mouse32_8_loop
	ret
_mymouse_draw_mouse32_8_clipped:
	mov	edx,[_mymouse_axres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,2			; /4 = number of dwords to do
	push	edx			; save number of dwords to do
_mymouse_draw_mouse32_8_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse32_8_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the 4 pixels
	or	[edi],ebx
	add	edi,4			; 4 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse32_8_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,72			; 36 pixels/scanline * 2 (pixels+mask)
	add	ebp,36			; 36 pixels/scanline
	shl	eax,2
	sub	edi,eax			; correct for number of pixels already done
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse32_8_loop2b
	pop	edx			; restore stack
	ret
%endif
;
%ifdef _MYMOUSE_DRAW_MOUSE32_16_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse32_16_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
	mov	ecx,ebx
	and	ebx,$0fffffffe		; align to every second pixel
	and	ecx,1			; find out which shifted cursor to use
	jz	_mymouse_draw_mouse32_16_noshift
	mov	esi,_mymouse_cursor_foreground2
_mymouse_draw_mouse32_16_noshift:
	mov	ecx,32			; 32 scanlines to do
	cmp	eax,[_mymouse_yres32]	; screen height-32 for y clipping check
	jbe	_mymouse_draw_mouse32_16_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse32_16_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ebx*2]	; twice because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres32]	; screen width-32 for x clipping check
	jae	near _mymouse_draw_mouse32_16_clipped
_mymouse_draw_mouse32_16_loop:
	push	ecx			; save the scanline count
	mov	ecx,17			; 17 dwords to save (the background)
	push	edi			; save registers
	push	esi
	mov	esi,edi			; esi->screen
	mov	edi,ebp			; edi->background buffer
	rep	movsd			; save the background
	mov	ebp,edi			; keep track of the background pointer
	pop	esi			; restore registers
	pop	edi
	mov	eax,[esi]		; now AND in the cursor mask
	mov	ebx,[esi+4]		; and OR in the cursor itself
	mov	ecx,[esi+8]
	mov	edx,[esi+12]
	and	[edi],eax
	and	[edi+4],ecx
	or	[edi],ebx
	or	[edi+4],edx
	mov	eax,[esi+16]
	mov	ebx,[esi+20]
	mov	ecx,[esi+24]
	mov	edx,[esi+28]
	and	[edi+8],eax
	and	[edi+12],ecx
	or	[edi+8],ebx
	or	[edi+12],edx
	mov	eax,[esi+32]
	mov	ebx,[esi+36]
	mov	ecx,[esi+40]
	mov	edx,[esi+44]
	and	[edi+16],eax
	and	[edi+20],ecx
	or	[edi+16],ebx
	or	[edi+20],edx
	mov	eax,[esi+48]
	mov	ebx,[esi+52]
	mov	ecx,[esi+56]
	mov	edx,[esi+60]
	and	[edi+24],eax
	and	[edi+28],ecx
	or	[edi+24],ebx
	or	[edi+28],edx
	mov	eax,[esi+64]
	mov	ebx,[esi+68]
	mov	ecx,[esi+72]
	mov	edx,[esi+76]
	and	[edi+32],eax
	and	[edi+36],ecx
	or	[edi+32],ebx
	or	[edi+36],edx
	mov	eax,[esi+80]
	mov	ebx,[esi+84]
	mov	ecx,[esi+88]
	mov	edx,[esi+92]
	and	[edi+40],eax
	and	[edi+44],ecx
	or	[edi+40],ebx
	or	[edi+44],edx
	mov	eax,[esi+96]
	mov	ebx,[esi+100]
	mov	ecx,[esi+104]
	mov	edx,[esi+108]
	and	[edi+48],eax
	and	[edi+52],ecx
	or	[edi+48],ebx
	or	[edi+52],edx
	mov	eax,[esi+112]
	mov	ebx,[esi+116]
	mov	ecx,[esi+120]
	mov	edx,[esi+124]
	and	[edi+56],eax
	and	[edi+60],ecx
	or	[edi+56],ebx
	or	[edi+60],edx
	mov	eax,[esi+128]
	mov	ebx,[esi+132]
	and	[edi+64],eax
	or	[edi+64],ebx
	pop	ecx			; restore the scanline count
	add	esi,136			; 34 pixels/scanline * 2 (pixels+mask) * 2 (2 bytes/pixel)
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	near _mymouse_draw_mouse32_16_loop
	ret
_mymouse_draw_mouse32_16_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	shr	edx,1			; /2 = number of dwords to do
	push	edx			; save number of dwords to do
_mymouse_draw_mouse32_16_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse32_16_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the 2 pixels
	or	[edi],ebx
	add	edi,4			; 2 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse32_16_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,136			; 34 pixels/scanline * 2 (pixels+mask) * 2 (2 bytes/pixel)
	add	ebp,68			; 34 pixels/scanline (2 bytes/pixel)
	shl	eax,2			; *4 for number of bytes
	sub	edi,eax
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse32_16_loop2b
	pop	edx			; restore stack
	ret
%endif
;
%ifdef _MYMOUSE_DRAW_MOUSE32_32_MACRO
	times ($$-$) & 31 nop		; alignment
_mymouse_draw_mouse32_32_2:
	xor	eax,eax
	xor	ebx,ebx
	mov	edi,[_VESAScreen]	; the screen
	mov	esi,_mymouse_cursor_foreground
	mov	ebp,_mymouse_cursor_background
	mov	bx,[_mymouse_xpos]	; get the current mouse position
	mov	ax,[_mymouse_ypos]
	mov	[_mymouse_oldx],bx	; save the current position (for
	mov	[_mymouse_oldy],ax	; when we undraw it)
	mov	ecx,32			; 32 scanlines to do
	cmp	eax,[_mymouse_yres32]	; screen height-32 for y clipping check
	jbe	_mymouse_draw_mouse32_32_noyclip	; no clipping
	mov	ecx,[_mymouse_ayres]	; clip in y, don't draw entire cursor
	sub	ecx,eax			; number of lines to draw
_mymouse_draw_mouse32_32_noyclip:
	imul	eax,[_mymouse_axres]	; * screen width
	lea	edi,[edi + ebx*4]	; four times because it's 2 bytes/pixel
	add	edi,eax			; offset into screen
	cmp	ebx,[_mymouse_xres32]	; screen width-32 for x clipping check
	jae	near _mymouse_draw_mouse32_32_clipped
_mymouse_draw_mouse32_32_loop:
	push	ecx			; save the scanline count
	mov	ecx,32			; 32 dwords to save (the background)
	push	edi			; save registers
	push	esi
	mov	esi,edi			; esi->screen
	mov	edi,ebp			; edi->background buffer
	rep	movsd			; save the background
	mov	ebp,edi			; keep track of the background pointer
	pop	esi			; restore registers
	pop	edi
	mov	eax,[esi]		; now AND in the cursor mask
	mov	ebx,[esi+4]		; and OR in the cursor itself
	mov	ecx,[esi+8]
	mov	edx,[esi+12]
	and	[edi],eax
	and	[edi+4],ecx
	or	[edi],ebx
	or	[edi+4],edx
	mov	eax,[esi+16]
	mov	ebx,[esi+20]
	mov	ecx,[esi+24]
	mov	edx,[esi+28]
	and	[edi+8],eax
	and	[edi+12],ecx
	or	[edi+8],ebx
	or	[edi+12],edx
	mov	eax,[esi+32]
	mov	ebx,[esi+36]
	mov	ecx,[esi+40]
	mov	edx,[esi+44]
	and	[edi+16],eax
	and	[edi+20],ecx
	or	[edi+16],ebx
	or	[edi+20],edx
	mov	eax,[esi+48]
	mov	ebx,[esi+52]
	mov	ecx,[esi+56]
	mov	edx,[esi+60]
	and	[edi+24],eax
	and	[edi+28],ecx
	or	[edi+24],ebx
	or	[edi+28],edx
	mov	eax,[esi+64]
	mov	ebx,[esi+68]
	mov	ecx,[esi+72]
	mov	edx,[esi+76]
	and	[edi+32],eax
	and	[edi+36],ecx
	or	[edi+32],ebx
	or	[edi+36],edx
	mov	eax,[esi+80]
	mov	ebx,[esi+84]
	mov	ecx,[esi+88]
	mov	edx,[esi+92]
	and	[edi+40],eax
	and	[edi+44],ecx
	or	[edi+40],ebx
	or	[edi+44],edx
	mov	eax,[esi+96]
	mov	ebx,[esi+100]
	mov	ecx,[esi+104]
	mov	edx,[esi+108]
	and	[edi+48],eax
	and	[edi+52],ecx
	or	[edi+48],ebx
	or	[edi+52],edx
	mov	eax,[esi+112]
	mov	ebx,[esi+116]
	mov	ecx,[esi+120]
	mov	edx,[esi+124]
	and	[edi+56],eax
	and	[edi+60],ecx
	or	[edi+56],ebx
	or	[edi+60],edx
	mov	eax,[esi+128]
	mov	ebx,[esi+132]
	mov	ecx,[esi+136]
	mov	edx,[esi+140]
	and	[edi+64],eax
	and	[edi+68],ecx
	or	[edi+64],ebx
	or	[edi+68],edx
	mov	eax,[esi+144]
	mov	ebx,[esi+148]
	mov	ecx,[esi+152]
	mov	edx,[esi+156]
	and	[edi+72],eax
	and	[edi+76],ecx
	or	[edi+72],ebx
	or	[edi+76],edx
	mov	eax,[esi+160]
	mov	ebx,[esi+164]
	mov	ecx,[esi+168]
	mov	edx,[esi+172]
	and	[edi+80],eax
	and	[edi+84],ecx
	or	[edi+80],ebx
	or	[edi+84],edx
	mov	eax,[esi+176]
	mov	ebx,[esi+180]
	mov	ecx,[esi+184]
	mov	edx,[esi+188]
	and	[edi+88],eax
	and	[edi+92],ecx
	or	[edi+88],ebx
	or	[edi+92],edx
	mov	eax,[esi+192]
	mov	ebx,[esi+196]
	mov	ecx,[esi+200]
	mov	edx,[esi+204]
	and	[edi+96],eax
	and	[edi+100],ecx
	or	[edi+96],ebx
	or	[edi+100],edx
	mov	eax,[esi+208]
	mov	ebx,[esi+212]
	mov	ecx,[esi+216]
	mov	edx,[esi+220]
	and	[edi+104],eax
	and	[edi+108],ecx
	or	[edi+104],ebx
	or	[edi+108],edx
	mov	eax,[esi+224]
	mov	ebx,[esi+228]
	mov	ecx,[esi+232]
	mov	edx,[esi+236]
	and	[edi+112],eax
	and	[edi+116],ecx
	or	[edi+112],ebx
	or	[edi+116],edx
	mov	eax,[esi+240]
	mov	ebx,[esi+244]
	mov	ecx,[esi+248]
	mov	edx,[esi+252]
	and	[edi+120],eax
	and	[edi+124],ecx
	or	[edi+120],ebx
	or	[edi+124],edx
	pop	ecx			; restore the scanline count
	add	esi,256			; 32 pixels/scanline * 2 (pixels+mask) * 4 (4 bytes/pixel)
	add	edi,[_mymouse_axres]	; next scanline
	dec	ecx			; do all scanlines
	jnz	near _mymouse_draw_mouse32_32_loop
	ret
_mymouse_draw_mouse32_32_clipped:
	mov	edx,[_mymouse_xres]	; screen width-xpos = number of pixels to do
	sub	edx,ebx
	push	edx			; save number of dwords to do
_mymouse_draw_mouse32_32_loop2b:
	mov	edx,[esp]		; get number of dwords to do
_mymouse_draw_mouse32_32_loop2a:
	mov	eax,[edi]		; save current dword
	mov	[ebp],eax		; save the background
	mov	eax,[esi]		; 4 byte mask
	mov	ebx,[esi+4]		; 4-byte colors
	add	esi,8
	add	ebp,4
	and	[edi],eax		; draw the pixel
	or	[edi],ebx
	add	edi,4			; 2 pixels on
	dec	edx			; another dword done
	jnz	_mymouse_draw_mouse32_32_loop2a	; keep going
	add	edi,[_mymouse_axres]	; next scanline
	mov	eax,[esp]		; number of dwords done
	add	esi,256			; 23 pixels/scanline * 2 (pixels+mask) * 4 (4 bytes/pixel)
	add	ebp,128			; 32 pixels/scanline (4 bytes/pixel)
	shl	eax,2			; *4 for number of bytes
	sub	edi,eax
	sub	esi,eax
	sub	esi,eax
	sub	ebp,eax
	dec	ecx			; do all scanlines
	jnz	_mymouse_draw_mouse32_32_loop2b
	pop	edx			; restore stack
	ret
%endif

%endif
