; Sound subsystem
; by Gaz
;
%ifndef _MYSB
%define _MYSB
[BITS 32]
[section .bss]
_mysb_spare	resd 1

%ifdef _MYSB_DETECT_MACRO
_mysb_base	resd 1				; SoundBlaster attributes, dwords for convenience
_mysb_irq	resd 1
_mysb_dmalow	resd 1
_mysb_dmahigh	resd 1
_mysb_mpu	resd 1
_mysb_awe	resd 1
;
_mysb_ds	resd 1
_mysb_irqs	resd 1				; the IRQ flags (which IRQs are triggered)
		resd 1
_mysb_oldirqs	resd 5				; space for the old IRQ addresses, each address
		resw 5				; is a selector and offset (ie dword + word)
_mysb_oldirqmsk	resd 1
;
_snd_selector	resd 1
_snd_address	resd 1
;
_snd_device	resd 1				; sound device in use
_snd_dev_bits	resd 1				; bits/sample (8/16)
_snd_dev_dma	resd 1				; single-cycle/auto-initialised DMA mode
_snd_dev_rate	resd 1				; output rate
_snd_dev_voices	resd 1				; number of sound channels
;
; _snd_samples contains the current voices. Each voice has the structure:
;
; pointer to current position in sample being played (0 = no sample on this voice)
; samples left to play in this sample
; sample volume (unused)
; sample panning (unused)
;
_snd_samples	resd 4*32
%endif

[section .data]
%ifdef _MYSB_DETECT_MACRO
_mysb_envvar	db 'BLASTER',0			; environment variable name for SoundBlaster
%endif

[section .text]
;
;------------------------------------------------------------------------------------
;
; Call to try and detect a SoundBlaster. Carry will be clear on success, set otherwise.
;
%ifdef _MYSB_DETECT_MACRO
%ifdef _MYARGS_INIT_MACRO
_mysb_detect_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	DetectOS				; detect OS we're running under
	mov	[_mysb_base],dword $0220	; SB defaults - base address
	mov	[_mysb_irq],dword 5		; IRQ 5
	mov	[_mysb_dmalow],dword 1		; DMA channel 1 for 8-bit output
	mov	[_mysb_dmahigh],dword 0		; no 16-bit output
	mov	[_mysb_mpu],dword 0		; no MPU interface
	mov	[_mysb_awe],dword 0		; no Advanced Wave Effects
	mov	eax,[esp + 28]
	and	eax,_SND_FORCEAUTODETECT	; force hardware detection?
	jnz	_mysb_detect_manual		; yes, try and detect it manually
	GetEnv	_mysb_envvar,esi		; see if the BLASTER enviroment variable has been set
	jc	near _mysb_detect_manual	; no, try and detect it manually
	mov	edi,esi				; yes, save address of environment variable
; Get the base address
	PosLetter edi,'a',esi
	jc	near _mysb_detect_manual
	lea	esi,[esi + edi + 1]
	mov	eax,[esi]			; get base address (should be Axxx)
	and	eax,$0ffffff			; and make the top byte a null-terminator
	push	eax
	HexToInt esp,eax
	lea	esp,[esp + 4]
	jc	near _mysb_detect_manual
	cmp	eax,$0220
	jb	near _mysb_detect_manual
	cmp	eax,$0280
	ja	near _mysb_detect_manual
	mov	[_mysb_base],eax
; Get the IRQ line number
	PosLetter edi,'i',esi
	jc	near _mysb_detect_manual
	lea	esi,[esi + edi + 1]
	mov	al,[esi]			; get IRQ line value (should be Ix)
	and	eax,$0ff			; put in a null terminator
	push	eax
	HexToInt esp,eax
	lea	esp,[esp + 4]
	jc	near _mysb_detect_manual
	mov	[_mysb_irq],eax
; Get the low DMA channel
	PosLetter edi,'d',esi
	jc	near _mysb_detect_manual
	lea	esi,[esi + edi + 1]
	mov	al,[esi]			; get low DMA channel number (should be Dx)
	and	eax,$0ff			; put in a null terminator
	push	eax
	HexToInt esp,eax
	lea	esp,[esp + 4]
	jc	near _mysb_detect_manual
	mov	[_mysb_dmalow],eax
; Get the high DMA channel
	PosLetter edi,'h',esi
	jc	_mysb_detect_enodmahigh		; not all SBs have a high DMA channel
	lea	esi,[esi + edi + 1]
	mov	al,[esi]			; get high DMA channel number (should be Hx)
	and	eax,$0ff			; put in a null terminator
	push	eax
	HexToInt esp,eax			; on error this will be 0 anyway
	lea	esp,[esp + 4]
	mov	[_mysb_dmahigh],eax
_mysb_detect_enodmahigh:
; Get the MPU interface
	PosLetter edi,'p',esi
	jc	_mysb_detect_enompu
	lea	esi,[esi + edi + 1]
	mov	eax,[esi]			; get MPU address (should be Pxxx)
	and	eax,$0ffffff			; put in a null terminator
	push	eax
	HexToInt esp,eax			; on error this will be 0 anyway
	lea	esp,[esp + 4]
	mov	[_mysb_mpu],eax
_mysb_detect_enompu:
; Get the AWE interface
	PosLetter edi,'e',esi
	jc	_mysb_detect_enoawe
	lea	esi,[esi + edi + 1]
	mov	eax,[esi]			; get AWE address (should be Exxx)
	and	eax,$0ffffff			; put in a null terminator
	push	eax
	HexToInt esp,eax			; on error this will be 0 anyway
	lea	esp,[esp + 4]
	mov	[_mysb_awe],eax
_mysb_detect_enoawe:
;
; verify BLASTER settings here? Might as well not bother...
;
	jmp	_mysb_detect_ok			; finished
_mysb_detect_manual:				; try and manually detect a SoundBlaster
	mov	eax,[esp + 28]
	and	eax,_SND_NOAUTODETECT		; don't try hardware detection?
	jnz	_mysb_detect_error		; no, end with error
	sti					; enable interrupts
	cmp	[_os_type],dword _OS_TYPE_WINNT	; are we running under NT?
	je	near _mysb_detect_error		; yes, can't auto-detect SoundBlaster (no access to the IO ports) so error
;
; detect the base address - we do this by trying to reset the DSP at
; each of the possible SoundBlaster base addresses ($220-$280). If a
; SoundBlaster exists at the checked address, it will return a status
; byte (ie we know a SoundBlaster exists then)
;
	mov	[_mysb_base],dword $0220
_mysb_detect_base_loop:
	SBDSPReset				; try and reset the SB at this address
	jnc	_mysb_detect_base_ok		; found it!
	add	[_mysb_base],dword $010		; not found so try the next address
	cmp	[_mysb_base],dword $0280	; tried all the addresses?
	jbe	_mysb_detect_base_loop		; no, keep looking
	jmp	_mysb_detect_error		; yes, no SoundBlaster :(
_mysb_detect_base_ok:
;
; detect the low DMA channel - we do this by programming the SoundBlaster's DSP
; to play an 8-bit sample via DMA. Whilst the sample is playing, we check the
; DMA activity and then know which DMA channel the SoundBlaster is using. We
; have to be careful to first find out if there are any DMA channels in use by
; non-SoundBlaster devices so we first stop any SoundBlaster DMA activity and
; check whether there's any DMA activity.
;
	SBDSPReset				; first stop any current DSP activity
	SBDSPWrite $0d3				; DSP command $d3 - speaker off (don't want to hear anything here)
	SBDSPWrite $040				; DSP command $40 - set sample rate
	SBDSPWrite 165				; 11025 Hz (worked out via 256 - (1000000/rate))
	SBDSPWrite $0d0				; DSP command $d0 - pause 8-bit DMA
	SBDSPWrite $0d5				; DSP command $d5 - pause 16-bit DMA
	mov	ecx,100				; detect DMA channels in use when the SB isn't using them
	xor	eax,eax				; eax is a scratch register
	xor	ebx,ebx				; ebx holds the mask of DMA channels
_mysb_detect_lowdma_nonaudio_loop:
	in	al,$8				; get the DMA activity for the master controller
	or	ebx,eax				; and OR in the activity bits to our mask
	dec	ecx				; looped long enough?
	jnz	_mysb_detect_lowdma_nonaudio_loop	; no, keep looping
	and	ebx,$0f0			; yes, mask off all but bits 4-7 (the channel activity bits)
	not	ebx				; and make the DMA channels in use into a proper mask
	mov	ecx,100				; now program the SB to play a sample via DMA so we
	xor	eax,eax				; can detect which channel it was using
	xor	edx,edx				; edx holds the DMA channels in use
	SBDSPWrite $014				; DSP command $014 - start 8-bit DMA output
	SBDSPWrite $050				; low byte of (sample length - 1)
	SBDSPWrite $0				; high byte of (sample length - 1)
_mysb_detect_lowdma_loop:
	in	al,$8				; get the DMA activity for the master controller
	or	edx,eax				; and OR in any activity bits to our mask
	dec	ecx				; looped long enough?
	jnz	_mysb_detect_lowdma_loop	; no, keep looping
	and	edx,$0f0			; yes, mask off all but bits 4-7 (the channel activity bits)
	and	edx,ebx				; and mask out any non-audio DMA channels that were in use
	or	edx,edx				; sanity check - no low DMA channel?
	jz	near _mysb_detect_error		; no! (damaged card, no port access, being single-stepped?)
	mov	eax,-5				; eax will hold the actual channel number
_mysb_detect_lowdma_loop2:
	inc	eax				; increase the channel number
	shr	edx,1				; shift bits by one
	jnc	_mysb_detect_lowdma_loop2	; found the channel? if not, keep looping
	mov	[_mysb_dmalow],eax		; yes, same the channel number
;
; now detect the high DMA channel - we use the same method as above
;
	SBDSPReset
	SBDSPVersion ax				; first get the DSP version
	cmp	ah,4				; is it 4.xx or above?
	jb	near _mysb_detect_irq		; no, can't do 16-bit output
	SBDSPReset				; yes, stop any DMA activity
	SBDSPWrite $0d0				; DSP command $d0 - pause 8-bit DMA
	SBDSPWrite $0d5				; DSP command $d5 - pause 16-bit DMA
	mov	ecx,100				; detect DMA channels in use when the SB isn't using them
	xor	eax,eax				; eax is a scratch register
	xor	ebx,ebx				; ebx holds the mask of DMA channels
_mysb_detect_highdma_nonaudio_loop:
	in	al,$0d0				; get the DMA activity for the slave controller
	or	ebx,eax				; and OR in the activity bits to our mask
	dec	ecx				; looped long enough?
	jnz	_mysb_detect_highdma_nonaudio_loop	; no, keep looping
	and	ebx,$0f0			; yes, mask off all but bits 4-7 (the channel activity bits)
	not	ebx				; and make the DMA channels in use into a proper mask
	mov	ecx,100				; and program the SB to play a sample via DMA so we
	xor	eax,eax				; can detect which channel it was using
	xor	edx,edx				; edx holds the DMA channels in use
	SBDSPWrite $0b0				; DSP command $0b0 - start 16-bit DMA output
	SBDSPWrite $0				; mode of 0 (mono, unsigned)
	SBDSPWrite $050				; low byte of (number of samples - 1)
	SBDSPWrite $0				; high byte of (number of samples - 1)
_mysb_detect_highdma_loop:
	in	al,$0d0				; get the DMA activity for the slave controller
	or	edx,eax				; and OR in any activity bits to our mask
	dec	ecx				; looped long enough?
	jnz	_mysb_detect_highdma_loop	; no, keep looping
	and	edx,$0f0			; yes, mask off all but bits 4-7 (the channel activity bits)
	and	edx,ebx				; and mask out any non-audio DMA channels that were in use
	or	edx,edx				; sanity check - no high DMA channel?
	jz	near _mysb_detect_error		; no! (damaged card?)
	mov	eax,-1				; eax will hold the actual channel number
_mysb_detect_highdma_loop2:
	inc	eax				; increase the channel number
	shr	edx,1				; shift bits by one
	jnc	_mysb_detect_highdma_loop2	; found the channel? if not, keep looping
	mov	[_mysb_dmahigh],eax		; yes, save the channel number
_mysb_detect_irq:
;
; detect the IRQ in use - to do this we program the DSP to do a DMA transfer (ie play
; a sample). After it finishes, the IRQ the SoundBlaster uses is called. We place our
; own IRQs in all the possible SoundBlaster ones and see which one was called. Like in
; detecting the DMA we have to be careful to ignore IRQs generated by non-SoundBlaster
; devices
;
	mov	edi,_mysb_oldirqs		; edi -> space to save IRQs
	mov	eax,$0204			; save IRQ 2 address
	mov	bl,$0a				; interrupt vector 10
	int	$31
	mov	[edi],cx			; save selector
	mov	[edi + 2],edx			; save offset
	add	edi,6
	mov	eax,$0204			; save IRQ 3 address
	mov	bl,$0b
	int	$31
	mov	[edi],cx
	mov	[edi + 2],edx
	add	edi,6
	mov	eax,$0204			; save IRQ 5 address
	mov	bl,$0d
	int	$31
	mov	[edi],cx
	mov	[edi + 2],edx
	add	edi,6
	mov	eax,$0204			; save IRQ 7 address
	mov	bl,$0f
	int	$31
	mov	[edi],cx
	mov	[edi + 2],edx
	add	edi,6
	mov	eax,$0204			; save IRQ 10 address
	mov	bl,$072
	int	$31
	mov	[edi],cx
	mov	[edi + 2],edx
; install the new IRQs
	in	al,$021				; get the current IRQ masks for PIC1
	mov	[_mysb_oldirqmsk],al
	in	al,$0a1				; get the current IRQ masks for PIC2
	mov	[_mysb_oldirqmsk + 1],al
	mov	ax,ds				; save the current data selector for
	mov	[_mysb_ds],ax			; using in the IRQ handlers
	mov	eax,$0205			; set new IRQ 2 address
	mov	bl,$0a				; interrupt vector 10
	mov	cx,cs				; selector
	mov	edx,_mysb_irq2			; offset
	int	$31
	mov	eax,$0205			; set new IRQ 3 address
	mov	bl,$0b
	mov	cx,cs
	mov	edx,_mysb_irq3
	int	$31
	mov	eax,$0205			; set new IRQ 5 address
	mov	bl,$0d
	mov	cx,cs
	mov	edx,_mysb_irq5
	int	$31
	mov	eax,$0205			; set new IRQ 7 address
	mov	bl,$0f
	mov	cx,cs
	mov	edx,_mysb_irq7
	int	$31
	mov	eax,$0205			; set new IRQ 10 address
	mov	bl,$072
	mov	cx,cs
	mov	edx,_mysb_irq10
	int	$31
	mov	al,[_mysb_oldirqmsk]		; unmask the IRQs we want to check
	and	al,$053				; $053 = 01010011 (ie IRQ 76543210, ie IRQs 2, 3, 5 and 7 on)
	out	$021,al				; and unmask PIC1
	mov	al,[_mysb_oldirqmsk + 1]
	and	al,$0fb				; $0fb = 11111011 (ie IRQ 15..8, ie IRQ 10 on)
	out	$0a1,al				; and unmask PIC2
	mov	[_mysb_irqs],dword 0		; zero the IRQ flags (no IRQs triggered)
	mov	[_mysb_irqs + 4],dword 0
	MicrosecondDelay 100			; and wait a bit to see what IRQs are triggered without the SB
	mov	esi,[_mysb_irqs]		; get the results in esi and edi
	mov	edi,[_mysb_irqs + 4]
	not	esi				; and invert them so we get a mask so we can mask out any IRQs
	not	edi				; that were in use without the SB (can't be used by the SB)
	mov	[_mysb_irqs],dword 0		; zero the IRQ flags (no IRQs triggered)
	mov	[_mysb_irqs + 4],dword 0
; setup the DMA for a transfer
	SBDSPReset				; stop any DMA activity
	SBDSPWrite $0d3				; DSP command $d3 - speaker off (don't want to hear anything here)
	SBDSPWrite $040				; DSP command $40 - set sample rate
	SBDSPWrite 165				; 11025 Hz (worked out via 256 - (1000000/rate))
	SBDSPWrite $041				; DSP command $041 - enable speaker (required on older SBs)
	SBDSPWrite $0d0				; DSP command $d0 - pause 8-bit DMA
	SBDSPWrite $0d5				; DSP command $d5 - pause 16-bit DMA
	mov	eax,[_mysb_dmalow]		; mask out the DMA channel while we reprogram it
	add	eax,4
	out	$0a,al
	xor	eax,eax				; clear byte pointer flip-flop
	out	$0c,al
	mov	eax,[_mysb_dmalow]		; set channel mode - single cycle read (read means from memory)
	add	eax,$048
;	add	eax,$090			; my docs are wrong?
	out	$0b,al
	mov	edx,[_mysb_dmalow]		; set the buffer offset
	shl	edx,1
	xor	eax,eax
	out	dx,al				; low byte
	out	dx,al				; high byte
	inc	edx				; set the size (length - 1)
	out	dx,al				; low byte
	out	dx,al				; high byte
	mov	ebx,[_mysb_dmalow]		; set page port
	cmp	ebx,0				; port depends on the DMA channel
	jne	_mysb_detect_irq_not0
	mov	edx,$087			; DMA channel 0
_mysb_detect_irq_not0:
	cmp	ebx,1
	jne	_mysb_detect_irq_not1
	mov	edx,$083			; DMA channel 1
_mysb_detect_irq_not1:
	cmp	ebx,2
	jne	_mysb_detect_irq_not2
	mov	edx,$081			; DMA channel 2
_mysb_detect_irq_not2:
	cmp	ebx,3
	jne	_mysb_detect_irq_not3
	mov	edx,$082			; DMA channel 3
_mysb_detect_irq_not3:
	out	dx,al				; set page port
	mov	eax,[_mysb_dmalow]		; and unmask the DMA channel
	out	$0a,al
; start the transfer and detect the IRQ
	SBDSPWrite $014				; DSP command $014 - start an 8-bit DMA transfer
	SBDSPWrite $0				; low byte of (length - 1)
	SBDSPWrite $0				; high byte of (length - 1)
	MicrosecondDelay 100			; wait while the transfer occurs
	and	[_mysb_irqs],esi		; mask out any channels that we don't want to monitor
	and	[_mysb_irqs + 4],edi
	xor	eax,eax				; and see which IRQ was triggered
	cmp	[_mysb_irqs],byte $0ff		; IRQ 2?
	jne	_mysb_detect_notirq2
	mov	eax,2
_mysb_detect_notirq2:
	cmp	[_mysb_irqs + 1],byte $0ff	; IRQ 3?
	jne	_mysb_detect_notirq3
	mov	eax,3
_mysb_detect_notirq3:
	cmp	[_mysb_irqs + 2],byte $0ff	; IRQ 5?
	jne	_mysb_detect_notirq5
	mov	eax,5
_mysb_detect_notirq5:
	cmp	[_mysb_irqs + 3],byte $0ff	; IRQ 7?
	jne	_mysb_detect_notirq7
	mov	eax,7
_mysb_detect_notirq7:
	cmp	[_mysb_irqs + 4],byte $0ff	; IRQ 10?
	jne	_mysb_detect_notirq10
	mov	eax,10
_mysb_detect_notirq10:
	mov	[_mysb_irq],eax			; save the IRQ
; restore the old IRQs
	mov	al,[_mysb_oldirqmsk]		; restore the old IRQ mask for PIC1
	out	$021,al
	mov	al,[_mysb_oldirqmsk + 1]	; and for PIC2
	out	$0a1,al
	mov	edi,_mysb_oldirqs		; restore old IRQ addresses
	mov	eax,$0205			; restore IRQ 2 address
	mov	bl,$0a				; interrupt vector 10
	mov	cx,[edi]			; selector
	mov	edx,[edi + 2]			; offset
	int	$31
	add	edi,6
	mov	eax,$0205			; restore IRQ 3 address
	mov	bl,$0b
	mov	cx,[edi]
	mov	edx,[edi + 2]
	int	$31
	add	edi,6
	mov	eax,$0205			; restore IRQ 5 address
	mov	bl,$0d
	mov	cx,[edi]
	mov	edx,[edi + 2]
	int	$31
	add	edi,6
	mov	eax,$0205			; restore IRQ 7 address
	mov	bl,$0f
	mov	cx,[edi]
	mov	edx,[edi + 2]
	int	$31
	add	edi,6
	mov	eax,$0205			; restore IRQ 10 address
	mov	bl,$072
	mov	cx,[edi]
	mov	edx,[edi + 2]
	int	$31
	cmp	[_mysb_irq],dword 0		; IRQ not detected?
	je	_mysb_detect_error		; no!
_mysb_detect_ok:
	SBDSPReset				; reset the DSP
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_mysb_detect_error:
	mov	[_mysb_base],dword 0		; error so clear all SB attributes
	mov	[_mysb_irq],dword 0
	mov	[_mysb_dmalow],dword 0
	mov	[_mysb_dmahigh],dword 0
	mov	[_mysb_mpu],dword 0
	mov	[_mysb_awe],dword 0
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
;
; IRQ handlers for IRQ detection
;
_mysb_irq2
	push	ds				; save registers
	push	eax
	push	edx
	mov	ax,[cs:_mysb_ds]		; get the data selector to use
	mov	ds,ax
	mov	[_mysb_irqs],byte $0ff		; flag this IRQs been called
	mov	edx,[_mysb_base]		; edx holds the base addres
	add	edx,14				; base + 14 = SB DSP interrupt acknowledge
	in	al,dx
	mov	eax,$020			; acknowledge PIC1 interrupt
	out	$20,al
	out	$0a0,al				; IRQ 2 is chained to PIC2 so we acknowledge that as well
	pop	edx				; restore registers
	pop	eax
	pop	ds
	iret
_mysb_irq3
	push	ds
	push	eax
	push	edx
	mov	ax,[cs:_mysb_ds]
	mov	ds,ax
	mov	[_mysb_irqs + 1],byte $0ff
	mov	edx,[_mysb_base]
	add	edx,14
	in	al,dx
	mov	eax,$020
	out	$20,al
	pop	edx
	pop	eax
	pop	ds
	iret
_mysb_irq5
	push	ds
	push	eax
	push	edx
	mov	ax,[cs:_mysb_ds]
	mov	ds,ax
	mov	[_mysb_irqs + 2],byte $0ff
	mov	edx,[_mysb_base]
	add	edx,14
	in	al,dx
	mov	eax,$020
	out	$20,al
	pop	edx
	pop	eax
	pop	ds
	iret
_mysb_irq7
	push	ds
	push	eax
	push	edx
	mov	ax,[cs:_mysb_ds]
	mov	ds,ax
	mov	[_mysb_irqs + 3],byte $0ff
	mov	edx,[_mysb_base]
	add	edx,14
	in	al,dx
	mov	eax,$020
	out	$20,al
	pop	edx
	pop	eax
	pop	ds
	iret
_mysb_irq10
	push	ds
	push	eax
	push	edx
	mov	ax,[cs:_mysb_ds]
	mov	ds,ax
	mov	[_mysb_irqs + 4],byte $0ff
	mov	edx,[_mysb_base]
	add	edx,14
	in	al,dx
	mov	eax,$020
	out	$20,al
	out	$0a0,al				; IRQ 10 is on PIC2 so acknowledge PIC2 as well
	pop	edx
	pop	eax
	pop	ds
	iret
%else
%error "Must call ArgsInit before SndDetect!"
%endif
%endif
;
;------------------------------------------------------------------------------------
;
; Initialises the sound subsystem with a SoundBlaster as the sound device
;
%ifdef _MYSB_INIT_MACRO
_mysb_init_2:
	push	eax
	push	ebx
	mov	ax,$100				; allocate some low memory
	mov	bx,3200				; 50K
	int	$31
	jc	near _mysb_init_error
	mov	[_snd_selector],dx		; selector allocated (need this to free the memory later)
	and	eax,$0ffff			; convert segment address to linear address
	shl	eax,4
	add	eax,65535			; align up to nearest 64K boundary
	and	eax,$0ffff0000
	mov	[_snd_address],eax		; and save it
_mysb_init_ok:
	pop	ebx
	pop	eax
	clc
	ret
_mysb_init_error:
	pop	ebx
	pop	eax
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Returns the DSP version (high byte is major number, low byte is minor number)
;
%ifdef _MYSB_DSP_VERSION_MACRO
_mysb_dsp_version_2:
	push	eax
	xor	eax,eax				; eax will hold the version
;	SBDSPReset
	SBDSPWrite $0e1				; DSP command to get DSP version
	SBDSPRead ah				; get major number
	SBDSPRead al				; get minor number
	mov	[_mysb_spare],ax		; and save version
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Resets the SoundBlaster DSP
;
%ifdef _MYSB_DSP_RESET_MACRO
_mysb_dsp_reset_2:
	push	eax				; save registers
	push	ecx
	push	edx
	mov	edx,[_mysb_base]		; get base address of SB to reset
	add	edx,6				; Reset port is at base address + 6
	mov	al,1
	out	dx,al				; begin initialisation procedure
	MicrosecondDelay 10			; wait for 10 microseconds
	xor	eax,eax
	out	dx,al
	MicrosecondDelay 10			; wait for 10 microseconds
	add	edx,8				; 8 + 6 = 14 = SB ReadBuffer Status port
	mov	ecx,65535			; try 65535 times
_mysb_dsp_reset_wait_loop:
	dec	ecx				; another attempt made
	jz	_mysb_dsp_reset_error		; end with error after all attempts made
	in	al,dx				; otherwise get read status
	and	eax,$080			; get data ready bit
	jz	_mysb_dsp_reset_wait_loop	; and loop until data ready
	sub	edx,4				; 14 - 4 = 10 = SB Read Data port
	in	al,dx				; get data
	cmp	al,$0aa				; SoundBlaster present?
	jne	_mysb_dsp_reset_error
	pop	edx				; restore registers
	pop	ecx
	pop	eax
	clc					; flag success
	ret
_mysb_dsp_reset_error:
	pop	edx				; restore registers
	pop	ecx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Reads a byte from the SoundBlaster DSP
;
%ifdef _MYSB_DSP_READ_MACRO
_mysb_dsp_read_2:
	push	eax
	push	edx
	mov	edx,[_mysb_base]		; edx holds the SB base address
	add	edx,14				; base + 14 is the DSP read status address
_mysb_dsp_read_loop:
	in	al,dx				; get the status
	and	eax,$080			; is the read ready bit set?
	jz	_mysb_dsp_read_loop		; no, wait until it is
	sub	edx,4				; base + 14 - 4 = base + 10 = SB read address
	in	al,dx				; and read the byte from the DSP
	mov	[_mysb_spare],al		
	pop	edx
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Writes the byte in bl to the SoundBlaster DSP
;
%ifdef _MYSB_DSP_WRITE_MACRO
_mysb_dsp_write_2:
	push	eax
	push	edx
	mov	edx,[_mysb_base]		; edx holds the SB base address
	add	edx,12				; base + 12 is the DSP write status address
_mysb_dsp_write_loop:
	in	al,dx				; get the status
	and	eax,$80				; is the write ready bit clear?
	jnz	_mysb_dsp_write_loop		; no, wait until it is
	mov	eax,ebx				; get byte in dl in al
	out	dx,al				; and write the byte to the DSP
	pop	edx
	pop	eax
	ret
%endif


%endif
