#include <windows.h>
#include <stdio.h>

// defines para establecer los BPM de debug sobre DR7
#define LOCAL_EXACT_BPM_ENABLED  1UL<<9
#define GLOBAL_EXACT_BPM_ENABLED  1UL<<10
#define GLOBAL_EXACT_BPM_DISABLED 0
#define LOCAL_EXACT_BPM_DISABLED 0
#define RESERVED_BIT10 0X700

// Flags para el ipo de BPM en el registro DR0
#define DR0_ENABLED              1
#define DR0_EXECUTION	0UL<<16
#define DR0_WRITE		1UL<<16
#define DR0_IO			2UL<<16
#define DR0_RW			3UL<<16

// cuando el BPM es de ejecucin su longitud debe ser 1
#define LEN0_1BYTES		0UL<<19		
// si el BPM es de RW su longitud puede ser uno de los siguientes valores
#define LEN0_2BYTES		1UL<<19
#define LEN0_UNDEF		2UL<<19
#define LEN0_4BYTES		3UL<<19		

static LONG WINAPI MyBPMHandler(LPEXCEPTION_POINTERS pExceptStruct);
void PutBPM(HANDLE hThread,DWORD Address);

int main()
{
	DWORD Address;

	SetUnhandledExceptionFilter(MyBPMHandler);
	Address=(DWORD)&MessageBox;
	PutBPM(GetCurrentThread(),Address);
	MessageBox(NULL,"Hi all","Message",MB_OK);
	return (0);

}
// Pone un BPM sobre el Thread especificado en la direccin especificada usando el 
// registro DR0 como contenedor de la direccin, en DR7 se setean los bits para
// activar el BPM sobre DR0
void PutBPM(HANDLE hThread,DWORD Address)
{
	CONTEXT Regs;					// Estructura para establecer el contexto del thread

	// obtenemos contexto del thread
	GetThreadContext(hThread,&Regs);
	// activamos los flags para los registros de depuracin, k es lo unico k tocaremos del contexto
	Regs.ContextFlags=CONTEXT_DEBUG_REGISTERS;	
	// ponemos DR7 para k active un BPM en DR0
	Regs.Dr7=LOCAL_EXACT_BPM_ENABLED|DR0_EXECUTION|DR0_ENABLED|LEN0_1BYTES;
	// sobre Address
	Regs.Dr0=Address;
	// y establecemos de nuevo el contexto del Thread
	SetThreadContext(hThread,&Regs);
}

// Manejador de excepciones para cuando el BPM surta efecto
static LONG WINAPI MyBPMHandler(LPEXCEPTION_POINTERS pExceptStruct)
{
	PEXCEPTION_RECORD ExcepRecord; 
	PCONTEXT Context;

	// cogemos puntero al contexto y al registro de la excepcin
	Context=pExceptStruct->ContextRecord;
	ExcepRecord=pExceptStruct->ExceptionRecord;

	// Es una excepcin de trazado paso a paso?
	if (ExcepRecord->ExceptionCode==STATUS_SINGLE_STEP)
	{
		DWORD *ESPData;
		// mostramos la direccin edel EIP y la direccin de retorno
		ESPData=(DWORD*)Context->Esp;
		printf("\nSe ejecuto un MessageBox en: %08Xh",Context->Eip);
		printf("\n\tDireccion de retorno: %08Xh",*ESPData);
		// borramos el BPM		
		Context->Dr0=0;
		Context->Dr7=GLOBAL_EXACT_BPM_DISABLED|LOCAL_EXACT_BPM_DISABLED|RESERVED_BIT10;
		Context->ContextFlags=CONTEXT_FULL|CONTEXT_DEBUG_REGISTERS;
		// y seguimos		
		return EXCEPTION_CONTINUE_EXECUTION;
	}
	return EXCEPTION_CONTINUE_SEARCH;
}
