;@ECHO OFF
;GOTO MAKE

.586p
.MODEL FLAT, STDCALL
OPTION CASEMAP : NONE

INCLUDE    \masm32\include\kernel32.inc
INCLUDELIB \masm32\lib\kernel32.lib
INCLUDE    \masm32\include\user32.inc
INCLUDELIB \masm32\lib\user32.lib

INCLUDE    \masm32\include\windows.inc

;------------PROTOs---------------------------------------------------
MsgBox                             PROTO :LPSTR, :DWORD

;------------CONST----------------------------------------------------
.CONST
szNtDll                            DB "NTDLL", 0
szKiUserExctDisp                   DB "KiUserExceptionDispatcher", 0
szNtCont                           DB "NtContinue", 0
KUED_Entry1                        DB 08Bh, 04Ch, 024h, 004h                   ; MOV ECX, [ESP + 4]  (4 bytes)
KUED_Entry2                        DB 08Bh, 01Ch, 024h, 000h                   ; MOV EBX, [ESP]      (3 bytes)

szCap                              DB "KiExctHook by yoda", 0
szNotNtErr                         DB "This example doesn't work on non-NT OSs !", 0
szKUEDHookErr                      DB "Error while hooking KiUserExceptionDispatcher !", 0
szOk                               DB "Test exception successfully handled by KiUserExceptionDispatcher hook :)", 0

;------------DATA?----------------------------------------------------
.DATA?
pOrgKiUserExctDisp                 DD ?
_NtContinue                        DD ?

;------------CODE-----------------------------------------------------
.CODE
ASSUME FS : NOTHING

;
; Args:
; pAddr       - address where the jump should be assembled to
; pJumpTarget - jump target addresse
;
AssembleJump PROC USES EBX ESI EDI, pAddr : LPVOID, pJumpTarget : LPVOID
	MOV    EDI, pAddr                                                      ; EDI -> assemble address
	MOV    BYTE PTR [EDI], 0E9h                                            ; stamp jump opcode
	MOV    EAX, pJumpTarget
	SUB    EAX, EDI
	SUB    EAX, 5
	MOV    DWORD PTR [EDI + 1], EAX                                        ; stamp jump target
	RET
AssembleJump ENDP

;
; Returns: BOOL
;
HookKiUserExceptionDispatcher PROC USES EBX ESI EDI, pNewHandler : LPVOID
	LOCAL  dwBuff : DWORD
	
	SUB    ESI, ESI                                                        ; ESI = Result
	
	;-> get API entry
	INVOKE LoadLibrary, OFFSET szNtDll
	MOV    EBX, EAX                                                        ; EBX -> NtDll base
	INVOKE GetProcAddress, EBX, OFFSET szNtCont
	OR     EAX, EAX
	JZ     @@ExitProc
	MOV    _NtContinue, EAX
	INVOKE GetProcAddress, EBX, OFFSET szKiUserExctDisp
	OR     EAX, EAX
	JZ     @@ExitProc
	MOV    pOrgKiUserExctDisp, EAX
	MOV    EDI, EAX                                                        ; EDI -> pKUED
	
	;-> signature check
	MOV    EAX, DWORD PTR [EDI]
	CMP    EAX, DWORD PTR [KUED_Entry1]
	JNZ    @@ExitProc
	MOV    EAX, DWORD PTR [EDI + 4]
	AND    EAX, 000FFFFFFh
	CMP    EAX, DWORD PTR [KUED_Entry2]
	JNZ    @@ExitProc
	
	;-> overwrite API entry
	INVOKE VirtualProtect, EDI, 5, PAGE_EXECUTE_READWRITE, ADDR dwBuff
	OR     EAX, EAX
	JZ     @@ExitProc
	INVOKE AssembleJump, EDI, pNewHandler	
	
	;-> OK
	INC    ESI
	
  @@ExitProc:
        XCHG   EAX, ESI
	RET
HookKiUserExceptionDispatcher ENDP

;
; Stack:
; [ESP]      - struct EXCEPTION_RECORD*   \
; [ESP + 4]  - struct _CONTEXT*           -  struct _EXCEPTION_POINTERS
; (no return address !)
;
MyKiUserExctHandler:
	;INT    3
	;-> overwritten code from KUED entry
	MOV    ECX, [ESP + 4]                                                       ; ECX = struct _CONTEXT*
	MOV    EBX, [ESP]                                                           ; EBX = struct EXCEPTION_RECORD*
	
	;-> is it our test exception (INT 3) ?
	CMP    [EBX].EXCEPTION_RECORD.ExceptionCode, EXCEPTION_BREAKPOINT
	JNZ    @F
	CMP    [EBX].EXCEPTION_RECORD.ExceptionAddress, OFFSET TEST_BP
	JNZ    @F
	
	;-> increment EIP and call "NtContinue" - handle exception
	ADD    [ECX].CONTEXT.regEip, 1
	PUSH   0
	PUSH   ECX
	CALL   _NtContinue
  @@:
	;-> KUED jump
	MOV    EAX, pOrgKiUserExctDisp
	ADD    EAX, 7
	JMP    EAX

UnhookKiUserExceptionDispatcher PROC USES EBX ESI EDI
	;-> rewrite the first 6 original KUED entry bytes (first 5 bytes were patched only)
	MOV    EDI, pOrgKiUserExctDisp
	MOV    EAX, DWORD PTR [KUED_Entry1]
	MOV    DWORD PTR [EDI], EAX
	MOV    EAX, DWORD PTR [KUED_Entry2]
	MOV    WORD PTR [EDI + 4], AX
	RET
UnhookKiUserExceptionDispatcher ENDP

IsNT PROC USES ECX EDX
	INVOKE GetVersion
	SHR    EAX, 31
	XOR    EAX, 1
	RET
IsNT ENDP

MsgBox PROC szText : LPSTR, dwFlags : DWORD
	INVOKE MessageBox, 0, szText, OFFSET szCap, dwFlags
	RET
MsgBox ENDP

Main:
	;-> running on a NT OS ?
	CALL   IsNT
	OR     EAX, EAX
	JZ     @@NotNtErr
	
	;-> hook
	INVOKE HookKiUserExceptionDispatcher, OFFSET MyKiUserExctHandler
	OR     EAX, EAX
	JZ     @@KUEDHookErr
	
	;-> raise a test exception
TEST_BP:
	INT    3

	;-> unhook
	INVOKE UnhookKiUserExceptionDispatcher
	
	;-> success msg
	INVOKE MsgBox, OFFSET szOk, MB_ICONINFORMATION
	
  @@Quit:
	INVOKE ExitProcess, 0
	
  @@NotNtErr:
  	INVOKE MsgBox, OFFSET szNotNtErr, MB_ICONERROR
  	JMP    @@Quit
  @@KUEDHookErr:
  	INVOKE MsgBox, OFFSET szKUEDHookErr, MB_ICONERROR
  	JMP    @@Quit
End Main

:MAKE
DEL *.EXE
\MASM32\BIN\ML /nologo /c /coff /Gz /Cp /Zp1 KiExctHook.BAT
\MASM32\BIN\LINK /nologo /MERGE:.idata=.text /MERGE:.data=.text /MERGE:.rdata=.text /SECTION:.text,EWR /IGNORE:4078 /SUBSYSTEM:WINDOWS KiExctHook.obj
DEL *.OBJ

ECHO.
PAUSE
CLS