
;*-------------------------------*
; void EndianRev(*buffer, len);
;*-------------------------------*
EndianRev proc uses ebx esi edi, lpD:DWORD, Len:DWORD

	mov	esi, lpD
	mov	edi, esi
	mov	ecx, Len
	shr	ecx, 2
__l1:
	lodsd
	mov	ebx, eax
	rol	ebx, 8
	and	ebx, 000FF00FFh
	ror	eax, 8
	and	eax, 0FF00FF00h
	or	eax, ebx
	stosd
	dec	ecx
	jg	__l1
	RET
EndianRev endp

;;*-------------------------------------------------------------------*
;;- SHA-1 Hashing Algorithm -/- Win32ASM implementation by tE!        -
;;- FIPS PUB 180-1 Compatible                                         -
;;---------------------------------------------------------------------
;; - Processes 512Bit Data-Blocks
;; - 4 Rounds a 20 function calls
;; - Output is 160 Bit Hash Value
;; - Stronger than MD5
;; - 4 Constants / One for each round:
;;    K1 = 5A827999 = 2 ^ 32 *  2^ / 4
;;    K2 = 6ED9EBA1 = 2 ^ 32 *  3^ / 4
;;    K3 = 8F1BBCDC = 2 ^ 32 *  5^ / 4
;;    K4 = CA62C1D6 = 2 ^ 32 * 10^ / 4
;; - 4 Nonlinear functions / One for each round:
;;   f1(b,c,d) = (b AND c) OR ((NOT b) AND d)          for t = 00-19
;; ->f1(b,c,d) =  d XOR (b AND (c XOR d)) - optimized
;;   f2(b,c,d) =  b XOR c XOR d                        for t = 30-39
;;   f3(b,c,d) = (b AND c) OR (b AND d) OR (c AND d)   for t = 40-59
;; ->f3(b,c,d) = (b AND c) OR (d AND (b OR c)) - optimized
;;   f4(b,c,d) =  b XOR c XOR d                        for t = 60-79
;; - Speed: ~10 MB/s on a Intel PII 300
;;*--------------------------------------------------------------------*

SHA1 PROC SHA1Hash:DWORD,lpBuffer:DWORD,lBuffer:DWORD

	local a,b:DWORD

	local c:DWORD
	local d:DWORD
	local e:DWORD
	local BCNT:DWORD

	pushad

	mov	eax, lBuffer

	shr	eax,6
	jc	__out

;	mov	eax, lBuffer
;	push	64
;	pop	ebx
;	xor	edx, edx
;	div	ebx
;	test	edx, edx
;	jnz	__out			; not padded!? -> exit

	mov	BCNT, eax
  ;; Initialize variables

	mov	edi, SHA1Hash

	mov	[edi+00], 067452301h	; A
	mov	[edi+04], 0EFCDAB89h	; B
	mov	[edi+08], 098BADCFEh	; C
	mov	[edi+12], 010325476h	; D
	mov	[edi+16], 0C3D2E1F0h	; E

	mov	edi, lpBuffer		; Buffer to hash

__loop:
	mov	esi, SHA1Hash
	mov	eax, [esi+00]
	mov	ebx, [esi+04]
	mov	ecx, [esi+08]
	mov	edx, [esi+12]
	mov	esi, [esi+16]
	mov	a, eax
	mov	b, ebx
	mov	c, ecx
	mov	d, edx
	mov	e, esi
;Round 1
	xor	esi, esi		; t
__l1:	mov	eax, a
	rol	eax, 5			; a <<< 5
 ;; f1 {
	mov	ebx, d
	mov	edx, ebx
	xor	edx, c
	and	edx, b
	xor	ebx, edx
  ;;   }
	add	ebx, e			; e
	lea	ebx, [ebx+eax+5A827999h]; K1
	add	ebx, [edi+esi*4]	; W(t) ->( W(t) = M(t) for t=0 - 15 )

	mov	eax, d
	mov	e, eax			; e=d
	mov	eax, c
	mov	d, eax			; d=c
	mov	eax, b
	ror	eax, 2			; same as <<< 30 !
	mov	c, eax			; c=b <<< 30
	mov	eax, a
	mov	b, eax			; b=a
	mov	a, ebx			; a=f1(b,c,d)+W(t)+e+K1+(a <<< 5)
	inc	esi			; t++
	cmp	esi, 16
	jnz	__l1	

__l2:	mov	eax, a
	rol	eax, 5
 ;; f1 {
	mov	ebx, d
	mov	edx, ebx
	xor	edx, c
	and	edx, b
	xor	ebx, edx
 ;;    }	
	add	ebx, e
	lea	ebx, [ebx+eax+5A827999h]

	lea	edx, [esi]
	and	edx, 0Fh
	lea	ecx, [edi+edx*4]
	mov	eax, [ecx]
	lea	edx, [esi+2]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+8]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+13]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	rol	eax, 1
	mov	[ecx], eax

	add	ebx, eax
	mov	eax, d
	mov	e, eax
	mov	eax, c
	mov	d, eax
	mov	eax, b
	ror	eax, 2
	mov	c, eax
	mov	eax, a
	mov	b, eax
	mov	a, ebx
	inc	esi
	cmp	esi, 20
	jnz	__l2

;Round 2
__l3:	mov	eax, a
	rol	eax, 5
 ;; f2 {
	mov	ebx, b
	xor	ebx, c
	xor	ebx, d
 ;;    }
	add	ebx, e
	lea	ebx, [ebx+eax+6ED9EBA1h]

	lea	edx, [esi]
	and	edx, 0Fh
	lea	ecx, [edi+edx*4]
	mov	eax, [ecx]
	lea	edx, [esi+2]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+8]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+13]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	rol	eax, 1
	mov	[ecx], eax

	add	ebx, eax
	mov	eax, d
	mov	e, eax
	mov	eax, c
	mov	d, eax
	mov	eax, b
	ror	eax, 2
	mov	c, eax
	mov	eax, a
	mov	b, eax
	mov	a, ebx
	inc	esi
	cmp	esi, 40
	jnz	__l3

; Round 3
__l4:	mov	eax, a
	rol	eax, 5
 ;; f3 {
	mov	ebx, b
	mov	edx, ebx
	and	ebx, c
	or	edx, c
	and	edx, d
	or	ebx, edx
 ;;    }
	lea	ebx, [ebx+eax+8F1BBCDCh]
	add	ebx, e

	lea	edx, [esi]
	and	edx, 0Fh
	lea	ecx, [edi+edx*4]
	mov	eax, [ecx]
	lea	edx, [esi+2]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+8]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+13]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	rol	eax, 1
	mov	[ecx], eax

	add	ebx, eax
	mov	eax, d
	mov	e, eax
	mov	eax, c
	mov	d, eax
	mov	eax, b
	ror	eax, 2
	mov	c, eax
	mov	eax, a
	mov	b, eax
	mov	a, ebx
	inc	esi
	cmp	esi, 60
	jnz	__l4

; Round 4
__l5:	mov	eax, a
	rol	eax, 5
 ;; f4 {
	mov	ebx, b
	xor	ebx, c
	xor	ebx, d
 ;;    }
	add	ebx, e
	lea	ebx, [ebx+eax+0CA62C1D6h]

	lea	edx, [esi]
	and	edx, 0Fh
	lea	ecx, [edi+edx*4]
	mov	eax, [ecx]
	lea	edx, [esi+2]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+8]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	lea	edx, [esi+13]
	and	edx, 0Fh
	xor	eax, [edi+edx*4]
	rol	eax, 1
	mov	[ecx], eax

	add	ebx, eax
	mov	eax, d
	mov	e, eax
	mov	eax, c
	mov	d, eax
	mov	eax, b
	ror	eax, 2
	mov	c, eax
	mov	eax, a
	mov	b, eax
	mov	a, ebx
	inc	esi
	cmp	esi, 80
	jnz	__l5

;--------------------------------------------------------

	mov	edx,SHA1Hash

	mov	eax, a
	add	[edx], eax
	mov	eax, b
	add	[edx+4], eax
	mov	eax, c
	add	[edx+8], eax
	mov	eax, d
	add	[edx+12], eax
	mov	eax, e
	add	[edx+16], eax
  ;; Check if any Blocks left
	add	edi, 64
 	dec	BCNT
 	jnz	__loop

	
	push	20
	push	dword ptr[SHA1Hash]
	call	EndianRev
	

	sub	eax, eax
	mov	a, eax
	mov	b, eax
	mov	c, eax
	mov	d, eax
	mov	e, eax
__out:
	popad
	RET
SHA1 ENDP



;
; push lBuffer
; push lpBuffer
; call SHAPadding
;
SHAPadding PROC lpBuffer:DWORD,lBuffer:DWORD	; Pads M to 512Bits (64 Bytes) Border

	LOCAL len:DWORD
	pushad
	mov	edi, lpBuffer
	mov	eax, lBuffer
	mov	len, eax
	add	edi, eax
	mov	byte ptr[edi], 80h	; Append TRUE Bit to Message
	inc 	edi
	inc	eax
	mov	lBuffer, eax
	push	64
	pop	ebx
	xor	edx, edx
	div	ebx			; len/64
	mov	eax, 64
	sub	eax, edx
	cmp	eax, 8
	jge	__ok1
	add	eax, 64
__ok1:
	mov	ecx, eax
	add	lBuffer, eax
	sub	eax, eax
	cld
	rep	stosb
	mov	eax, len
	shl	eax, 3
	push	eax
	push	edi	
	mov	edi, lpBuffer
	mov	ebx, lBuffer
	sub	ecx, ecx

__lc:	
	mov	eax, [edi+ecx]
	mov	[edi+ecx+3],al
	mov	[edi+ecx+2],ah
	shr	eax, 16
	mov	[edi+ecx+1],al
	mov	[edi+ecx],ah
	add	ecx, 4
	cmp	ecx, ebx
	jl	__lc

	pop	edi
	pop	eax
	mov	[edi-4], eax
	popad
	RET
SHAPadding ENDP