#include <Filter.h>
#include <layouts.h>

//#define _settextcolor(x)
// Global items
#define BufLen 15000
#define GROUPBIT 0x00020000
#define gotoxy(x,y) _settextposition(y,x)
#define IS_DATA_CHANNEL(x) (((x)&0xff00) == 0x1f00)
extern void send_char(char);
extern void set8250(double bps); 
extern void hardwareInit();
inline BOOL isFrequency(unsigned short f) {
	if (f < 0x02f8)
		return TRUE;
//	if( f >= 0x2f9 && f <= 0x2ff) // not sure of these
//		return TRUE;	
//	if( f >= 0x31e && f <= 0x323 )  // not sure of these
//		return TRUE;	
//	if( f >= 0x327 && f <= 0x329 ) // not sure of these
//		return TRUE;	
	if( f >= 0x32f && f <= 0x33f )
		return TRUE;
//	if( f >= 0x3a1 && f <= 0x3a7 )  // not sure of these
//		return TRUE;	
	if( f >= 0x3c1 && f <= 0x3ff)   // not sure of 3ff, at least 3fe
		return TRUE;
	if( f == 0x3be )				// not sure where this maps
		return TRUE;
	return FALSE;
}
static const char *mapCodeToF(unsigned short theCode)
{
	static char myres[12];
	
	if( theCode <= 0x2cf ) {
		sprintf(myres,"%8.4f",851.0125 + (0.025 * ((double) theCode)));
	} else if( theCode <= 0x2f7 ) {
		sprintf(myres,"%8.4f",848.0000 + (0.025 * ((double) theCode)));
	} else if( theCode >= 0x32f && theCode <= 0x33f ) {
		sprintf(myres,"%8.4f",846.6250 + (0.025 * ((double) theCode)));
	} else  if( theCode >= 0x3c1 && theCode <= 0x3fe ) {
		sprintf(myres,"%8.4f",843.4000 + (0.025 * ((double) theCode)));
	} else{
		sprintf(myres,"0x%03hx   ",(WORD)theCode); // 3ff, 3be
	}
	return myres;
}
extern void stats(const char *);
extern void showPrompt();
extern void doKeyEvt();

#define QuickOut(y,x,c,t){ _settextposition(y,x);_settextcolor(c);_outtext(t);}
extern void drawBar(int rowNum, const char *lab);
   
// some global substitutions for msvc 1.52C

#define getvect _dos_getvect
#define setvect _dos_setvect
#define outportb outp
#define inportb inp
   
#include <trunkvar.h>
