/*
FILL.C
Win32 program to try to zero out a selected area of memory
Works like the F command in DEBUG

Demonstrates lack of memory protection for Win32 apps in Windows 95
For example, FILL 10000 FFFF crashes Win95
Some areas are protected:  Try running FILL 0 1000

Uses structured exception handle (SEH) _try and _except statements
to catch general protection (GP) faults; on GP fault, displays message
"Protected!" and exits.

August 1995
Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html

Win32 Console apps look like DOS apps, so making FILL a Console app
isn't good for demonstrating the lack of protecting in Win32.
Revised August 31, 1995 to only use Console if compiled with -DUSE_CONSOLE

Also for demonstration purposes, it's better to let Win95 detect 
the GP fault, so don't use _try/_except in this program
*/

#include <stdlib.h>
#include <stdio.h>
#ifndef USE_CONSOLE
#include <windows.h>
#endif
#include <excpt.h>

#ifdef USE_CONSOLE
#define PUTS(s) puts(s)
#else
#define PUTS(s) { MessageBox(0, (s), "FILL", MB_OK); }
#endif

void fail(const char *s) { PUTS(s); exit(1); }

#ifdef USE_CONSOLE
main(int argc, char *argv[]) 
#else
// Microsoft C code per MSJ, May 1991, pp. 135-6
#define argc __argc
#define argv __argv
extern int __argc;
extern char **__argv;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
#endif
{
    unsigned *addr, bytes;
    if (argc < 3) fail("usage: fill [address] [bytes]");
    sscanf(argv[1], "%X", &addr);
    sscanf(argv[2], "%X", &bytes);
#if 1
    // for demonstration purposes, better to let Win95 handle GP fault
    memset(addr, 0, bytes);
#else
    _try { memset(addr, 0, bytes); }
    _except (EXCEPTION_EXECUTE_HANDLER) { fail("Protected!"); }
#endif

    PUTS("Not protected!");     // often will never see this!
    exit(0);
}

