/*
MAPFILE.C
Win32 Console app -- shows connection between memory-mapped file I/O
and DOS file handles, demand-paged virtual memory

Uses PAGEWALK.EXE

from Schulman, Unauthorized Windows 95, 1994

Revised February 1996 to use GetK32ProcAddress
*/

#include <stdlib.h>
#include <stdio.h>
#include "windows.h"
#include "k32exp.h"

void fail(const char *s) { puts(s); exit(1); }

unsigned short (WINAPI *Win32HandleToDosFileHandle)(HANDLE h);

main(int argc, char *argv[])
{
    MEMORY_BASIC_INFORMATION info, info2;
    DWORD size;
    unsigned char *p, *p2;
    HANDLE f, f2;
    int i;
    int c;
    
    if ((f = CreateFile(argv[1], GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ, NULL, OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE)
        fail("CreateFile failed");
    printf("CreateFile \"%s\" -> %u\n", argv[1], f);
    size = GetFileSize(f, NULL);
    
#if 1
    // see k32exp.h
    Win32HandleToDosFileHandle = 
        GetK32ProcAddress(WIN32HANDLETODOSFILEHANDLE_ORD);
#else
    #define GET_PROC(mod, func) GetProcAddress(GetModuleHandle(mod), (func))
    Win32HandleToDosFileHandle = GET_PROC("KERNEL32",
        "Win32HandleToDosFileHandle");
#endif  
    if (Win32HandleToDosFileHandle)
    {
        unsigned short h = Win32HandleToDosFileHandle(f);
        printf("Win32HandleToDosFileHandle(%u) ==> %u (%04Xh)\n", f, h, h);
    }
    else
        printf("Couldn't get Win32HandleToDosFileHandle\n");
    
    if ((f2 = CreateFileMapping(f, NULL, PAGE_READWRITE,
        0, size, NULL)) == NULL)
        fail("CreateFileMapping failed");
    printf("CreateFileMapping ==> %d (%04Xh)\n", f2, f2);
    
    if ((p = MapViewOfFile(f2, FILE_MAP_READ | FILE_MAP_WRITE, 0, 0, 0)) == NULL)
        fail("MapViewOfFile failed");
    printf("MapViewOfFile ==> %08Xh\n", p);

    printf("%d (%0Xh) bytes\n", size, size);
    
    for (;;)
    {
        char buf[80];
        int offset;
        printf("? ");
        gets(buf);
        switch (*buf) 
        {
            case 'q': case 'Q' : goto done; break;
            
            case '!' : system(&buf[1]); break;
            
            case '?' :
            {
                unsigned linmeg = ((unsigned) p) >> 20;
                char cmd[80];
                sprintf(cmd, "pagewalk -linmeg 0x%04X", linmeg);
                system(cmd);
                break;
            }
            
            default :
            {
                sscanf(buf, "%X", &offset);
                if (offset >= size)
                    printf("Max %0Xh bytes\n", size);
                else
                {
                    // _asm int 3
                    c = p[offset];
                    printf("Read offset %0Xh\n", offset, offset);
                }
                break;
            }
        }
    }
    
done:
    CloseHandle(f2);
    CloseHandle(f);
    // printf("File closed\n");
}
