/* 
RUSSROUL.C -- Win32 "Russian Roulette" app
How many times can you blast a random spot in memory before crashing Win95?

See fuller explanation below, in code.

Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html
September 1995

Compile with Microsoft C (32-bit): cl russroul.c -link /BASE:0x400000
*/

#ifdef USE_CONSOLE
#include <stdlib.h>
#include <stdio.h>
#else
#include <windows.h>
#endif
#include <time.h>
#include <excpt.h>

/**********************************************************************/

/* The rand() function in 32-bit Microsoft C, as in most (?) 32-bit
   C run-time libraries, has RAND_MAX = 0x7FFF (STDLIB.H).  This is
   too small.  We need even coverage of the entire range 0-UINT_MAX.
   This simple random-number generator (from George Marsaglia,
   "The Mathematics of Random Number Generators," Proceedings of
   Symposia in Applied Mathematics v. 46 (1992)) has a period of
   4.3 x 10^9 -- just what we need. */
unsigned seed;
unsigned my_srand(unsigned x) { seed = x; }
unsigned my_rand(void) { return (seed = (69069.0 * (seed + 1.0))); }

/**********************************************************************/

#ifdef USE_CONSOLE
main(int argc, char *argv[])
#else
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
#endif
{
    unsigned *p;
    int i, attempt;
    int gp = 0;

#ifdef USE_CONSOLE  
    #define P(s)   printf(s ## "\n")
    
P("RUSSROUL -- Win32 (Console) 'Russian Roulette' test for Win95");
P("version 2.0 -- April 1995");
P("Copyright (c) Andrew Schulman (76320.302@compuserve.com)");
P("This program may be freely redistributed.\n");
    
P("'Russian Roulette' is a Win32 Console (character mode) program.");
P("To simulate a buggy program with an uninitialized pointer,");
P("RussRoul generates random pointers. It tries to write (poke) each");
P("randomly-generated pointer, thereby simulating a buggy program");
P("that writes through an uninitialized pointer (a common bug). For");
P("each randomly-generated pointer, RussRoul will ask you to press");
P("ENTER before trying to write to the pointer. RussRoul will keep");
P("doing this until the program is halted with a GP Fault (this is");
P("what *SHOULD* happen in a genuine protected operating system with");
P("private address spaces), or until the operating system crashes or");
P("hangs. In Windows 95, it usually won't take very long (less than");
P("a dozen random writes, generally) before the system crashes or");
P("hangs. Hence this program's name, 'Russian Roulette'!\n");
#else
    char buf[256];
    int len;
#endif

    my_srand(time(NULL));      /* seed randomizer */

    for (attempt=1;;attempt++)  /* until user hits Ctrl-C or Win95 crashes */
    {
        for (i=0, gp = 1; gp; i++)
        {
            p = (unsigned *) my_rand();    /* pick a pointer, any pointer */
#ifdef USE_CONSOLE          
            printf("%08lX\r", p);
#endif      
            _try { int w; gp = 0; w = *p; *p = w; }
            _except (EXCEPTION_EXECUTE_HANDLER) { gp = 1; }
        }
        
#ifdef USE_CONSOLE      
        printf("Attempt #%u.  Tried %u pointers\n", attempt, i);
        printf("Press ENTER to try to blast %08lXh at %08lX-%08lX "
               "or Ctrl-C to stop ", 
            *p, p, p+3);
        getchar();
#else
        len = wsprintf(buf, "Attempt #%u.  Tried %u pointers\n", attempt, i);
        wsprintf(buf+len, "Okay to blast %08lXh at %08lX-%08lX?",
            *p, p, p+3);
        if (MessageBox(0, buf, "Russian Roulette", MB_YESNO) != IDYES)
            break;
#endif
        
        _try { gp = 0; *p = 0x12345678L; }
        _except (EXCEPTION_EXECUTE_HANDLER) { gp = 1; }
#ifdef USE_CONSOLE      
        if (gp) printf("GP fault! That area is properly protected!\n\n");
        else    printf("Not protected! Blasted %08lX-%08lX!\n\n", p, p+3);    
#else       
        if (gp) 
            wsprintf(buf, "GP fault! That area is properly protected!");
        else    
            wsprintf(buf, "Not protected! Blasted %08lX-%08lX!", p, p+3);    
        MessageBox(0, buf, "Russian Roulette", MB_OK);
#endif      
    }
}
