// adapted from Java in a Nutshell, example 7-2, p. 143
// see http://www.ora.com/www/catalog/books/javanut/examples/section7/GetURLInfo.java

import java.net.*;
import java.io.*;
import java.util.*;

public class GetURL 
{
    public static void printURL(URLConnection u) 
        throws IOException 
    {
        System.out.println(u.getURL().toExternalForm() + "\n");
        DataInputStream in = new DataInputStream(u.getInputStream());
        for (;;) 
        {
            String line = in.readLine();
            if (line == null) 
                break;
            System.out.println(line);
        }
    }
    
    public static void main(String[] args) 
        throws MalformedURLException, IOException 
        {
            URL url = new URL(args[0]);
            URLConnection connection = url.openConnection();
            printURL(connection);
        }
}
