/*
VXDCHAIN.H
Win32 functions to manipulate the Windows Virtual Device Driver
(VxD) chain.

Andrew Schulman
Senior editor, O'Reilly & Associates (Sebastopol CA)
andrew@ora.com

ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html

August 1995

See VXDCHAIN.C for more information
*/

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#pragma pack(1)

typedef struct {
    DWORD DDB_Next;                  // addr of next VxD in chain, or 0
    WORD DDB_SDK_Version;
    WORD DDB_Req_Device_Number;      // the VxD ID number
    BYTE DDB_Dev_Major_Version;
    BYTE DDB_Dev_Minor_Version;
    WORD DDB_Flags;
    BYTE DDB_Name[8];                // padded with spaces
    DWORD DDB_Init_Order;            // also order within list (SHELL last)
    DWORD DDB_Control_Proc;
    DWORD DDB_V86_API_Proc;
    DWORD DDB_PM_API_Proc;
    void (*DDB_V86_API_CSIP)();  // V86 mode seg:ofs callback addr
    void (*DDB_PM_API_CSIP)();   // prot mode sel:ofs callback addr
    DWORD DDB_Reference_Data;
    DWORD DDB_Service_Table_Ptr;
    DWORD DDB_Service_Table_Size;
    // Win95 keeps Win32 service table at offset 38h
    DWORD DDB_Win32_Service_Table_Ptr;
    } DDB;                           // from ddk include/vmm.inc
        
#define WIN32_SERVICE   0x4000       // set by Register_Win32_Services
        
#pragma pack()      

typedef void (*FUNCPTR)(void);
    
int WINAPI Get_First_VxD(DWORD *proot);
int WINAPI Get_Next_VxD(DDB *pddb, DWORD *pnext);
int WINAPI Find_VxD(char *name, DWORD *pvxd);
int WINAPI Find_VxD_ID(WORD id, DWORD *pvxd);
FUNCPTR WINAPI Get_VxD_Proc_Address(DWORD func_num);

#define SUCCESS                 0
#define ERROR_CANT_FIND_VMM     1
#define ERROR_CANT_MAP_LINEAR   2       // can't happen in Win32
#define ERROR_CANT_FIND_VXD     3
#define ERROR_END_OF_CHAIN      4
#define ERROR_NAME_UNKNOWN      5
#define ERROR_BUFFER_TOO_SHORT  6

