/*
W16LOCK.C
Win32 app, demonstrates the Win16Lock in Windows 95

Andrew Schulman
andrew@ora.com
http://www.ora.com/windows/
ftp://ftp.ora.com/pub/examples/windows/win95.update/schulman.html
August 1995

This version is corrected from the version that appears in my book
*Unauthorized Windows 95* (IDG Books, 1994), page 553:

After the book was written, KERNEL32.DLL stopped exporting the
undocumented GetpWin16Lock(), _EnterSysLevel(), and _LeaveSysLevel()
Win32 functions by name.  These functions *are* still present, and
are exported -- but by number, not name.  (GetpWin16Lock is
KERNEL32.93, _EnterSysLevel is KERNEL32.97, and _LeaveSysLevel is
KERNEL32.98.)  However, KERNEL32 does not allow imports by ordinal.
To access these functions, CHGDIR.C now uses the GetK32ProcAddress()
function from K32EXP.C.

cl w16lock.c k32exp.c

For more information on this program, see *Unauthorized Windows
95*, pp. 553-557.

Note:
The Win16Lock is definitely *not* a mutex, even though Microsoft now calls
it the "Win16Mutex." As can be seen from this program, it's a single DWORD,
located down in conventional memory (below 1MB) no less.
*/

#include <stdlib.h>
#define  WIN32_LEAN_AND_MEAN
#include "windows.h"
#include "k32exp.h"

#define MSG(s)           MessageBox(0, s, "W16LOCK", MB_OK)

void fail(const char *s) { MSG(s); exit(1); }

void (WINAPI *GetpWin16Lock)(DWORD *pWin16Lock);
int (WINAPI *_ConfirmWin16Lock)(void);  // returns current lock count
void (WINAPI *_EnterSysLevel)(DWORD lock);
void (WINAPI *_LeaveSysLevel)(DWORD lock);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    // Microsoft C code per MSJ, May 1991, pp. 135-6
    #define argc __argc
    #define argv __argv
    extern int __argc;
    extern char **__argv;
    
    DWORD Win16Lock = 0;
    int iter = (argc < 2) ? 1000000 : atoi(argv[1]);
    int i;

#if 1
    // new code: uses GetK32ProcAddress in K32EXP.C
    #define GETPWIN16LOCK_ORD       93
    #define ENTERSYSLEVEL_ORD       97
    #define LEAVESYSLEVEL_ORD       98
        
    char buf[256];
    int len;
        
    GetpWin16Lock = (void *) GetK32ProcAddress(GETPWIN16LOCK_ORD);
    _EnterSysLevel = (void *) GetK32ProcAddress(ENTERSYSLEVEL_ORD);
    _LeaveSysLevel = (void *) GetK32ProcAddress(LEAVESYSLEVEL_ORD);
    
    len = sprintf(buf, "GetpWin16Lock at %08lXh\n", GetpWin16Lock);
    len += sprintf(buf+len, "_EnterSysLevel at %08lXh\n", _EnterSysLevel);
    len += sprintf(buf+len, "_LeaveSysLevel at %08lXh\n", _LeaveSysLevel);
    MSG(buf);
#else
    // old code: uses GetProcAddress, which no longer works for these
    // undocumented KERNEL32 functions in Win95
    #define GET(mod, func) { \
        if (! (func = GetProcAddress(GetModuleHandle(mod), #func))) \
            fail("Can't link to " mod "!" #func); \
        }
        
    GET("KERNEL32", GetpWin16Lock);
    GET("KERNEL32", _EnterSysLevel);
    GET("KERNEL32", _LeaveSysLevel);
    GET("KERNEL32", _ConfirmWin16Lock);
#endif  

    GetpWin16Lock(&Win16Lock);
    if (Win16Lock == 0)
        fail("GetpWin16Lock didn't work");
    len = sprintf(buf, "Win16Lock at %08lXh\n", Win16Lock);
	sprintf(buf+len, "About to grab the lock for %u API calls\n", iter);
    MSG(buf);
    
    _EnterSysLevel(Win16Lock);
    for (i=0; i<iter; i++)
        (void) GetVersion();    // or any call that doesn't use Win16
    _LeaveSysLevel(Win16Lock);
    return 0;
}
