/*
W32HAND.C
Win32 Console app -- demonstrates Win32/DOS file handle conversion in Win95

from Schulman, Unauthorized Windows 95, 1994

Revised February 1996 to use GetK32ProcAddress

Run w32hand > w32hand.log < w32hand.c
*/

#include <stdlib.h>
#include <stdio.h>
#define  WIN32_LEAN_AND_MEAN
#include "windows.h"
#include "k32exp.h"

void fail(const char *s) { puts(s); exit(1); }

unsigned short (WINAPI *Win32HandleToDosFileHandle)(HANDLE h);
HANDLE (WINAPI *DosFileHandleToWin32Handle)(unsigned short h);

#define GET_PROC(mod, func) GetProcAddress(GetModuleHandle(mod), (func))

main(int argc, char *argv[])
{
    unsigned short fu;
    int fh;
    
#if 1
    // see k32exp.h
    Win32HandleToDosFileHandle = 
        GetK32ProcAddress(WIN32HANDLETODOSFILEHANDLE_ORD);
#else
    Win32HandleToDosFileHandle = GET_PROC("KERNEL32",
        "Win32HandleToDosFileHandle");
#endif  
    if (! Win32HandleToDosFileHandle)
        fail("Cannot link to Win32HandleToDosFileHandle");
    printf("Win32\t\tDOS\n"
           "-----\t\t---\n");
    for (fh=0; fh<0x100; fh++)
        if (fu = Win32HandleToDosFileHandle(fh))
            printf("%0u (%0Xh)\t%0u (%08Xh)\n", fh, fh, fu, fu);
        
    return 0;
}
