#include "reduce.h"


main(int argc, char **argv)
{
   char giffile[2000];

   test_args(argc,argv,giffile);
   process(giffile);
   printf("done.\n");

   return 0;
}

void test_args(int argc, char **argv, char *giffile)
{
   if (argc!=2)
      usage_exit();

   strcpy(giffile,argv[1]);
   while (*argv[1]!='.' && *argv[1]!='\0') *argv[1]++;
   if (*argv[1]=='\0')
	strcat(giffile,".gif");
}

void usage_exit(void)
{
   printf("Reduce v1.0\n");
   printf("	reduces 256-color GIF to 126-color GIF\n");
   printf("		for use with hide-and-seek steganography\n");
   printf("\nUSAGE:  reduce <giffile[.gif]>\n");
   printf("	.gif extension is assumed and optional.\n");
   printf("WARNING: produces a file called NEWGIF.GIF and will overwrite\n");
   printf("	any file of that name that already exists.\n");
   exit(0);
}

void process(char *giffile)
{
   int x=0,y=0,point=0;
   int a=0,b=0;
   int oldmode=0;
   struct pal oldpal[257],newpal[257];
   struct map maps[257];
   char dacs[(256*3)+1];

   oldmode=fg_getmode();
   fg_setmode(23);

   x=fg_showgif(giffile,0);
   if (x!=0)
   {
      fg_setmode(oldmode);
      if (x==1)
	printf("Error! file %s not found!\n",giffile);
      else if (x==2)
	printf("Error! file %s not a GIF file\n",giffile);
      exit(0);
   }

   //get palette
   get_pal(oldpal);
   //sort palette data and make new palette
   sort_pal(oldpal,newpal);
   //map old pal to new pal
   map_pal(newpal,oldpal,maps);
   //map GIF to new palette
   for (x=0;x<320;x++)
      for (y=0;y<480;y++)
      {
	 point=fg_getpixel(x,y);
	 a=x; b=y;
	 while (maps[point].dither)
	 {
	   b++;
	   if (b>479)
	   {
	      b=0;
	      a++;
	   }
	   if (a>319) a=0;
	   point=fg_getpixel(a,b);
	 }
	 fg_setcolor(maps[point].to);
	 fg_point(x,y);
      }
   //switch palettes
   y=0;
   for (x=0;x<256;x++)
   {
      dacs[y++]=newpal[x].r;
      dacs[y++]=newpal[x].g;
      dacs[y++]=newpal[x].b;
   }
   fg_setdacs(0,256,dacs);
   //save GIF
   fg_makegif(0,319,0,479,"NEWGIF.GIF");

   //done
   fg_setmode(oldmode);

}

void get_pal(struct pal *oldpal)
{
   char x[(256*3)+1];
   int a=0,b=0;

   fg_getdacs(0,256,x);
   for (a=0;a<256;a++)
   {
      oldpal[a].num=a;
      oldpal[a].r=x[b++];
      oldpal[a].g=x[b++];
      oldpal[a].b=x[b++];
   }
}

void sort_pal(struct pal *oldpal,struct pal *newpal)
{
   struct Count count[257];
   int x=0,y=0;

   for (y=0;y<256;y++)
   {
      count[y].num=y;
      count[y].count=0;
   }

   for (x=0;x<320;x++)
      for (y=0;y<480;y++)
	 count[fg_getpixel(x,y)].count++;

   quicksort(count,0,255);

   y=0;
   for (x=0;x<256;x+=2)
   {
       newpal[x].num=newpal[x+1].num=count[y++].num;
       newpal[x].r=oldpal[newpal[x].num].r;
       newpal[x+1].r=newpal[x].r;
       newpal[x].g=oldpal[newpal[x].num].g;
       newpal[x+1].g=newpal[x].g;
       newpal[x].b=oldpal[newpal[x].num].b;
       newpal[x+1].b=newpal[x].b;
   }
}

void quicksort(struct Count *count,int l, int r)
{
   unsigned long v;
   struct Count t;
   int i,j;

   if (r>l)
   {
      v=count[r].count;
      i=l-1;
      j=r;
      for(;;)
      {
	 while (count[++i].count>v);
	 while (count[--j].count<v);
	 if (i>=j) break;
	 t=count[i];count[i]=count[j];count[j]=t;
      }
      t=count[i];count[i]=count[r];count[r]=t;
      quicksort(count,l,i-1);
      quicksort(count,i+1,r);
   }
}


void map_pal(struct pal *newpal,struct pal *oldpal,struct map *maps)
{
   int x=0,y=0,best=0,c=0;
   unsigned long t=0,low=0;

   for (x=0;x<128;x++)
   {
      maps[newpal[x].num].to=x;
      maps[newpal[x].num].dither=0;
   }
   for (x=128;x<256;x++)
   {
      // what we need to do here is find nearest colors
      // for the 2nd 128 amongst the first 128 and map them.
     c=newpal[x].num;
     low=4294963719l;
     for (y=0;y<128;y++)
     {
	t=(3L*(long)(oldpal[c].r-newpal[y].r)*(long)(oldpal[c].r-newpal[y].r)
	  +4L*(long)(oldpal[c].g-newpal[y].g)*(long)(oldpal[c].g-newpal[y].g)
	  +2L*(long)(oldpal[c].b-newpal[y].b)*(long)(oldpal[c].b-newpal[y].b));
	if (t<low)
	{
	   low=t;
	   best=y;
	}
     }
     maps[c].to=best;
     maps[c].dither=1;
   }
}








