// FiltDlg.cpp : implementation file
//
// This module implements the Filter Options dialog.
//
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include "stdafx.h"
#include "OpenTrap.h"
#include "FiltDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/////////////////////////////////////////////////////////////////////////////
// CFilterDlg dialog


CFilterDlg::CFilterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFilterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilterDlg)
	m_intShow = -1;
	m_strBaseName = _T("");
	m_strExt = _T("");
	m_strModuleName = _T("");
	m_bBaseName = FALSE;
	m_bErrorsOnly = FALSE;
	m_bExt = FALSE;
	m_bModuleName = FALSE;
	m_bSaveSettings = FALSE;
	//}}AFX_DATA_INIT
}


void CFilterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
//	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilterDlg)
	DDX_Control(pDX, IDC_chkModuleName, m_chkModuleName);
	DDX_Control(pDX, IDC_chkExt, m_chkExt);
	DDX_Control(pDX, IDC_chkBaseName, m_chkBaseName);
	DDX_Control(pDX, IDC_txtBaseName, m_txtBaseName);
	DDX_Control(pDX, IDC_txtModuleName, m_txtModuleName);
	DDX_Control(pDX, IDC_txtExt, m_txtExt);
	DDX_Radio(pDX, IDC_optShow1, m_intShow);
	DDX_Text(pDX, IDC_txtBaseName, m_strBaseName);
	DDX_Text(pDX, IDC_txtExt, m_strExt);
	DDX_Text(pDX, IDC_txtModuleName, m_strModuleName);
	DDV_MaxChars(pDX, m_strModuleName, 8);
	DDX_Check(pDX, IDC_chkBaseName, m_bBaseName);
	DDX_Check(pDX, IDC_chkErrorsOnly, m_bErrorsOnly);
	DDX_Check(pDX, IDC_chkExt, m_bExt);
	DDX_Check(pDX, IDC_chkModuleName, m_bModuleName);
	DDX_Check(pDX, IDC_chkSaveSettings, m_bSaveSettings);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFilterDlg, CDialog)
	//{{AFX_MSG_MAP(CFilterDlg)
	ON_BN_CLICKED(IDC_chkBaseName, OnchkBaseName)
	ON_BN_CLICKED(IDC_chkExt, OnchkExt)
	ON_BN_CLICKED(IDC_chkModuleName, OnchkModuleName)
	ON_BN_CLICKED(IDC_cmdReset, OncmdReset)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_CONTEXT_HELP, OnContextHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterDlg message handlers

void CFilterDlg::OnchkBaseName() 
{
	if (m_chkBaseName.GetCheck())
	{
		m_txtBaseName.EnableWindow(TRUE);
		m_txtBaseName.SetFocus();
	}
	else
	{
		m_txtBaseName.EnableWindow(FALSE);
	}
}

void CFilterDlg::OnchkExt() 
{
	if (m_chkExt.GetCheck())
	{
		m_txtExt.EnableWindow(TRUE);
		m_txtExt.SetFocus();
	}
	else
	{
		m_txtExt.EnableWindow(FALSE);
	}
}

void CFilterDlg::OnchkModuleName() 
{
	if (m_chkModuleName.GetCheck())
	{
		m_txtModuleName.EnableWindow(TRUE);
		m_txtModuleName.SetFocus();
	}
	else
	{
		m_txtModuleName.EnableWindow(FALSE);
	}
}

void CFilterDlg::OncmdReset() 
{
	m_intShow = 0;
	m_bExt = m_bBaseName = m_bModuleName = m_bErrorsOnly = FALSE;
	m_strExt.Empty();
	m_strBaseName.Empty();
	m_strModuleName.Empty();
	m_txtExt.EnableWindow(FALSE);
	m_txtBaseName.EnableWindow(FALSE);
	m_txtModuleName.EnableWindow(FALSE);
	UpdateData(FALSE);
}

BOOL CFilterDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Make sure edit controls are enabled according to their
	// corresponding check box settings.
	m_txtBaseName.EnableWindow(m_bBaseName);
	m_txtExt.EnableWindow(m_bExt);
	m_txtModuleName.EnableWindow(m_bModuleName);
	return TRUE;
}

// Handle data validation when user clicks OK.
// If any fields are invalid, program presents an appropriate error message,
// puts input focus on the invalid field, and leaves the dialog open.
void CFilterDlg::OnOK() 
{
	int pos;
	UpdateData(TRUE);
	// Make sure base name is not blank, and if it contains a "*"
	// wildcard, it must be at the end of the string.
	if (m_bBaseName)
	{
		if (m_strBaseName.IsEmpty())
		{
			AfxMessageBox(IDP_NO_BLANK_FILTERS);
			return;
		}
		pos = m_strBaseName.Find('*');
		if (pos >= 0 && pos != m_strBaseName.GetLength() - 1)
		{
			AfxMessageBox(IDP_BAD_FILENAME);
			m_txtBaseName.SetFocus();
			return;
		}
	}
	// For extensions, again just make sure that the "*" wildcard appears
	// only at the end of the string.
	if (m_bExt)
	{
		pos = m_strExt.Find('*');
		if (pos >= 0 && pos != m_strExt.GetLength() - 1)
		{
			AfxMessageBox(IDP_BAD_FILENAME);
			m_txtExt.SetFocus();
			return;
		}
	}
	// In contrast, Module Name strings cannot include wildcards.
	if (m_bModuleName)
	{
		if (m_strModuleName.Find('?') >= 0 || m_strModuleName.Find('*') >= 0)
		{
			AfxMessageBox(IDP_BAD_MODULE_NAME);
			m_txtModuleName.SetFocus();
			return;
		}
	}
	CDialog::OnOK();
}

// Handler for right-mouse help.
void CFilterDlg::OnContextMenu(CWnd* pWnd, CPoint point)
{
	CPoint ptClient = point;
	CWnd* wndTarget;
	UINT id = 0;
	ScreenToClient(&ptClient);
	wndTarget = ChildWindowFromPoint(ptClient, CWP_SKIPTRANSPARENT);
	if (wndTarget == this)
		wndTarget = ChildWindowFromPoint(ptClient);
	if (wndTarget)
		id = wndTarget->GetDlgCtrlID();
	if (id == 0 || id == IDOK || id == IDCANCEL)
		return;
	else
		m_intHelpContext = id + 0x40000;
	CMenu my_menu;
	my_menu.CreatePopupMenu();
	my_menu.AppendMenu(MF_ENABLED, ID_CONTEXT_HELP, "What's this?");
	my_menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, point.x, point.y, this);
}

void CFilterDlg::OnContextHelp()
{
	WinHelp(m_intHelpContext, HELP_CONTEXTPOPUP);
}
