// opentrap.cpp - This program interacts with opentrap.vxd, allowing access
//               to any I/O port.
//
//
// Rick Knoblaugh 11/01/96
//
//
//#define STRICT
//#define _MT
#pragma pack(1)
#include <stdio.h>
#include <sys\timeb.h>
#include <time.h>
#include <windows.h>
#include <windowsx.h>
#include <process.h>




#define VXD_NAME		"\\\\.\\opentrap.VXD"

#define VXD_GET_VER 1
#define VXD_REGISTER_CB 2       //register a callback and logging conditions
#define VXD_REC_DONE    3       //release the buffer VxD reported to us
#define VXD_UPDATE 4            //update logging conditions
#define VXD_GET_VER 1

#define DISABLE_LOGGING 1
#define APP_EXITING 16




#define IFSFN_OPEN 36           //function codes for file system operations
#define IFSFN_READ 0
#define IFSFN_CLOSE  11         
#define IFSFN_DELETE 31
#define LOG_ALL 0x0ffffffff
#define LOG_ALL_DOS 0x0fffffffe
#define LOG_ONLY_ERRORS 0xfffe
#define REP_BUF_SIZE (60 * 1024)
#define MAX_PATH 260


LRESULT CALLBACK regvproc(HWND, UINT, WPARAM, LPARAM);
void __stdcall our_callback(DWORD);
void InitUnobsfucator(void);
void format_log_record (struct trap_record *);
void    release_rec(DWORD);
DWORD  __stdcall do_getcalls();


CRITICAL_SECTION   crit_sec; 
DWORD      thread_id;
HANDLE     stop_flag;
HANDLE     thread_handle;
HANDLE	    vxd_handle		= INVALID_HANDLE_VALUE;
HINSTANCE   hinstance;    //Handle of current instance
HWND        handle;


struct      _timeb timebuffer;
char *      timeline;


struct	        trap_criteria   {
DWORD          tc_func_num;	//function app wants trapped (-1 = all)
DWORD          tc_drive;       //drive (-1 = all drives)
DWORD          tc_proc_handle; //process (-1 if all processes)
DWORD          tc_vm_num;      //VMs (-1 if all) (0x0fffffffe if only DOS)
WORD           tc_status;      //error code (-1 if all status)
DWORD          tc_callback;    //address to call back
WORD           tc_misc;        //misc flags for OpenTrap
                                };

struct  trap_record     {
DWORD           tr_function;   
DWORD           tr_drive;      
unsigned char   tr_ir_flags;   
WORD            tr_ir_options; 
DWORD           tr_res_type;   
DWORD           tr_handle;
char            tr_file1[MAX_PATH];
char            tr_file2[MAX_PATH];
char            tr_program[9];
DWORD           tr_vm;         
DWORD           tr_proc_handle;
WORD            tr_error;      
DWORD           tr_drv_context;
WORD            tr_drv_status;
WORD            tr_drv_miscflag;
                           };

struct          upcall  {
DWORD           trap_rec_num;
DWORD           trap_dat_ptr;
WORD            trap_dat_len;
                        };



struct  trap_criteria   trap_cond={IFSFN_OPEN ,(DWORD) LOG_ALL,(DWORD) LOG_ALL,(DWORD) LOG_ALL ,(WORD) LOG_ALL,NULL,(WORD) 0};
//struct  trap_criteria   trap_cond2={IFSFN_READ ,(DWORD) LOG_ALL,(DWORD) LOG_ALL,(DWORD) LOG_ALL_DOS ,(WORD) LOG_ALL,NULL,(WORD) 0};
struct  trap_criteria   trap_cond2={IFSFN_CLOSE ,(DWORD) LOG_ALL,(DWORD) LOG_ALL,(DWORD) LOG_ALL ,(WORD) LOG_ALL,NULL,(WORD) 0};

struct  upcall  trap_update;

unsigned char general_io_buf[512];      //holds data to/from Vxd
char        data_buffer[128];           //holds data from edit controls
DWORD Unobsfucator = 0;
DWORD   condition_handle;               //how vxd references our callback
DWORD   condition_handle2;              //how vxd references our callback
char * rep_buf_ptr;
char * start_rep_buf;





int WINAPI WinMain(HINSTANCE winhandle, HINSTANCE prevwinhandle,
                        LPSTR cmdparam, int cmdshow)
{
   	static char appname[]="opentrap";
   	hinstance=winhandle;

   	MSG     message;
   	WNDCLASSEX windowclass;

   	windowclass.style =     CS_HREDRAW | CS_VREDRAW;
        windowclass.lpfnWndProc = regvproc;
   	windowclass.cbClsExtra = 0;
   	windowclass.cbWndExtra = 0;
   	windowclass.cbSize =    sizeof(WNDCLASSEX);
   	windowclass.hInstance = winhandle;   
   	windowclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   	windowclass.hIconSm= LoadIcon(NULL, IDI_APPLICATION);
   	windowclass.hCursor = LoadCursor(NULL, IDC_ARROW);
   	windowclass.hbrBackground=(HBRUSH) GetStockObject(WHITE_BRUSH);
   	windowclass.lpszMenuName=NULL;
   	windowclass.lpszClassName=appname;
   

   	RegisterClassEx(&windowclass);

   	handle = CreateWindow (appname, "Load OpenTrap",
                   WS_OVERLAPPEDWINDOW,
                   CW_USEDEFAULT,
                   CW_USEDEFAULT,
                   CW_USEDEFAULT,
                   CW_USEDEFAULT,
                   NULL, NULL, winhandle, NULL);

   	ShowWindow(handle, cmdshow);
   	UpdateWindow(handle);

   	while(GetMessage(&message, NULL, 0,0))
   	{
        TranslateMessage(&message);     //get key events
        DispatchMessage(&message);
    }        
   		return message.wParam;        

}



LRESULT CALLBACK regvproc(HWND hwnd, UINT message, 
                                WPARAM wParam, LPARAM lParam)
{
    HDC         hdc;
	PAINTSTRUCT	pntstruct;
    SIZE        extent;
			
	static HMENU hmenu;
	static TEXTMETRIC tm;
    static int  client_x_size;
    static int  client_y_size;
    static int  xpos;
    static int  ypos;
	static int  yinc;
    static int  linespacing;
    unsigned int max_lines;
    unsigned int i;

    switch(message)
    {


    case WM_CREATE:


        rep_buf_ptr=(char *) malloc (REP_BUF_SIZE);

		if ( rep_buf_ptr == NULL )
        {

            MessageBox(hwnd, "Can't malloc", "!!!!!!!!!!!!!!!",
                  MB_ICONINFORMATION);
            return -1;
		}


		*rep_buf_ptr='R';
		*(rep_buf_ptr + 1)='I';


		
        start_rep_buf=rep_buf_ptr;

        InitUnobsfucator();

    	// open the handle to the VXD
		vxd_handle = CreateFile( VXD_NAME, 0, 0, NULL,
									0, FILE_FLAG_DELETE_ON_CLOSE, NULL );

		if ( vxd_handle == INVALID_HANDLE_VALUE )
        {

            MessageBox(hwnd, "Can't access opentrap.vxd", "Vxd NOT Present",
                  MB_ICONINFORMATION);
            return -1;
		}

		DeviceIoControl(	vxd_handle, VXD_GET_VER,
									start_rep_buf, 4, NULL, 0, NULL, NULL );

		trap_cond.tc_callback=(DWORD) &our_callback;
		trap_cond2.tc_callback=(DWORD) &our_callback;
		
	    InitializeCriticalSection(&crit_sec);
		
	    stop_flag = CreateEvent(NULL, FALSE, FALSE, NULL); 

	    ResetEvent(stop_flag);	


        thread_handle=(HANDLE) _beginthreadex(NULL, 4096,(unsigned int (__stdcall *) (void *)) do_getcalls,
					NULL, 0,(unsigned int *) &thread_id);


       MessageBox(hwnd, "Loaded opentrap.vxd", "Everythings Cool",
                    MB_ICONINFORMATION);

       
        return 0;


	case WM_DESTROY:
		
       HANDLE file_handle;
       DWORD havewritten;

        trap_update.trap_rec_num=condition_handle;
        trap_update.trap_dat_ptr=(DWORD) &trap_cond;
        trap_update.trap_dat_len=sizeof(struct trap_criteria);

        trap_cond.tc_misc=(APP_EXITING | DISABLE_LOGGING);

        DeviceIoControl(vxd_handle,VXD_UPDATE, &trap_update,
                   (sizeof(struct upcall)),NULL,
                   0, NULL, NULL );

        trap_update.trap_rec_num=condition_handle2;
        trap_update.trap_dat_ptr=(DWORD) &trap_cond2;
        trap_update.trap_dat_len=sizeof(struct trap_criteria);

        trap_cond2.tc_misc=(APP_EXITING | DISABLE_LOGGING);

          DeviceIoControl(vxd_handle,VXD_UPDATE, &trap_update,
                   (sizeof(struct upcall)),NULL,
                   0, NULL, NULL );     

       CloseHandle(vxd_handle);


       SetEvent(stop_flag);            //tell logging thread to stop

       CloseHandle(thread_handle);
       
       file_handle=CreateFile("logdat.txt", GENERIC_WRITE,
                       0, NULL, CREATE_ALWAYS, 0,0);

       WriteFile(file_handle, start_rep_buf, (rep_buf_ptr - start_rep_buf),
                       &havewritten, NULL);

       CloseHandle(file_handle);

	    DeleteCriticalSection(&crit_sec);

      
       free(start_rep_buf);

       PostQuitMessage(0);
       return 0L;


    default:

        return DefWindowProc(hwnd, message, wParam, lParam);

    } //end switch of messages passed to callback

}


DWORD  __stdcall do_getcalls()
{

       //Set up the callback with the VxD (note: VxD will get the
       //id for this thread and use it and the callback address to
       //inform us about file opens)
DeviceIoControl(        vxd_handle, VXD_REGISTER_CB, &trap_cond,
                   (sizeof(struct trap_criteria)),&condition_handle,
                   sizeof(condition_handle), NULL, NULL );


  DeviceIoControl(        vxd_handle, VXD_REGISTER_CB, &trap_cond2,
                   (sizeof(struct trap_criteria)),&condition_handle2,
                   sizeof(condition_handle2), NULL, NULL ); 




       while( WaitForSingleObjectEx(stop_flag, INFINITE, TRUE) == WAIT_IO_COMPLETION);

       return 0;
}


void __stdcall our_callback(DWORD trap_rec_ptr)
{

	format_log_record( (struct trap_record *) trap_rec_ptr);
   release_rec(trap_rec_ptr);


}

void format_log_record (struct trap_record * tr_ptr)
{
char * work_ptr;


if ( (rep_buf_ptr + 240) > (start_rep_buf + REP_BUF_SIZE)) return;


	EnterCriticalSection(&crit_sec);

   _ftime(&timebuffer);
   timeline=ctime( & (timebuffer.time));

   rep_buf_ptr+=(sprintf(rep_buf_ptr, "File: %s \n", tr_ptr->tr_file1));
   rep_buf_ptr+=(sprintf(rep_buf_ptr, "ir_flags: %02x  io_options: %04x  ", (unsigned) tr_ptr->tr_ir_flags, 
                    tr_ptr->tr_ir_options));

   rep_buf_ptr+=(sprintf(rep_buf_ptr, "reenter: %08x  VM: %04x  func: %04x\n", (unsigned) tr_ptr->tr_res_type, 
                    tr_ptr->tr_vm, tr_ptr->tr_function));
   
   rep_buf_ptr+=(sprintf(rep_buf_ptr, "drive: %04x  status: %04x  File accessed by: %s \n ", tr_ptr->tr_drive, 
                    tr_ptr->tr_error, tr_ptr->tr_program));

    if (tr_ptr->tr_function == IFSFN_OPEN ) work_ptr="OPEN";
    else
    if (tr_ptr->tr_function == IFSFN_CLOSE ) work_ptr="CLOSE";

   rep_buf_ptr+=(sprintf(rep_buf_ptr, "function: %s  Handle: %04x  Time: %.8s.%hu  \n \n", 
                    work_ptr, tr_ptr->tr_handle, &timeline[11], timebuffer.millitm));

	LeaveCriticalSection(&crit_sec);

}


void    release_rec(DWORD rec_address)
{


		DeviceIoControl(	vxd_handle, VXD_REC_DONE,
                                                        (void *) &rec_address, 4, NULL, 0, NULL, NULL );

}


void InitUnobsfucator(void)
{
    DWORD   tid;
    
    tid = GetCurrentThreadId();
    
    __asm {
			push	es
            mov     ax, fs
            mov     es, ax
            mov     eax, 18h
            mov     eax, es:[eax]
            sub     eax, 10h
            xor     eax,[tid]
            mov     [Unobsfucator], eax
			pop		es
    }
}
