// OptDlg.cpp : implementation file
//
// This module implements the Logging Options dialog box.
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include "stdafx.h"
#include "OpenTrap.h"
#include "OptDlg.h"
#include "OTextern.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptDlg dialog


COptDlg::COptDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptDlg)
	m_intLogSize = 1;
	m_bSaveSettings = FALSE;
	m_intVM = -1;
	m_intAction = -1;
	m_bErrorsOnly = FALSE;
	m_bHide = FALSE;
	//}}AFX_DATA_INIT
}


void COptDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	if (g_intRecCount)
	{
		min_buf_size_K = (g_pNextRec - g_pBufferStart) / 1024 + 1;
		if (min_buf_size_K > 2048)
			min_buf_size_K = 2048;
		if (min_buf_size_K < 64)
			min_buf_size_K = 64;
	}
	else
		min_buf_size_K = 64;
	//{{AFX_DATA_MAP(COptDlg)
	DDX_Control(pDX, IDC_lblBuf2, m_lblBuf2);
        DDX_Text(pDX, IDC_txtLogSize, m_intLogSize);
	DDV_MinMaxUInt(pDX, m_intLogSize, min_buf_size_K, 2048);
        DDX_Check(pDX, IDC_chkSaveSettings, m_bSaveSettings);
	DDX_Radio(pDX, IDC_optVM1, m_intVM);
	DDX_Radio(pDX, IDC_optAction1, m_intAction);
	DDX_Check(pDX, IDC_chkLogErrorsOnly, m_bErrorsOnly);
	DDX_Check(pDX, IDC_chkHide, m_bHide);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptDlg, CDialog)
	//{{AFX_MSG_MAP(COptDlg)
	ON_WM_CONTEXTMENU()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_CONTEXT_HELP, OnContextHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptDlg message handlers

BOOL COptDlg::OnInitDialog() 
{
	int buf_free_K;
	CString txt;

	CDialog::OnInitDialog();

	if (g_bLogFull)
		txt = "Buffer is full";
	else
	{
		buf_free_K = g_intLogSizeK - ((g_pNextRec - g_pBufferStart) / 1024);
		txt.Format("(%uKB free)", buf_free_K);
	}
	m_lblBuf2.SetWindowText(txt);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptDlg::OnOK() 
{
	// TODO: Add extra validation here
	if (!UpdateData(TRUE))
	{
		m_intLogSize = g_intLogSizeK;
		UpdateData(FALSE);
		return;
	}
	CDialog::OnOK();
}

void COptDlg::OnContextMenu(CWnd* pWnd, CPoint point)
{
	CPoint ptClient = point;
	CWnd* wndTarget;
	UINT id = 0;
	ScreenToClient(&ptClient);
	wndTarget = ChildWindowFromPoint(ptClient, CWP_SKIPTRANSPARENT);
	if (wndTarget == this)
		wndTarget = ChildWindowFromPoint(ptClient);
	if (wndTarget)
		id = wndTarget->GetDlgCtrlID();
	if (id == 0 || id == IDOK || id == IDCANCEL)
		return;
	else
		m_intHelpContext = id + 0x40000;
	CMenu my_menu;
	my_menu.CreatePopupMenu();
	my_menu.AppendMenu(MF_ENABLED, ID_CONTEXT_HELP, "What's this?");
	my_menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, point.x, point.y, this);
}

void COptDlg::OnContextHelp()
{
	WinHelp(m_intHelpContext, HELP_CONTEXTPOPUP);
}

