// OTDoc.h : interface of the COpenTrapDoc class
//
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.
/////////////////////////////////////////////////////////////////////////////

class COpenTrapDoc : public CDocument
{
protected: // create from serialization only
	COpenTrapDoc();
	DECLARE_DYNCREATE(COpenTrapDoc)

// Attributes
public:
	int m_intCurPage;
	void SetFilterFlag(void);

// Operations
public:
	BOOL Filter_Record(void* p);
	void Fix_Pointers(DWORD count);
	void Write_Text_Log(CString file_name);
	void Packed_to_ASCII(int rec_num, struct packed_record* p, char *b);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenTrapDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenTrapDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(COpenTrapDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_bIsExporting;
	BOOL Wildcard_Compare(char *buffer, BOOL which);
	BOOL Check_Buffer_Size(DWORD data_size);
};

/////////////////////////////////////////////////////////////////////////////
