// OTextern.h
// Global data and functions declared in OTglobal.h
// OpenTrap Version 1.00 by Gregory A. Wolking
// Copyright  1997 Ziff-Davis Publishing
// First published in PC Magazine, US Edition, July 1997.

#include <sys\timeb.h>
#include <time.h>
#include <process.h>

#define VXD_NAME		"\\\\.\\functrap.VXD"
#define VXD_GET_VER 1
#define VXD_REGISTER_CB 2       //register a callback and logging conditions
#define VXD_REC_DONE    3       //release the buffer VxD reported to us
#define VXD_UPDATE 4            //update logging conditions
#define VXD_GET_VER 1

#define DISABLE_LOGGING 1
#define APP_EXITING 16
#define IFSFN_OPEN 36           //function codes for file system operations
#define IFSFN_READ 0
#define IFSFN_CLOSE  11         
#define IFSFN_DELETE 31
#define LOG_ALL 0x0ffffffff
#define LOG_ALL_DOS 0x0fffffffe
#define LOG_WINDOWS_ONLY 0x1
#define LOG_ONLY_ERRORS 0xfffe
#include "OTStruct.h"

// Variables
extern struct trap_criteria   g_tcCond1;
extern struct trap_criteria   g_tcCond2;
extern struct upcall	g_ucUpdate;
extern char				data_buffer[128];		//holds data from edit controls
extern DWORD			g_dwCondition1;			//how vxd references our callback
extern DWORD			g_dwCondition2;		//how vxd references our callback
extern char *			g_pNextRec;
extern char *			g_pBufferStart;
extern char *			g_pBufSafeEnd;
extern struct packed_record *	g_pLastRecord;
extern CRITICAL_SECTION	g_csCritical; 
extern DWORD			g_dwThreadID;
extern HANDLE			g_hStopFlag;
extern HANDLE			g_hThread;
extern HANDLE			g_hVXD;
extern UINT				g_intRecCount;
extern BOOL				g_bIsLogging;
extern BOOL				g_bLogFull;
extern BOOL				g_bLogErrorsOnly;
extern UINT				g_intLogSizeK;
extern HWND				g_hWndMainFrame;

// Functions
extern void __stdcall our_callback(DWORD);
extern void append_log_record (struct trap_record *);
extern void    release_rec(DWORD);
extern DWORD  __stdcall do_getcalls();

// Options
extern BOOL g_bShowNums;
extern BOOL g_bCommaDelimited;
extern BOOL g_bWriteFiltered;
extern BOOL g_bExportRecNums;
extern BOOL g_intFilterEvents;
extern BOOL g_bFilterErrorsOnly;
extern CString g_strFilterModuleName;
extern CString g_strFilterFileExt;
extern CString g_strFilterFileName;
extern BOOL g_bFilterModule;
extern BOOL g_bFilterFileExt;
extern BOOL g_bFilterFileName;
extern BOOL g_bUseFilters;
extern BOOL g_bLogOpensOnly;
extern DWORD g_dwWatchVM;
extern BOOL g_bHide;

// Strings
extern TCHAR g_szFormat[];
extern TCHAR g_szSettingKey[];
extern TCHAR g_szViewKey[];
extern TCHAR g_szLogKey[];
extern TCHAR g_szExportKey[];
extern TCHAR g_szFontKey[];
extern TCHAR g_szFontFormat[];