// Options.cpp : implementation file
//

#include "stdafx.h"
#include "uncontraband.h"
#include "Options.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptions dialog


COptions::COptions(int *automode, unsigned long *length, int *srcstring, char *str, int *exact, CWnd* pParent)
	: CDialog(COptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptions)
	//}}AFX_DATA_INIT
	m_automode  = automode;
	m_length    = length;
	m_srcstring = srcstring;
	m_str       = str;
	m_exact     = exact;

	m_iautomode  = *m_automode;
	m_ilength    = *m_length;
	m_isrcstring = *m_srcstring;
	strcpy (m_istr, m_str);
	m_iexact	 = *m_exact;
}


void COptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptions)
	DDX_Control(pDX, IDC_SRCFOR, m_srcfor);
	DDX_Control(pDX, IDC_STRING, m_string);
	DDX_Control(pDX, IDC_PRTONLY, m_prtonly);
	DDX_Control(pDX, IDOK, m_ok);
	DDX_Control(pDX, IDC_LEN, m_len);
	DDX_Control(pDX, IDC_CASE, m_case);
	DDX_Control(pDX, IDC_AUTOMODE, m_auto);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptions, CDialog)
	//{{AFX_MSG_MAP(COptions)
	ON_BN_CLICKED(IDC_AUTOMODE, OnAutomode)
	ON_EN_CHANGE(IDC_LEN, OnChangeLen)
	ON_BN_CLICKED(IDC_PRTONLY, OnPrtonly)
	ON_EN_CHANGE(IDC_SRCFOR, OnChangeSrcfor)
	ON_BN_CLICKED(IDC_STRING, OnString)
	ON_BN_CLICKED(IDC_CASE, OnCase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptions message handlers

void COptions::EnableWindows () 
{
   m_len.EnableWindow (m_iautomode);
   m_prtonly.EnableWindow (m_iautomode);
   m_string.EnableWindow (m_iautomode);
   m_srcfor.EnableWindow (m_iautomode && m_isrcstring);
   m_case.EnableWindow (m_iautomode && m_isrcstring);
   m_ok.EnableWindow (TRUE);
   if (m_iautomode) {
	   if (m_ilength < 1) m_ok.EnableWindow (FALSE);
	   if (m_isrcstring && !*m_istr) m_ok.EnableWindow (FALSE);
   }
}  

void COptions::OnAutomode() 
{
	// TODO: Add your control notification handler code here
	
	m_iautomode = m_auto.GetCheck ();
	EnableWindows ();
}

void COptions::OnChangeLen() 
{
	// TODO: Add your control notification handler code here
	
	char buf [32];

	m_len.GetWindowText (buf, sizeof (buf));
	m_ilength = atol (buf);
	EnableWindows ();
}

void COptions::OnPrtonly() 
{
	// TODO: Add your control notification handler code here
	
	m_isrcstring = 0;
	EnableWindows ();
}

void COptions::OnChangeSrcfor() 
{
	// TODO: Add your control notification handler code here

	m_srcfor.GetWindowText (m_istr, sizeof (m_istr));
	EnableWindows ();
}

void COptions::OnString() 
{
	// TODO: Add your control notification handler code here
	
	m_isrcstring = 1;
	EnableWindows ();
}

void COptions::OnOK() 
{
	// TODO: Add extra validation here
	
	*m_automode  = m_iautomode;
	*m_length    = m_ilength;
	*m_srcstring = m_isrcstring;
	*m_exact     = m_iexact;
	strcpy (m_str, m_istr);
	CDialog::OnOK();
}

BOOL COptions::OnInitDialog() 
{
	CDialog::OnInitDialog();

	char		buf [32];

	sprintf (buf, "%d", m_ilength);

	m_auto.SetCheck (m_iautomode);
	m_len.SetWindowText (buf);
	m_prtonly.SetCheck (!m_isrcstring);
	m_string.SetCheck (m_isrcstring);
	m_srcfor.SetWindowText (m_istr);
	m_case.SetCheck (m_iexact);
	EnableWindows ();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COptions::OnCase() 
{
	// TODO: Add your control notification handler code here
	m_iexact = m_case.GetCheck ();	
}
