#include<stdio.h>
#include<string.h>
typedef struct lm_handle
{
	int job_id;
	char * mem_ptr2;	/* internal use */
	unsigned char mem_ptr2_bytes[12]; /* internal use */
	char job_data[1024];
} LM_HANDLE;
typedef struct vendorcode6 {
			    short type;	   /* Type of structure */
			    unsigned long data[2]; /* 64-bit code */
			    unsigned long keys[4]; 
			    short flexlm_version;
			    short flexlm_revision;
			    char flexlm_patch[2];
			    char behavior_ver[5];
			    unsigned long borrow[2]; /* unused */
} VENDORCODE;
/*
*
* Module: extr.c v1.0.0.0
*
* Description: Demonstration program to show interaction
*              between security code in lm_new.c and main
*              program.
*
* blendern
* 08-oct-1999
*
* Last modified: 08-oct-1999
*/

/*
* Decoding table type
*/

typedef struct decode_table_s {
        int offsets[4];
} decode_table_t;

/*
 * really vendorcode5, but renamed to avoid conflict
 * if Globetrotter headers are included.
 * The encryption seeds are stored in the data part of this structure.
 *
 * the VENDOR_CODES are stored in the keys part of this structure.
 */

typedef struct my_vendorcode5 {
                            short type;    /* Type of structure */
                            unsigned long data[2]; /* 64-bit code */
                            unsigned long keys[4]; /*- [0]: Product features 
*/
                                                   /*- [1]: platforms */
                                                   /*- [2]: platforms */
                                                   /*- [3]: Expiration date/ 
*/
                                                   /*-      Key check */
                            short flexlm_version;
                            short flexlm_revision;
                            char flexlm_patch[2];
#define LM_MAX_BEH_VER 4
                            char behavior_ver[LM_MAX_BEH_VER + 1];
                          } MY_VENDORCODE5;

/*
 * decryption table values.
 */

decode_table_t decode_table[] = {
        {3, 5, 4, 11}, /* index 0 */
        {9, 8, 3, 1}, /* index 1 */
        {8, 1, 2, 5}, /* index 2 */
        {2, 1, 10, 5}, /* index 3 */
        {3, 0, 1, 7}, /* index 4 */
        {1, 10, 3, 7}, /* index 5 */
        {7, 3, 5, 11}, /* index 6 */
        {0, 1, 9, 4}, /* index 7 */
        {0, 4, 1, 10}, /* index 8 */
        {11, 8, 1, 3}, /* index 9 */
        {8, 4, 2, 5}, /* index 10 */
        {6, 1, 0, 9}, /* index 11 */
        {4, 3, 8, 9}, /* index 12 */
        {0, 4, 2, 10}, /* index 13 */
        {3, 10, 8, 7}, /* index 14 */
        {1, 11, 0, 3}, /* index 15 */
        {6, 5, 1, 0}, /* index 16 */
        {0, 2, 4, 8}, /* index 17 */
        {5, 0, 1, 4}, /* index 18 */
        {10, 3, 5, 1} /* index 19 */
};


int derive_seeds(char *data1, char *data2, char *vendorname, char *job08, char *job0c,
	char *job10, char *encseed1, char *encseed2, char *selector, char *xorval)
{
    int i;
    int key_index;
    int tabindex1;
    int tabindex2;
    int tabindex3;
    int tabindex4;
    int decrypt_xor_value;
	unsigned long *jobvals;

    MY_VENDORCODE5 teststruct;
    char myvendorname[1024];  /* This is the vendor_id */

    /* Job structure */
    struct s_tmp
    {
            int i;
            char *cp;
            unsigned char a[12];
    } myjob;

    /* Initialize job */
    myjob.i = 66;
    myjob.cp = 0;

	jobvals = (unsigned long *) myjob.a;

  	teststruct.type = 4;
	teststruct.data[0] = 0x0;
	teststruct.data[1] = 0x0;
	teststruct.keys[0] = 0x0;
	teststruct.keys[1] = 0x0;
	teststruct.keys[2] = 0x0;
	teststruct.keys[3] = 0x0;

	strcpy(xorval,"");
	if (strlen(vendorname) < 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Vendor name too short");
		return(-1);
	}
	strcpy(myvendorname,vendorname);
	if (sscanf(data1, "%x", &(teststruct.data[0])) != 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Can't convert data1 to int");
		return(-1);
	}

	if (sscanf(data2, "%x", &(teststruct.data[1])) != 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Can't convert data2 to int");
		return(-1);
	}
	if (sscanf(job08, "%x", jobvals) != 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Can't convert job08 to int");
		return(-1);
	}
	if (sscanf(job0c, "%x", jobvals+1) != 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Can't convert job0c to int");
		return(-1);
	}
	if (sscanf(job10, "%x", jobvals+2) != 1)
	{
		strcpy(encseed1,"");
		strcpy(encseed2,"");
		strcpy(selector, "Can't convert job10 to int");
		return(-1);
	}

    key_index = (int)(myvendorname[0] & 0xff) % 20;

    tabindex1 = decode_table[key_index].offsets[0];

    tabindex2 = decode_table[key_index].offsets[1];

    tabindex3 = decode_table[key_index].offsets[2];

    tabindex4 = decode_table[key_index].offsets[3];


    /*
     * use values to reverse xor which occurs if
     * valid job given.
     */
    decrypt_xor_value = ((long)(myjob.a[tabindex1]) << 0)
            | ((long)(myjob.a[tabindex2]) << 8)
            | ((long)(myjob.a[tabindex3]) << 16)
            | ((long)(myjob.a[tabindex4]) << 24);

    sprintf (selector, "a[%d], a[%d], a[%d], a[%d]", tabindex1, tabindex2, tabindex3, tabindex4);
    sprintf (xorval, "%08x", decrypt_xor_value);
   sprintf (encseed1, "%08x", teststruct.data[0] ^ decrypt_xor_value);
    sprintf (encseed2, "%08x", teststruct.data[1] ^ decrypt_xor_value);

    return(0);
}

