#ifndef __VKTOOLS_H_INCLUDED__
#define __VKTOOLS_H_INCLUDED__ 1
#ifndef VENDORCODE
typedef struct vendorcode {
			    short type;	   /* Type of structure */
			    unsigned long data[2]; /* 64-bit code */
			    unsigned long keys[4]; /*- [0]: Product features */
					   	   /*- [1]: platforms */
					   	   /*- [2]: platforms */
					   	   /*- [3]: Expiration date/ */
						   /*-      Key check */
			    short flexlm_version;
			    short flexlm_revision;
			    char flexlm_patch[2];
#define LM_MAX_BEH_VER 4
			    char behavior_ver[LM_MAX_BEH_VER + 1];
			  } VENDORCODE;
#endif

/*****************************************************************************/
/*	
 *	Header:	vktools.h
 *
 *	Description:	Header for programs using vktools.c.
 *			
 *
 *	Last changed:  3-OCT-1999
 *	N. Blender
 *
 */

/*
 * structure definitions 
 */

/*
 * list structure definition for encryption seed data
 */
typedef struct nbl_list_s
{
	struct nbl_list_s *next;
	struct nbl_list_s *prev;
	char vendorname[32]; /* vendor to search */
	unsigned long encryption_seed1;
	unsigned long encryption_seed2;
	char behavior[32]; /* Default behavior version */
} nbl_list_t;

/*
 * function prototypes
 */
unsigned long nbl_svk(char *instr, VENDORCODE *inv);
int nbl_keygen(int inver, char *myvname, char *outdata);
unsigned long nbl_br(unsigned long inval);
unsigned long nbl_hbs(unsigned long inval);
int z_init(char *instr, unsigned long *outval);
int nb_nzsum(char *instr, unsigned long *outval);
unsigned long nbl_makekey(char *instr, VENDORCODE *vs, unsigned long *vkey5);
unsigned long rl_icf(unsigned long inval);
int nbl_list_store_value(nbl_list_t *hdr, char *indata, unsigned long seed1, 
	 unsigned long seed2, char *behavior);
nbl_list_t *nbl_list_create(char *indata);
int nbl_list_init (nbl_list_t *rec);
int nbl_list_addrecord(nbl_list_t *rec, nbl_list_t *newrec);
int nbl_list_unthread(nbl_list_t *rec);
nbl_list_t *nbl_list_locate(nbl_list_t *rec, char *key);
int nbl_list_debug_print(nbl_list_t *rec);
int nbl_list_free(nbl_list_t *rec);
int nbl_read_config_from_file(char *filename, nbl_list_t *lh);
int nbl_crogen(char *vendname, unsigned long *ovals);
unsigned long nbl_rev(char *instr,unsigned long *decvals, unsigned long *okeys);
unsigned long nbl_gen(char *instr, unsigned long *numarr, unsigned long *okeys);
#endif

