/* (c) 1998, Fred Cohen & Associates (all.net) - ALL RIGHTS RESERVED */

#define RESPONSEFILE ".response"
#define GENDIR "/u/fc/src/dd"
#define GENLOG "/log"
#define	Ktime	20
int CHECKUSER=1;int DOCHROOT=1;

#define BUFSIZE 4096
#define MAXSIZE 2048
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <syslog.h>
#define LOG2(x,y) {F=fopen(GENLOG,"a+");if (F != NULL) {logfile(F);fprintf(F,x,y);} fclose(F);}
#define LOG3(x,y,z) {F=fopen(GENLOG,"a+");if (F != NULL) {logfile(F);fprintf(F,x,y,z);} fclose(F);}
#define LOG4(x,y,z,w) {F=fopen(GENLOG,"a+");if (F != NULL) {logfile(F);fprintf(F,x,y,z,w);} fclose(F);}
#define LOG5(x,y,z,w,v) {F=fopen(GENLOG,"a+");if (F != NULL) {logfile(F);fprintf(F,x,y,z,w,v);} fclose(F);}

char	line[BUFSIZE],name[BUFSIZE],bs1[BUFSIZE],bs2[BUFSIZE],bs3[BUFSIZE], timestamp[64],
	logline[BUFSIZE], remotehost[BUFSIZE], remoteuser[BUFSIZE],
	portnumber[BUFSIZE], demonname[BUFSIZE];
struct stat buf; FILE *F;
int	i, n, staterr, port, state;
time_t *tloc;time_t	t;

void	logfile(F)
FILE	*F;

{
	alarm(Ktime);t=time(NULL);
#ifdef SYSV
	cftime(timestamp, "%Y/%m/%d %T", localtime(&t));
#else
	strftime(timestamp, 20, "%Y/%m/%d %T", localtime(&t));
#endif
	fprintf(F,"%s %d %s %s %s %d %d %d %s", remotehost,port,remoteuser,demonname,timestamp,getpid(),getppid(),state, line);
	alarm(0);
}

void	cat(s)
char	s[];

{
	alarm(IOtime);i=open(s,0);
	while ((n=read(i,bs2,MAXSIZE)) > 0) {
		alarm(IOtime);write(1,bs2,n);
	}
	close(i);alarm(0);
}

/* the stimulus-response loop */
fetch()

{
	alarm(Ktime);strcat(portnumber,RESPONSEFILE);
	read(0,line,MAXSIZE); line[MAXSIZE]='\0';
	sscanf(line, "%s %s", bs1, bs2);
	if (0 != (S_IROTH & buf.st_mode)) {
		cat(name); LOG2("cat %s\n",name);exit();
	}	/* Send it*/
	LOG5("Access-Denied");
}

main(argc,argv,envp)
int argc; char *argv[],*envp[];

{
	alarm(Ktime);
	if (0 != chdir(GENDIR)) error("Cannot change to dd directory");
	if (DOCHROOT == 1) if (chroot(".") != 0)  error("Cannot change root directory to .");
	if (0 != setuid(WWWUID)) error("setUID failed");	/* become dduser or die */

	if (argc>1) strncpy(remotehost,argv[1],MAXSIZE); else strcpy(remotehost,"nowhere");
	if (argc>2) strncpy(portnumber,argv[2],MAXSIZE); else strcpy(portnumber,"0");
	if (argc>3) strncpy(remoteuser,argv[3],MAXSIZE); else strcpy(remoteuser,"nobody");
	if (argc>4) strncpy(demonname,argv[4],MAXSIZE); else strcpy(deamonname,"unknown");

	remotehost[MAXSIZE]='\0';remoteuser[MAXSIZE]='\0';
	portnumber[MAXSIZE]='\0';deamonname[MAXSIZE]='\0';
	alarm(Ktime);
	sscanf(portnumber, "%d", port);
	state=0;fetch();
}
