;***************************************************************
;*         aPLib v0.19b  -  the smaller the better :)          *
;*            WASM & TASM fast assembler depacker              *
;*                                                             *
;*    Copyright (c) 1998 by  Jibz  All Rights Reserved     *
;***************************************************************

.386p
.MODEL flat

getbitM MACRO
LOCAL stillbitsleft
    add    dl, dl
    jnz    stillbitsleft
    mov    dl, [esi]
    inc    esi
    adc    dl, dl
stillbitsleft:
ENDM getbitM

domatchM MACRO reg
    push   esi
    mov    esi, edi
    sub    esi, reg
    rep    movsb
    pop    esi
ENDM domatchM

getgammaM MACRO reg
LOCAL getmorebits
    mov    reg, 1
getmorebits:
    getbitM
    adc    reg, reg
    getbitM
    jc     getmorebits
ENDM getgammaM

.CODE

PUBLIC _aP_depack_asm_fast

_aP_depack_asm_fast:
    push   ebp
    mov    ebp, esp
    pushad
    push   ebp

    mov    esi, [ebp + 8]     ; C calling convention
    mov    edi, [ebp + 12]

    cld
    mov    dl, 80h

literal:
    mov     al, [esi]
    inc     esi
    mov     [edi], al
    inc     edi

nexttag:
    getbitM
    jnc    literal

    getbitM
    jnc    codepair

    xor    eax, eax
    getbitM
    jnc    shortmatch

    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    jz     thewrite
    push   edi
    sub    edi, eax
    mov    al, [edi]
    pop    edi
thewrite:
    mov    [edi], al
    inc    edi
    jmp    short nexttag

codepair:
    getgammaM eax
    sub    eax, 2
    jnz    normalcodepair
    getgammaM ecx
    domatchM ebp
    jmp    nexttag

normalcodepair:
    dec    eax
    shl    eax, 8
    mov    al, [esi]
    inc    esi
    mov    ebp, eax
    getgammaM ecx
    cmp    eax, 32000
    jae    do_add_2
    cmp    eax, 1280
    jb     not_gt_1280
    inc    ecx
    domatchM eax
    jmp    nexttag
not_gt_1280:
    cmp    eax, 7fh
    ja     dont_add_2
do_add_2:
    add    ecx, 2
dont_add_2:
    domatchM eax
    jmp    nexttag

shortmatch:
    mov    al, [esi]
    inc    esi
    xor    ecx, ecx
    db     0c0h, 0e8h, 001h
    jz     donedepacking
    adc    ecx, 2
    mov    ebp, eax
    domatchM eax
    jmp    nexttag

donedepacking:
    pop    ebp
    sub    edi, [ebp + 12]
    mov    [ebp - 4], edi     ; return unpacked length in eax

    popad
    pop    ebp
    ret

END
