;***************************************************************
;*         aPLib v0.19b  -  the smaller the better :)          *
;*                NASM fast assembler depacker                 *
;*                                                             *
;*    Copyright (c) 1998 by  Jibz  All Rights Reserved     *
;*    -> NASM     Archee/CoNTRACT (soltesz@hotmail.com)        *
;***************************************************************

section .text use32

global _aP_depack_asm_fast

%macro getbitM 0
    add    dl, dl
    jnz    %%stillbitsleft
    mov    dl, [esi]
    inc    esi
    adc    dl, dl
%%stillbitsleft:
%endmacro

%macro domatchM 1
    push   esi
    mov    esi, edi
    sub    esi, %1
    rep    movsb
    pop    esi
%endmacro

%macro getgammaM 1
    mov    %1, 1
%%getmore:
    getbitM
    adc    %1, %1
    getbitM
    jc     %%getmore
%endmacro

_aP_depack_asm_fast:
    push   ebp
    mov    ebp, esp
    pushad
    push   ebp

    mov    esi, [ebp + 8]     ; C calling convention
    mov    edi, [ebp + 12]

    cld
    mov    dl, 80h

literal:
    mov     al, [esi]
    inc     esi
    mov     [edi], al
    inc     edi

nexttag:
    getbitM
    jnc    literal

    getbitM
    jnc    codepair

    xor    eax, eax
    getbitM
    jnc    near shortmatch

    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    getbitM
    adc    eax, eax
    jz     thewrite
    push   edi
    sub    edi, eax
    mov    al, [edi]
    pop    edi
thewrite:
    mov    [edi], al
    inc    edi
    jmp    short nexttag

codepair:
    getgammaM eax
    sub    eax, 2
    jnz    normalcodepair
    getgammaM ecx
    domatchM ebp
    jmp    nexttag

normalcodepair:
    dec    eax
    shl    eax, 8
    mov    al, [esi]
    inc    esi
    mov    ebp, eax
    getgammaM ecx
    cmp    eax, 32000
    jae    do_add_2
    cmp    eax, 1280
    jb     not_gt_1280
    inc    ecx
    domatchM eax
    jmp    nexttag
not_gt_1280:
    cmp    eax, BYTE 7fh
    ja     dont_add_2
do_add_2:
    add    ecx, 2
dont_add_2:
    domatchM eax
    jmp    nexttag

shortmatch:
    mov    al, [esi]
    inc    esi
    xor    ecx, ecx
    db     0c0h, 0e8h, 001h
    jz     donedepacking
    adc    ecx, BYTE 2
    mov    ebp, eax
    domatchM eax
    jmp    nexttag

donedepacking:
    pop    ebp
    sub    edi, [ebp + 12]
    mov    [ebp - 4], edi     ; return unpacked length in eax

    popad
    pop    ebp
    ret
