; Humnuller
;
; K Orton 2007

; PIC constants
W	EQU	0
F	EQU	1
INDF	EQU	H'0000'
PCL	EQU	H'0002'
STATUS	EQU	H'0003'
FSR	EQU	H'0004'
PORTA	EQU	H'0005'
PORTB	EQU	H'0006'
PORTC	EQU	H'0007'
INTCON	EQU	H'000B'
SSPBUF	EQU	H'0013'
SSPCON	EQU	H'0014'
ADRESH	EQU	H'001E'
ADCON0	EQU	H'001F'
OPTREG	EQU	H'0081'
TRISA	EQU	H'0085'
TRISB	EQU	H'0086'
TRISC	EQU	H'0087'
SSPCON2	EQU	H'0091'
SSPSTAT	EQU	H'0094'
ADRESL	EQU	H'009E'
ADCON1	EQU	H'009F'
GO	EQU	2
C	EQU	0
Z	EQU	2
RP0	EQU	5
RP1	EQU	6
IRP	EQU	7
CFG	EQU	H'3932'

	__CONFIG	CFG

; Program constants
FSEL	EQU	0			; RB0: Frequency select
REJ	EQU	1			; RB1: Hum/VLF reject
INV	EQU	2			; RB2: DAC invert
F1TC	EQU	3			; RB3: Filter 1 TC
F2TC	EQU	4			; RB4: Filter 2 TC
ADEN	EQU	5			; RB5: Adapt enable
SYNC	EQU	2			; RC2 = /SYNC
CUR	EQU	H'0078'
PRV	EQU	H'0079'
SMPHI	EQU	H'007A'
SMPLO	EQU	H'007B'
LPF1HI	EQU	H'007C'
LPF1LO	EQU	H'007D'
LPF2HI	EQU	H'007E'
LPF2LO	EQU	H'007F'
LPF3HI	EQU	H'000E'			; Use some SFRs
LPF3LO	EQU	H'000F'			;  as GPRs
DEL1	EQU	H'0015'
DEL2	EQU	H'0016'
DEL1S	EQU	H'001B'
DEL2S	EQU	H'001C'

; 16 bit unsigned right shift macro (3~)
SR16	MACRO
	BCF	STATUS,C
	RRF	SMPHI,F
	RRF	SMPLO,F
	ENDM

; 16 bit load macro (4~)
LD16	MACRO	HI,LO
	MOVF	HI,W
	MOVWF	SMPHI
	MOVF	LO,W
	MOVWF	SMPLO
	ENDM

; 16 bit load from INDF macro (5~)
LDINDF	MACRO
	MOVF	INDF,W
	MOVWF	SMPLO
	BSF	FSR,0
	MOVF	INDF,W
	MOVWF	SMPHI
	ENDM

; Set FSR macro (11~)
; Buffer index 1..180 expected in W
SETFSR	MACRO
	CALL	MAPIND
	MOVWF	FSR
	BCF	STATUS,IRP
	BTFSC	FSR,0
	BSF	STATUS,IRP
	BCF	FSR,0
	ENDM

; Delay macro (1+3*CNT~)
; Uses DEL1
DELAY	MACRO	CNT
	LOCAL	L1
	MOVLW	CNT
	MOVWF	DEL1
L1	DECFSZ	DEL1,F
	GOTO	L1
	ENDM

; Add to low macro (3~)
ADDLO	MACRO	HI,LO
	ADDWF	LO,F
	BTFSC	STATUS,C
	INCF	HI,F
	ENDM

; Subtract from low macro (3~)
SUBLO	MACRO	HI,LO
	SUBWF	LO,F
	BTFSS	STATUS,C
	DECF	HI,F
	ENDM

; PIC reset
	ORG	0
	CLRF	INTCON			; No interrupts
	GOTO	INIT

; Map delay buffer index to register address
; Buffer index 1..180 expected in W
; IRP     returned in W0
; FSR1..7 returned in W1..7
MAPIND	ADDWF	PCL,F
	NOP
	RETLW	H'20'			; Bank 0
	RETLW	H'22'
	RETLW	H'24'
	RETLW	H'26'
	RETLW	H'28'
	RETLW	H'2A'
	RETLW	H'2C'
	RETLW	H'2E'
	RETLW	H'30'
	RETLW	H'32'
	RETLW	H'34'
	RETLW	H'36'
	RETLW	H'38'
	RETLW	H'3A'
	RETLW	H'3C'
	RETLW	H'3E'
	RETLW	H'40'
	RETLW	H'42'
	RETLW	H'44'
	RETLW	H'46'
	RETLW	H'48'
	RETLW	H'4A'
	RETLW	H'4C'
	RETLW	H'4E'
	RETLW	H'50'
	RETLW	H'52'
	RETLW	H'54'
	RETLW	H'56'
	RETLW	H'58'
	RETLW	H'5A'
	RETLW	H'5C'
	RETLW	H'5E'
	RETLW	H'60'
	RETLW	H'62'
	RETLW	H'64'
	RETLW	H'66'
	RETLW	H'68'
	RETLW	H'6A'
	RETLW	H'6C'
	RETLW	H'6E'
	RETLW	H'70'
	RETLW	H'72'
	RETLW	H'74'
	RETLW	H'76'
	RETLW	H'A0'			; Bank 1
	RETLW	H'A2'
	RETLW	H'A4'
	RETLW	H'A6'
	RETLW	H'A8'
	RETLW	H'AA'
	RETLW	H'AC'
	RETLW	H'AE'
	RETLW	H'B0'
	RETLW	H'B2'
	RETLW	H'B4'
	RETLW	H'B6'
	RETLW	H'B8'
	RETLW	H'BA'
	RETLW	H'BC'
	RETLW	H'BE'
	RETLW	H'C0'
	RETLW	H'C2'
	RETLW	H'C4'
	RETLW	H'C6'
	RETLW	H'C8'
	RETLW	H'CA'
	RETLW	H'CC'
	RETLW	H'CE'
	RETLW	H'D0'
	RETLW	H'D2'
	RETLW	H'D4'
	RETLW	H'D6'
	RETLW	H'D8'
	RETLW	H'DA'
	RETLW	H'DC'
	RETLW	H'DE'
	RETLW	H'E0'
	RETLW	H'E2'
	RETLW	H'E4'
	RETLW	H'E6'
	RETLW	H'E8'
	RETLW	H'EA'
	RETLW	H'EC'
	RETLW	H'EE'
	RETLW	H'11'			; Bank 2
	RETLW	H'13'
	RETLW	H'15'
	RETLW	H'17'
	RETLW	H'19'
	RETLW	H'1B'
	RETLW	H'1D'
	RETLW	H'1F'
	RETLW	H'21'
	RETLW	H'23'
	RETLW	H'25'
	RETLW	H'27'
	RETLW	H'29'
	RETLW	H'2B'
	RETLW	H'2D'
	RETLW	H'2F'
	RETLW	H'31'
	RETLW	H'33'
	RETLW	H'35'
	RETLW	H'37'
	RETLW	H'39'
	RETLW	H'3B'
	RETLW	H'3D'
	RETLW	H'3F'
	RETLW	H'41'
	RETLW	H'43'
	RETLW	H'45'
	RETLW	H'47'
	RETLW	H'49'
	RETLW	H'4B'
	RETLW	H'4D'
	RETLW	H'4F'
	RETLW	H'51'
	RETLW	H'53'
	RETLW	H'55'
	RETLW	H'57'
	RETLW	H'59'
	RETLW	H'5B'
	RETLW	H'5D'
	RETLW	H'5F'
	RETLW	H'61'
	RETLW	H'63'
	RETLW	H'65'
	RETLW	H'67'
	RETLW	H'69'
	RETLW	H'6B'
	RETLW	H'6D'
	RETLW	H'6F'
	RETLW	H'91'			; Bank 3
	RETLW	H'93'
	RETLW	H'95'
	RETLW	H'97'
	RETLW	H'99'
	RETLW	H'9B'
	RETLW	H'9D'
	RETLW	H'9F'
	RETLW	H'A1'
	RETLW	H'A3'
	RETLW	H'A5'
	RETLW	H'A7'
	RETLW	H'A9'
	RETLW	H'AB'
	RETLW	H'AD'
	RETLW	H'AF'
	RETLW	H'B1'
	RETLW	H'B3'
	RETLW	H'B5'
	RETLW	H'B7'
	RETLW	H'B9'
	RETLW	H'BB'
	RETLW	H'BD'
	RETLW	H'BF'
	RETLW	H'C1'
	RETLW	H'C3'
	RETLW	H'C5'
	RETLW	H'C7'
	RETLW	H'C9'
	RETLW	H'CB'
	RETLW	H'CD'
	RETLW	H'CF'
	RETLW	H'D1'
	RETLW	H'D3'
	RETLW	H'D5'
	RETLW	H'D7'
	RETLW	H'D9'
	RETLW	H'DB'
	RETLW	H'DD'
	RETLW	H'DF'
	RETLW	H'E1'
	RETLW	H'E3'
	RETLW	H'E5'
	RETLW	H'E7'
	RETLW	H'E9'
	RETLW	H'EB'
	RETLW	H'ED'
	RETLW	H'EF'

; Software programmable delay (CALL SPDEL=6+(32-W)~)
; Delay 0..32 expected in W (0=longest delay)
SPDEL	ADDWF	PCL,F
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN

; PIC initialisation
INIT	BSF	STATUS,RP0		; Set options:
	MOVLW	B'01010111'		;  RB pull-ups on
	MOVWF	OPTREG
	MOVLW	B'00000001'		; Set up digital I/O:
	MOVWF	TRISA			;  Port A 0:   Ain
	MOVLW	B'11111111'		;  Port B all: Din
	MOVWF	TRISB			;  Port C 3-5: SPI
	CLRF	TRISC			;  All others: Dout
	BCF	STATUS,RP0
	CLRF	PORTA
	CLRF	PORTC
	MOVLW	B'10000000'		; Set up ADC:
	MOVWF	ADCON0			;  Select RAO and
	BSF	STATUS,RP0		;  Fosc/32
	MOVLW	B'10001110'		;  Right justified data
	MOVWF	ADCON1			;  RA0 only and
	BCF	STATUS,RP0		;   supply refs
	MOVLW	B'10000001'		;  Enable ADC
	MOVWF	ADCON0
	CLRF	SSPCON			; Set up SPI:
	BSF	STATUS,RP0		;  Master mode at
	CLRF	SSPCON2			;   5Mbit/sec
	CLRF	SSPSTAT			;  High clock
	BCF	STATUS,RP0		;   pulses
	MOVLW	B'00100000'		;  Enable SPI
	MOVWF	SSPCON

; Program initialisation
	MOVLW	H'B4'			; Set all delay buffer
	MOVWF	CUR			;  samples to mid code
L1	MOVF	CUR,W
	SETFSR
	CLRF	INDF			; Store low byte first
	BSF	FSR,0
	MOVLW	H'80'
	MOVWF	INDF
	DECFSZ	CUR,F
	GOTO	L1
	MOVLW	H'40'			; Set filter 1 to
	BTFSS	PORTB,F1TC		;  mid code
	MOVLW	H'80'
	MOVWF	LPF1HI
	CLRF	LPF1LO
	MOVLW	H'40'			; Set filter 2 to
	BTFSS	PORTB,F2TC		;  mid code
	MOVLW	H'80'
	MOVWF	LPF2HI
	CLRF	LPF2LO
	MOVLW	H'80'			; Set filter 3 to
	MOVWF	LPF3HI			;  mid code
	CLRF	LPF3LO
	MOVLW	D'16'			; Set PLL delays
	MOVWF	DEL1S
	MOVWF	DEL2S
	MOVLW	1			; Get safe starting
	MOVWF	PRV			;  state
	CLRF	SMPHI
	CLRF	SMPLO

; Main loop
L2	MOVLW	H'96'			; Decide delay size
	BTFSS	PORTB,FSEL		;  in samples:
	MOVLW	H'B4'			;  150 for 60Hz
	MOVWF	CUR			;  180 for 50Hz
L3	BSF	ADCON0,GO		; Start ADC
	BTFSS	PORTB,REJ		; Decide DAC source
	GOTO	L4
	MOVF	CUR,W			; Hum select:
	SETFSR
	LDINDF				;  Get indexed sample
	BTFSS	PORTB,INV		;  Invert DAC if
	COMF	SMPHI,F			;   required
	BTFSS	PORTB,INV
	COMF	SMPLO,F
	SR16				;  Shift for DAC
	SR16
	SR16
	SR16
	GOTO	L5
L4	MOVLW	8			; Hum reject:
	ADDWF	SMPHI,F			;  Centre DAC code
	MOVLW	B'00001111'		;  Invert DAC if
	BTFSS	PORTB,INV		;   required
	XORWF	SMPHI,F
	BTFSS	PORTB,INV
	COMF	SMPLO,F
	DELAY	8
	NOP
	NOP
L5	DELAY	D'61'
	MOVF	DEL1S,W			; ADC/DAC delay
	CALL	SPDEL
	BSF	PORTC,SYNC		; Output sync
	NOP				;  pulse
	NOP
	BCF	PORTC,SYNC
	NOP
	NOP
	MOVF	SMPHI,W			; Output DAC high
	MOVWF	SSPBUF			;  byte
	DELAY	5
	MOVF	SMPLO,W			; Output DAC low byte
	MOVWF	SSPBUF
	MOVF	DEL2S,W			; Overall delay
	CALL	SPDEL
	DELAY	D'20'
	NOP
	NOP
	LD16	LPF1HI,LPF1LO		; Filter 1 feedback/
	SR16				;  filter 2 input
	SR16
	SR16
	SR16
	SR16
	BCF	STATUS,C
	BTFSS	PORTB,F1TC
	RRF	SMPHI,F
	BTFSS	PORTB,F1TC
	RRF	SMPLO,F
	MOVF	SMPLO,W
	SUBLO	LPF1HI,LPF1LO
	ADDLO	LPF2HI,LPF2LO
	MOVF	SMPHI,W
	SUBWF	LPF1HI,F
	ADDWF	LPF2HI,F
	LD16	LPF2HI,LPF2LO		; Filter 2 feedback/
	SR16				;  filter 3 input
	SR16
	SR16
	SR16
	SR16
	BCF	STATUS,C
	BTFSS	PORTB,F2TC
	RRF	SMPHI,F
	BTFSS	PORTB,F2TC
	RRF	SMPLO,F
	MOVF	SMPLO,W
	MOVWF	DEL1
	SUBLO	LPF2HI,LPF2LO
	MOVF	SMPHI,W
	MOVWF	DEL2
	SUBWF	LPF2HI,F
	LD16	LPF3HI,LPF3LO		; Filter 3 feedback
	SR16
	SR16
	SR16
	SR16
	SR16
	SR16
	MOVF	SMPLO,W			; Get error
	SUBLO	DEL2,DEL1
	MOVF	SMPHI,W
	SUBWF	DEL2,F
	MOVF	DEL1,W			; Feedback error
	ADDLO	LPF3HI,LPF3LO
	MOVF	DEL2,W
	ADDWF	LPF3HI,F
	MOVLW	D'32'			; Move error to
	ADDLO	DEL2,DEL1		;  range 0..63
	MOVF	DEL1,W			; Outside range?
	ANDLW	B'11000000'
	IORWF	DEL2,W
	BTFSC	STATUS,Z
	GOTO	L6
	CLRF	DEL1			; Yes - clamp
	MOVLW	D'63'
	BTFSS	DEL2,7
	MOVWF	DEL1
	GOTO	L7
L6	NOP				; No - equalise
	NOP				;  delay
	NOP
	NOP
	NOP
L7	BCF	STATUS,C		; Split in two
	RRF	DEL1,W
	MOVWF	DEL1
	MOVWF	DEL2
	BTFSC	STATUS,C		; Deal with odd
	INCF	DEL2,F			;  delay
	MOVF	PRV,W			; Get previous
	SETFSR				;  sample
	LDINDF
	SR16				; Shift for filtering
	SR16
	SR16
	SR16
	SR16
	SR16
	COMF	SMPHI,F			; Negate
	COMF	SMPLO,F
	INCF	SMPHI,F
	INCFSZ	SMPLO,F
	DECF	SMPHI,F
	BSF	STATUS,RP0		; Get ADC sample
	MOVF	ADRESL,W
	BCF	STATUS,RP0
	ADDLO	SMPHI,SMPLO		; Form error
	ADDLO	LPF1HI,LPF1LO		; Inject into
	MOVF	ADRESH,W		;  filter 1 too
	ADDWF	SMPHI,F
	ADDWF	LPF1HI,F
	BTFSS	PORTB,ADEN
	GOTO	L8
	BCF	FSR,0			; Feedback error
	MOVF	SMPLO,W			;  to delayed
	ADDWF	INDF,F			;  sample
	BSF	FSR,0
	BTFSC	STATUS,C
	INCF	INDF,F
	MOVF	SMPHI,W			; Error left in
	ADDWF	INDF,F			;  case DAC needs it
	GOTO	L9
L8	NOP				; (equalise delay)
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
L9	MOVF	CUR,W			; Note previous
	MOVWF	PRV			;  sample
	DECFSZ	CUR,F			; Loop back
	GOTO	L10
	MOVF	DEL1,W			; PLL sample time
	MOVWF	DEL1S
	MOVF	DEL2,W
	MOVWF	DEL2S
	GOTO	L2
L10	NOP				; (equalising delay)
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO	L3

	END
