/*
 *  $Id: libnet.h,v 1.1.1.1 2000/05/25 00:28:49 route Exp $
 *
 *  libnet.h - Network routine library header file
 *
 *  Copyright (c) 1998 - 2001 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef __LIBNET_H
#define __LIBNET_H

#ifdef	__cplusplus
 extern "C" {
#endif

#if (WIN32)
/* 
 *  Win32 requiered defines that you find partly in config.h
 */
 #define IPPROTO_IGMP	2
 #define IPTOS_THROUGHPUT 0x08
 #define IPTOS_LOWDELAY 0x10
 #define LIBNET_BSD_BYTE_SWAP 1
 #define LIBNET_LIL_ENDIAN 1
 #define HAVE_STRERROR 1
 #define SIGQUIT 0
 #define SIGPIPE 8
 #define IP_MF 0x2000
 #define TH_PUSH 0x08
 #define TH_ACK 0x10
 #define TH_URG 0x20
 #define TH_ECE 0x40
 #define TH_CWR 0x80
 #define TH_SYN 0x02
 #define TH_RST 0x04
 #define TH_FIN 0x01
 #define IP_RF 0x8000			/* reserved fragment flag */
 #define IP_DF 0x4000			/* dont fragment flag */
 #define IP_MF 0x2000			/* more fragments flag */
 #define IP_OFFMASK 0x1fff		/* mask for fragmenting bits */
#endif

#include <stdio.h>
#include <string.h>
#if defined (_MSC_VER)
 #include <io.h>
#else
 #include <unistd.h>
#endif
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#if !(WIN32)
#include <sys/ioctl.h>
#endif
#if defined(HAVE_SYS_SOCKIO_H) && !defined(SIOCGIFADDR)
#include <sys/sockio.h>
#endif
#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>
#if (__linux__)
#include <time.h>
#include <pcap.h>
#endif
#if(WIN32) 
#include <winsock.h>
#include "./ntddndis.h"
#include "./pcap.h"
#include "./packet32.h"
#include "./packet_types.h"
#include <time.h>
#include <limits.h>
#include <wincrypt.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <net/if.h>
#if !(__linux__)
#include <netinet/ip_var.h>
#else   /* __linux__ */
#if (HAVE_NET_ETHERNET_H)
#include <net/ethernet.h>
#endif  /* HAVE_NET_ETHERNET_H */
#endif  /* __linux__ */
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netinet/ip_icmp.h>
#if (__linux__) && !(__GLIBC__)
/*
 *  We get multiple definitions of IGMP_AGE_THRESHOLD if we include netinet.
 */
#include <linux/igmp.h>
#else
#include <netinet/igmp.h>
#endif
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#endif	/* WIN32 */

#include <errno.h>
#include <assert.h>

#include "./libnet/libnet-headers.h"
#include "./libnet/libnet-structures.h"
#include "./libnet/libnet-macros.h"
#include "./libnet/libnet-asn1.h"
#include "./libnet/libnet-functions.h"
#include "./libnet/libnet-ospf.h"

#define LIBNET_VERSION  "1.0.2a"

#if (!LIBNET_LIL_ENDIAN && !LIBNET_BIG_ENDIAN)
#error "byte order has not been specified, you'll \
need to #define either LIBNET_LIL_ENDIAN or LIBNET_BIG_ENDIAN.  See the \
documentation regarding the libnet-config script."
#endif

#ifdef	__cplusplus
 }
#endif

#endif  /* __LIBNET_H */

/* EOF */
