VERSION 2.00
Begin Form ConfigScrn 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Communication Settings"
   Height          =   4245
   Icon            =   TERMSET.FRX:0000
   Left            =   1050
   LinkMode        =   1  'Source
   LinkTopic       =   "Form3"
   ScaleHeight     =   3840
   ScaleWidth      =   4980
   Top             =   1185
   Width           =   5100
   Begin OptionButton ComPort 
      Caption         =   "Com1"
      Height          =   252
      Index           =   1
      Left            =   1920
      TabIndex        =   31
      Top             =   2340
      Width           =   852
   End
   Begin OptionButton ComPort 
      Caption         =   "Com4"
      Height          =   252
      Index           =   4
      Left            =   1920
      TabIndex        =   30
      Top             =   3240
      Width           =   852
   End
   Begin OptionButton ComPort 
      Caption         =   "Com3"
      Height          =   252
      Index           =   3
      Left            =   1920
      TabIndex        =   29
      Top             =   2940
      Width           =   852
   End
   Begin OptionButton ComPort 
      Caption         =   "Com2"
      Height          =   252
      Index           =   2
      Left            =   1920
      TabIndex        =   28
      Top             =   2640
      Width           =   852
   End
   Begin Frame Frame1 
      Caption         =   "&Baud Rate"
      Height          =   975
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   3315
      Begin OptionButton Baud3 
         Caption         =   "300"
         Height          =   255
         Left            =   300
         TabIndex        =   3
         Top             =   240
         Width           =   735
      End
      Begin OptionButton Baud6 
         Caption         =   "600"
         Height          =   255
         Left            =   1260
         TabIndex        =   4
         Top             =   240
         Width           =   615
      End
      Begin OptionButton Baud12 
         Caption         =   "1200"
         Height          =   255
         Left            =   2220
         TabIndex        =   5
         Top             =   240
         Width           =   735
      End
      Begin OptionButton Baud24 
         Caption         =   "2400"
         Height          =   255
         Left            =   300
         TabIndex        =   6
         Top             =   600
         Width           =   735
      End
      Begin OptionButton Baud48 
         Caption         =   "4800"
         Height          =   255
         Left            =   1260
         TabIndex        =   7
         Top             =   600
         Width           =   735
      End
      Begin OptionButton Baud96 
         Caption         =   "9600"
         Height          =   255
         Left            =   2220
         TabIndex        =   8
         Top             =   600
         Width           =   735
      End
   End
   Begin CommandButton OKButton 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3780
      TabIndex        =   0
      Top             =   240
      Width           =   975
   End
   Begin CommandButton CancelButton 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3780
      TabIndex        =   1
      Top             =   720
      Width           =   975
   End
   Begin Frame Frame2 
      Caption         =   "&Data Bits"
      Height          =   615
      Left            =   240
      TabIndex        =   9
      Top             =   1260
      Width           =   1275
      Begin OptionButton Data7 
         Caption         =   "7"
         Height          =   255
         Left            =   180
         TabIndex        =   10
         Top             =   240
         Width           =   375
      End
      Begin OptionButton Data8 
         Caption         =   "8"
         Height          =   255
         Left            =   720
         TabIndex        =   11
         Top             =   240
         Width           =   435
      End
   End
   Begin Frame Frame3 
      Caption         =   "&Stop Bits"
      Height          =   615
      Left            =   1740
      TabIndex        =   12
      Top             =   1260
      Width           =   1335
      Begin OptionButton Stop1 
         Caption         =   "1"
         Height          =   255
         Left            =   240
         TabIndex        =   13
         Top             =   240
         Width           =   435
      End
      Begin OptionButton Stop2 
         Caption         =   "2"
         Height          =   255
         Left            =   780
         TabIndex        =   14
         Top             =   240
         Width           =   495
      End
   End
   Begin Frame Frame7 
      Caption         =   "&Echo"
      Height          =   615
      Left            =   3300
      TabIndex        =   15
      Top             =   1260
      Width           =   1455
      Begin OptionButton EchoOff 
         Caption         =   "Off"
         Height          =   315
         Left            =   780
         TabIndex        =   17
         Top             =   240
         Width           =   615
      End
      Begin OptionButton EchoOn 
         Caption         =   "On"
         Height          =   195
         Left            =   180
         TabIndex        =   16
         Top             =   300
         Width           =   555
      End
   End
   Begin Frame Frame4 
      Caption         =   "&Parity"
      Height          =   1575
      Left            =   240
      TabIndex        =   18
      Top             =   2040
      Width           =   1275
      Begin OptionButton NoParity 
         Caption         =   "None"
         Height          =   255
         Left            =   180
         TabIndex        =   19
         Top             =   300
         Width           =   855
      End
      Begin OptionButton OddParity 
         Caption         =   "Odd"
         Height          =   255
         Left            =   180
         TabIndex        =   20
         Top             =   600
         Width           =   735
      End
      Begin OptionButton EvenParity 
         Caption         =   "Even"
         Height          =   255
         Left            =   180
         TabIndex        =   21
         Top             =   900
         Width           =   855
      End
   End
   Begin Frame Frame6 
      Caption         =   "&Com Port"
      Height          =   1575
      Left            =   1740
      TabIndex        =   22
      Top             =   2040
      Width           =   1335
   End
   Begin Frame Frame5 
      Caption         =   "&Flow Control"
      Height          =   1575
      Left            =   3300
      TabIndex        =   23
      Top             =   2040
      Width           =   1455
      Begin OptionButton NoFlow 
         Caption         =   "None"
         Height          =   255
         Left            =   180
         TabIndex        =   26
         Top             =   300
         Width           =   855
      End
      Begin OptionButton XonFlow 
         Caption         =   "Xon/Xoff"
         Height          =   255
         Left            =   180
         TabIndex        =   24
         Top             =   600
         Width           =   1095
      End
      Begin OptionButton RTSFlow 
         Caption         =   "RTS"
         Height          =   255
         Left            =   180
         TabIndex        =   25
         Top             =   900
         Width           =   735
      End
      Begin OptionButton BothFlow 
         Caption         =   "Xon/RTS"
         Height          =   255
         Left            =   180
         TabIndex        =   27
         Top             =   1200
         Width           =   1155
      End
   End
End
'***********  Communication Settings Configuration Form

'Copyright (c) 1991, Crescent Software

DefInt A-Z

Dim Shared NewPort                 'temp config settings
Dim Shared NewBaud$, NewParity$
Dim Shared NewData$, NewStop$
Dim Shared NewShake

'
'--- 1200 baud option button
'
Sub Baud12_Click ()

    NewBaud$ = "1200"

End Sub

'
'--- 2400 baud option button
'
Sub Baud24_Click ()

    NewBaud$ = "2400"

End Sub

'
'--- 300 baud option button
'
Sub Baud3_Click ()

    NewBaud$ = "300"

End Sub

'
'--- 4800 baud option button
'
Sub Baud48_Click ()

    NewBaud$ = "4800"

End Sub

'
'--- 600 baud option button
'
Sub Baud6_Click ()

    NewBaud$ = "600"

End Sub

'
'--- 9600 baud option button
'
Sub Baud96_Click ()

    NewBaud$ = "9600"

End Sub

'
'--- Both RTS and Xon/Xoff handshaking option button
'
Sub BothFlow_Click ()

    NewShake = 3

End Sub

'
'--- Cancel button actions
'
Sub CancelButton_Click ()

    Unload ConfigScrn

End Sub

Sub ComPort_Click (Index As Integer)
    NewPort = Index
End Sub

'
'--- 7 data bits option button
'
Sub Data7_Click ()

    NewData$ = "7"

End Sub

'
'--- 8 data bits option button
'
Sub Data8_Click ()

    NewData$ = "8"

End Sub

'
'--- Echo off option button
'
Sub EchoOff_Click ()

    Echo = 0

End Sub

'
'--- Echo on option button
'
Sub EchoOn_Click ()

    Echo = True

End Sub

'
'--- Even parity option button
'
Sub EvenParity_Click ()

    NewParity$ = "E"
    
End Sub

'
'--- Initialize and display configuration form
'
Sub Form_Load ()
    
    '--- Get current port
    Port = Form1.MSComm1.CommPort
    ConfigScrn.ComPort(Port).Value = True       'Set option button

    '--- Get current baud
    FirstComma = InStr(Form1.MSComm1.Settings, ",")
    Baud$ = Left$(Form1.MSComm1.Settings, FirstComma - 1)
    
    Select Case Val(Baud$)                  'select baud
    Case 300                                'set active baud
        ConfigScrn.Baud3.Value = True       'option button
    Case 600
        ConfigScrn.Baud6.Value = True
    Case 1200
        ConfigScrn.Baud12.Value = True
    Case 2400
        ConfigScrn.Baud24.Value = True
    Case 4800
        ConfigScrn.Baud48.Value = True
    Case 9600
        ConfigScrn.Baud96.Value = True
    End Select

    '--- Get current parity
    Parity$ = Mid$(Form1.MSComm1.Settings, FirstComma + 1, 1)
    
    Select Case UCase$(Parity$)             'select parity
    Case "N"                                'set active parity
        ConfigScrn.NoParity.Value = True    'option button
    Case "E"
        ConfigScrn.EvenParity.Value = True
    Case "O"
        ConfigScrn.OddParity.Value = True
    End Select

    
    '--- Get data bits
    SecondComma = FirstComma + 2
    DBits$ = Mid$(Form1.MSComm1.Settings, SecondComma + 1, 1)
    Select Case Val(DBits$)              'select data bits
    Case 7                              'set active choice
        ConfigScrn.Data7.Value = True       'option button
    Case 8
        ConfigScrn.Data8.Value = True
    End Select

    '--- Get stop bits
    ThirdComma = SecondComma + 2
    SBits$ = Mid$(Form1.MSComm1.Settings, ThirdComma + 1, 1)
    Select Case Val(SBits$)                 'select stop bits
    Case 1                                  'set active choice
        ConfigScrn.Stop1.Value = True       'option button
    Case 2
        ConfigScrn.Stop2.Value = True
    End Select

    
    Select Case Form1.MSComm1.Handshaking
    Case 0                                  'set active choice
        ConfigScrn.NoFlow.Value = True      'option button
    Case 1
        ConfigScrn.XonFlow.Value = True
    Case 2
        ConfigScrn.RTSFlow.Value = True
    Case 3
        ConfigScrn.BothFlow.Value = True
    End Select

    If Echo Then
        ConfigScrn.EchoOn.Value = True
    Else
        ConfigScrn.EchoOff.Value = True
    End If
End Sub

'
'--- No handshaking option button
'
Sub NoFlow_Click ()

    NewShake = 0

End Sub

'
'--- No parity option button
'
Sub NoParity_Click ()

    NewParity$ = "N"
    
End Sub

'
'--- Odd parity option button
'
Sub OddParity_Click ()

    NewParity$ = "O"
    
End Sub

'
'--- Ok button actions
'
Sub OkButton_Click ()
    On Error Resume Next

    OldPort = Form1.MSComm1.CommPort
    If NewPort <> OldPort Then                    'if port num changing
        If Form1.MSComm1.PortOpen Then            'close the old port
           Form1.MSComm1.PortOpen = False
           ReOpen = True
        End If

        Form1.MSComm1.CommPort = NewPort          'set new port number

        If Err = 0 Then
           If ReOpen Then
              Form1.MSComm1.PortOpen = True
              Form1.MOpen.Checked = Form1.MSComm1.PortOpen
           End If
        End If
        If Err Then
           MsgBox Error$, 48
           Form1.MSComm1.CommPort = OldPort
           Exit Sub
        End If
    End If
    
    Form1.MSComm1.Settings = NewBaud$ + "," + NewParity$ + "," + NewData$ + "," + NewStop$
    If Err Then
       MsgBox Error$, 48
       Exit Sub
    End If
    Form1.MSComm1.Handshaking = NewShake
    If Err Then
       MsgBox Error$, 48
       Exit Sub
    End If

    Unload ConfigScrn                               'remove configuration form

End Sub

'
'--- RTS handshaking option button
'
Sub RTSFlow_Click ()

    NewShake = 2

End Sub

'
'--- 1 stop bit option button
'
Sub Stop1_Click ()

    NewStop$ = "1"

End Sub

'
'--- 2 stop bits option button
'
Sub Stop2_Click ()

    NewStop$ = "2"

End Sub

'
'--- XON handshaking option button
'
Sub XonFlow_Click ()

    NewShake = 1

End Sub

